//+------------------------------------------------------------------+
//|                                           Adaptable_StochRSI.mq4 |
//|                               Copyright  2014, Gehtsoft USA LLC |
//|                                            http://fxcodebase.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2014, Gehtsoft USA LLC"
#property link      "http://fxcodebase.com"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 Green
#property indicator_color2 Red

extern int RSI_Length=14;
extern int Stoch_K_Length=14;
extern int K_Smooth_Length=8;
extern int K_Smooth_Method=1;  // 0 - SMA
                               // 1 - EMA
                               // 2 - SMMA
                               // 3 - LWMA
extern int D_Smooth_Length=8;
extern int D_Smooth_Method=1;  // 0 - SMA
                               // 1 - EMA
                               // 2 - SMMA
                               // 3 - LWMA
extern int Price=0;    // Applied price
                       // 0 - Close
                       // 1 - Open
                       // 2 - High
                       // 3 - Low
                       // 4 - Median
                       // 5 - Typical
                       // 6 - Weighted  
extern bool   ShowArrows       = false;
extern string arrowsIdentifier = "adpstorsi Arrows1";
extern double arrowsUpperGap   = 1.0;
extern double arrowsLowerGap   = 1.0;
extern color  arrowsUpColor    = LimeGreen;
extern color  arrowsDnColor    = Red;
extern int    arrowsUpCode     = 241;
extern int    arrowsDnCode     = 242;
extern double levelOb          = 80.0;
extern double levelOs          = 20.0;

double K[], D[];
double SKI[], RSI[];
double trend[];

int init()
{
 IndicatorShortName("Adaptable Stochastic RSI");
 IndicatorDigits(Digits);
 IndicatorBuffers(5);
 SetIndexBuffer(0,K);
 SetIndexBuffer(1,D);
 SetIndexBuffer(2,SKI);
 SetIndexBuffer(3,RSI);
 SetIndexBuffer(4,trend);
 SetLevelValue(0,levelOb);
 SetLevelValue(1,levelOs);
 return(0);
}

int deinit() 
{  
   deleteArrows(); 
return(0); 
}

int start()
{
 if(Bars<=3) return(0);
 int ExtCountedBars=IndicatorCounted();
 if (ExtCountedBars<0) return(-1);
 int limit=Bars-2;
 if(ExtCountedBars>2) limit=Bars-ExtCountedBars-1;
 int pos;
 pos=limit;
 while(pos>=0)
 {
  RSI[pos]=iRSI(NULL, 0, RSI_Length, Price, pos);

  pos--;
 } 
 
 double Min, Max;
 pos=limit;
 while(pos>=0)
 {
  Min=RSI[ArrayMinimum(RSI, Stoch_K_Length, pos)];
  Max=RSI[ArrayMaximum(RSI, Stoch_K_Length, pos)];
  if (Min==Max)
  {
   SKI[pos]=1.;
  }
  else
  {
   SKI[pos]=(RSI[pos]-Min)/(Max-Min);
  }

  pos--;
 }
 
 pos=limit;
 while(pos>=0)
 {
  K[pos]=100.*iMAOnArray(SKI, 0, K_Smooth_Length, 0, K_Smooth_Method, pos);

  pos--;
 }  
   
 pos=limit;
 while(pos>=0)
 {
  D[pos]=iMAOnArray(K, 0, D_Smooth_Length, 0, D_Smooth_Method, pos);
  trend[pos] = trend[pos+1];
  if (K[pos]>D[pos]) trend[pos] = 1;
  if (K[pos]<D[pos]) trend[pos] =-1;
  
  //
  //
  //
  //
  //
     
  if (ShowArrows)
  {
     deleteArrow(Time[pos]);
     if (trend[pos] != trend[pos+1])
     {
        if (trend[pos] == 1)  drawArrow(pos,arrowsUpColor,arrowsUpCode,false);
        if (trend[pos] ==-1)  drawArrow(pos,arrowsDnColor,arrowsDnCode, true);
     }
   }

  pos--;
 }  
   
 return(0);
}

//
//
//
//
//

void drawArrow(int i,color theColor,int theCode,bool up)
{
   string name = arrowsIdentifier+":"+Time[i];
   double gap  = iATR(NULL,0,20,i);   
   
      //
      //
      //
      //
      //
      
      ObjectCreate(name,OBJ_ARROW,0,Time[i],0);
         ObjectSet(name,OBJPROP_ARROWCODE,theCode);
         ObjectSet(name,OBJPROP_COLOR,theColor);
         if (up)
               ObjectSet(name,OBJPROP_PRICE1,High[i] + arrowsUpperGap * gap);
         else  ObjectSet(name,OBJPROP_PRICE1,Low[i]  - arrowsLowerGap * gap);
}

//
//
//
//
//

void deleteArrows()
{
   string lookFor       = arrowsIdentifier+":";
   int    lookForLength = StringLen(lookFor);
   for (int i=ObjectsTotal()-1; i>=0; i--)
   {
      string objectName = ObjectName(i);
         if (StringSubstr(objectName,0,lookForLength) == lookFor) ObjectDelete(objectName);
   }
}

//
//
//
//
//

void deleteArrow(datetime time)
{
   string lookFor = arrowsIdentifier+":"+time; ObjectDelete(lookFor);
}



