//+------------------------------------------------------------------+
//|                                         adaptivemacd 4 color mtf |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "www.forex-tsd.com"
#property link      "www.forex-tsd.com"

//
//
//
//
//

#property indicator_separate_window
#property indicator_buffers    5
#property indicator_color1     LimeGreen
#property indicator_color2     Red
#property indicator_color3     DimGray
#property indicator_color4     DeepSkyBlue
#property indicator_color5     PaleVioletRed
#property indicator_width1     2
#property indicator_width2     2
#property indicator_width3     2
#property indicator_width4     2
#property indicator_width5     2
#property indicator_level1     0
#property indicator_levelcolor Gold
#property indicator_levelstyle STYLE_DOT

//
//
//
//
//

extern string TimeFrame        = "Current time frame";
extern int    FastMa           = 12;
extern int    FastMaMethod     = 0;
extern int    FastMaPrice      = 0;
extern int    AmaPeriod        = 26;
extern int    AmaPrice         = PRICE_CLOSE;
extern int    Nfast            = 5;
extern int    Nslow            = 20;
extern double GCoeff           = 2.0;
extern int    SignalMa         = 9;
extern int    SignalMaMode     = 0;
extern bool   Interpolate      = true;

extern bool   alertsOn         = true;
extern bool   alertsOnCurrent  = true;
extern bool   alertsMessage    = true;
extern bool   alertsSound      = false;
extern bool   alertsEmail      = false;

extern string  __              = "arrows settings";
extern bool   ShowArrows       = true;
extern string arrowsIdentifier = "rsima arrows";
extern color  arrowsUpColor    = Lime;
extern color  arrowsDnColor    = Orange;

//
//
//
//
//

double osma[];
double green_buffer[];
double red_buffer[];
double macd[];
double sig[];
double kAMAbuffer[];
double diff[];
double trend[];

//
//
//
//
//

double fastend;
double slowend;
string indicatorFileName;
bool   calculateValue;
bool   returnBars;
int    timeFrame;

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int init()
{
 IndicatorBuffers(8);
   SetIndexBuffer(0,green_buffer); SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID);
   SetIndexBuffer(1,red_buffer);   SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID);
   SetIndexBuffer(2,osma);
   SetIndexBuffer(3,macd);
   SetIndexBuffer(4,sig);
   SetIndexBuffer(5,kAMAbuffer);
   SetIndexBuffer(6,diff);
   SetIndexBuffer(7,trend);
   
      fastend   = (2.0 /(Nfast + 1));
      slowend   = (2.0 /(Nslow + 1));
   //
   //
   //
   //
   //
      
     indicatorFileName = WindowExpertName();
     calculateValue    = (TimeFrame=="calculateValue"); if (calculateValue) return(0);
     returnBars        = (TimeFrame=="returnBars");     if (returnBars)     return(0);
     timeFrame         = stringToTimeFrame(TimeFrame);
      
   //
   //
   //
   //
   //
   
   IndicatorShortName(timeFrameToString(timeFrame)+"  adaptive macd  ("+FastMa+")"+getAverageName(FastMaMethod)+" ("+AmaPeriod+")");
   return(0);
}

//
//
//
//
//

int deinit(){  if (!calculateValue && ShowArrows) deleteArrows();  return(0); }

//
//
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

int start()
  {
   
   int counted_bars=IndicatorCounted();
   int i,n,k,x,limit;

   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
         limit=MathMin(Bars-counted_bars,Bars-1);
         if (returnBars)  { green_buffer[0] = limit+1; return(0); }
   
   //
   //
   //
   //
   //
   
   if (calculateValue || timeFrame == Period())
   {
   
   for(i=limit; i>=0; i--)
   {
      double price = iMA(NULL,0,1,0,MODE_SMA,AmaPrice,i);

         if (i > Bars-AmaPeriod) { kAMAbuffer[i] = price; continue; }
   
         //
         //
         //
         //
         //
   
         double efratio = 1.00;
         double noise   = 0.00;
         double smooth;
         double signal;
             signal  = MathAbs(price-iMA(NULL,0,1,0,MODE_SMA,AmaPrice,i+AmaPeriod));
             diff[i] = MathAbs(price-iMA(NULL,0,1,0,MODE_SMA,AmaPrice,i+1));
                for (k=0;k<AmaPeriod;k++)
                        noise += diff[i+k];

          //
          //
          //
          //
          //

                  if (noise != 0) efratio = signal/noise;
                            smooth        = MathPow(efratio*(fastend-slowend)+slowend,GCoeff);
                            kAMAbuffer[i] = kAMAbuffer[i+1] + smooth*(price-kAMAbuffer[i+1]);
                            macd[i]       = iCustomMA(iMA(NULL,0,1,0,MODE_SMA,FastMaPrice,i),FastMa,FastMaMethod,i) - kAMAbuffer[i];
          }
          
         for (i=limit; i>=0; i--) sig[i]  = iMAOnArray(macd,Bars,SignalMa,0,SignalMaMode,i);
   
   //
   //
   //
   //
   //
   
   for (i=limit; i>=0; i--)
   {
   
      osma[i] = macd[i]- sig[i];
      green_buffer[i]  = 0;
      red_buffer[i]    = 0;
        
      if(osma[i] > 0) 
     
           green_buffer[i]   = osma[i];
      else red_buffer[i]     = osma[i]; 
      
      trend[i] = trend[i+1]; 
         
	   if (macd[i] > sig[i] && macd[i+1] <= sig[i+1]) trend[i]= 1; 
	   if (macd[i] < sig[i] && macd[i+1] >= sig[i+1]) trend[i]=-1;
	   
	   if (!calculateValue) manageArrow(i);
      
      //
      //
      //
      //
      //
      
      }
      
      manageAlerts();
      return(0);
      }
  
      //
      //
      //
      //
      //
   
      limit = MathMax(limit,MathMin(Bars,iCustom(NULL,timeFrame,indicatorFileName,"returnBars",0,0)*timeFrame/Period()));
   
      for (i=limit; i>=0; i--)
      {
   
      int y = iBarShift(NULL,timeFrame,Time[i]);
         osma[i]        = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",FastMa,FastMaMethod,FastMaPrice,AmaPeriod,AmaPrice,Nfast,Nslow,GCoeff,SignalMa,SignalMaMode,2,y);
         green_buffer[i]= iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",FastMa,FastMaMethod,FastMaPrice,AmaPeriod,AmaPrice,Nfast,Nslow,GCoeff,SignalMa,SignalMaMode,0,y);
         red_buffer[i]  = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",FastMa,FastMaMethod,FastMaPrice,AmaPeriod,AmaPrice,Nfast,Nslow,GCoeff,SignalMa,SignalMaMode,1,y);
         macd[i]        = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",FastMa,FastMaMethod,FastMaPrice,AmaPeriod,AmaPrice,Nfast,Nslow,GCoeff,SignalMa,SignalMaMode,3,y);
         sig[i]         = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",FastMa,FastMaMethod,FastMaPrice,AmaPeriod,AmaPrice,Nfast,Nslow,GCoeff,SignalMa,SignalMaMode,4,y);
         trend[i]       = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",FastMa,FastMaMethod,FastMaPrice,AmaPeriod,AmaPrice,Nfast,Nslow,GCoeff,SignalMa,SignalMaMode,7,y);
         
         manageArrow(i);

         //
         //
         //
         //
         //
         
         if (!Interpolate || y==iBarShift(NULL,timeFrame,Time[i-1])) continue;

         //
         //
         //
         //
         //

         datetime time = iTime(NULL,timeFrame,y);
         for(n = 1; i+n < Bars && Time[i+n] >= time; n++) continue;	
         for(x = 1; x < n; x++)
         {
  	         osma[i+x]         = osma[i]         + (osma[i+n]         - osma[i])         * x/n;
  	         green_buffer[i+x] = green_buffer[i] + (green_buffer[i+n] - green_buffer[i]) * x/n;
  	         red_buffer[i+x]   = red_buffer[i]   + (red_buffer[i+n]   - red_buffer[i])   * x/n;
  	         macd[i+x]         = macd[i]         + (macd[i+n]         - macd[i])         * x/n;
  	         sig[i+x]          = sig[i]          + (sig[i+n]          - sig[i])          * x/n;
  	      
        }  	            
   }
      
   manageAlerts();
      
   return(0);
}
      
//
//
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

void manageAlerts()
{
   if (!calculateValue && alertsOn)
   {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1; whichBar = iBarShift(NULL,0,iTime(NULL,timeFrame,whichBar));
      if (trend[whichBar] != trend[whichBar+1])
      {
         if (trend[whichBar] ==  1) doAlert(whichBar,"up");
         if (trend[whichBar] == -1) doAlert(whichBar,"down");
      }
   }
}

//
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       //
       //
       //
       //
       //

       message =  StringConcatenate(Symbol()," ",timeFrameToString(timeFrame)," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," adaptive macd changed direction to ",doWhat);
          if (alertsMessage) Alert(message);
          if (alertsEmail)   SendMail(StringConcatenate(Symbol()," adaptive macd "),message);
          if (alertsSound)   PlaySound("alert2.wav");
   }
}

//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

//
//
//
//
//

int stringToTimeFrame(string tfs)
{
   StringToUpper(tfs);
   for (int i=ArraySize(iTfTable)-1; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[i],Period()));
                                                      return(Period());
}
string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

double workPrices[];
double workResult[];
int    r;

double iCustomMA(double price, int period, int method, int i)
{
   if (ArraySize(workPrices)!= Bars) ArrayResize(workPrices,Bars);
            r = Bars-i-1;
   workPrices[r] = price;

   //
   //
   //
   //
   //
   
      switch(method)
      {
         case  0: return(iSma(price,period,i));
         case  1: return(iEma(price,period,i));
         case  2: return(iSmma(price,period,i));
         case  3: return(iLwma(price,period,i));
         case  4: return(iLsma(price,period,i));
         case  5: return(iTma(price,period,i));
         case  6: return(iSineWMA(price,period,i));
         case  7: return(iVolumeWMA(price,period,i));
         case  8: return(iHma(price,period,i));
         case  9: return(iNonLagMa(price,period,i));
         case 10: return(iLwmp(price,period,i));
      }
   return(EMPTY_VALUE);
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

double iSma(double price, double period, int i)
{
   double sum = 0;
   for(int k=0; k<period && (r-k)>=0; k++) sum += workPrices[r-k];  
   if (k!=0)
         return(sum/k);
   else  return(EMPTY_VALUE);
}

//
//
//
//
//

double iEma(double price, double period, int i)
{
   if (ArraySize(workResult)!= Bars) ArrayResize(workResult,Bars);
   double alpha = 2.0 / (1.0+period);
          workResult[r] = workResult[r-1]+alpha*(price-workResult[r-1]);
   return(workResult[r]);
}
//
//
//
//
//

double iSmma(double price, double period, int i)
{
   if (ArraySize(workResult)!= Bars) ArrayResize(workResult,Bars);
   if (i>=(Bars-period))
   {
      double sum = 0; 
         for(int k=0; k<period && (r-k)>=0; k++) sum += workPrices[r-k];  
         if (k!=0)
               workResult[i] = sum/k;
         else  workResult[i] = EMPTY_VALUE;
   }      
   else   workResult[r] = (workResult[r-1]*(period-1)+price)/period;
   return(workResult[r]);
}

//
//
//
//
//

double iLwma_prices[][3];
double iLwma(double price, double period, int i,int forValue=0)
{
   if (ArrayRange(iLwma_prices,0)!= Bars) ArrayResize(iLwma_prices,Bars);
   
   //
   //
   //
   //
   //
   
   iLwma_prices[r][forValue] = price;
      double sum  = 0;
      double sumw = 0;

      for(int k=0; k<period && (r-k)>=0; k++)
      {
         double weight = period-k;
                sumw  += weight;
                sum   += weight*iLwma_prices[r-k][forValue];  
      }             
   if (sumw!=0)
         return(sum/sumw);
   else  return(EMPTY_VALUE);
}

//
//
//
//
//

double iLwmp_prices[][3];
double iLwmp(double price, double period, int i,int forValue=0)
{
   if (ArrayRange(iLwmp_prices,0)!= Bars) ArrayResize(iLwmp_prices,Bars);
   
   //
   //
   //
   //
   //
   
   iLwmp_prices[r][forValue] = price;
      double sum  = 0;
      double sumw = 0;

      for(int k=0; k<period && (r-k)>=0; k++)
      {
         double weight = (period-k)*(period-k);
                sumw  += weight;
                sum   += weight*iLwmp_prices[r-k][forValue];  
      }             
   if (sumw!=0)
         return(sum/sumw);
   else  return(EMPTY_VALUE);
}

//
//
//
//
//

double iLsma(double price, double period, int i)
{
   return(3.0*iLwma(price,period,i)-2.0*iSma(price,period,i));
}

//
//
//
//
//

double iHma(double price, double period, int i)
{
   int HalfPeriod = MathFloor(period/2);
   int HullPeriod = MathFloor(MathSqrt(period));
            double price1 = 2.0*iLwma(price,HalfPeriod,i,0)-iLwma(price,period,i,1);
   return (iLwma(price1,HullPeriod,i,2));
}

//
//
//
//
//

double iTma(double price, double period, int i)
{
   double half = (period+1.0)/2.0;
   double sum  = 0;
   double sumw = 0;

   for(int k=0; k<period && (r-k)>=0; k++)
   {
      double weight = k+1; if (weight > half) weight = period-k;
             sumw  += weight;
             sum   += weight*workPrices[r-k];  
   }             
   if (sumw!=0)
         return(sum/sumw);
   else  return(EMPTY_VALUE);
}

//
//
//
//
//

#define Pi 3.14159265358979323846
double iSineWMA(double price, int period, int i)
{
   double sum  = 0;
   double sumw = 0;
  
   for(int k=0; k<period && (r-k)>=0; k++)
   { 
      double weight = MathSin(Pi*(k+1)/(period+1));
             sumw  += weight;
             sum   += weight*workPrices[r-k]; 
   }
   if (sumw!=0)
         return(sum/sumw);
   else  return(EMPTY_VALUE);
}

//
//
//
//
//

double iVolumeWMA(double price, int period, int i)
{
   double sum  = 0;
   double sumw = 0;
  
   for(int k=0; k<period && (r-k)>=0; k++)
   { 
      double weight = Volume[i+k];
             sumw  += weight;
             sum   += weight*workPrices[r-k]; 
   }
   if (sumw!=0)
         return(sum/sumw);
   else  return(EMPTY_VALUE);
}


//+------------------------------------------------------------------
//|                                                                  
//+------------------------------------------------------------------
//
//
//
//
//

#define _length  0
#define _len     1
#define _weight  2

#define numOfSeparateCalculations 1
double  nlm_values[3][numOfSeparateCalculations];
double  nlm_prices[ ][numOfSeparateCalculations];
double  nlm_alphas[ ][numOfSeparateCalculations];

//
//
//
//
//

double iNonLagMa(double price, int length, int i, int forValue=0)
{
   if (ArrayRange(nlm_prices,0) != Bars) ArrayResize(nlm_prices,Bars);
            int r = Bars-i-1;  nlm_prices[r][forValue]=price;
   if (length<3 || r<3) return(nlm_prices[r][forValue]);
   
   //
   //
   //
   //
   //
   
   if (nlm_values[_length][forValue] != length)
   {
      double Cycle = 4.0;
      double Coeff = 3.0*Pi;
      int    Phase = length-1;
      
         nlm_values[_length][forValue] = length;
         nlm_values[_len   ][forValue] = length*4 + Phase;  
         nlm_values[_weight][forValue] = 0;

         if (ArrayRange(nlm_alphas,0) < nlm_values[_len][forValue]) ArrayResize(nlm_alphas,nlm_values[_len][forValue]);
         for (int k=0; k<nlm_values[_len][forValue]; k++)
         {
            if (k<=Phase-1) 
                 double t = 1.0 * k/(Phase-1);
            else        t = 1.0 + (k-Phase+1)*(2.0*Cycle-1.0)/(Cycle*length-1.0); 
            double beta = MathCos(Pi*t);
            double g = 1.0/(Coeff*t+1); if (t <= 0.5 ) g = 1;
      
            nlm_alphas[k][forValue]        = g * beta;
            nlm_values[_weight][forValue] += nlm_alphas[k][forValue];
         }
   }
   
   //
   //
   //
   //
   //
   
   if (nlm_values[_weight][forValue]>0)
   {
      double sum = 0;
           for (k=0; k < nlm_values[_len][forValue]; k++) sum += nlm_alphas[k][forValue]*nlm_prices[r-k][forValue];
           return( sum / nlm_values[_weight][forValue]);
   }
   else return(0);           
}


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

string methodNames[] = {"SMA","EMA","SMMA","LWMA","LSMA","TriMA","SWMA","VWMA","HullMA","NonLagMA","LWM parabolic"};
string getAverageName(int& method)
{
   method=MathMax(MathMin(method,10),0); return(methodNames[method]);
}

//
//
//
//
//

void manageArrow(int i)
{
   if (!calculateValue && ShowArrows)
   {
      deleteArrow(Time[i]);
      if (trend[i]!=trend[i+1])
      {
         if (trend[i] == 1) drawArrow(i,arrowsUpColor,221,false);
         if (trend[i] ==-1) drawArrow(i,arrowsDnColor,222,true);
      }
   }
}               

//
//
//
//
//

void drawArrow(int i,color theColor,int theCode,bool up)
{
   string name = arrowsIdentifier+":"+Time[i];
   double gap  = iATR(NULL,0,20,i);   
   
      //
      //
      //
      //
      //
      
      ObjectCreate(name,OBJ_ARROW,0,Time[i],0);
         ObjectSet(name,OBJPROP_ARROWCODE,theCode);
         ObjectSet(name,OBJPROP_COLOR,theColor);
  
         if (up)
               ObjectSet(name,OBJPROP_PRICE1,High[i]+gap);
         else  ObjectSet(name,OBJPROP_PRICE1,Low[i] -gap);
}

//
//
//
//
//

void deleteArrows()
{
   string lookFor       = arrowsIdentifier+":";
   int    lookForLength = StringLen(lookFor);
   for (int i=ObjectsTotal()-1; i>=0; i--)
   {
      string objectName = ObjectName(i);
         if (StringSubstr(objectName,0,lookForLength) == lookFor) ObjectDelete(objectName);
   }
}

void deleteArrow(datetime time)
{
   string lookFor = arrowsIdentifier+":"+time; ObjectDelete(lookFor);
}

//
//
//
//
//

