#property copyright   "http://www.bestexpertadvisors.com"
#property link        "http://www.bestexpertadvisors.com"
#property description "Our amazing premium EAs and new systems are coming soon."
#property description "You can follow us to get the latest news."

#property strict

#property indicator_separate_window
#property indicator_buffers 8

#property indicator_level1 0.0


#define SS_MIN_SMOOTHING 	0.1
#define ARROW_EMPTY -999

#define SYMBOL_COUNT 28
#define CURRENCY_COUNT 8

#define NO_ERROR 0
#define STD_ERROR -1
#define PI1    3.141592653589793          // 1 * pi   3,141592653589793
#define SQRT21      1.414213562373095         // 1 * sqrt(2)
#define MINIMUMDENOMINATOR 0.00000001


enum CURR_INDEX_METHOD {
	CURR_INDEX_METHOD_USD = 0,		// USD index
	CURR_INDEX_METHOD_EUR = 1		// EUR index
};

int ciDepth = 0;					// depth of currency index array
double ciBaseFactor = 0.0;		// currency index base factor
string ciBaseCurrency = "";	// currency index base currency

struct CURRENCY_INDEX {		// PURPOSE																
   int index;					// unique symbol index												
   string name;				// symbol name															
   double expo;				// symbol exponent
};
CURRENCY_INDEX currencyIndex[];

struct CURRENCY_INDEX_CROSS {		// PURPOSE																
   int index;							// unique symbol index												
   string name;						// symbol name															
   double sign;						// symbol exponent sign for index calculation
   double reference;					// past reference index value
   double current;					// current index value
};
CURRENCY_INDEX_CROSS currencyIndexCross[CURRENCY_COUNT];

struct CURRENCY_PROPERTIES {	// PURPOSE												
   int index;						// unique currency index							
   string name;					// currency name										
   bool isBase;					// true if this is current base currency		
   bool isQuote;					// true if this is current quote currency		
   int arrBuy;						// buy arrow code									
   int arrSell;					// sell arrow code									
};
CURRENCY_PROPERTIES cuProp[CURRENCY_COUNT];

#define S_AUD "AUD"
#define S_CAD "CAD"
#define S_CHF "CHF"
#define S_EUR "EUR"
#define S_GBP "GBP"
#define S_JPY "JPY"
#define S_NZD "NZD"
#define S_USD "USD"

#define I_AUD 0
#define I_CAD 1
#define I_CHF 2
#define I_EUR 3
#define I_GBP 4
#define I_JPY 5
#define I_NZD 6
#define I_USD 7


input string s___general				= "-------     General Settings     -------";				// -----------------------------------------------------------------
input CURR_INDEX_METHOD ciAlgorithm	= CURR_INDEX_METHOD_USD;	// index algorithm
input int referenceDays					= 2;								// reference point: days in the past
input double finalSmoothing			= 0.0;							// final smoothing length (0: OFF)
input int inputMaxBars					= 5000;							// maximum bar count
input string s___colour					= "-------     Currency Colour Selection     -------";	// -----------------------------------------------------------------
input color colorAUD						= clrGold;				// colour AUD
input color colorCAD						= clrOrchid;			// colour CAD
input color colorCHF						= clrDarkGoldenrod;	// colour CHF
input color colorEUR						= clrSkyBlue;			// colour EUR
input color colorGBP						= clrOrangeRed;		// colour GBP
input color colorJPY						= clrPink;				// colour JPY
input color colorNZD						= clrLemonChiffon;	// colour NZD
input color colorUSD						= clrYellowGreen;		// colour USD
input string s___currency				= "-------     Currency Display Selection     -------";	// -----------------------------------------------------------------
input int widthCurrent					= 2;						// width of current pair line
input bool displayAUD					= true;					// display AUD
input bool displayCAD					= true;					// display CAD
input bool displayCHF					= true;					// display CHF
input bool displayEUR					= true;					// display EUR
input bool displayGBP					= true;					// display GBP
input bool displayJPY					= true;					// display JPY
input bool displayNZD					= true;					// display NZD
input bool displayUSD					= true;					// display USD

// this is used in func lineDisp()   -   don't delete!
bool displayCurrent						= false;					// display current pair only (override)
 

// currency buffers
double bEUR[], bGBP[], bAUD[], bCHF[], bJPY[], bNZD[], bCAD[], bUSD[];	// buffers (smoothed)
double rEUR[], rGBP[], rAUD[], rCHF[], rJPY[], rNZD[], rCAD[], rUSD[];	// raw buffers (unsmoothed)


double ssCoeff[];	// Ehlers SuperSmoother Coefficients
string symb;
int tf, maxBars;

int baseIndex = 0, quoteIndex = 0, currencyCount = CURRENCY_COUNT;



/* -----------------------------------------------------------
   init
   ---------------------------------------------------------- */
int init() {
	symb = Symbol();
	tf = Period();
	string sAlgo = "";
	
	// preparation of currency index algorithm 		START
	int ci = -1,  xi = 0;
	if (ciAlgorithm == CURR_INDEX_METHOD_USD) {
		sAlgo = "USDx";
		ciBaseCurrency = "USD";
		ciDepth = 6;
		ArrayResize(currencyIndex, 6);
		ciBaseFactor = 50.14348112;
		ci++;		currencyIndex[ci].index = ci;		currencyIndex[ci].name = "EURUSD";	currencyIndex[ci].expo = -0.576;		// EUR 57.6 %
		ci++;		currencyIndex[ci].index = ci;		currencyIndex[ci].name = "USDJPY";	currencyIndex[ci].expo =  0.136;		// JPY 13.6 %
		ci++;		currencyIndex[ci].index = ci;		currencyIndex[ci].name = "GBPUSD";	currencyIndex[ci].expo = -0.119;		// GBP 11.9 %
		ci++;		currencyIndex[ci].index = ci;		currencyIndex[ci].name = "USDCAD";	currencyIndex[ci].expo =  0.091;		// CAD  9.1 %
		ci++;		currencyIndex[ci].index = ci;		currencyIndex[ci].name = "USDSEK";	currencyIndex[ci].expo =  0.042;		// SEK  4.2 %
		ci++;		currencyIndex[ci].index = ci;		currencyIndex[ci].name = "USDCHF";	currencyIndex[ci].expo =  0.036;		// CHF  3.6 %
	}	
	else if (ciAlgorithm == CURR_INDEX_METHOD_EUR) {
		sAlgo = "EURx";
		ciBaseCurrency = "EUR";
		ciDepth = 5;
		ArrayResize(currencyIndex, 5);
		ciBaseFactor = 34.38805726;
		ci++;		currencyIndex[ci].index = ci;		currencyIndex[ci].name = "EURUSD";	currencyIndex[ci].expo = 0.3155;		// USD 31.55 %
		ci++;		currencyIndex[ci].index = ci;		currencyIndex[ci].name = "EURGBP";	currencyIndex[ci].expo = 0.3056;		// GBP 30.56 %
		ci++;		currencyIndex[ci].index = ci;		currencyIndex[ci].name = "EURJPY";	currencyIndex[ci].expo = 0.1891;		// JPY 18.91 %
		ci++;		currencyIndex[ci].index = ci;		currencyIndex[ci].name = "EURSEK";	currencyIndex[ci].expo = 0.0785;		// SEK  7.85 %
		ci++;		currencyIndex[ci].index = ci;		currencyIndex[ci].name = "EURCHF";	currencyIndex[ci].expo = 0.1113;		// CHF 11.13 %
	}	
	
	if (ciBaseCurrency == "USD") {
		xi = I_AUD;	currencyIndexCross[xi].index = xi;	currencyIndexCross[xi].name = "AUDUSD";	currencyIndexCross[xi].sign =  1.0;		// AUDUSD
		xi = I_CAD;	currencyIndexCross[xi].index = xi;	currencyIndexCross[xi].name = "USDCAD";	currencyIndexCross[xi].sign = -1.0;		// USDCAD
		xi = I_CHF;	currencyIndexCross[xi].index = xi;	currencyIndexCross[xi].name = "USDCHF";	currencyIndexCross[xi].sign = -1.0;		// USDCHF
		xi = I_EUR;	currencyIndexCross[xi].index = xi;	currencyIndexCross[xi].name = "EURUSD";	currencyIndexCross[xi].sign =  1.0;		// EURUSD
		xi = I_GBP;	currencyIndexCross[xi].index = xi;	currencyIndexCross[xi].name = "GBPUSD";	currencyIndexCross[xi].sign =  1.0;		// GBPUSD
		xi = I_JPY;	currencyIndexCross[xi].index = xi;	currencyIndexCross[xi].name = "USDJPY";	currencyIndexCross[xi].sign = -1.0;		// USDJPY
		xi = I_NZD;	currencyIndexCross[xi].index = xi;	currencyIndexCross[xi].name = "NZDUSD";	currencyIndexCross[xi].sign =  1.0;		// NZDUSD
		xi = I_USD;	currencyIndexCross[xi].index = xi;	currencyIndexCross[xi].name = "";			currencyIndexCross[xi].sign =  0.0;		// ---
	}
	else if (ciBaseCurrency == "EUR") {
		xi = I_AUD;	currencyIndexCross[xi].index = xi;	currencyIndexCross[xi].name = "EURAUD";	currencyIndexCross[xi].sign = -1.0;		// EURAUD
		xi = I_CAD;	currencyIndexCross[xi].index = xi;	currencyIndexCross[xi].name = "EURCAD";	currencyIndexCross[xi].sign = -1.0;		// EURCAD
		xi = I_CHF;	currencyIndexCross[xi].index = xi;	currencyIndexCross[xi].name = "EURCHF";	currencyIndexCross[xi].sign = -1.0;		// EURCHF
		xi = I_EUR;	currencyIndexCross[xi].index = xi;	currencyIndexCross[xi].name = "";			currencyIndexCross[xi].sign =  0.0;		// ---
		xi = I_GBP;	currencyIndexCross[xi].index = xi;	currencyIndexCross[xi].name = "EURGBP";	currencyIndexCross[xi].sign = -1.0;		// EURGBP
		xi = I_JPY;	currencyIndexCross[xi].index = xi;	currencyIndexCross[xi].name = "EURJPY";	currencyIndexCross[xi].sign = -1.0;		// EURJPY
		xi = I_NZD;	currencyIndexCross[xi].index = xi;	currencyIndexCross[xi].name = "EURNZD";	currencyIndexCross[xi].sign = -1.0;		// EURNZD
		xi = I_USD;	currencyIndexCross[xi].index = xi;	currencyIndexCross[xi].name = "EURUSD";	currencyIndexCross[xi].sign = -1.0;		// EURUSD
	}
	
	// set reference value
	for (xi = 0; xi < CURRENCY_COUNT; xi++) {
		currencyIndexCross[xi].reference = getCurrencyIndexValue(1440, referenceDays, xi);
	}
	// preparation of currency index algorithm 		END
	
	prepareCurrencies(cuProp);	// prepare currencies array FIRST!
	
	maxBars = 0;
	if (inputMaxBars > 0) {
		maxBars = (int)MathMax(inputMaxBars, 300);
	}

	IndicatorBuffers(CURRENCY_COUNT * 2);
	
	// visible buffers
   int b = -1;
	string sC = "";
	
	b++; sC = S_AUD; SetIndexBuffer(b,bAUD); SetIndexLabel(b,sC); SetIndexStyle(b,lineDisp(symb,sC,displayAUD), STYLE_SOLID, lineWidth(symb,sC), colorAUD);
	b++; sC = S_CAD; SetIndexBuffer(b,bCAD); SetIndexLabel(b,sC); SetIndexStyle(b,lineDisp(symb,sC,displayCAD), STYLE_SOLID, lineWidth(symb,sC), colorCAD);
	b++; sC = S_CHF; SetIndexBuffer(b,bCHF); SetIndexLabel(b,sC); SetIndexStyle(b,lineDisp(symb,sC,displayCHF), STYLE_SOLID, lineWidth(symb,sC), colorCHF);
	b++; sC = S_EUR; SetIndexBuffer(b,bEUR); SetIndexLabel(b,sC); SetIndexStyle(b,lineDisp(symb,sC,displayEUR), STYLE_SOLID, lineWidth(symb,sC), colorEUR);
	b++; sC = S_GBP; SetIndexBuffer(b,bGBP); SetIndexLabel(b,sC); SetIndexStyle(b,lineDisp(symb,sC,displayGBP), STYLE_SOLID, lineWidth(symb,sC), colorGBP);
	b++; sC = S_JPY; SetIndexBuffer(b,bJPY); SetIndexLabel(b,sC); SetIndexStyle(b,lineDisp(symb,sC,displayJPY), STYLE_SOLID, lineWidth(symb,sC), colorJPY);
	b++; sC = S_NZD; SetIndexBuffer(b,bNZD); SetIndexLabel(b,sC); SetIndexStyle(b,lineDisp(symb,sC,displayNZD), STYLE_SOLID, lineWidth(symb,sC), colorNZD);
	b++; sC = S_USD; SetIndexBuffer(b,bUSD); SetIndexLabel(b,sC); SetIndexStyle(b,lineDisp(symb,sC,displayUSD), STYLE_SOLID, lineWidth(symb,sC), colorUSD);
	
	// invisible buffers
   b++; SetIndexBuffer(b,rAUD); 
   b++; SetIndexBuffer(b,rCAD); 
   b++; SetIndexBuffer(b,rCHF); 
   b++; SetIndexBuffer(b,rEUR); 
   b++; SetIndexBuffer(b,rGBP); 
   b++; SetIndexBuffer(b,rJPY); 
   b++; SetIndexBuffer(b,rNZD); 
   b++; SetIndexBuffer(b,rUSD); 
	
	string sm = "";
	if (finalSmoothing >= SS_MIN_SMOOTHING) {
		if (pSuperSmoother(ssCoeff, finalSmoothing) != 0) {
			Print("Ehlers Supersmoother could not be initialized - indicator terminated.");
			return(INIT_FAILED);
		}
		sm = StringConcatenate(" fs[", DoubleToString(finalSmoothing,2), "]");
	}
	
	string w  = WindowExpertName();
   // string ps = " " + getPriceStringStd(priceUsed);
   string ps = "";
   string sn = StringConcatenate(w, " ", sAlgo, sm, ps);
   IndicatorShortName(sn);
	
   IndicatorDigits(3);

	return(INIT_SUCCEEDED);
}


/* -----------------------------------------------------------
   deinit
   ---------------------------------------------------------- */
int deinit() {
	return(0);
}


/* -----------------------------------------------------------
   start
   ---------------------------------------------------------- */
int start() {
	int countedBars = IndicatorCounted();

	if (countedBars < 0) {
		return(-1);
	}
	if (countedBars > 0) {
		countedBars--;
	}

	int limit = Bars - countedBars - 3;
	if (maxBars > 0) {
		limit = (int)MathMin(limit, maxBars);
	}

	for (int shift = limit; shift >= 0; shift--) {
		// calculate raw index values
		int xi = 0;
		for (xi = 0; xi < CURRENCY_COUNT; xi++) {
			currencyIndexCross[xi].current = getCurrencyIndexValue(tf, shift, xi);
		}
		
		// -------------------------------------------------------------------- set raw value buffers
		xi = I_AUD;		rAUD[shift] = 100.0 * safeDivide((currencyIndexCross[xi].current - currencyIndexCross[xi].reference), currencyIndexCross[xi].reference);
		xi = I_CAD;		rCAD[shift] = 100.0 * safeDivide((currencyIndexCross[xi].current - currencyIndexCross[xi].reference), currencyIndexCross[xi].reference);
		xi = I_CHF;		rCHF[shift] = 100.0 * safeDivide((currencyIndexCross[xi].current - currencyIndexCross[xi].reference), currencyIndexCross[xi].reference);
		xi = I_EUR;		rEUR[shift] = 100.0 * safeDivide((currencyIndexCross[xi].current - currencyIndexCross[xi].reference), currencyIndexCross[xi].reference);
		xi = I_GBP;		rGBP[shift] = 100.0 * safeDivide((currencyIndexCross[xi].current - currencyIndexCross[xi].reference), currencyIndexCross[xi].reference);
		xi = I_JPY;		rJPY[shift] = 100.0 * safeDivide((currencyIndexCross[xi].current - currencyIndexCross[xi].reference), currencyIndexCross[xi].reference);
		xi = I_NZD;		rNZD[shift] = 100.0 * safeDivide((currencyIndexCross[xi].current - currencyIndexCross[xi].reference), currencyIndexCross[xi].reference);
		xi = I_USD;		rUSD[shift] = 100.0 * safeDivide((currencyIndexCross[xi].current - currencyIndexCross[xi].reference), currencyIndexCross[xi].reference);

		// -------------------------------------------------------------------- display buffers
		if (finalSmoothing < SS_MIN_SMOOTHING) {
			bAUD[shift] = rAUD[shift];
			bCAD[shift] = rCAD[shift];
			bCHF[shift] = rCHF[shift];
			bEUR[shift] = rEUR[shift];
			bGBP[shift] = rGBP[shift];
			bJPY[shift] = rJPY[shift];
			bNZD[shift] = rNZD[shift];
			bUSD[shift] = rUSD[shift];
		}
		else {
			bAUD[shift] = ipSuperSmootherOnArray(rAUD, bAUD, ssCoeff, shift);
			bCAD[shift] = ipSuperSmootherOnArray(rCAD, bCAD, ssCoeff, shift);
			bCHF[shift] = ipSuperSmootherOnArray(rCHF, bCHF, ssCoeff, shift);
			bEUR[shift] = ipSuperSmootherOnArray(rEUR, bEUR, ssCoeff, shift);
			bGBP[shift] = ipSuperSmootherOnArray(rGBP, bGBP, ssCoeff, shift);
			bJPY[shift] = ipSuperSmootherOnArray(rJPY, bJPY, ssCoeff, shift);
			bNZD[shift] = ipSuperSmootherOnArray(rNZD, bNZD, ssCoeff, shift);
			bUSD[shift] = ipSuperSmootherOnArray(rUSD, bUSD, ssCoeff, shift);
		}
				
	}

	return(0);
}


/* -----------------------------------------------------------
   getCurrencyIndexValue
	---
	Coded by simplex, 2015
   ---------------------------------------------------------- */
double getCurrencyIndexValue(const int _tf, const int sh, const int currIndex) {
	double out = ciBaseFactor;
	for (int ci = 0; ci < ciDepth; ci++) {
		out *= MathPow(iClose(currencyIndex[ci].name, _tf, sh), currencyIndex[ci].expo);
	}
	if (MathAbs(currencyIndexCross[currIndex].sign) > 0.5) {
		double price = iClose(currencyIndexCross[currIndex].name, _tf, sh);
		out *= MathPow(price, currencyIndexCross[currIndex].sign);
	}
	return(out);
}


/* -----------------------------------------------------------
   lineWidth
	---
	Coded by simplex, 2015
   ---------------------------------------------------------- */
int lineWidth(const string sym, const string curr) {
	int out = 1;
	if (StringFind(sym, curr) > -1) {
		out = widthCurrent;
	}
	return(out);
}


/* -----------------------------------------------------------
   lineDisp
	---
	Coded by simplex, 2015
   ---------------------------------------------------------- */
int lineDisp(const string sym, const string curr, const bool displayCurrency) {
	int out = DRAW_NONE;
	if (displayCurrent) {
		if (StringFind(sym, curr) > -1) {
			out = DRAW_LINE;
		}
	}
	else {
		if (displayCurrency) {
			out = DRAW_LINE;
		}
	}
	return(out);
}


/* ----------------------------------------------------
	getBaseCurrency
	returns a string for the base currency of the pair
	---
	Coded by simplex, 2014
	---------------------------------------------------- */
string getBaseCurrency(const string _pair) {
	string out = StringSubstr(_pair, 0, 3);
	return(out);
}


/* ----------------------------------------------------
	getQuoteCurrency
	returns a string for the quote currency of the pair
	---
	Coded by simplex, 2014
	---------------------------------------------------- */
string getQuoteCurrency(const string _pair) {
	string out = StringSubstr(_pair, 3, 3);
	return(out);
}


/* ----------------------------------------------------
	pSuperSmoother
	John Ehlers' Supersmoother
	---
	Coded by simplex, 2014-02
	---------------------------------------------------- */
int pSuperSmoother(double &_coeff[], const double smooPeriod = 10) {
	string s = "Supersmoother Coeff Array ";
	if (ArrayRange(_coeff,0) != 3) {
		ArrayResize(_coeff,3);
		if (ArrayRange(_coeff,0) != 3) {
			Print(s + "COULD NOT BE RESIZED: " + IntegerToString(ArrayRange(_coeff,0)));
			return(STD_ERROR);
		}
	}
	double a1 = MathExp(-SQRT21 * PI1 / smooPeriod);
	double b1 = 2.0 * a1 * MathCos(SQRT21 * PI1 / smooPeriod);
	_coeff[1] = b1;						// c2
	_coeff[2] = -a1 * a1;				// c3
	_coeff[0] = 1.0 - _coeff[1] - _coeff[2];		// c1
	return(NO_ERROR);
}


/* ----------------------------------------------------
	ipSuperSmootherOnArray
	John Ehlers' Supersmoother
	---
	Coded by simplex, 2014-02
	---------------------------------------------------- */
double ipSuperSmootherOnArray(double &inArray[], double &outArray[], double &_coeff[], const int sh) {
	double out = 0.0;
	out = _coeff[0] * (inArray[sh] + inArray[sh+1]) / 2.0 
		 + _coeff[1] * outArray[sh+1] 
		 + _coeff[2] * outArray[sh+2];
	return(out);
}


/* -----------------------------------------------------------
   prepareCurrencies
	---
	Coded by simplex, 2015
   ---------------------------------------------------------- */
void prepareCurrencies(CURRENCY_PROPERTIES &cup[]) {
	cup[I_AUD].index = I_AUD;
	cup[I_CAD].index = I_CAD;
	cup[I_CHF].index = I_CHF;
	cup[I_EUR].index = I_EUR;
	cup[I_GBP].index = I_GBP;
	cup[I_JPY].index = I_JPY;
	cup[I_NZD].index = I_NZD;
	cup[I_USD].index = I_USD;
	
	cup[I_AUD].name = S_AUD;
	cup[I_CAD].name = S_CAD;
	cup[I_CHF].name = S_CHF;
	cup[I_EUR].name = S_EUR;
	cup[I_GBP].name = S_GBP;
	cup[I_JPY].name = S_JPY;
	cup[I_NZD].name = S_NZD;
	cup[I_USD].name = S_USD;
	
	for (int i=0; i<currencyCount; i++) {
		if (getBaseCurrency(symb) == cuProp[i].name) {
			cuProp[i].isBase  = true;
			baseIndex = i;
		}
		else {
			cuProp[i].isBase  = false;
		}
		
		if (getQuoteCurrency(symb) == cuProp[i].name) {
			cuProp[i].isQuote  = true;
			quoteIndex = i;
		}
		else {
			cuProp[i].isQuote  = false;
		}
		
		if (cuProp[i].isBase || cuProp[i].isQuote) {
			cuProp[i].arrBuy  = 233;
			cuProp[i].arrSell = 234;
		}
		else {
			cuProp[i].arrBuy  = 241;
			cuProp[i].arrSell = 242;
		}
		Print("Currency prepared: " + cup[i].name + " (" + IntegerToString(cup[i].index) + ")");
	}

}


/* ----------------------------------------------------
	safeDenominator
	Avoid divide by zero errors: check whether denominator
	is smaller than defined threshold (MINIMUMDENOMINATOR).
	Function output preserves sign of _input value.
	---------------------------------------------------- */
double safeDenominator(double in) {
	double out = MINIMUMDENOMINATOR;
	if (in > 0.0) {
		out = MathMax(in, MINIMUMDENOMINATOR);
	}
	else if (in < 0.0) {
		out = MathMin(in, -MINIMUMDENOMINATOR);
	}
	return(out);
}


/* ----------------------------------------------------
	safeDivide
	---------------------------------------------------- */
double safeDivide(double num, double den) {
	double out = 0.0;
	out = num / safeDenominator(den);
	return(out);
}



/* --------------------------------------------------------------------------
   Coded by simplex, 2015
   END OF PROGRAM FILE
   -------------------------------------------------------------------------- */
