//+------------------------------------------------------------------+
//|                                                   ADXcrosses.mq4 |
//+------------------------------------------------------------------+
#property copyright ""
#property link ""

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1  Blue
#property indicator_color2  Red
#property indicator_width1  4
#property indicator_width2  4
#property indicator_minimum 0
#property indicator_maximum 1

//---- input parameters
extern int ADXcrossesPeriod = 14;
extern bool   alertsOn        = true;
extern bool   alertsOnCurrent = false;
extern bool   alertsMessage   = true;
extern bool   alertsSound     = false;
extern bool   alertsEmail     = false;
//---- buffers
double UpH[];
double DnH[];
double trend[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{

   IndicatorBuffers(3);
   SetIndexBuffer(0,UpH);    SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(1,DnH);    SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(2,trend);

    return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
    return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+

int start()
{
      int i,counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
           int limit=MathMin(Bars-counted_bars,Bars-1);
      //
      //
      //
      //
      //
      
      for (i=limit; i>=0; i--)
      {
         double nowplusdi  = iADX(NULL,0,ADXcrossesPeriod,PRICE_CLOSE,MODE_PLUSDI, i);
         double nowminusdi = iADX(NULL,0,ADXcrossesPeriod,PRICE_CLOSE,MODE_MINUSDI,i);  
         UpH[i]   = EMPTY_VALUE;
         DnH[i]   = EMPTY_VALUE;
         trend[i] = trend[i+1];
         
         //
         //
         //
         //
         //
          
         if (nowplusdi>nowminusdi) trend[i] = 1;
         if (nowplusdi<nowminusdi) trend[i] =-1; 
         if (trend[i] == 1)   UpH[i] = 1;
         if (trend[i] ==-1)   DnH[i] = 1;
    
      }
      manageAlerts();
return(0);
}
//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

void manageAlerts()
{
   if (alertsOn)
   {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1;
      if (trend[whichBar]!=trend[whichBar+1])
      {
         if (trend[whichBar] == -1) doAlert(whichBar,"down");
         if (trend[whichBar] ==  1) doAlert(whichBar,"up");
      }         
   }
}

//
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       //
       //
       //
       //
       //

       message =  StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," ADX trend changeed to ",doWhat);
          if (alertsMessage) Alert(message);
          if (alertsEmail)   SendMail(StringConcatenate(Symbol()," ADX crosses "),message);
          if (alertsSound)   PlaySound("alert2.wav");
   }
}