
//------------------------------------------------------------------
#property copyright "www.forex-station.com"
#property link      "www.forex-station.com"
//------------------------------------------------------------------
#property indicator_separate_window
#property indicator_buffers  2
#property indicator_color1   clrLime
#property indicator_color2   clrRed
#property indicator_width1   2
#property indicator_width2   2
#property indicator_minimum  0
#property indicator_maximum  1
#property strict

//
//
//
//
//

extern ENUM_TIMEFRAMES TimeFrame       = PERIOD_CURRENT;    // Time frame to use
extern int             AdxPeriod       = 14;                // Adx period
extern bool            alertsOn        = true;              // Turn alerts on?
extern bool            alertsOnCurrent = false;             // Alerts on current (still opened) bar?
extern bool            alertsMessage   = true;              // Alerts should display a message?
extern bool            alertsSound     = false;             // Alerts should play a sound?
extern bool            alertsEmail     = false;             // Alerts should send an email?
extern bool            alertsNotify    = false;             // Alerts should send notification?
extern string          soundFile       = "alert2.wav";      // Sound file

double Up[],Dn[],trend[],count[];
string indicatorFileName;
#define _mtfCall(_buff,_ind) iCustom(NULL,TimeFrame,indicatorFileName,PERIOD_CURRENT,AdxPeriod,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsEmail,alertsNotify,soundFile,_buff,_ind)

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int init()
{
   IndicatorBuffers(4);  
   SetIndexBuffer(0,Up);  SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(1,Dn);  SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(2,trend);
   SetIndexBuffer(3,count);
   
   indicatorFileName = WindowExpertName();
   TimeFrame         = fmax(TimeFrame,_Period); 
return(0);
}
int deinit() {  return(0); }

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//

int start()
{
    int i,counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
            int limit = MathMin(Bars-counted_bars,Bars-1); count[0] = limit;
            if (TimeFrame != _Period)
            {
               limit = (int)MathMax(limit,MathMin(Bars-1,_mtfCall(3,0)*TimeFrame/Period()));
               for (i=limit; i>=0; i--)
               {
                  int y = iBarShift(NULL,TimeFrame,Time[i]);
                     Up[i]  = _mtfCall(0,y);
                     Dn[i]  = _mtfCall(1,y);
               }
   return(0);
   }
         
   //
   //
   //
   //
   //
            
   for(i=limit; i>=0; i--)
   {
      double adxplus  = iADX(NULL,0,AdxPeriod,PRICE_CLOSE,MODE_PLUSDI, i);
      double adxminus = iADX(NULL,0,AdxPeriod,PRICE_CLOSE,MODE_MINUSDI,i);
      trend[i] = (i<Bars-1) ? (adxplus>adxminus) ? 1 : (adxplus<adxminus) ? -1 : trend[i+1] : 0;  
      Up[i] = (trend[i] ==  1) ? 1 : EMPTY_VALUE;
      Dn[i] = (trend[i] == -1) ? 1 : EMPTY_VALUE;
   }
         
   if (alertsOn)
   {
      int whichBar = 1; if (alertsOnCurrent) whichBar = 0; 
      if (trend[whichBar] != trend[whichBar+1])
      if (trend[whichBar] == 1)
            doAlert(" crossing up");
      else  doAlert(" crossing down");       
   }
return(0);
}

//-------------------------------------------------------------------
//                                                                  
//-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//+------------------------------------------------------------------+
//
//
//
//

void doAlert(string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
      if (previousAlert != doWhat || previousTime != Time[0]) {
          previousAlert  = doWhat;
          previousTime   = Time[0];

          //
          //
          //
          //
          //

          message =  StringConcatenate(Symbol()," ",timeFrameToString(_Period)," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," Adx ",doWhat);
             if (alertsMessage) Alert(message);
             if (alertsNotify)  SendNotification(message);
             if (alertsEmail)   SendMail(_Symbol+" Adx ",message);
             if (alertsSound)   PlaySound(soundFile);
      }
}

