#property copyright   "www.forex-indicators.org"
#property link        "http://www.forex-indicators.org"
#property description "If this indicator does not work, please contact us at: emails@forex-indicators.org"

#property strict

#property indicator_chart_window
#property indicator_buffers 1
#property indicator_color1 clrDodgerBlue
#property indicator_width1 8



int width = 5;
color color_ = clrBlue;

double line[];
string identif="NN_ddra";
int prev_scale=int(ChartGetInteger(0,CHART_SCALE));

/////////////////////////////////////////////////////////////////
int OnInit()
  {
  //
  ChartSetInteger(0,CHART_MODE,CHART_LINE);
  
  //
SetIndexBuffer(0,line);

//
del_f();


   return(INIT_SUCCEEDED);
  }


//////////////////////////////////////////////////////////////
 void OnDeinit(const int reason)
 {
 //
 del_f();

 }


//////////////////////////////////////////////////////////////////
int OnCalculate(const int rates_total,const int prev_calculated,const datetime &time[],const double &open[],const double &high[],
                const double &low[],const double &close[],const long &tick_volume[],const long &volume[],const int &spread[])
  {
   //no bars
 if(Bars<20) return(0);
  
  //history update
  int all=rates_total;
  int counted=prev_calculated;
  if(all-counted>1)
  {
  del_f();
  ArrayInitialize(line,EMPTY_VALUE);
  counted=0;
  }
  
  

   //main
 for(int i=all-counted+1;i>=0;i--)
 {
 if(i>Bars-20) i=Bars-20;

  drawHist(i);
  line[i]=Close[i];
 }






   return(rates_total);
  }


////////////////////////////////////////////////////////////////////////////////
void OnChartEvent(const int id,const long& lparam,  const double& dparam, const string& sparam)
{
if(id==CHARTEVENT_CHART_CHANGE) 
{
int chart_width=int(ChartGetInteger(0,CHART_SCALE));

if(chart_width!=prev_scale)
{
if(chart_width==5) {SetIndexStyle(0,DRAW_LINE,EMPTY,31);width=32;}
else
if(chart_width==4) {SetIndexStyle(0,DRAW_LINE,EMPTY,17);width=16;}
else
if(chart_width==3) {SetIndexStyle(0,DRAW_LINE,EMPTY,7);width=8;}
else
if(chart_width==2) {SetIndexStyle(0,DRAW_LINE,EMPTY,4);width=4;}
else
if(chart_width==1) {SetIndexStyle(0,DRAW_LINE,EMPTY,3);width=2;}
else
if(chart_width==0) {SetIndexStyle(0,DRAW_LINE,EMPTY,1);width=1;}

//
del_f();
for(int i=Bars-20;i>=0;i--)
 {
  drawHist(i);
  line[i]=Close[i];
 }
 
 prev_scale=chart_width;
 }
}


}

//////////////////////////////////////////////////////////////
void drawHist(int i)
{
   string name = identif+string(Time[i])+"hists";

   

      if(ObjectFind(0,name)==-1) 
      {
      ObjectCreate(0,name,OBJ_TREND,0,Time[i],1,Time[i],Close[i]);
         ObjectSetInteger(0,name,OBJPROP_COLOR,color_);
         
         ObjectSetInteger(0,name,OBJPROP_RAY,false);
         ObjectSetInteger(0,name,OBJPROP_BACK,true);
         ObjectSetInteger(0,name,OBJPROP_SELECTABLE,false); 
         ObjectSetInteger(0,name,OBJPROP_SELECTED,false); 
         ObjectSetInteger(0,name,OBJPROP_HIDDEN,true); 
         ObjectSetInteger(0,name,OBJPROP_ZORDER,false);
         
         
         
      }
      ObjectSetDouble(0,name,OBJPROP_PRICE2,Close[i]);
      ObjectSetInteger(0,name,OBJPROP_WIDTH,width);
         
}

////////////////////////////////////////////////////
void del_f()
{
 string name_delete;
 for(int i=ObjectsTotal()-1;i>=0;i--)
 {
 name_delete=ObjectName(i);
 if(StringFind(name_delete,identif)!=-1) ObjectDelete(name_delete);
 }
 
 
 
}