//------------------------------------------------------------------
#property copyright "mladen"
#property link      "mladenfx@gmail.com"
//------------------------------------------------------------------
#property indicator_separate_window
#property indicator_buffers 3
#property indicator_color1  clrOrangeRed
#property indicator_color2  clrBlue
#property indicator_color3  clrRed
#property indicator_width2  2
#property indicator_width3  2
#property indicator_minimum 0
#property indicator_maximum 100
#property strict

//
//
//
//
//

extern int    StochasticLength          = 55;   // Stochastic length
extern int    SmoothEMA                 = 15;   // Ema smoothing period
extern double levelOb                   = 80.0; // Overbought level
extern double levelOs                   = 20.0; // Oversold level
//
//
//
//
//

double dss[];
double buffer2[];
double buffer3[];
double slope[];

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int init()
{
   IndicatorBuffers(4);
   SetIndexBuffer(0,dss);
   SetIndexBuffer(1,buffer2); SetIndexStyle(1,DRAW_ARROW); SetIndexArrow(1,159); SetIndexLabel(1, "DSS Up");
   SetIndexBuffer(2,buffer3); SetIndexStyle(2,DRAW_ARROW); SetIndexArrow(2,159); SetIndexLabel(2, "DSS Down");
   SetIndexBuffer(3,slope);
   SetLevelValue(0,levelOb);
   SetLevelValue(1,levelOs);
      StochasticLength = fmax(1,StochasticLength);
      SmoothEMA        = fmax(1,SmoothEMA);
      
      //
      //
      //
      //
      //
       
       IndicatorShortName ("DSS("+(string)StochasticLength+","+(string)SmoothEMA+")");
   return(0);
}
int deinit()
{  
return(0);
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int start()
{
   int counted_bars = IndicatorCounted();
      if(counted_bars < 0) return(-1);
      if(counted_bars > 0) counted_bars--;
           int limit = fmin(Bars-counted_bars,Bars-1);
           
   //
   //
   //
   //
   //
   
 	for(int i = limit; i>=0; i--) 
 	{
 	  if (i<Bars-1)
 	  {
 	     dss[i] = iDss(Close[i],High[i],Low[i],StochasticLength,SmoothEMA,i);
 	     buffer2[i] = EMPTY_VALUE;
        buffer3[i] = EMPTY_VALUE;
        slope[i] = (i<Bars-1) ? (dss[i]>dss[i+1])  ? 1 : (dss[i]<dss[i+1])  ? -1 : slope[i+1] : 0;  
        if(slope[i] == 1)  buffer2[i] = dss[i];
        if(slope[i] ==-1)  buffer3[i] = dss[i];
      }
   }
return(0);
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

double workDss[][5];
#define _st1    0
#define _ss1    1
#define _pHigh  2
#define _pLow   3
#define _dss    4

double iDss(double close, double high, double low, int length, double smooth, int r)
{
   if (ArrayRange(workDss,0)!=Bars) ArrayResize(workDss,Bars); r=Bars-r-1;
   
   //
   //
   //
   //
   //
   
      double alpha = 2.0 / (1.0+smooth);
         workDss[r][_pHigh]  = high;
         workDss[r][_pLow]   = low;
     
         double min = workDss[r][_pLow];
         double max = workDss[r][_pHigh];
         for (int k=1; k<length && (r-k)>=0; k++)
         {
            min = MathMin(min,workDss[r-k][_pLow]);
            max = MathMax(max,workDss[r-k][_pHigh]);
         }
      
         workDss[r][_st1] = 0;
               if (min!=max) workDss[r][_st1] = 100*(close-min)/(max-min);
         workDss[r][_ss1] = workDss[r-1][_ss1]+alpha*(workDss[r][_st1]-workDss[r-1][_ss1]);

         //
         //
         //
         //
         //
         
         min = workDss[r][_ss1];
         max = workDss[r][_ss1];
         for (int k=1; k<length && (r-k)>=0; k++)
         {
            min = MathMin(min,workDss[r-k][_ss1]);
            max = MathMax(max,workDss[r-k][_ss1]);
         }
         double stoch = 0; if (min!=max) stoch = 100*(workDss[r][_ss1]-min)/(max-min);
         
         //
         //
         //
         //
         //
         
         workDss[r][_dss] = workDss[r-1][_dss]+alpha*(stoch -workDss[r-1][_dss]);
   return(workDss[r][_dss]);
}

