//+------------------------------------------------------------------+
//|                                                      CCI nrp.mq4 |
//+------------------------------------------------------------------+
#property copyright "www,forex-station.com"
#property link      "www,forex-station.com"

#property indicator_separate_window
#property indicator_buffers 7
#property indicator_color1  clrDimGray
#property strict

//
//
//
//
//

enum enPrices
{
   pr_close,      // Close
   pr_open,       // Open
   pr_high,       // High
   pr_low,        // Low
   pr_median,     // Median
   pr_typical,    // Typical
   pr_weighted,   // Weighted
   pr_average,    // Average (high+low+open+close)/4
   pr_medianb,    // Average median body (open+close)/2
   pr_tbiased,    // Trend biased price
   pr_tbiased2,   // Trend biased (extreme) price
   pr_haclose,    // Heiken ashi close
   pr_haopen ,    // Heiken ashi open
   pr_hahigh,     // Heiken ashi high
   pr_halow,      // Heiken ashi low
   pr_hamedian,   // Heiken ashi median
   pr_hatypical,  // Heiken ashi typical
   pr_haweighted, // Heiken ashi weighted
   pr_haaverage,  // Heiken ashi average
   pr_hamedianb,  // Heiken ashi median body
   pr_hatbiased,  // Heiken ashi trend biased price
   pr_hatbiased2, // Heiken ashi trend biased (extreme) price
   pr_habclose,   // Heiken ashi (better formula) close
   pr_habopen ,   // Heiken ashi (better formula) open
   pr_habhigh,    // Heiken ashi (better formula) high
   pr_hablow,     // Heiken ashi (better formula) low
   pr_habmedian,  // Heiken ashi (better formula) median
   pr_habtypical, // Heiken ashi (better formula) typical
   pr_habweighted,// Heiken ashi (better formula) weighted
   pr_habaverage, // Heiken ashi (better formula) average
   pr_habmedianb, // Heiken ashi (better formula) median body
   pr_habtbiased, // Heiken ashi (better formula) trend biased price
   pr_habtbiased2 // Heiken ashi (better formula) trend biased (extreme) price
};

extern ENUM_TIMEFRAMES    TimeFrame              = PERIOD_CURRENT;    // Time frame
extern int                CCIPeriod              = 14;                // CCI period
extern enPrices           CCIPrice               = pr_typical;        // CCI price to use      
extern double             SmoothLength           = 5;                 // Jurik smooth length
extern double             SmoothPhase            = 0;                 // Jurik smooth phase               
extern bool               SmoothDouble           = false;             // Jurik smooth double
extern double             OverSold               = -100;              // Oversold level
extern double             OverBought             = 100;               // Overbought level
extern color              OverSoldColor          = clrDeepSkyBlue;    // Oversold color
extern color              OverBoughtColor        = clrPaleVioletRed;  // Overbought color
extern color              ShadowColor            = clrGray;           // Shadow color
extern int                LineWidth              = 3;                 // Main line width
extern int                ShadowWidth            = 0;                 // Shadow width (<=0 main line width+3) 
extern bool               alertsOn               = false;             // Turn alerts on?
extern bool               alertsOnZoneEnter      = true;              // Alerts on entering OB/OS zones?
extern bool               alertsOnZoneExit       = true;              // Alerts on exiting OB/OS zones
extern bool               alertsOnCurrent        = false;             // Alerts on still opened bar?
extern bool               alertsMessage          = true;              // Alerts should display message?
extern bool               alertsSound            = false;             // Alerts should play a sound?
extern bool               alertsNotify           = false;             // Alerts should send a notification?
extern bool               alertsEmail            = false;             // Alerts should send an email?
extern string             soundFile              = "alert2.wav";      // Sound file
extern bool               arrowsVisible          = false;             // Show arrows?
extern string             arrowsIdentifier       = "cci arrows1";     // Arrows ID
extern bool               arrowsOnNewest         = false;             // Arrows drawn on newest bar of higher time frame bar
extern double             arrowsDisplaceUp       = 0.5;               // Arrow gap up
extern double             arrowsDisplaceDn       = 0.5;               // Arrow gap down
extern bool               arrowsOnZoneEnter      = true;              // Arrows on entering OB/OS zone?
extern color              arrowsUpZoneEnterColor = clrDeepSkyBlue;    // Arrows on entering OB/OS zone up color
extern color              arrowsDnZoneEnterColor = clrRed;            // Arrows on entering OB/OS zone down
extern int                arrowsUpZoneEnterCode  = 233;               // Arrows on entering OB/OS zone up code
extern int                arrowsDnZoneEnterCode  = 234;               // Arrows on entering OB/OS zone down code
extern int                arrowsUpZoneEnterSize  = 2;                 // Arrows on entering OB/OS zone up size
extern int                arrowsDnZoneEnterSize  = 2;                 // Arrows on entering OB/OS zone down size
extern bool               arrowsOnZoneExit       = false;             // Arrows on exiting OB/OS zone?           
extern color              arrowsUpZoneExitColor  = clrLime;           // Arrows on exiting OB/OS zone up color
extern color              arrowsDnZoneExitColor  = clrOrange;         // Arrows on exiting OB/OS zone down color 
extern int                arrowsUpZoneExitCode   = 119;               // Arrows on exiting OB/OS zone up code
extern int                arrowsDnZoneExitCode   = 119;               // Arrows on exiting OB/OS zone down code
extern int                arrowsUpZoneExitSize   = 2;                 // Arrows on exiting OB/OS zone up size
extern int                arrowsDnZoneExitSize   = 2;                 // Arrows on exiting OB/OS zone down size
extern bool               Interpolate            = true;              // Interpolate in mtf mode?

double cci[],buffer1da[],buffer1db[],buffer1ua[],buffer1ub[],prices[],trend[],shadowa[],shadowb[],count[];
string indicatorFileName;
#define _mtfCall(_buff,_ind) iCustom(NULL,TimeFrame,indicatorFileName,PERIOD_CURRENT,CCIPeriod,CCIPrice,SmoothLength,SmoothPhase,SmoothDouble,OverSold,OverBought,OverSoldColor,OverBoughtColor,ShadowColor,LineWidth,ShadowWidth,alertsOn,alertsOnZoneEnter,alertsOnZoneExit,alertsOnCurrent,alertsMessage,alertsSound,alertsNotify,alertsEmail,soundFile,arrowsVisible,arrowsIdentifier,arrowsOnNewest,arrowsDisplaceUp,arrowsDisplaceDn,arrowsOnZoneEnter,arrowsUpZoneEnterColor,arrowsDnZoneEnterColor,arrowsUpZoneEnterCode,arrowsDnZoneEnterCode,arrowsUpZoneEnterSize,arrowsDnZoneEnterSize,arrowsOnZoneExit,arrowsUpZoneExitColor,arrowsDnZoneExitColor,arrowsUpZoneExitCode,arrowsDnZoneExitCode,arrowsUpZoneExitSize,arrowsDnZoneExitSize,_buff,_ind)

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int init()
{
   for (int i=0; i<indicator_buffers; i++) SetIndexStyle(i,DRAW_LINE);
   int shadowWidth = (ShadowWidth<=0) ? LineWidth+3 : ShadowWidth;
   IndicatorBuffers(10);
   SetIndexBuffer(0, cci);       SetIndexStyle(0,EMPTY,EMPTY,LineWidth);
   SetIndexBuffer(1, shadowa);   SetIndexStyle(1,EMPTY,EMPTY,shadowWidth,ShadowColor);
   SetIndexBuffer(2, shadowb);   SetIndexStyle(2,EMPTY,EMPTY,shadowWidth,ShadowColor);
   SetIndexBuffer(3, buffer1ua); SetIndexStyle(3,EMPTY,EMPTY,LineWidth,OverBoughtColor);
   SetIndexBuffer(4, buffer1ub); SetIndexStyle(4,EMPTY,EMPTY,LineWidth,OverBoughtColor);
   SetIndexBuffer(5, buffer1da); SetIndexStyle(5,EMPTY,EMPTY,LineWidth,OverSoldColor);
   SetIndexBuffer(6, buffer1db); SetIndexStyle(6,EMPTY,EMPTY,LineWidth,OverSoldColor);
   SetIndexBuffer(7, prices);
   SetIndexBuffer(8, trend);
   SetIndexBuffer(9, count);
   SetLevelValue(0,OverBought);
   SetLevelValue(1,OverSold);

   indicatorFileName = WindowExpertName();
   TimeFrame         = fmax(TimeFrame,_Period);  
         
   IndicatorShortName(timeFrameToString(TimeFrame)+" CCI ("+(string)CCIPeriod+")");
return(0);
}
int deinit()
{
    string lookFor       = arrowsIdentifier+":";
    int    lookForLength = StringLen(lookFor);
    for (int i=ObjectsTotal()-1; i>=0; i--)
    {
       string objectName = ObjectName(i);
          if (StringSubstr(objectName,0,lookForLength) == lookFor) ObjectDelete(objectName);
    }
return(0);
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//

int start()
{
   int i,counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
         int limit = fmin(Bars-counted_bars,Bars-1); count[0]=limit;
            if (TimeFrame!=_Period)
            {
               limit = (int)fmax(limit,fmin(Bars-1,_mtfCall(9,0)*TimeFrame/_Period));
               if (trend[limit]==-1) { CleanPoint(limit,buffer1da,buffer1db); CleanPoint(limit,shadowa,shadowb); }
               if (trend[limit]== 1) { CleanPoint(limit,buffer1ua,buffer1ub); CleanPoint(limit,shadowa,shadowb); }
               for (i=limit;i>=0 && !_StopFlag; i--)
               {
                  int y = iBarShift(NULL,TimeFrame,Time[i]);
                     cci[i]       = _mtfCall(0,y);
                     shadowa[i]   = EMPTY_VALUE;
                     shadowb[i]   = EMPTY_VALUE;
                     buffer1da[i] = EMPTY_VALUE;
                     buffer1db[i] = EMPTY_VALUE;
                     buffer1ua[i] = EMPTY_VALUE;
                     buffer1ub[i] = EMPTY_VALUE;
                     trend[i]     = _mtfCall(8,y);
                 
                     //
                     //
                     //
                     //
                     //
                     
                     if (!Interpolate || (i>0 && y==iBarShift(NULL,TimeFrame,Time[i-1]))) continue;
                        #define _interpolate(buff) buff[i+k] = buff[i]+(buff[i+n]-buff[i])*k/n
                        int n,k; datetime time = iTime(NULL,TimeFrame,y);
                           for(n = 1; (i+n)<Bars && Time[i+n] >= time; n++) continue;	
                           for(k = 1; k<n && (i+n)<Bars && (i+k)<Bars; k++)  _interpolate(cci);
                                                    
              }   
              for (i=limit; i >= 0; i--)
              {
                 if (trend[i] == -1) { PlotPoint(i,buffer1da,buffer1db,cci); PlotPoint(i,shadowa,shadowb,cci); }
                 if (trend[i] ==  1) { PlotPoint(i,buffer1ua,buffer1ub,cci); PlotPoint(i,shadowa,shadowb,cci); }  
	            }      
      return(0);
      }
      
      //
      //
      //
      //
      //
      
      if (trend[limit]==-1) { CleanPoint(limit,buffer1da,buffer1db); CleanPoint(limit,shadowa,shadowb); }
      if (trend[limit]== 1) { CleanPoint(limit,buffer1ua,buffer1ub); CleanPoint(limit,shadowa,shadowb); }
      for(i=limit; i>=0; i--)
      {
        prices[i] = getPrice(CCIPrice,Open,Close,High,Low,i,Bars);
         double avg = 0; for(int k=0; k<CCIPeriod && (i+k)<Bars; k++) avg +=      prices[i+k];      avg /= CCIPeriod;
         double dev = 0; for(int k=0; k<CCIPeriod && (i+k)<Bars; k++) dev += fabs(prices[i+k]-avg); dev /= CCIPeriod;
            if (dev!=0)
                  cci[i] = iDSmooth((prices[i]-avg)/(0.015*dev),SmoothLength,SmoothPhase,SmoothDouble,i);
            else  cci[i] = iDSmooth(0                          ,SmoothLength,SmoothPhase,SmoothDouble,i);
         
            //
            //
            //
            //
            //
         
            buffer1da[i] = EMPTY_VALUE;
            buffer1db[i] = EMPTY_VALUE;
            buffer1ua[i] = EMPTY_VALUE;
            buffer1ub[i] = EMPTY_VALUE;
            shadowa[i]   = EMPTY_VALUE;
            shadowb[i]   = EMPTY_VALUE;
            trend[i] = (i<Bars-1) ? (cci[i]>OverBought) ? 1 : (cci[i]<OverSold) ? -1 : (cci[i]<OverBought && cci[i]>OverSold) ? 0 : trend[i+1] : 0;  
            if (trend[i] == -1) { PlotPoint(i,buffer1da,buffer1db,cci); PlotPoint(i,shadowa,shadowb,cci); }
            if (trend[i] ==  1) { PlotPoint(i,buffer1ua,buffer1ub,cci); PlotPoint(i,shadowa,shadowb,cci); }   
            
            //
            //
            //
            //
            //
                           
            if (arrowsVisible)
            {
               string lookFor = arrowsIdentifier+":"+(string)Time[i]; ObjectDelete(lookFor);            
               if (i<(Bars-1) && trend[i] != trend[i+1])
               {
                  if (arrowsOnZoneEnter && trend[i]   ==-1)                 drawArrow(i,arrowsUpZoneEnterColor,arrowsUpZoneEnterCode,arrowsUpZoneEnterSize,false);
                  if (arrowsOnZoneEnter && trend[i]   == 1)                 drawArrow(i,arrowsDnZoneEnterColor,arrowsDnZoneEnterCode,arrowsDnZoneEnterSize,true);
                  if (arrowsOnZoneExit  && trend[i+1] == 1 && trend[i]!= 1) drawArrow(i,arrowsDnZoneExitColor,arrowsDnZoneExitCode,arrowsDnZoneExitSize,true); 
                  if (arrowsOnZoneExit  && trend[i+1] ==-1 && trend[i]!=-1) drawArrow(i,arrowsUpZoneExitColor,arrowsUpZoneExitCode,arrowsUpZoneExitSize,false); 
               }                                            
      
            }
   }
   if (alertsOn)
   {
      int whichBar = 1; if (alertsOnCurrent) whichBar = 0;
      if (trend[whichBar] != trend[whichBar+1])
      {
         if (alertsOnZoneEnter && trend[whichBar]   ==  1)                        doAlert(whichBar,DoubleToStr(OverBought,2)+" crossed up");
         if (alertsOnZoneEnter && trend[whichBar]   == -1)                        doAlert(whichBar,DoubleToStr(OverSold,2) +" crossed down");
         if (alertsOnZoneExit  && trend[whichBar+1] == -1 && trend[whichBar]!=-1) doAlert(whichBar,DoubleToStr(OverBought,2) +" crossed up");
         if (alertsOnZoneExit  && trend[whichBar+1] ==  1 && trend[whichBar]!= 1) doAlert(whichBar,DoubleToStr(OverSold,2)+" crossed down");
      }
   }
return(0);
}      
   
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//

double wrk[][20];

#define bsmax  5
#define bsmin  6
#define volty  7
#define vsum   8
#define avolty 9

double iDSmooth(double price, double length, double phase, bool isDouble, int i, int s=0) 
{
   if (isDouble)
         return (iSmooth(iSmooth(price,MathSqrt(length),phase,i,s),MathSqrt(length),phase,i,s+10));
   else  return (iSmooth(price,length,phase,i,s));
}

//
//
//
//
//

double iSmooth(double price, double length, double phase, int i, int s=0)
{
   if (length <=1) return(price);
   if (ArrayRange(wrk,0) != Bars) ArrayResize(wrk,Bars);
   
   int r = Bars-i-1; 
      if (r==0) { int k; for(k=0; k<7; k++) wrk[r][k+s]=price; for(; k<10; k++) wrk[r][k+s]=0; return(price); }

   //
   //
   //
   //
   //
   
      double len1   = MathMax(MathLog(MathSqrt(0.5*(length-1)))/MathLog(2.0)+2.0,0);
      double pow1   = MathMax(len1-2.0,0.5);
      double del1   = price - wrk[r-1][bsmax+s];
      double del2   = price - wrk[r-1][bsmin+s];
      double div    = 1.0/(10.0+10.0*(MathMin(MathMax(length-10,0),100))/100);
      int    forBar = MathMin(r,10);
	
         wrk[r][volty+s] = 0;
               if(MathAbs(del1) > MathAbs(del2)) wrk[r][volty+s] = MathAbs(del1); 
               if(MathAbs(del1) < MathAbs(del2)) wrk[r][volty+s] = MathAbs(del2); 
         wrk[r][vsum+s] =	wrk[r-1][vsum+s] + (wrk[r][volty+s]-wrk[r-forBar][volty+s])*div;
         
         //
         //
         //
         //
         //
   
         wrk[r][avolty+s] = wrk[r-1][avolty+s]+(2.0/(MathMax(4.0*length,30)+1.0))*(wrk[r][vsum+s]-wrk[r-1][avolty+s]);
            double dVolty = 0;
            if (wrk[r][avolty+s] > 0)
                  dVolty = wrk[r][volty+s]/wrk[r][avolty+s];   
	               if (dVolty > MathPow(len1,1.0/pow1)) dVolty = MathPow(len1,1.0/pow1);
                  if (dVolty < 1)                      dVolty = 1.0;

      //
      //
      //
      //
      //
	        
   	double pow2 = MathPow(dVolty, pow1);
      double len2 = MathSqrt(0.5*(length-1))*len1;
      double Kv   = MathPow(len2/(len2+1), MathSqrt(pow2));

         if (del1 > 0) wrk[r][bsmax+s] = price; else wrk[r][bsmax+s] = price - Kv*del1;
         if (del2 < 0) wrk[r][bsmin+s] = price; else wrk[r][bsmin+s] = price - Kv*del2;
	
   //
   //
   //
   //
   //
      
      double R     = MathMax(MathMin(phase,100),-100)/100.0 + 1.5;
      double beta  = 0.45*(length-1)/(0.45*(length-1)+2);
      double alpha = MathPow(beta,pow2);

         wrk[r][0+s] = price + alpha*(wrk[r-1][0+s]-price);
         wrk[r][1+s] = (price - wrk[r][0+s])*(1-beta) + beta*wrk[r-1][1+s];
         wrk[r][2+s] = (wrk[r][0+s] + R*wrk[r][1+s]);
         wrk[r][3+s] = (wrk[r][2+s] - wrk[r-1][4+s])*MathPow((1-alpha),2) + MathPow(alpha,2)*wrk[r-1][3+s];
         wrk[r][4+s] = (wrk[r-1][4+s] + wrk[r][3+s]); 

   //
   //
   //
   //
   //

return(wrk[r][4+s]);
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

#define _prHABF(_prtype) (_prtype>=pr_habclose && _prtype<=pr_habtbiased2)
#define _priceInstances     1
#define _priceInstancesSize 4
double workHa[][_priceInstances*_priceInstancesSize];
double getPrice(int tprice, const double& open[], const double& close[], const double& high[], const double& low[], int i, int bars, int instanceNo=0)
{
  if (tprice>=pr_haclose)
   {
      if (ArrayRange(workHa,0)!= Bars) ArrayResize(workHa,Bars); instanceNo*=_priceInstancesSize; int r = bars-i-1;
         
         //
         //
         //
         //
         //
         
         double haOpen  = (r>0) ? (workHa[r-1][instanceNo+2] + workHa[r-1][instanceNo+3])/2.0 : (open[i]+close[i])/2;;
         double haClose = (open[i]+high[i]+low[i]+close[i]) / 4.0;
         if (_prHABF(tprice))
               if (high[i]!=low[i])
                     haClose = (open[i]+close[i])/2.0+(((close[i]-open[i])/(high[i]-low[i]))*MathAbs((close[i]-open[i])/2.0));
               else  haClose = (open[i]+close[i])/2.0; 
         double haHigh  = fmax(high[i], fmax(haOpen,haClose));
         double haLow   = fmin(low[i] , fmin(haOpen,haClose));

         //
         //
         //
         //
         //
         
         if(haOpen<haClose) { workHa[r][instanceNo+0] = haLow;  workHa[r][instanceNo+1] = haHigh; } 
         else               { workHa[r][instanceNo+0] = haHigh; workHa[r][instanceNo+1] = haLow;  } 
                              workHa[r][instanceNo+2] = haOpen;
                              workHa[r][instanceNo+3] = haClose;
         //
         //
         //
         //
         //
         
         switch (tprice)
         {
            case pr_haclose:
            case pr_habclose:    return(haClose);
            case pr_haopen:   
            case pr_habopen:     return(haOpen);
            case pr_hahigh: 
            case pr_habhigh:     return(haHigh);
            case pr_halow:    
            case pr_hablow:      return(haLow);
            case pr_hamedian:
            case pr_habmedian:   return((haHigh+haLow)/2.0);
            case pr_hamedianb:
            case pr_habmedianb:  return((haOpen+haClose)/2.0);
            case pr_hatypical:
            case pr_habtypical:  return((haHigh+haLow+haClose)/3.0);
            case pr_haweighted:
            case pr_habweighted: return((haHigh+haLow+haClose+haClose)/4.0);
            case pr_haaverage:  
            case pr_habaverage:  return((haHigh+haLow+haClose+haOpen)/4.0);
            case pr_hatbiased:
            case pr_habtbiased:
               if (haClose>haOpen)
                     return((haHigh+haClose)/2.0);
               else  return((haLow+haClose)/2.0);        
            case pr_hatbiased2:
            case pr_habtbiased2:
               if (haClose>haOpen)  return(haHigh);
               if (haClose<haOpen)  return(haLow);
                                    return(haClose);        
         }
   }
   
   //
   //
   //
   //
   //
   
   switch (tprice)
   {
      case pr_close:     return(close[i]);
      case pr_open:      return(open[i]);
      case pr_high:      return(high[i]);
      case pr_low:       return(low[i]);
      case pr_median:    return((high[i]+low[i])/2.0);
      case pr_medianb:   return((open[i]+close[i])/2.0);
      case pr_typical:   return((high[i]+low[i]+close[i])/3.0);
      case pr_weighted:  return((high[i]+low[i]+close[i]+close[i])/4.0);
      case pr_average:   return((high[i]+low[i]+close[i]+open[i])/4.0);
      case pr_tbiased:   
               if (close[i]>open[i])
                     return((high[i]+close[i])/2.0);
               else  return((low[i]+close[i])/2.0);        
      case pr_tbiased2:   
               if (close[i]>open[i]) return(high[i]);
               if (close[i]<open[i]) return(low[i]);
                                     return(close[i]);        
   }
   return(0);
}

//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//-------------------------------------------------------------------
//                                                                  
//-------------------------------------------------------------------
//
//
//
//
//

void CleanPoint(int i,double& first[],double& second[])
{
   if (i>=Bars-3) return;
   if ((second[i]  != EMPTY_VALUE) && (second[i+1] != EMPTY_VALUE))
        second[i+1] = EMPTY_VALUE;
   else
      if ((first[i] != EMPTY_VALUE) && (first[i+1] != EMPTY_VALUE) && (first[i+2] == EMPTY_VALUE))
          first[i+1] = EMPTY_VALUE;
}

void PlotPoint(int i,double& first[],double& second[],double& from[])
{
   if (i>=Bars-2) return;
   if (first[i+1] == EMPTY_VALUE)
      if (first[i+2] == EMPTY_VALUE) 
            { first[i]  = from[i]; first[i+1]  = from[i+1]; second[i] = EMPTY_VALUE; }
      else  { second[i] = from[i]; second[i+1] = from[i+1]; first[i]  = EMPTY_VALUE; }
   else     { first[i]  = from[i];                          second[i] = EMPTY_VALUE; }
}

//
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       //
       //
       //
       //
       //

       message =  StringConcatenate(Symbol()," ",timeFrameToString(Period())," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," CCI ",doWhat);
          if (alertsMessage) Alert(message);
          if (alertsNotify)  SendNotification(message);
          if (alertsEmail)   SendMail(_Symbol+" CCI ",message);
          if (alertsSound)   PlaySound(soundFile);
   }
}

//-------------------------------------------------------------------
//                                                                  
//-------------------------------------------------------------------
//
//
//
//
//

void drawArrow(int i,color theColor,int theCode,int theSize,bool tup)
{
   string name = arrowsIdentifier+":"+(string)Time[i];
   double gap  = iATR(NULL,0,20,i);   
   
      //
      //
      //
      //
      //

      datetime time = Time[i]; if (arrowsOnNewest) time += _Period*60-1;      
      ObjectCreate(name,OBJ_ARROW,0,time,0);
         ObjectSet(name,OBJPROP_ARROWCODE,theCode);
         ObjectSet(name,OBJPROP_WIDTH,    theSize);
         ObjectSet(name,OBJPROP_COLOR,    theColor);
         if (tup)
               ObjectSet(name,OBJPROP_PRICE1,High[i] + arrowsDisplaceUp * gap);
         else  ObjectSet(name,OBJPROP_PRICE1,Low[i]  - arrowsDisplaceDn * gap);
}



