#property copyright   "http://www.bestexpertadvisors.com"
#property link        "http://www.bestexpertadvisors.com"
#property description "Our amazing premium EAs and new systems are coming soon."
#property description "You can follow us to get the latest news."

#property indicator_separate_window
#property indicator_buffers 4
#property indicator_color1 SeaGreen
#property indicator_color2 SeaGreen
#property indicator_color3 SeaGreen
#property indicator_color4 Red

extern int    BandsPeriod     = 20;  // period of averaging
extern int    BandsMethod     = 0;   // method of averaging: 0 = Simple,   1 = Exponential,
                                     //                      2 = Smoothed, 3 = Weighted
extern int    BandsShift      = 0;   // shift from chart of indicator
extern double BandsDeviations = 2.0; // deviation
extern int    CCIPeriod       = 14;  // period of CCI
extern int    CCIPrice        = 5;   // price for CCI:     0 = PRICE_CLOSE, 1 = PRICE_OPEN,
                                     // 2 = PRICE_HIGH,    3 = PRICE_LOW,   4 = 0PRICE_MEDIAN,
                                     // 5 = PRICE_TYPICAL, 6 = PRICE_WEIGHTED

double MiddleBuffer[];
double UpperBuffer[];
double LowerBuffer[];
double CCIBuffer[];

int init()
  {
   IndicatorShortName("CCI Indicator with Bollinger Bands ("+BandsPeriod+","+DoubleToStr(BandsDeviations,2)+") On CCI"+"("+CCIPeriod+")");
   IndicatorDigits(Digits);
   SetLevelValue(0,-100);
   SetLevelValue(1,100);
   SetLevelValue(2,0);
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID);
   SetIndexStyle(1,DRAW_LINE,STYLE_SOLID);
   SetIndexStyle(2,DRAW_LINE,STYLE_SOLID);
   SetIndexBuffer(0,MiddleBuffer);
   SetIndexBuffer(1,UpperBuffer);
   SetIndexBuffer(2,LowerBuffer);
   SetIndexDrawBegin(0,CCIPeriod+BandsPeriod+BandsShift);
   SetIndexDrawBegin(1,CCIPeriod+BandsPeriod+BandsShift);
   SetIndexDrawBegin(2,CCIPeriod+BandsPeriod+BandsShift);
   SetIndexLabel(0,"MiddleBB");
   SetIndexLabel(1,"UpperBB");
   SetIndexLabel(2,"LowerBB");
   SetIndexStyle(3,DRAW_LINE,STYLE_SOLID);
   SetIndexBuffer(3,CCIBuffer);
   SetIndexDrawBegin(3,CCIPeriod);
   SetIndexLabel(3,"CCI");
   return(0);
  }

int start()
  {
   if(Bars <= CCIPeriod+BandsPeriod) return(0);
   int counted_bars = IndicatorCounted();
   if(counted_bars < 0) return(-1);
   if(counted_bars > 0) counted_bars--;
   int limit = Bars - counted_bars;
   for(int i=limit; i>=0; i--) CCIBuffer[i] = iCCI(NULL,0,CCIPeriod,CCIPrice,i);
   for(i=0; i<limit; i++) MiddleBuffer[i] = iMAOnArray(CCIBuffer,0,BandsPeriod,BandsShift,BandsMethod,i);
   while(i >= 0)
     {
      double sum = 0.0;
      int k = i + BandsPeriod - 1;
      double oldval = MiddleBuffer[i];
      while(k >= i)
        {
         double newres = CCIBuffer[k] - oldval;
         sum = sum + newres * newres;
         k--;
        }
      double deviation = BandsDeviations * MathSqrt(sum/BandsPeriod);
      UpperBuffer[i] = oldval + deviation;
      LowerBuffer[i] = oldval - deviation;
      i--;
     }
   return(0);
  }

//+------------------------------------------------------------------+