//+------------------------------------------------------------------+
//|                              Mladen Elite Indicators 7 June 2011 |
//+------------------------------------------------------------------+
#property copyright "this version made for forex-tsd elite section"
#property copyright "original idea by Eli Hayun"

#property indicator_separate_window
#property indicator_minimum -0.5
#property indicator_maximum  3.5

#property indicator_buffers 8
#property indicator_color1 Lime
#property indicator_color2 Red
#property indicator_color3 Lime
#property indicator_color4 Red
#property indicator_color5 Lime
#property indicator_color6 Red
#property indicator_color7 Lime
#property indicator_color8 Red

//
//
//
//
//

extern string UniqueID         = "CCI trends";
extern int    Period_1         = PERIOD_M1;
extern int    Period_2         = PERIOD_M5;
extern int    Period_3         = PERIOD_M15;
extern int    Period_4         = PERIOD_M30;
extern int    cci_1            = 5;//*******************
extern int    cci_2            = 5;
extern int    cci_3            = 3;
extern int    cci_4            = 3;
extern int    cci_price        = PRICE_TYPICAL;
extern bool   AutoDisplay      = true;
extern color  LabelsColor      = DimGray;
extern int    LabelsShiftRight = 10;
extern bool   alertsOn         = false;
extern bool   alertsOnCurrent  = true;
extern bool   alertsMessage    = true;
extern bool   alertsSound      = false;
extern bool   alertsEmail      = false;

//
//
//
//
//

double buf4_up[];
double buf4_down[];
double buf3_up[];
double buf3_down[];
double buf2_up[];
double buf2_down[];
double buf1_up[];
double buf1_down[];

string shortname = "";
string indicatorFileName;
bool   returnBars;

//+------------------------------------------------------------------
//|                                           
//+------------------------------------------------------------------
//
//
//
//
//

int init()
{
      SetIndexBuffer(0,buf4_up);
      SetIndexBuffer(1,buf4_down);
      SetIndexBuffer(2,buf3_up);
      SetIndexBuffer(3,buf3_down);
      SetIndexBuffer(4,buf2_up);
      SetIndexBuffer(5,buf2_down);
      SetIndexBuffer(6,buf1_up);
      SetIndexBuffer(7,buf1_down);
      for (int i=0;i<8; i++)
      {
         SetIndexStyle(i,DRAW_ARROW); 
         SetIndexArrow(i,110);
      }
      returnBars = (UniqueID=="returnBars"); if (returnBars) return(0);
      
      //
      //
      //
      //
      //
      
      SetAutoDisplay();
      shortname         = UniqueID+" ("+Period_1+","+Period_2+","+Period_3+","+Period_4+")";
      indicatorFileName = WindowExpertName();
   IndicatorShortName(shortname);
   return(0);
}
int deinit() { return(0); }


//+------------------------------------------------------------------
//|                                           
//+------------------------------------------------------------------
//
//
//
//
//

int start()
{
   int limit,counted_bars=IndicatorCounted();

      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
         limit = MathMin(Bars-counted_bars,Bars-1);
      
         if (returnBars) { buf4_up[0] = limit+1; return(0); }
         
         limit = MathMax(limit,iCustom(NULL,Period_1,indicatorFileName,"returnBars",0,0)*Period_1/Period());
         limit = MathMax(limit,iCustom(NULL,Period_2,indicatorFileName,"returnBars",0,0)*Period_2/Period());
         limit = MathMax(limit,iCustom(NULL,Period_3,indicatorFileName,"returnBars",0,0)*Period_3/Period());
         limit = MathMax(limit,iCustom(NULL,Period_4,indicatorFileName,"returnBars",0,0)*Period_4/Period());
         limit = MathMin(limit,Bars-1);

         //
         //
         //
         //
         //

         for (int l=0; l<4; l++)
         {  
            string txt = "??";
            double gp;
            switch (l)
            {
               case 0: txt = tf2txt(Period_1)+" -"+cci_1;  gp = 0.4; break;
               case 1: txt = tf2txt(Period_2)+" -"+cci_2;  gp = 1.4; break;
               case 2: txt = tf2txt(Period_3)+" -"+cci_3;  gp = 2.4; break;
               case 3: txt = tf2txt(Period_4)+" -"+cci_4;  gp = 3.4; break;
            }
            string name = UniqueID+l;
               ObjectCreate(name, OBJ_TEXT, WindowFind(shortname),0,0);
                  ObjectSet(name, OBJPROP_TIME1 ,Time[0]+Period()*LabelsShiftRight*60);
                  ObjectSet(name, OBJPROP_PRICE1,gp);
                  ObjectSetText(name, txt,8,"Arial",LabelsColor);
         }
         
   //
   //
   //
   //
   //   

   for(int i = limit; i>=0; i--)
   {
      double cci1 = iCCI(NULL, Period_1, cci_1, cci_price, iBarShift(NULL,Period_1,Time[i]));
      double cci2 = iCCI(NULL, Period_2, cci_2, cci_price, iBarShift(NULL,Period_2,Time[i]));
      double cci3 = iCCI(NULL, Period_3, cci_3, cci_price, iBarShift(NULL,Period_3,Time[i]));
      double cci4 = iCCI(NULL, Period_4, cci_4, cci_price, iBarShift(NULL,Period_4,Time[i]));

      buf1_up[i] = EMPTY_VALUE; buf1_down[i] = EMPTY_VALUE; if (cci1>0) buf1_up[i] = 0; if (cci1<0) buf1_down[i] = 0;
      buf2_up[i] = EMPTY_VALUE; buf2_down[i] = EMPTY_VALUE; if (cci2>0) buf2_up[i] = 1; if (cci2<0) buf2_down[i] = 1;
      buf3_up[i] = EMPTY_VALUE; buf3_down[i] = EMPTY_VALUE; if (cci3>0) buf3_up[i] = 2; if (cci3<0) buf3_down[i] = 2;
      buf4_up[i] = EMPTY_VALUE; buf4_down[i] = EMPTY_VALUE; if (cci4>0) buf4_up[i] = 3; if (cci4<0) buf4_down[i] = 3;
   }
   manageAlerts();
   return(0);
}

//+-------------------------------------------------------------------------------------------------------------------+
//|                                           
//+-------------------------------------------------------------------------------------------------------------------+
//
//
//
//
//

void SetAutoDisplay()
{
   if (AutoDisplay)
      switch (Period())
      {
         case PERIOD_M1  :  SetValues(PERIOD_M1,  PERIOD_M5,  PERIOD_M15, PERIOD_M30); break;
         case PERIOD_M5  :  SetValues(PERIOD_M5,  PERIOD_M15, PERIOD_M30, PERIOD_H1);  break;
         case PERIOD_M15 :  SetValues(PERIOD_M15, PERIOD_M30, PERIOD_H1,  PERIOD_H4);  break;
         case PERIOD_M30 :  SetValues(PERIOD_M30, PERIOD_H1,  PERIOD_H4,  PERIOD_D1);  break;
         case PERIOD_H1  :  SetValues(PERIOD_H1,  PERIOD_H4,  PERIOD_D1,  PERIOD_W1);  break;
         case PERIOD_H4  :  SetValues(PERIOD_H4,  PERIOD_D1,  PERIOD_W1,  PERIOD_MN1); break;
         case PERIOD_D1  :  SetValues(PERIOD_D1,  PERIOD_W1,  PERIOD_MN1, PERIOD_MN1); break;
         case PERIOD_W1  :  SetValues(PERIOD_W1,  PERIOD_MN1, PERIOD_MN1, PERIOD_MN1); break;
         case PERIOD_MN1 :  SetValues(PERIOD_MN1, PERIOD_MN1, PERIOD_MN1, PERIOD_MN1); break;
      }
      Period_1 = MathMax(Period_1,Period());
      Period_2 = MathMax(Period_2,Period());
      Period_3 = MathMax(Period_3,Period());
      Period_4 = MathMax(Period_4,Period());
}
void SetValues(int p1, int p2, int p3, int p4){ Period_1 = p1;   Period_2 = p2; Period_3 = p3; Period_4 = p4; }

//
//
//
//
//

string tf2txt(int tf)
{
   if (tf == PERIOD_M1)  return("M1");
   if (tf == PERIOD_M5)  return("M5");
   if (tf == PERIOD_M15) return("M15");
   if (tf == PERIOD_M30) return("M30");
   if (tf == PERIOD_H1)  return("H1");
   if (tf == PERIOD_H4)  return("H4");
   if (tf == PERIOD_D1)  return("D1");
   if (tf == PERIOD_W1)  return("W1");
   if (tf == PERIOD_MN1) return("MN");
   return("??");
}

//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//
//

void manageAlerts()
{
   if (alertsOn)
   {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1; 

      //
      //
      //
      //
      //
      
      bool trendUp   = ( buf1_up[whichBar]   == 0 && buf2_up[whichBar]   == 1 && buf3_up[whichBar]   == 2 && buf4_up[whichBar]  == 3);
      bool trendDown = ( buf1_down[whichBar] == 0 && buf2_down[whichBar] == 1 && buf3_down[whichBar] == 2 && buf4_down[whichBar]== 3);
               if (trendUp)   doAlert(whichBar,"up");
               if (trendDown) doAlert(whichBar,"down");
   }
}

//
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat) 
   {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       //
       //
       //
       //
       //

       message =  StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," CCI trend trend is ",doWhat);
          if (alertsMessage) Alert(message);
          if (alertsEmail)   SendMail(StringConcatenate(Symbol(),"CCI trend "),message);
          if (alertsSound)   PlaySound("alert2.wav");
   }
}