//------------------------------------------------------------------
#property copyright "mladen"
#property link      "www.forex-station.com"
//------------------------------------------------------------------
#property indicator_separate_window
#property indicator_buffers 3
#property indicator_color1  clrLimeGreen
#property indicator_color2  clrOrange
#property indicator_color3  clrOrange
#property indicator_width1  3
#property indicator_width2  3
#property indicator_width3  3
#property strict

//
//
//
//
//

enum enPrices
{
   pr_close,      // Close
   pr_open,       // Open
   pr_high,       // High
   pr_low,        // Low
   pr_median,     // Median
   pr_typical,    // Typical
   pr_weighted,   // Weighted
   pr_average,    // Average (high+low+open+close)/4
   pr_medianb,    // Average median body (open+close)/2
   pr_tbiased,    // Trend biased price
   pr_haclose,    // Heiken ashi close
   pr_haopen ,    // Heiken ashi open
   pr_hahigh,     // Heiken ashi high
   pr_halow,      // Heiken ashi low
   pr_hamedian,   // Heiken ashi median
   pr_hatypical,  // Heiken ashi typical
   pr_haweighted, // Heiken ashi weighted
   pr_haaverage,  // Heiken ashi average
   pr_hamedianb,  // Heiken ashi median body
   pr_hatbiased   // Heiken ashi trend biased price
};
enum enDoWhat
{
   do_cci,  // Make cci using nma as price filter
   do_nma   // Make nma smoothed cci
};
extern int                pperiod            = 14;                // Calculating period
extern enPrices           pprice             = pr_close;          // Price
extern int                filter             = 40;                // Nma period 
extern int                filterTema         = 10;                // Nma tema period
extern enDoWhat           doWhat             = do_cci;            // Make what?
extern int                linesWidth         = 3;                 // Lines width
extern double             LevelUp            = 50;                // overbought level
extern double             LevelDown          = -50;               // oversold level
extern bool               alertsOn           = true;              // Turn alerts on
extern bool               alertsOnZoneEnter  = true;              // Alerts on entering ob/os zone
extern bool               alertsOnZoneExit   = true;              // Alerts on leaving ob/os zone
extern bool               alertsOnCurrent    = false;             // Alerts on current (still opened) bar
extern bool               alertsMessage      = true;              // Alerts should display alert message
extern bool               alertsNotification = false;             // Alerts should send alert notification
extern bool               alertsSound        = false;             // Alerts should play alert sound
extern bool               alertsEmail        = false;             // Alerts should send alert email?
extern string             soundFile           = "alert2.wav";     // what sound file to use


double buffer[];
double bufferda[];
double bufferdb[];
double trend[];
double work[];
double pricef[];
double cross[];

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int init()
{
   IndicatorBuffers(7);
   SetIndexBuffer(0,buffer,  INDICATOR_DATA); SetIndexStyle(0,EMPTY,EMPTY,linesWidth);
   SetIndexBuffer(1,bufferda,INDICATOR_DATA); SetIndexStyle(1,EMPTY,EMPTY,linesWidth);
   SetIndexBuffer(2,bufferdb,INDICATOR_DATA); SetIndexStyle(2,EMPTY,EMPTY,linesWidth);
   SetIndexBuffer(3,trend   ,INDICATOR_CALCULATIONS);
   SetIndexBuffer(4,work    ,INDICATOR_CALCULATIONS);
   SetIndexBuffer(5,pricef  ,INDICATOR_CALCULATIONS);
   SetIndexBuffer(6,cross   ,INDICATOR_CALCULATIONS);
   SetLevelValue(0,LevelUp);
   SetLevelValue(1,LevelDown);
   IndicatorShortName("cci nma ("+(string)pperiod+","+(string)filter+")");
   return(0);
}

//
//
//
//
//

int start()
{
   int counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
           int limit=MathMin(Bars-counted_bars,Bars-2);

   //
   //
   //
   //
   //

   if (trend[limit]==-1) CleanPoint(limit,bufferda,bufferdb);
   for(int i=limit; i>=0; i--)
   {
      if (doWhat==do_cci)
            pricef[i] = iNma(getPrice(pprice,Open,Close,High,Low,i),filter,filterTema,i);
      else  pricef[i] = getPrice(pprice,Open,Close,High,Low,i);
      double avg = 0; for(int k=0; k<pperiod && (i+k)<Bars; k++) avg +=         pricef[i+k];      avg /= pperiod;
      double dev = 0; for(int k=0; k<pperiod && (i+k)<Bars; k++) dev += MathAbs(pricef[i+k]-avg); dev /= pperiod;
         if (dev!=0)
               work[i] = (pricef[i]-avg)/(0.015*dev);
         else  work[i] = 0;
         if (doWhat==do_cci)
                  buffer[i] = work[i];
         else     buffer[i] = iNma(work[i],filter,filterTema,i);
         bufferda[i] = EMPTY_VALUE;
         bufferdb[i] = EMPTY_VALUE;
         trend[i]    = trend[i+1];
         cross[i]    = cross[i+1];
      
         //
         //
         //
         //
         //
         
         if (buffer[i]>buffer[i+1])                    trend[i] = 1;
         if (buffer[i]<buffer[i+1])                    trend[i] =-1;
         if (buffer[i]>LevelUp)                        cross[i] = 1;
         if (buffer[i]<LevelDown)                      cross[i] =-1;
         if (buffer[i]<LevelUp && buffer[i]>LevelDown) cross[i] = 0;
         if (trend[i] == -1) PlotPoint(i,bufferda,bufferdb,buffer);
   } 
   
   //
   //
   //
   //
   //
   
   if (alertsOn)
   {
      int whichBar = 1; if (alertsOnCurrent) whichBar = 0;
      if (cross[whichBar] != cross[whichBar+1])
      {
         if (alertsOnZoneEnter && cross[whichBar]   ==  1) doAlert(whichBar,DoubleToStr(LevelUp,2)  +" level broken up");
         if (alertsOnZoneEnter && cross[whichBar]   == -1) doAlert(whichBar,DoubleToStr(LevelDown,2)+" level broken down");
         if (alertsOnZoneExit  && cross[whichBar+1] == -1) doAlert(whichBar,DoubleToStr(LevelDown,2)+" level broken up");
         if (alertsOnZoneExit  && cross[whichBar+1] ==  1) doAlert(whichBar,DoubleToStr(LevelUp,2)  +" level broken down");
      }
    }    
   return(0);
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

#define _nmaInstances 1
#define _nmaPrice     3
#define _nmaMom       4
#define _nmaValue     5
double workNma[][_nmaInstances*6];

double iNma(double price, int period, int temaperiod, int i, int instanceNo=0)
{
   if (period<=1) return(price);
   if (ArrayRange(workNma,0)!=Bars) ArrayResize(workNma,Bars); i = Bars-i-1; instanceNo*=6;

   //
   //
   //
   //
   //

   double alpha = 2.0 /(1.0 + temaperiod);
   if (i < 1)
   {
      workNma[i][instanceNo+_nmaPrice] = price;
      workNma[i][instanceNo+_nmaValue] = price;
      workNma[i][instanceNo+_nmaMom]   = 0;
      workNma[i][instanceNo+0]         = price;
      workNma[i][instanceNo+1]         = price;
      workNma[i][instanceNo+2]         = price;
   }
   else
   {
      workNma[i][instanceNo+0]         = workNma[i-1][instanceNo+0]+alpha*(price                   -workNma[i-1][instanceNo+0]);
      workNma[i][instanceNo+1]         = workNma[i-1][instanceNo+1]+alpha*(workNma[i][instanceNo+0]-workNma[i-1][instanceNo+1]);
      workNma[i][instanceNo+2]         = workNma[i-1][instanceNo+2]+alpha*(workNma[i][instanceNo+1]-workNma[i-1][instanceNo+2]);
      workNma[i][instanceNo+_nmaPrice] = 3*workNma[i][instanceNo+0] - 3*workNma[i][instanceNo+1] + workNma[i][instanceNo+2];
      workNma[i][instanceNo+_nmaMom]   = workNma[i][instanceNo+_nmaPrice]-workNma[i-1][instanceNo+_nmaPrice];
         
      //
      //
      //
      //
      //
   
      double momRatio = 0.00;
      double sumMomen = 0.00;
      double ratio    = 0.00;
      
      for (int k = 0; k<period && (i-k)>=0; k++)
      {
         sumMomen += MathAbs(workNma[i-k][instanceNo+_nmaMom]);
         momRatio +=         workNma[i-k][instanceNo+_nmaMom]*(MathSqrt(k+1)-MathSqrt(k));
      }
      if (sumMomen != 0) ratio = MathAbs(momRatio)/sumMomen;
      workNma[i][instanceNo+_nmaValue] =  workNma[i-1][instanceNo+_nmaValue]+ratio*(price-workNma[i-1][instanceNo+_nmaValue]);
   }         
   return(workNma[i][instanceNo+_nmaValue]);
}

//-------------------------------------------------------------------
//
//-------------------------------------------------------------------
//
//
//
//
//

void CleanPoint(int i,double& first[],double& second[])
{
   if ((second[i]  != EMPTY_VALUE) && (second[i+1] != EMPTY_VALUE))
        second[i+1] = EMPTY_VALUE;
   else
      if ((first[i] != EMPTY_VALUE) && (first[i+1] != EMPTY_VALUE) && (first[i+2] == EMPTY_VALUE))
          first[i+1] = EMPTY_VALUE;
}

//
//
//
//
//

void PlotPoint(int i,double& first[],double& second[],double& from[])
{
   if (i>=Bars-2) return;
   if (first[i+1] == EMPTY_VALUE)
         {
            if (first[i+2] == EMPTY_VALUE) 
                  { first[i]  = from[i]; first[i+1]  = from[i+1]; second[i] = EMPTY_VALUE; }
            else  { second[i] = from[i]; second[i+1] = from[i+1]; first[i]  = EMPTY_VALUE; }
         }
   else  { first[i] = from[i]; second[i] = EMPTY_VALUE; }
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//
//

double workHa[][4];
double getPrice(int tprice, const double& open[], const double& close[], const double& high[], const double& low[], int i, int instanceNo=0)
{
  if (tprice>=pr_haclose)
   {
      if (ArrayRange(workHa,0)!= Bars) ArrayResize(workHa,Bars);
         int r = Bars-i-1;
         
         //
         //
         //
         //
         //
         
         double haOpen;
         if (r>0)
                haOpen  = (workHa[r-1][instanceNo+2] + workHa[r-1][instanceNo+3])/2.0;
         else   haOpen  = (open[i]+close[i])/2;
         double haClose = (open[i] + high[i] + low[i] + close[i]) / 4.0;
         double haHigh  = MathMax(high[i], MathMax(haOpen,haClose));
         double haLow   = MathMin(low[i] , MathMin(haOpen,haClose));

         if(haOpen  <haClose) { workHa[r][instanceNo+0] = haLow;  workHa[r][instanceNo+1] = haHigh; } 
         else                 { workHa[r][instanceNo+0] = haHigh; workHa[r][instanceNo+1] = haLow;  } 
                                workHa[r][instanceNo+2] = haOpen;
                                workHa[r][instanceNo+3] = haClose;
         //
         //
         //
         //
         //
         
         switch (tprice)
         {
            case pr_haclose:     return(haClose);
            case pr_haopen:      return(haOpen);
            case pr_hahigh:      return(haHigh);
            case pr_halow:       return(haLow);
            case pr_hamedian:    return((haHigh+haLow)/2.0);
            case pr_hamedianb:   return((haOpen+haClose)/2.0);
            case pr_hatypical:   return((haHigh+haLow+haClose)/3.0);
            case pr_haweighted:  return((haHigh+haLow+haClose+haClose)/4.0);
            case pr_haaverage:   return((haHigh+haLow+haClose+haOpen)/4.0);
            case pr_hatbiased:
               if (haClose>haOpen)
                     return((haHigh+haClose)/2.0);
               else  return((haLow+haClose)/2.0);        
         }
   }
   
   //
   //
   //
   //
   //
   
   switch (tprice)
   {
      case pr_close:     return(close[i]);
      case pr_open:      return(open[i]);
      case pr_high:      return(high[i]);
      case pr_low:       return(low[i]);
      case pr_median:    return((high[i]+low[i])/2.0);
      case pr_medianb:   return((open[i]+close[i])/2.0);
      case pr_typical:   return((high[i]+low[i]+close[i])/3.0);
      case pr_weighted:  return((high[i]+low[i]+close[i]+close[i])/4.0);
      case pr_average:   return((high[i]+low[i]+close[i]+open[i])/4.0);
      case pr_tbiased:   
               if (close[i]>open[i])
                     return((high[i]+close[i])/2.0);
               else  return((low[i]+close[i])/2.0);        
   }
   return(0);
}   

//
//
//
//
//

void doAlert(int forBar, string tdoWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != tdoWhat || previousTime != Time[forBar]) {
       previousAlert  = tdoWhat;
       previousTime   = Time[forBar];

       //
       //
       //
       //
       //

        message =  StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," cci + nma ",tdoWhat);
             if (alertsMessage)       Alert(message);
             if (alertsNotification)  SendNotification(message);
             if (alertsEmail)         SendMail(StringConcatenate(Symbol()," cci + nma "),message);
             if (alertsSound)         PlaySound(soundFile);
   }
} 


   