#property copyright   "www.forex-indicators.org"
#property link        "http://www.forex-indicators.org"
#property description "If this indicator does not work, please contact us at: emails@forex-indicators.org"

#property indicator_chart_window
//---- input parameters
extern int     PeriodsToPlot= 24;   
extern bool    Hourly  = false;
extern bool    FourHourly = false;
extern bool    Daily   = true;
extern bool    Weekly  = false;
extern bool    Monthly = false;
//extern color   ZoneColour = LightGray;
//extern color   DividerColour = White;
extern color   ZoneColour1 = PaleGoldenrod;
extern color   ZoneColour2 = Tan;
//extern bool    ExtendRange = false; 

double PlotPeriodHigh;
double PlotPeriodLow;
double Period_Price[][6];
double Buf_HighLow[200][400];
int PeriodCode;
int PeriodBuffer;
string PeriodLabel;
double RangeBuffer = 0.0010;
double Range = 0.0;


double Poin;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   Poin = Point;
	//Checking for unconvetional Point digits number
   if ((Point == 0.00001) || (Point == 0.001))
   {
      Poin *= 10;
   }
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   for(int i=0; i<PeriodsToPlot; i++)
   {
      ObjectDelete("LZ" + i);
      ObjectDelete("HZ" + i);
      ObjectDelete("LDiv" + i);
      ObjectDelete("HDiv" + i);
   }   
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   deinit();
   double PlotPeriodHigh=0.0;
   double PlotPeriodLow=1000.0;
   Range = 0;

   if(Hourly==true)
   {
      PeriodCode = 60;
      PeriodLabel = "Hourly";
      PeriodBuffer = 3600;
   }
   else if(FourHourly==true)
   {
      PeriodCode = 240;
      PeriodLabel = "4 Hourly";
      PeriodBuffer = 14400;

   }
   else if(Daily==true)
   {
      PeriodCode = 1440;
      PeriodLabel = "Daily";
      PeriodBuffer = 86400;
   }
   else if (Weekly==true)
   {
      PeriodCode = 10080;
      PeriodLabel = "Weekly";
      PeriodBuffer = 604800;
   }
   else
   {
      PeriodCode = 43200;
      PeriodLabel = "Monthly";
      PeriodBuffer = 2629743;
   }
            
   //ArrayInitialize(Period_Price,0);
   ArrayCopyRates(Period_Price,(Symbol()), PeriodCode);
   //Add the high and low to the buffer for each bar. Also record the highest and lowest price for the whole period we are plotting
   for(int i=0; i<PeriodsToPlot; i++)
   {
      Buf_HighLow[i][0] = Period_Price[i][3];
      Buf_HighLow[i][1] = Period_Price[i][2];
      if(Period_Price[i][3] > PlotPeriodHigh)
         PlotPeriodHigh = Period_Price[i][3];
      if(Period_Price[i][2] < PlotPeriodLow)
         PlotPeriodLow = Period_Price[i][2];   
   }
      
   
   for(int c=0; c<PeriodsToPlot; c++)
   {
      //Plot

      if(c==0)
      {
         //Current Period High
         ObjectCreate("HZ" + c,OBJ_RECTANGLE,0,Period_Price[c][0],Buf_HighLow[c][0]);
         ObjectSet("HZ" + c,2,Time[c]);
         ObjectSet("HZ" + c,3,PlotPeriodHigh + RangeBuffer);
         //ObjectSet("HZ" + c,6,ZoneColour);
         ObjectSet("HZ" + c,8,2);
                  
         /*
         //Current Period High Period Divider
         ObjectCreate("HDiv"+c, OBJ_TREND,0, Period_Price[c][0],Buf_HighLow[c][0]);
         ObjectSet("HDiv"+c,10,false);
         ObjectSet("HDiv"+c, OBJPROP_COLOR, DividerColour);
         ObjectSet("HDiv"+c, OBJPROP_STYLE, STYLE_SOLID);
         ObjectSet("HDiv"+c,OBJPROP_WIDTH,2);
         ObjectSet("HDiv"+c,2,Period_Price[c][0]);
         ObjectSet("HDiv"+c,3,PlotPeriodHigh + RangeBuffer);
         ObjectSet("HDiv"+c,9,true);
         */
         //Current Period Low
         ObjectCreate("LZ" + c,OBJ_RECTANGLE,0,Period_Price[c][0],PlotPeriodLow - RangeBuffer);
         ObjectSet("LZ" + c,2,Time[c]);
         ObjectSet("LZ" + c,3,Buf_HighLow[c][1]);
         //ObjectSet("LZ" + c,6,ZoneColour);
         ObjectSet("LZ" + c,8,2);
         /*
         //Current Period Low Period Divider
         ObjectCreate("LDiv"+c, OBJ_TREND,0, Period_Price[c][0],Buf_HighLow[c][1]);
         ObjectSet("LDiv"+c,10,false);
         ObjectSet("LDiv"+c, OBJPROP_COLOR, DividerColour);
         ObjectSet("LDiv"+c, OBJPROP_STYLE, STYLE_SOLID);
         ObjectSet("LDiv"+c,OBJPROP_WIDTH,2);
         ObjectSet("LDiv"+c,2,Period_Price[c][0]);
         ObjectSet("LDiv"+c,3,PlotPeriodLow - RangeBuffer);
         ObjectSet("LDiv"+c,9,true);
         */
      }
      else
      {
         //Previous Period High
         ObjectCreate("HZ" + c,OBJ_RECTANGLE,0,Period_Price[c][0],Buf_HighLow[c][0]);
         ObjectSet("HZ" + c,2,Period_Price[c-1][0]);
         ObjectSet("HZ" + c,3,PlotPeriodHigh + RangeBuffer);
         //ObjectSet("HZ" + c,6,ZoneColour);
         ObjectSet("HZ" + c,8,2);
         ObjectSetText("HZ" + c,DoubleToStr((Period_Price[c][3]-Period_Price[c][2])/Poin,0) + " pips");
         /*
         //Previous Period High Period Divider
         ObjectCreate("HDiv"+c, OBJ_TREND,0, Period_Price[c][0],Buf_HighLow[c][0]);
         ObjectSet("HDiv"+c,10,false);
         ObjectSet("HDiv"+c, OBJPROP_COLOR, DividerColour);
         ObjectSet("HDiv"+c, OBJPROP_STYLE, STYLE_SOLID);
         ObjectSet("HDiv"+c,OBJPROP_WIDTH,2);
         ObjectSet("HDiv"+c,2,Period_Price[c][0]);
         ObjectSet("HDiv"+c,3,PlotPeriodHigh + RangeBuffer);
         ObjectSet("HDiv"+c,9,true);
         */         
         //Previous Period Low
         ObjectCreate("LZ" + c,OBJ_RECTANGLE,0,Period_Price[c][0],PlotPeriodLow - RangeBuffer);
         ObjectSet("LZ" + c,2,Period_Price[c-1][0]);
         ObjectSet("LZ" + c,3,Buf_HighLow[c][1]);
         //ObjectSet("LZ" + c,6,ZoneColour);
         ObjectSet("LZ" + c,8,2);
         /*         
         //Previous Period Low Period Divider
         ObjectCreate("LDiv"+c, OBJ_TREND,0, Period_Price[c][0],Buf_HighLow[c][1]);
         ObjectSet("LDiv"+c,10,false);
         ObjectSet("LDiv"+c, OBJPROP_COLOR, DividerColour);
         ObjectSet("LDiv"+c, OBJPROP_STYLE, STYLE_SOLID);
         ObjectSet("LDiv"+c,OBJPROP_WIDTH,2);
         ObjectSet("LDiv"+c,2,Period_Price[c][0]);
         ObjectSet("LDiv"+c,3,PlotPeriodLow - RangeBuffer);
         ObjectSet("LDiv"+c,9,true);
         */
         Range = Range + ((Period_Price[c][3] - Period_Price[c][2])/Poin);
         ObjectSetText("HZ0",PeriodLabel + " (Ave. " + DoubleToStr(Range/(PeriodsToPlot-1),0) + " pips)");
         
         
      }
      if(MathMod(c,2) == 0)
         {
            ObjectSet("HZ" + c,6,ZoneColour1);
            ObjectSet("LZ" + c,6,ZoneColour1);
         }
         else
         {
            ObjectSet("HZ" + c,6,ZoneColour2);
            ObjectSet("LZ" + c,6,ZoneColour2);   
         }      
   }
  return(0);    
 }     
//+------------------------------------------------------------------+


