//------------------------------------------------------------------
#property copyright "mladen"
#property link      "www.forex-station.com"
//------------------------------------------------------------------
#property indicator_separate_window
#property indicator_buffers    5
#property indicator_color1     clrDarkGray
#property indicator_color2     clrLimeGreen
#property indicator_color3     clrLimeGreen
#property indicator_color4     clrOrangeRed
#property indicator_color5     clrOrangeRed
#property indicator_width1     2
#property indicator_width2     3
#property indicator_width3     3
#property indicator_width4     3
#property indicator_width5     3
#property strict

//
//
//
//
//

enum enMaTypes
{
   ma_sma,    // Simple moving average
   ma_ema,    // Exponential moving average
   ma_smma,   // Smoothed MA
   ma_lwma    // Linear weighted MA
};
enum enColorOn
{
   chg_onZero,  // Change color on zero cross
   chg_onOuter, // Change color on levels cross
   chg_onSlope  // Change color on slope change
};
extern ENUM_TIMEFRAMES TimeFrame         = PERIOD_CURRENT; // Time frame
input  int             DmiPeriod         = 32;             // DMI period
input  enMaTypes       DmiMaMethod       = ma_smma;        // DMI smoothing method
input  int             Smooth            = 0;              // Smothing period (<=1 for no smoothing)
input  enMaTypes       SmoothType        = ma_ema;         // Smothing method
input  enColorOn       ColorOn           = chg_onOuter;    // Change color on :
input  double          LevelUp           =  8;             // Level up
input  double          LevelDown         = -8;             // Level down
extern bool            alertsOn          = true;           // Turn alerts on?
extern bool            alertsOnCurrent   = false;          // Alerts on current (still opened) bar?
extern bool            alertsMessage     = true;           // Alerts should show pop-up message?
extern bool            alertsSound       = false;          // Alerts should play alert sound?
extern bool            alertsPushNotif   = false;          // Alerts should send push notification?
extern bool            alertsEmail       = false;          // Alerts should send email?
extern bool            Interpolate       = true;           // Interpolate in multi time frame mode?

double stoch[],stochua[],stochub[],stochda[],stochdb[],state[];
string indicatorFileName;
bool   returnBars;

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int OnInit()
{
   IndicatorBuffers(6);
   SetIndexBuffer( 0, stoch); 
   SetIndexBuffer( 1, stochua); 
   SetIndexBuffer( 2, stochub); 
   SetIndexBuffer( 3, stochda); 
   SetIndexBuffer( 4, stochdb); 
   SetIndexBuffer( 5, state); 
      SetLevelValue(0,LevelUp);
      SetLevelValue(1,LevelDown);
            indicatorFileName = WindowExpertName();
            returnBars        = TimeFrame==-99;
            TimeFrame         = MathMax(TimeFrame,_Period);
   IndicatorShortName(timeFrameToString(TimeFrame)+" DMI oscillator ("+(string)DmiPeriod+","+(string)Smooth+")");
   return(0);
}
void OnDeinit(const int reason) { }
//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double   &open[],
                const double   &high[],
                const double   &low[],
                const double   &close[],
                const long     &tick_volume[],
                const long     &volume[],
                const int      &spread[])
{
   int counted_bars = prev_calculated;
      if(counted_bars < 0) return(-1);
      if(counted_bars > 0) counted_bars--;
         int limit=MathMin(rates_total-counted_bars,rates_total-1);
         if (returnBars) { stoch[0] = MathMin(limit+1,rates_total-1); return(0); }
         if (TimeFrame!=_Period)
         {
            #define _mtfCall(_buff,_y) iCustom(NULL,TimeFrame,indicatorFileName,PERIOD_CURRENT,DmiPeriod,DmiMaMethod,Smooth,SmoothType,ColorOn,LevelUp,LevelDown,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsPushNotif,alertsEmail,_buff,_y)
            if (state[limit]== 1) CleanPoint(limit,stochua,stochub);
            if (state[limit]==-1) CleanPoint(limit,stochda,stochdb);
            for(int i=limit; i>=0; i--)
            {
               int y = iBarShift(NULL,TimeFrame,Time[i]);
               stoch[i]   = _mtfCall(0,y);
               state[i]   = _mtfCall(5,y);
               stochda[i] = EMPTY_VALUE;
               stochdb[i] = EMPTY_VALUE;
               stochua[i] = EMPTY_VALUE;
               stochub[i] = EMPTY_VALUE;
                  if (!Interpolate || (i>0 && y==iBarShift(NULL,TimeFrame,Time[i-1]))) continue;
                  
                  //
                  //
                  //
                  //
                  //
                  
                  #define _interpolate(buff,i,k,n) buff[i+k] = buff[i]+(buff[i+n]-buff[i])*k/n
                  int n,k; datetime ttime = iTime(NULL,TimeFrame,y);
                     for(n = 1; (i+n)<rates_total && time[i+n] >= ttime; n++) continue;	
                     for(k = 1; k<n && (i+n)<rates_total && (i+k)<rates_total; k++) _interpolate(stoch,i,k,n);
            }
            for(int i=limit; i>=0; i--)
            {
               if (state[i] ==  1) PlotPoint(i,stochua,stochub,stoch);
               if (state[i] == -1) PlotPoint(i,stochda,stochdb,stoch);
            }                  
            return(rates_total);
         }               
         
   //
   //
   //
   //
   //

   if (state[limit]== 1) CleanPoint(limit,stochua,stochub);
   if (state[limit]==-1) CleanPoint(limit,stochda,stochdb);
   for(int i=limit; i>=0; i--)
   {
      double dhh = (i<rates_total-1) ? high[i]-high[i+1] : 0;
      double dll = (i<rates_total-1) ? low[i+1]-low[i]   : 0;
      double tr  = (i<rates_total-1) ? MathMax(high[i],close[i+1])-MathMin(low[i],close[i+1]) : high[i]-low[i];
      double atr = iCustomMa(DmiMaMethod,tr,DmiPeriod,i,rates_total,0);

         double plusDM   = (dhh>dll && dhh>0) ? dhh : 0;
         double minusDM  = (dll>dhh && dll>0) ? dll : 0;
         double plusDI   = 100*iCustomMa(DmiMaMethod,plusDM ,DmiPeriod,i,rates_total,1)/atr;
         double minusDI  = 100*iCustomMa(DmiMaMethod,minusDM,DmiPeriod,i,rates_total,2)/atr;
                stoch[i] = iCustomMa(SmoothType,plusDI-minusDI,Smooth,i,rates_total,3);
                switch(ColorOn)
                {
                  case chg_onOuter : state[i] = (stoch[i]>LevelUp) ? 1 : (stoch[i]<LevelDown) ? -1 : 0; break;
                  case chg_onZero  : state[i] = (stoch[i]>0)       ? 1 : (stoch[i]<0)         ? -1 : 0; break;
                  default :          state[i] = (i<rates_total-1) ? (stoch[i]>stoch[i+1]) ? 1 : (stoch[i]<stoch[i+1]) ? -1 : state[i+1] : 0;
                }
                stochda[i] = EMPTY_VALUE;
                stochdb[i] = EMPTY_VALUE;
                stochua[i] = EMPTY_VALUE;
                stochub[i] = EMPTY_VALUE;
         if (state[i] ==  1) PlotPoint(i,stochua,stochub,stoch);
         if (state[i] == -1) PlotPoint(i,stochda,stochdb,stoch);
   }

   //
   //
   //
   //
   //
   
      if (alertsOn)
      {
        int whichBar = 1; if (alertsOnCurrent) whichBar = 0;
        if (state[whichBar] != state[whichBar+1])
        {
           if (state[whichBar] ==  1) doAlert(whichBar,"up");
           if (state[whichBar] == -1) doAlert(whichBar,"down");
        }
      }        
   
   return(rates_total);
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       //
       //
       //
       //
       //

       message =  timeFrameToString(_Period)+" - "+Symbol()+" at "+TimeToStr(TimeLocal(),TIME_SECONDS)+" DMI oscillator state changed to "+doWhat;
          if (alertsMessage)   Alert(message);
          if (alertsEmail)     SendMail(Symbol()+" DMI oscillator",message);
          if (alertsPushNotif) SendNotification(message);
          if (alertsSound)     PlaySound("alert2.wav");
   }
}

//------------------------------------------------------------------
//                                                                  
//------------------------------------------------------------------
//
//
//
//
//

#define _maInstances 4
#define _maWorkBufferx1 1*_maInstances
#define _maWorkBufferx2 2*_maInstances

double iCustomMa(int mode, double price, double length, int r, int bars, int instanceNo=0)
{
   r = bars-r-1;
   switch (mode)
   {
      case ma_sma   : return(iSma(price,(int)length,r,bars,instanceNo));
      case ma_ema   : return(iEma(price,length,r,bars,instanceNo));
      case ma_smma  : return(iSmma(price,(int)length,r,bars,instanceNo));
      case ma_lwma  : return(iLwma(price,(int)length,r,bars,instanceNo));
      default       : return(price);
   }
}

//
//
//
//
//

double workSma[][_maWorkBufferx2];
double iSma(double price, int period, int r, int _bars, int instanceNo=0)
{
   if (ArrayRange(workSma,0)!= _bars) ArrayResize(workSma,_bars); instanceNo *= 2; int k;

   workSma[r][instanceNo+0] = price;
   workSma[r][instanceNo+1] = price; for(k=1; k<period && (r-k)>=0; k++) workSma[r][instanceNo+1] += workSma[r-k][instanceNo+0];  
   workSma[r][instanceNo+1] /= 1.0*k;
   return(workSma[r][instanceNo+1]);
}

//
//
//
//
//

double workEma[][_maWorkBufferx1];
double iEma(double price, double period, int r, int _bars, int instanceNo=0)
{
   if (ArrayRange(workEma,0)!= _bars) ArrayResize(workEma,_bars);

   workEma[r][instanceNo] = price;
   if (r>0 && period>1)
          workEma[r][instanceNo] = workEma[r-1][instanceNo]+(2.0/(1.0+period))*(price-workEma[r-1][instanceNo]);
   return(workEma[r][instanceNo]);
}

//
//
//
//
//

double workSmma[][_maWorkBufferx1];
double iSmma(double price, double period, int r, int _bars, int instanceNo=0)
{
   if (ArrayRange(workSmma,0)!= _bars) ArrayResize(workSmma,_bars);

   workSmma[r][instanceNo] = price;
   if (r>1 && period>1)
          workSmma[r][instanceNo] = workSmma[r-1][instanceNo]+(price-workSmma[r-1][instanceNo])/period;
   return(workSmma[r][instanceNo]);
}

//
//
//
//
//

double workLwma[][_maWorkBufferx1];
double iLwma(double price, double period, int r, int _bars, int instanceNo=0)
{
   if (ArrayRange(workLwma,0)!= _bars) ArrayResize(workLwma,_bars);
   
   workLwma[r][instanceNo] = price; if (period<=1) return(price);
      double sumw = period;
      double sum  = period*price;

      for(int k=1; k<period && (r-k)>=0; k++)
      {
         double weight = period-k;
                sumw  += weight;
                sum   += weight*workLwma[r-k][instanceNo];  
      }             
      return(sum/sumw);
}


//-------------------------------------------------------------------
//                                                                  
//-------------------------------------------------------------------
//
//
//
//
//

void CleanPoint(int i,double& first[],double& second[])
{
   if (i>=Bars-3) return;
   if ((second[i]  != EMPTY_VALUE) && (second[i+1] != EMPTY_VALUE))
        second[i+1] = EMPTY_VALUE;
   else
      if ((first[i] != EMPTY_VALUE) && (first[i+1] != EMPTY_VALUE) && (first[i+2] == EMPTY_VALUE))
          first[i+1] = EMPTY_VALUE;
}

void PlotPoint(int i,double& first[],double& second[],double& from[])
{
   if (i>=Bars-2) return;
   if (first[i+1] == EMPTY_VALUE)
      if (first[i+2] == EMPTY_VALUE) 
            { first[i]  = from[i];  first[i+1]  = from[i+1]; second[i] = EMPTY_VALUE; }
      else  { second[i] =  from[i]; second[i+1] = from[i+1]; first[i]  = EMPTY_VALUE; }
   else     { first[i]  = from[i];                           second[i] = EMPTY_VALUE; }
}

//-------------------------------------------------------------------
//
//-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}