//------------------------------------------------------------------
#property copyright "mladen"
#property copyright "www.forex-station.com"
#property link      "www.forex-station.com"
//------------------------------------------------------------------
#property indicator_separate_window
#property indicator_buffers    5
#property indicator_color1     clrDarkGray    // stoch
#property indicator_color2     clrLimeGreen   // stochua
#property indicator_color3     clrLimeGreen   // stochub
#property indicator_color4     clrOrangeRed   // stochda
#property indicator_color5     clrOrangeRed   // stochdb
#property indicator_width1     2
#property indicator_width2     3
#property indicator_width3     3
#property indicator_width4     3
#property indicator_width5     3
#property strict

//
//
//
//
//

enum enMaTypes
{
   ma_sma,    // Simple moving average
   ma_ema,    // Exponential moving average
   ma_smma,   // Smoothed MA
   ma_lwma    // Linear weighted MA
};
extern ENUM_TIMEFRAMES TimeFrame         = PERIOD_CURRENT; // Time frame
input int              DmiPeriod         = 32;             // DMI period
input int              StochasticPeriod  = 50;             // Stochastic period
input int              StochasticSlowing =  9;             // Stochastic slowing period
input enMaTypes        SmoothingMethod   = ma_smma;        // Smoothing method for atr and dmi calculation
input double           LevelUp           = 90;             // Level up
input double           LevelDown         = 10;             // Level down
extern bool            alertsOn          = true;           // Turn alerts on?
extern bool            alertsOnCurrent   = false;          // Alerts on current (still opened) bar?
extern bool            alertsMessage     = true;           // Alerts should show pop-up message?
extern bool            alertsSound       = false;          // Alerts should play alert sound?
extern bool            alertsPushNotif   = false;          // Alerts should send push notification?
extern bool            alertsEmail       = false;          // Alerts should send email?
extern bool           divergenceVisible            = false;             // Should the divergence be visible
extern bool           divergenceOnValuesVisible    = true;              // Divergence lines on indicator line visible?
extern bool           divergenceOnChartVisible     = true;              // Divergence lines on main chart visible?
extern int            DivergearrowSize             = 1;                 // Divergence arrows size
extern double         DivergencearrowsUpperGap     = 4;                 // Upper Gap between divergence arrows and indicator line
extern double         DivergencearrowsLowerGap     = 4;                 // Lower Gap between divergence arrows and indicator line
extern bool           ShowClassicalDivergence      = true;              // Classical divergence visible
extern bool           ShowHiddenDivergence         = true;              // Hidden divergence visible
extern color          divergenceBullishColor       = clrLimeGreen;      // Bullish divergences color
extern color          divergenceBearishColor       = clrOrangeRed;      // Bearish divergences color
extern int            ClassicDivergenceUpArrowCode = 233;               // classical divergence up arrow code
extern int            ClassicDivergenceDnArrowCode = 234;               // classical divergence dn arrow code
extern int            HiddenDivergenceUpArrowCode  = 159;               // hidden divergence up arrow code
extern int            HiddenDivergenceDnArrowCode  = 159;               // hidden divergence dn arrow code
extern string         divergenceUniqueID           = "DMIStodiverg1";   // Unique ID for divergence lines
extern bool            Interpolate       = true;           // Interpolate in multi time frame mode?


double stoch[],stochua[],stochub[],stochda[],stochdb[],state[];
double cbulld[];
double hbulld[];
double cbeard[];
double hbeard[];
string indicatorFileName,shortName;
bool   returnBars;

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int OnInit()
{
   IndicatorBuffers(10);
   SetIndexBuffer( 0, stoch); 
   SetIndexBuffer( 1, stochua); 
   SetIndexBuffer( 2, stochub); 
   SetIndexBuffer( 3, stochda); 
   SetIndexBuffer( 4, stochdb); 
   SetIndexBuffer( 5,cbulld);  SetIndexStyle(5,DRAW_ARROW,0,DivergearrowSize); SetIndexArrow(5,ClassicDivergenceUpArrowCode);SetIndexStyle(5,DRAW_LINE,0,2);
   SetIndexBuffer( 6,cbeard);  SetIndexStyle(6,DRAW_ARROW,0,DivergearrowSize); SetIndexArrow(6,ClassicDivergenceDnArrowCode);SetIndexStyle(6,DRAW_LINE,0,2);
   SetIndexBuffer( 7,hbulld);  SetIndexStyle(7,DRAW_ARROW,0,DivergearrowSize); SetIndexArrow(7,HiddenDivergenceUpArrowCode);
   SetIndexBuffer( 8,hbeard);  SetIndexStyle(8,DRAW_ARROW,0,DivergearrowSize); SetIndexArrow(8,HiddenDivergenceDnArrowCode);
   SetIndexBuffer( 9, state); 
   
      SetLevelValue(0,LevelUp);
      SetLevelValue(1,LevelDown);
            indicatorFileName = WindowExpertName();
            returnBars        = TimeFrame==-99;
            TimeFrame         = MathMax(TimeFrame,_Period);
            shortName         = divergenceUniqueID+" "+timeFrameToString(TimeFrame)+" DMI Sto XX ("+(string)DmiPeriod+","+(string)StochasticPeriod+")";
   IndicatorShortName(shortName);
   return(0);
}
void OnDeinit(const int reason) 
{ 
   int lookForLength = StringLen(divergenceUniqueID);
   
      for (int i=ObjectsTotal()-1; i>=0; i--) 
      {
         string name = ObjectName(i);  if (StringSubstr(name,0,lookForLength) == divergenceUniqueID) ObjectDelete(name);
      }
//return(0); 
}
//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double   &open[],
                const double   &high[],
                const double   &low[],
                const double   &close[],
                const long     &tick_volume[],
                const long     &volume[],
                const int      &spread[])
{
   int counted_bars = prev_calculated;
      if(counted_bars < 0) return(-1);
      if(counted_bars > 0) counted_bars--;
            int limit=MathMin(rates_total-counted_bars,rates_total-1);
            if (returnBars) { stoch[0] = MathMin(limit+1,Bars-1); return(0); }
            if (TimeFrame!=_Period)
            {
               #define _mtfCall(_buff,_y) iCustom(NULL,TimeFrame,indicatorFileName,PERIOD_CURRENT,DmiPeriod,StochasticPeriod,StochasticSlowing,SmoothingMethod,LevelUp,LevelDown,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsPushNotif,alertsEmail,divergenceVisible,divergenceOnValuesVisible,divergenceOnChartVisible,DivergearrowSize,DivergencearrowsUpperGap,DivergencearrowsLowerGap,ShowClassicalDivergence,ShowHiddenDivergence,divergenceBullishColor,divergenceBearishColor,ClassicDivergenceUpArrowCode,ClassicDivergenceDnArrowCode,HiddenDivergenceUpArrowCode,HiddenDivergenceDnArrowCode,divergenceUniqueID,_buff,_y)
               if (state[limit]== 1) CleanPoint(limit,stochua,stochub);
               if (state[limit]==-1) CleanPoint(limit,stochda,stochdb);
               for(int i=limit; i>=0; i--)
               {
                  int y = iBarShift(NULL,TimeFrame,Time[i]);
                  stoch[i]   = _mtfCall(0,y);
                  state[i]   = _mtfCall(9,y);
                  stochda[i] = EMPTY_VALUE;
                  stochdb[i] = EMPTY_VALUE;
                  stochua[i] = EMPTY_VALUE;
                  stochub[i] = EMPTY_VALUE;
                  if (!Interpolate || (i>0 && y==iBarShift(NULL,TimeFrame,Time[i-1]))) continue;
                  
                  //
                  //
                  //
                  //
                  //
                  
                  #define _interpolate(buff,i,k,n) buff[i+k] = buff[i]+(buff[i+n]-buff[i])*k/n
                  int n,k; datetime ttime = iTime(NULL,TimeFrame,y);
                     for(n = 1; (i+n)<rates_total && time[i+n] >= ttime; n++) continue;	
                     for(k = 1; k<n && (i+n)<rates_total && (i+k)<rates_total; k++) _interpolate(stoch,i,k,n);
               }
               for(int i=limit; i>=0; i--)
               {
                  if (state[i] ==  1) PlotPoint(i,stochua,stochub,stoch);
                  if (state[i] == -1) PlotPoint(i,stochda,stochdb,stoch);
               }                  
               return(rates_total);
            }               
               
         
   //
   //
   //
   //
   //

   if (state[limit]== 1) CleanPoint(limit,stochua,stochub);
   if (state[limit]==-1) CleanPoint(limit,stochda,stochdb);
   for(int i=limit; i>=0; i--)
   {
      double dhh     = (i<rates_total-1) ? high[i]-high[i+1] : 0;
      double dll     = (i<rates_total-1) ? low[i+1]-low[i]   : 0;
      double tr      = (i<rates_total-1) ? MathMax(high[i],close[i+1])-MathMin(low[i],close[i+1]) : high[i]-low[i];
      double atr     = iCustomMa(SmoothingMethod,tr,DmiPeriod,i,rates_total,0);

         double plusDM   = (dhh>dll && dhh>0) ? dhh : 0;
         double minusDM  = (dll>dhh && dll>0) ? dll : 0;
         double plusDI   = 100*iCustomMa(SmoothingMethod,plusDM ,DmiPeriod,i,rates_total,1)/atr;
         double minusDI  = 100*iCustomMa(SmoothingMethod,minusDM,DmiPeriod,i,rates_total,2)/atr;
         double osc      = plusDI-minusDI;
                stoch[i] = iStoch(osc,osc,osc,StochasticPeriod,StochasticSlowing,i,rates_total);
                state[i] = (stoch[i]>LevelUp) ? 1 : (stoch[i]<LevelDown) ? -1 : 0;
                stochda[i] = EMPTY_VALUE;
                stochdb[i] = EMPTY_VALUE;
                stochua[i] = EMPTY_VALUE;
                stochub[i] = EMPTY_VALUE;
         if (state[i] ==  1) PlotPoint(i,stochua,stochub,stoch);
         if (state[i] == -1) PlotPoint(i,stochda,stochdb,stoch);
         if (divergenceVisible)
         {
           CatchBullishDivergence(stoch,i);
           CatchBearishDivergence(stoch,i);
         }          
   }

   //
   //
   //
   //
   //
   
      if (alertsOn)
      {
        int whichBar = 1; if (alertsOnCurrent) whichBar = 0;
        if (state[whichBar] != state[whichBar+1])
        {
           if (state[whichBar] ==  1) doAlert(whichBar,"up");
           if (state[whichBar] == -1) doAlert(whichBar,"down");
        }
      }        
   
   return(rates_total);
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       //
       //
       //
       //
       //

       message =  timeFrameToString(_Period)+" - "+Symbol()+" at "+TimeToStr(TimeLocal(),TIME_SECONDS)+" DMI stochastic extreme state changed to "+doWhat;
          if (alertsMessage)   Alert(message);
          if (alertsEmail)     SendMail(Symbol()+" DMI stochastic extreme",message);
          if (alertsPushNotif) SendNotification(message);
          if (alertsSound)     PlaySound("alert2.wav");
   }
}

//
//
//
//
//

//------------------------------------------------------------------
//------------------------------------------------------------------
//
//
//
void CatchBullishDivergence(double& values[], int i)
{
   i++;
            cbulld[(int)MathMin(i,Bars-1)] = EMPTY_VALUE;
            hbulld[(int)MathMin(i,Bars-1)] = EMPTY_VALUE;
            ObjectDelete(divergenceUniqueID+"l"+ DoubleToStr(Time[(int)MathMin(i,Bars-1)],0));
            ObjectDelete(divergenceUniqueID+"l"+"os" + DoubleToStr(Time[(int)MathMin(i,Bars-1)],0));            
   if (!IsIndicatorLow(values,(int)MathMin(i,Bars-1))) return;  

   //
   //
   //
   //
   //

   int currentLow = i;
   int lastLow    = GetIndicatorLastLow(values,i+1);
      if (currentLow>=0 && currentLow<Bars && lastLow>=0) 
      if (values[currentLow] > values[lastLow] && Low[currentLow] < Low[lastLow])
      {
        if (ShowClassicalDivergence)
        {
          cbulld[currentLow] = values[currentLow] - DivergencearrowsLowerGap;
          if(divergenceOnChartVisible)  DrawPriceTrendLine("l",Time[currentLow],Time[lastLow],Low[currentLow],Low[lastLow],          divergenceBullishColor,STYLE_SOLID);
          if(divergenceOnValuesVisible) DrawIndicatorTrendLine("l",Time[currentLow],Time[lastLow],values[currentLow],values[lastLow],divergenceBullishColor,STYLE_SOLID);
        }
      }
      
      if (currentLow>=0 && currentLow<Bars && lastLow>=0) 
      if (values[currentLow] < values[lastLow] && Low[currentLow] > Low[lastLow])
      {
        if (ShowHiddenDivergence)
        {
          hbulld[currentLow] = values[currentLow] - DivergencearrowsLowerGap;
          if(divergenceOnChartVisible)  DrawPriceTrendLine("l",Time[currentLow],Time[lastLow],Low[currentLow],Low[lastLow],           divergenceBullishColor, STYLE_DOT);
          if(divergenceOnValuesVisible) DrawIndicatorTrendLine("l",Time[currentLow],Time[lastLow],values[currentLow],values[lastLow], divergenceBullishColor, STYLE_DOT);
        }
      }
}

//
//
//
//
//

void CatchBearishDivergence(double& values[], int i)
{
   i++; 
            cbeard[(int)MathMin(i,Bars-1)] = EMPTY_VALUE;
            hbeard[(int)MathMin(i,Bars-1)] = EMPTY_VALUE;
            ObjectDelete(divergenceUniqueID+"h"+DoubleToStr(Time[(int)MathMin(i,Bars-1)],0));
            ObjectDelete(divergenceUniqueID+"h"+"os" + DoubleToStr(Time[(int)MathMin(i,Bars-1)],0));            
   if (IsIndicatorPeak(values,(int)MathMin(i,Bars-1)) == false) return;

   //
   //
   //
   //
   //
      
   int currentPeak = i;
   int lastPeak = GetIndicatorLastPeak(values,i+1);
      if (currentPeak>=0 && currentPeak<Bars && lastPeak>=0) 
      if (values[currentPeak] < values[lastPeak] && High[currentPeak]>High[lastPeak])
      {
        if (ShowClassicalDivergence)
        {
          cbeard[currentPeak] = values[currentPeak] + DivergencearrowsUpperGap;
          if (divergenceOnChartVisible)  DrawPriceTrendLine("h",Time[currentPeak],Time[lastPeak],High[currentPeak],High[lastPeak],        divergenceBearishColor,STYLE_SOLID);
          if (divergenceOnValuesVisible) DrawIndicatorTrendLine("h",Time[currentPeak],Time[lastPeak],values[currentPeak],values[lastPeak],divergenceBearishColor,STYLE_SOLID);
        }
      }
      if (currentPeak>=0 && currentPeak<Bars && lastPeak>=0) 
      if (values[currentPeak] > values[lastPeak] && High[currentPeak] < High[lastPeak])
      {
        if (ShowHiddenDivergence)
        {
          hbeard[currentPeak] = values[currentPeak] + DivergencearrowsUpperGap;
          if (divergenceOnChartVisible)  DrawPriceTrendLine("h",Time[currentPeak],Time[lastPeak],High[currentPeak],High[lastPeak],         divergenceBearishColor, STYLE_DOT);
          if (divergenceOnValuesVisible) DrawIndicatorTrendLine("h",Time[currentPeak],Time[lastPeak],values[currentPeak],values[lastPeak], divergenceBearishColor, STYLE_DOT);
        }
      }
}

//
//
//
//
//

bool IsIndicatorPeak(double& values[], int i) { return(values[i] >= values[(int)MathMin(i+1,Bars-1)] && values[i] > values[(int)MathMin(i+2,Bars-1)] && values[i] > values[(int)MathMax(i-1,0)]); }
bool IsIndicatorLow( double& values[], int i) { return(values[i] <= values[(int)MathMin(i+1,Bars-1)] && values[i] < values[(int)MathMin(i+2,Bars-1)] && values[i] < values[(int)MathMax(i-1,0)]); }

int GetIndicatorLastPeak(double& values[], int shift)
{
   for(int i = shift+5; i<Bars && (i+2)<(Bars-1) && (i-2)>=0; i++)
         if (values[i] >= values[i+1] && values[i] > values[i+2] && values[i] >= values[i-1] && values[i] > values[i-2]) return(i);
   return(-1);
}
int GetIndicatorLastLow(double& values[], int shift)
{
   for(int i = shift+5; i<Bars && (i+2)<(Bars-1) && (i-2)>=0; i++)
         if (values[i] <= values[i+1] && values[i] < values[i+2] && values[i] <= values[i-1] && values[i] < values[i-2]) return(i);
   return(-1);
}

//+------------------------------------------------------------------
//|                                                                  
//+------------------------------------------------------------------
//
//
//
//
//

void DrawPriceTrendLine(string first,datetime t1, datetime t2, double p1, double p2, color lineColor, double style)
{
   string   label = divergenceUniqueID+first+"os"+DoubleToStr(t1,0);
   ObjectDelete(label);
      ObjectCreate(label, OBJ_TREND, 0, t1+Period()*60-1, p1, t2, p2, 0, 0);
         ObjectSet(label, OBJPROP_RAY, false);
         ObjectSet(label, OBJPROP_COLOR, lineColor);
         ObjectSet(label, OBJPROP_STYLE, style);
}
void DrawIndicatorTrendLine(string first,datetime t1, datetime t2, double p1, double p2, color lineColor, double style)
{
   int indicatorWindow = WindowFind(shortName);
   if (indicatorWindow < 0) return;
   string label = divergenceUniqueID+first+DoubleToStr(t1,0);
   ObjectDelete(label);
      ObjectCreate(label, OBJ_TREND, indicatorWindow, t1+Period()*60-1, p1, t2, p2, 0, 0);
         ObjectSet(label, OBJPROP_RAY, false);
         ObjectSet(label, OBJPROP_COLOR, lineColor);
         ObjectSet(label, OBJPROP_STYLE, style);
}

//
//
//+------------------------------------------------------------------
//|                                                                  
//+------------------------------------------------------------------
//
//
//


double workSto[][5];
#define _hi 0
#define _lo 1
#define _re 2
#define _ma 3
#define _mi 4
double iStoch(double priceR, double priceH, double priceL, int period, int slowing, int i, int bars, int instanceNo=0)
{
   if (ArrayRange(workSto,0)!=bars) ArrayResize(workSto,bars); instanceNo *= 5; i=bars-i-1;
   
   //
   //
   //
   //
   //
   
   workSto[i][_hi+instanceNo] = priceH;
   workSto[i][_lo+instanceNo] = priceL;
   workSto[i][_re+instanceNo] = priceR;
   workSto[i][_ma+instanceNo] = priceH;
   workSto[i][_mi+instanceNo] = priceL;
      for (int k=1; k<period && (i-k)>=0; k++)
      {
         workSto[i][_mi+instanceNo] = MathMin(workSto[i][_mi+instanceNo],workSto[i-k][instanceNo+_lo]);
         workSto[i][_ma+instanceNo] = MathMax(workSto[i][_ma+instanceNo],workSto[i-k][instanceNo+_hi]);
      }                   
      double sumlow  = 0.0;
      double sumhigh = 0.0;
      for(int k=0; k<slowing && (i-k)>=0; k++)
      {
         sumlow  += workSto[i-k][_re+instanceNo]-workSto[i-k][_mi+instanceNo];
         sumhigh += workSto[i-k][_ma+instanceNo]-workSto[i-k][_mi+instanceNo];
      }

   //
   //
   //
   //
   //
   
   if(sumhigh!=0.0) 
         return(100.0*sumlow/sumhigh);
   else  return(0);    
}


//------------------------------------------------------------------
//                                                                  
//------------------------------------------------------------------
//
//
//
//
//

#define _maInstances 3
#define _maWorkBufferx1 1*_maInstances
#define _maWorkBufferx2 2*_maInstances

double iCustomMa(int mode, double price, double length, int r, int bars, int instanceNo=0)
{
   r = bars-r-1;
   switch (mode)
   {
      case ma_sma   : return(iSma(price,(int)length,r,bars,instanceNo));
      case ma_ema   : return(iEma(price,length,r,bars,instanceNo));
      case ma_smma  : return(iSmma(price,(int)length,r,bars,instanceNo));
      case ma_lwma  : return(iLwma(price,(int)length,r,bars,instanceNo));
      default       : return(price);
   }
}

//
//
//
//
//

double workSma[][_maWorkBufferx2];
double iSma(double price, int period, int r, int _bars, int instanceNo=0)
{
   if (ArrayRange(workSma,0)!= _bars) ArrayResize(workSma,_bars); instanceNo *= 2; int k;

   workSma[r][instanceNo+0] = price;
   workSma[r][instanceNo+1] = price; for(k=1; k<period && (r-k)>=0; k++) workSma[r][instanceNo+1] += workSma[r-k][instanceNo+0];  
   workSma[r][instanceNo+1] /= 1.0*k;
   return(workSma[r][instanceNo+1]);
}

//
//
//
//
//

double workEma[][_maWorkBufferx1];
double iEma(double price, double period, int r, int _bars, int instanceNo=0)
{
   if (ArrayRange(workEma,0)!= _bars) ArrayResize(workEma,_bars);

   workEma[r][instanceNo] = price;
   if (r>0 && period>1)
          workEma[r][instanceNo] = workEma[r-1][instanceNo]+(2.0/(1.0+period))*(price-workEma[r-1][instanceNo]);
   return(workEma[r][instanceNo]);
}

//
//
//
//
//

double workSmma[][_maWorkBufferx1];
double iSmma(double price, double period, int r, int _bars, int instanceNo=0)
{
   if (ArrayRange(workSmma,0)!= _bars) ArrayResize(workSmma,_bars);

   workSmma[r][instanceNo] = price;
   if (r>1 && period>1)
          workSmma[r][instanceNo] = workSmma[r-1][instanceNo]+(price-workSmma[r-1][instanceNo])/period;
   return(workSmma[r][instanceNo]);
}

//
//
//
//
//

double workLwma[][_maWorkBufferx1];
double iLwma(double price, double period, int r, int _bars, int instanceNo=0)
{
   if (ArrayRange(workLwma,0)!= _bars) ArrayResize(workLwma,_bars);
   
   workLwma[r][instanceNo] = price; if (period<=1) return(price);
      double sumw = period;
      double sum  = period*price;

      for(int k=1; k<period && (r-k)>=0; k++)
      {
         double weight = period-k;
                sumw  += weight;
                sum   += weight*workLwma[r-k][instanceNo];  
      }             
      return(sum/sumw);
}


//-------------------------------------------------------------------
//                                                                  
//-------------------------------------------------------------------
//
//
//
//
//

void CleanPoint(int i,double& first[],double& second[])
{
   if (i>=Bars-3) return;
   if ((second[i]  != EMPTY_VALUE) && (second[i+1] != EMPTY_VALUE))
        second[i+1] = EMPTY_VALUE;
   else
      if ((first[i] != EMPTY_VALUE) && (first[i+1] != EMPTY_VALUE) && (first[i+2] == EMPTY_VALUE))
          first[i+1] = EMPTY_VALUE;
}

void PlotPoint(int i,double& first[],double& second[],double& from[])
{
   if (i>=Bars-2) return;
   if (first[i+1] == EMPTY_VALUE)
      if (first[i+2] == EMPTY_VALUE) 
            { first[i]  = from[i];  first[i+1]  = from[i+1]; second[i] = EMPTY_VALUE; }
      else  { second[i] =  from[i]; second[i+1] = from[i+1]; first[i]  = EMPTY_VALUE; }
   else     { first[i]  = from[i];                           second[i] = EMPTY_VALUE; }
}

//-------------------------------------------------------------------
//
//-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}