#property copyright "www,forex-tsd.com"
#property link      "www,forex-tsd.com"

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1  clrLimeGreen
#property indicator_color2  clrOrange
#property indicator_color3  clrOrange
#property indicator_width1  2
#property indicator_width2  2
#property indicator_width3  2
#property strict

extern ENUM_TIMEFRAMES    TimeFrame   = PERIOD_CURRENT; // Time frame to use
extern int                Length      = 14;             // Calculation period
extern ENUM_APPLIED_PRICE Price       = PRICE_CLOSE;    // Price
extern bool               Interpolate = true;           // Interpolate in multi time frame mode?

double EVWMA[],EVWMAda[],EVWMAdb[],slope[],V[];
string indicatorFileName;
bool   returnBars;

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int init()
{
   IndicatorBuffers(5);
   SetIndexBuffer(0,EVWMA);
   SetIndexBuffer(1,EVWMAda);
   SetIndexBuffer(2,EVWMAdb);
   SetIndexBuffer(3,V);
   SetIndexBuffer(4,slope);
            indicatorFileName = WindowExpertName();
            returnBars        = TimeFrame==-99;
            TimeFrame         = MathMax(TimeFrame,_Period);
   IndicatorShortName("Elastic Volume Weighted Moving Average");
   return(0);
}
int deinit() { return(0); }

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int start()
{
   int counted_bars = IndicatorCounted();
      if(counted_bars < 0) return(-1);
      if(counted_bars > 0) counted_bars--;
         int limit = MathMin(Bars-counted_bars,Bars-1);
         if (returnBars) { EVWMA[0] = limit+1; return(0); }
         if (TimeFrame!=_Period)
         {
            limit = (int)MathMax(limit,MathMin(Bars-1,iCustom(NULL,TimeFrame,indicatorFileName,-99,0,0)*TimeFrame/Period()));
            if (slope[limit]==-1) CleanPoint(limit,EVWMAda,EVWMAdb);
            for (int i=limit; i>=0; i--)
            {
               int y = iBarShift(NULL,TimeFrame,Time[i]);               
                  slope[i] = iCustom(NULL,TimeFrame,indicatorFileName,PERIOD_CURRENT,Length,Price,4,y);
                  EVWMA[i] = iCustom(NULL,TimeFrame,indicatorFileName,PERIOD_CURRENT,Length,Price,0,y);
                  EVWMAda[i] = EMPTY_VALUE;
                  EVWMAdb[i] = EMPTY_VALUE;
                  if (!Interpolate || (i>0 && y==iBarShift(NULL,TimeFrame,Time[i-1]))) continue;
                  
                  //
                  //
                  //
                  //
                  //
                  
                  int n,j; datetime time = iTime(NULL,TimeFrame,y);
                     for(n = 1; (i+n)<Bars && Time[i+n] >= time; n++) continue;	
                     for(j = 1; j<n && (i+n)<Bars && (i+j)<Bars; j++)
                        EVWMA[i+j] = EVWMA[i] + (EVWMA[i+n] - EVWMA[i]   )*j/n;
            }
            for (int i=limit; i>=0; i--) if (slope[i]==-1) if (slope[i]==-1) PlotPoint(i,EVWMAda,EVWMAdb,EVWMA);
            return(0);                  
         }

   //
   //
   //
   //
   //
   
   if (slope[limit]==-1) CleanPoint(limit,EVWMAda,EVWMAdb);
      for(int i=limit; i >= 0; i--) V[i]=(double)Volume[i];
      for(int i=limit; i >= 0; i--)
      {
         double Total=iMAOnArray(V,0,Length,0,MODE_SMA,i)*Length;
         double price=iMA(NULL,0,1,0,MODE_SMA,Price,i);
         if (Total!=0)
               EVWMA[i]=((Total-Volume[i])*EVWMA[i+1]+Volume[i]*price)/Total;
         else  EVWMA[i]=price;
               EVWMAda[i] = EMPTY_VALUE;
               EVWMAdb[i] = EMPTY_VALUE;
               if (i<Bars-1)
               {
                  slope[i] = slope[i+1];
                  if (EVWMA[i]>EVWMA[i+1]) slope[i] =  1;
                  if (EVWMA[i]<EVWMA[i+1]) slope[i] = -1;
               }
               if (slope[i]==-1) PlotPoint(i,EVWMAda,EVWMAdb,EVWMA);                  
      }  
      return(0);
}

//-------------------------------------------------------------------
//
//-------------------------------------------------------------------
//
//
//
//
//

void CleanPoint(int i,double& first[],double& second[])
{
   if (i>Bars-2) return;
   if ((second[i]  != EMPTY_VALUE) && (second[i+1] != EMPTY_VALUE))
        second[i+1] = EMPTY_VALUE;
   else
      if ((first[i] != EMPTY_VALUE) && (first[i+1] != EMPTY_VALUE) && (first[i+2] == EMPTY_VALUE))
          first[i+1] = EMPTY_VALUE;
}

void PlotPoint(int i,double& first[],double& second[],double& from[])
{
   if (i>Bars-3) return;
   if (first[i+1] == EMPTY_VALUE)
         if (first[i+2] == EMPTY_VALUE) 
               { first[i]  = from[i]; first[i+1]  = from[i+1]; second[i] = EMPTY_VALUE; }
         else  { second[i] = from[i]; second[i+1] = from[i+1]; first[i]  = EMPTY_VALUE; }
   else        { first[i]  = from[i];                          second[i] = EMPTY_VALUE; }
}