#property copyright   "www.forex-indicators.org"
#property link        "http://www.forex-indicators.org"
#property description "If this indicator does not work, please contact us at: emails@forex-indicators.org"

//----
#property indicator_separate_window
#property indicator_buffers 7
#property indicator_color1 Gold
#property indicator_color2 Gold
#property indicator_color3 FireBrick
#property indicator_color4 FireBrick
#property indicator_color5 Green
#property indicator_color6 Red
#property indicator_color7 Red
#property indicator_width1 2
#property indicator_width3 2

//---- input parameters
extern string separator1="*** MACD/OSMA Settings ***";
extern double fastEMA=8.3896;
extern double slowEMA=17.5185;
extern double signal=9.0503;
extern bool   UseOSMA = false;
extern bool   UseDema = true;
extern string separator2="*** Indicator Settings";
extern double positiveSensitivity=0.0001;
extern double negativeSensitivity=-0.0001;
extern double historyBarsCount=0;
extern bool   drawDivergenceLines=true;
//---- buffers
double upOsMA[];
double upOsMAd[];
double downOsMA[];
double downOsMAu[];
double bullishDivergence[];
double bearishDivergence[];
double OsMA[];
static int chartBarsCount;
string shortName;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   SetIndexBuffer(0, upOsMA);            SetIndexStyle(0, DRAW_HISTOGRAM);
   SetIndexBuffer(1, upOsMAd);           SetIndexStyle(1, DRAW_HISTOGRAM);
   SetIndexBuffer(2, downOsMA);          SetIndexStyle(2, DRAW_HISTOGRAM);
   SetIndexBuffer(3, downOsMAu);         SetIndexStyle(3, DRAW_HISTOGRAM);
   SetIndexBuffer(4, bullishDivergence); SetIndexStyle(4, DRAW_ARROW); SetIndexArrow(4, 233);
   SetIndexBuffer(5, bearishDivergence); SetIndexStyle(5, DRAW_ARROW); SetIndexArrow(5, 234);
   SetIndexBuffer(6, OsMA);
   IndicatorDigits(MarketInfo(Symbol(), MODE_DIGITS) + 2);
   shortName = "FX5_Divergence("+DoubleToStr(fastEMA,4)+ ","+DoubleToStr(slowEMA,4)+","+DoubleToStr(signal,4)+")";
   IndicatorShortName(shortName);
//----
   if(historyBarsCount<=0 || historyBarsCount > Bars)
      chartBarsCount=Bars;
   else
      chartBarsCount=historyBarsCount;
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   for(int i=ObjectsTotal() - 1; i>=0; i--)
     {
      string label=ObjectName(i);
      if(StringSubstr(label, 0, 14)!="DivergenceLine")
         continue;
      ObjectDelete(label);
     }
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int countedBars=IndicatorCounted();
   if(countedBars < 0)
      countedBars=0;
//----
   CalculateOsMA(countedBars);
   CalculateDivergence(countedBars);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CalculateDivergence(int countedBars)
  {
   double arrowSeparation=1/MathPow(10, MarketInfo(Symbol(),
                            MODE_DIGITS) + 2) * 50;
//----    
   for(int i=chartBarsCount - countedBars; i>=0; i--)
     {
      bearishDivergence[i]=EMPTY_VALUE;
      bullishDivergence[i]=EMPTY_VALUE;
      //----   
      int firstPeakOrTroughShift=GetFirstPeakOrTrough(i);
      double firstPeakOrTroughOsMA=OsMA[firstPeakOrTroughShift];
      if(firstPeakOrTroughOsMA > 0)
        {
         int peak_0  =GetIndicatorLastPeak(i);
         int trough_0=GetIndicatorLastTrough(peak_0);
         int peak_1  =GetIndicatorLastPeak(trough_0);
         int trough_1=GetIndicatorLastTrough(peak_1);
        }
      else
        {
         trough_0=GetIndicatorLastTrough(i);
         peak_0  =GetIndicatorLastPeak(trough_0);
         trough_1=GetIndicatorLastTrough(peak_0);
         peak_1  =GetIndicatorLastPeak(trough_1);
        }
      //----  
      if(peak_0==-1 || peak_1==-1 || trough_0==-1 ||
         trough_1==-1)
         continue;
      //----          
      double indicatorLastPeak=OsMA[peak_0];
      double indicatorThePeakBefore=OsMA[peak_1];
      double indicatorLastTrough=OsMA[trough_0];
      double indicatorTheTroughBefore=OsMA[trough_1];
/*      
       int pricePeak_0 = GetPriceLastPeak(peak_0);
       int pricePeak_1 = GetPriceLastPeak(peak_1);
       int priceTrough_0 = GetPriceLastTrough(trough_0);
       int priceTrough_1 = GetPriceLastTrough(trough_1);
*/
      int pricePeak_0=peak_0;
      int pricePeak_1=peak_1;
      int priceTrough_0=trough_0;
      int priceTrough_1=trough_1;
      //----
      double priceLastPeak=High[pricePeak_0];
      double priceThePeakBefore=High[pricePeak_1];
      double priceLastTrough=Low[priceTrough_0];
      double priceTheTroughBefore=Low[priceTrough_1];
      // Bearish divergence condition         
      if((priceLastPeak > priceThePeakBefore &&
          indicatorLastPeak < indicatorThePeakBefore) ||
          (priceLastPeak < priceThePeakBefore &&
          indicatorLastPeak > indicatorThePeakBefore))
        {
         bearishDivergence[peak_0]=upOsMA[peak_0] + arrowSeparation;
         if(drawDivergenceLines)
           {
            PriceDrawLine(Time[pricePeak_0], Time[pricePeak_1],
                          priceLastPeak, priceThePeakBefore, Red);
            IndicatorDrawLine(Time[peak_0], Time[peak_1], indicatorLastPeak,
                              indicatorThePeakBefore, Red);
           }
         continue;
        }
      // Bullish divergence condition           
      if((priceLastTrough < priceTheTroughBefore &&
          indicatorLastTrough > indicatorTheTroughBefore) ||
          (priceLastTrough > priceTheTroughBefore &&
          indicatorLastTrough < indicatorTheTroughBefore))
        {
         bullishDivergence[trough_0]=downOsMA[trough_0] - arrowSeparation;
         if(drawDivergenceLines)
           {
            PriceDrawLine(Time[priceTrough_0], Time[priceTrough_1],
                          priceLastTrough, priceTheTroughBefore, Green);
            IndicatorDrawLine(Time[trough_0], Time[trough_1], indicatorLastTrough,
                              indicatorTheTroughBefore, Green);
           }
         continue;
        }
     }
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CalculateOsMA(int countedBars)
{
   for(int i=Bars - countedBars; i>=0; i--)
   {
      if (UseDema)
           double MACD = iDema(Close[i],fastEMA,i,0)-iDema(Close[i],slowEMA,i,1);
      else        MACD = iEma(Close[i],fastEMA,i,0)-iEma(Close[i],slowEMA,i,1);
      if (UseOSMA)
      {
         if (UseDema)
               double Signal = iDema(MACD,signal,i,2);
         else         Signal = iEma(MACD,signal,i,2);
         OsMA[i]=MACD - Signal;
      }
      else OsMA[i] = MACD;
      
      //
      //
      //
      //
      //
            
      upOsMA[i]   = EMPTY_VALUE;
      upOsMAd[i]  = EMPTY_VALUE;
      downOsMA[i] = EMPTY_VALUE;
      downOsMAu[i]= EMPTY_VALUE;
      if(OsMA[i] > 0)
         if (OsMA[i]>OsMA[i+1])
               upOsMA[i]  = OsMA[i];
         else  upOsMAd[i] = OsMA[i];
      if(OsMA[i] < 0)
         if (OsMA[i]<OsMA[i+1])
               downOsMA[i]  = OsMA[i];
         else  downOsMAu[i] = OsMA[i];
   }
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int GetPositiveRegionStart(int index)
  {
   int regionStart;
   for(int i=index + 1; i < Bars; i++)
     {
      if(OsMA[i]>=OsMA[i-1] && OsMA[i]>=OsMA[i+1] &&
         OsMA[i]>=OsMA[i+2] && OsMA[i] > positiveSensitivity)
         return(i);
     }
   return(-1);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int GetNegativeRegionStart(int index)
  {
   for(int i=index + 1; i < Bars; i++)
     {
      if(OsMA[i]<=OsMA[i-1] && OsMA[i]<=OsMA[i+1] &&
         OsMA[i]<=OsMA[i+2] && OsMA[i] < negativeSensitivity)
         return(i);
     }
   return(-1);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int GetFirstPeakOrTrough(int index)
  {
   for(int i=index + 1; i < Bars; i++)
     {
      if((OsMA[i]>=OsMA[i-1] && OsMA[i]>=OsMA[i+1] &&
         OsMA[i]>=OsMA[i+2] && OsMA[i] > positiveSensitivity) ||
         (OsMA[i]<=OsMA[i-1] && OsMA[i]<=OsMA[i+1] &&
         OsMA[i]<=OsMA[i+2] && OsMA[i] < negativeSensitivity))
         return(i);
     }
   return(-1);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int GetIndicatorLastPeak(int index)
  {
   int regionStart=GetPositiveRegionStart(index);
   if(regionStart==-1)
      return(-1);
//----   
   int peakShift=0;
   double peakValue=0;
//----
   for(int i=regionStart; i < Bars; i++)
     {
      if(OsMA[i] > peakValue && OsMA[i]>=OsMA[i-1] &&
         OsMA[i]>=OsMA[i+1] && OsMA[i]>=OsMA[i+2] &&
         OsMA[i] > positiveSensitivity)
        {
         peakValue=OsMA[i];
         peakShift=i;
        }
      if(OsMA[i] < 0)
         break;
     }
   return(peakShift);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int GetIndicatorLastTrough(int index)
  {
   int regionStart=GetNegativeRegionStart(index);
   if(regionStart==-1)
      return(-1);
//----         
   int troughShift=0;
   double troughValue=0;
//----   
   for(int i=regionStart; i < Bars; i++)
     {
      if(OsMA[i] < troughValue && OsMA[i]<=OsMA[i-1] &&
         OsMA[i]<=OsMA[i+1] && OsMA[i]<=OsMA[i+2] &&
         OsMA[i] < negativeSensitivity)
        {
         troughValue=OsMA[i];
         troughShift=i;
        }
      if(OsMA[i] > 0)
         break;
     }
   return(troughShift);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void PriceDrawLine(datetime x1, datetime x2, double y1, double y2,
                   color lineColor)
  {
   string label="DivergenceLine# " + DoubleToStr(x1, 0);
   ObjectDelete(label);
   ObjectCreate(label, OBJ_TREND, 0, x1, y1, x2, y2, 0, 0);
   ObjectSet(label, OBJPROP_RAY, 0);
   ObjectSet(label, OBJPROP_COLOR, lineColor);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void IndicatorDrawLine(datetime x1, datetime x2, double y1, double y2,
                       color lineColor)
  {
   int indicatorWindow=WindowFind(shortName);
   if(indicatorWindow < 0)
      return;
//----      
   string label="DivergenceLine$# " + DoubleToStr(x1, 0);
   ObjectDelete(label);
   ObjectCreate(label, OBJ_TREND, indicatorWindow, x1, y1, x2, y2, 0, 0);
   ObjectSet(label, OBJPROP_RAY, 0);
   ObjectSet(label, OBJPROP_COLOR, lineColor);
  }
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

double workDema[][6];
#define _ema1 0
#define _ema2 1

double iDema(double price, double period, int r, int instanceNo=0)
{
   if (ArrayRange(workDema,0)!= Bars) ArrayResize(workDema,Bars); instanceNo*=2; r = Bars-r-1;

   //
   //
   //
   //
   //
      
   double alpha = 2.0 / (1.0+period);
          workDema[r][_ema1+instanceNo] = workDema[r-1][_ema1+instanceNo]+alpha*(price                        -workDema[r-1][_ema1+instanceNo]);
          workDema[r][_ema2+instanceNo] = workDema[r-1][_ema2+instanceNo]+alpha*(workDema[r][_ema1+instanceNo]-workDema[r-1][_ema2+instanceNo]);
   return(workDema[r][_ema1+instanceNo]*2.0-workDema[r][_ema2+instanceNo]);
}

//
//
//
//
//

double workEma[][3];
double iEma(double price, double period, int r, int instanceNo=0)
{
   if (ArrayRange(workEma,0)!= Bars) ArrayResize(workEma,Bars); r= Bars-r-1;

   //
   //
   //
   //
   //
      
   double alpha = 2.0 / (1.0+period);
          workEma[r][instanceNo] = workEma[r-1][instanceNo]+alpha*(price-workEma[r-1][instanceNo]);
   return(workEma[r][instanceNo]);
}

