//+------------------------------------------------------------------+
//|                                            Heiken Ashi Ma T3.mq4 |
//+------------------------------------------------------------------+
//|                                                      mod by Raff |
//|                                               2009 mod by mladen |
//|  tools copied and pasted alerts from another HA indy so blame me |
//+------------------------------------------------------------------+
#property copyright "Copyright  2008,Forex-TSD.com"
#property link      "http://www.forex-tsd.com/"

#property indicator_chart_window
#property indicator_buffers 6
#property indicator_color1 Red
#property indicator_color2 RoyalBlue
#property indicator_color3 Red
#property indicator_color4 RoyalBlue
#property indicator_color5 Aqua
#property indicator_color6 Magenta
#property indicator_width1 1
#property indicator_width2 1
#property indicator_width3 2
#property indicator_width4 2

//
//
//
//
//

extern string TimeFrame        = "Current time frame";
extern int    MaPeriod         = 10;
extern int    MaMetod          = 2;
extern int    Step             = 1;
extern bool   BetterFormula    = true;
extern bool   T3Average        = true;
extern int    T3Period         = 10;
extern double T3Hot            = 0.618;
extern bool   T3Original       = false;
extern bool   T3Adaptive       = true;
extern bool   Interpolate      = true;

extern string _                = "Alerts settings";
extern bool   alertsOn         = false;
extern bool   alertsOnCurrent  = false;
extern bool   alertsMessage    = true;
extern bool   alertsPush       = true;
extern bool   alertsSound      = false;
extern bool   alertsEmail      = false;

extern bool   ShowArrows       = true;
extern int    arrowSize        = 2;
extern int    uparrowCode      = 233;
extern int    dnarrowCode      = 234;
extern bool   ArrowsOnFirstBar = false;

//
//
//
//
//

double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
double UpArrow[];
double DnArrow[];

//
//
//
//
//

string indicatorFileName;
bool   calculateValue;
bool   returnBars;
int    timeFrame;

//+------------------------------------------------------------------+
//|                                                                  |
//|------------------------------------------------------------------|
//
//
//
//
//

int init()
{
   SetIndexBuffer(0,ExtMapBuffer1); SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(1,ExtMapBuffer2); SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(2,ExtMapBuffer3); SetIndexStyle(2,DRAW_HISTOGRAM);
   SetIndexBuffer(3,ExtMapBuffer4); SetIndexStyle(3,DRAW_HISTOGRAM);
   SetIndexBuffer(4,UpArrow); 
   SetIndexBuffer(5,DnArrow); 
   
   if (ShowArrows)
   {
     SetIndexStyle(4,DRAW_ARROW,0,arrowSize); SetIndexArrow(4,uparrowCode);
     SetIndexStyle(5,DRAW_ARROW,0,arrowSize); SetIndexArrow(5,dnarrowCode);   
   }
   else
   {
     SetIndexStyle(4,DRAW_NONE);
     SetIndexStyle(5,DRAW_NONE);
   }       

   //
   //
   //
   //
   //
   
   indicatorFileName = WindowExpertName();
   calculateValue    = (TimeFrame=="calculateValue"); if (calculateValue) return(0);
   returnBars        = (TimeFrame=="returnBars");     if (returnBars)     return(0);
   timeFrame         = stringToTimeFrame(TimeFrame);
      
   //
   //
   //
   //
   //

   return(0);
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int start()
{
   double maOpen, maClose, maLow, maHigh;
   double haOpen, haClose, haLow, haHigh;
   int    counted_bars=IndicatorCounted();
   int    pointModifier;
   int    pos,k,x,limit;

   //
   //
   //
   //
   //
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
         limit=MathMin(Bars-counted_bars,Bars-1);
         if (returnBars)  { ExtMapBuffer1[0] = limit+1; return(0); }
         
         if (Digits==3 || Digits==5)
               pointModifier = 10;
         else  pointModifier = 1;   
   
   //
   //
   //
   //
   //
   
   if (calculateValue || timeFrame == Period())
   {          
          
   //
   //
   //
   //
   //
   
   for(pos = limit; pos >= 0; pos--)
   {
      if (T3Average)
         {
            maOpen  = iT3a(Open[pos], T3Period,T3Hot,T3Original,T3Adaptive,pos,0);  
            maClose = iT3a(Close[pos],T3Period,T3Hot,T3Original,T3Adaptive,pos,1);  
            maLow   = iT3a(Low[pos],  T3Period,T3Hot,T3Original,T3Adaptive,pos,2);  
            maHigh  = iT3a(High[pos], T3Period,T3Hot,T3Original,T3Adaptive,pos,3);  
         }
      else
         {
            maOpen  = iMA(NULL,0,MaPeriod,0,MaMetod,PRICE_OPEN ,pos);
            maClose = iMA(NULL,0,MaPeriod,0,MaMetod,PRICE_CLOSE,pos);
            maLow   = iMA(NULL,0,MaPeriod,0,MaMetod,PRICE_LOW  ,pos);
            maHigh  = iMA(NULL,0,MaPeriod,0,MaMetod,PRICE_HIGH ,pos);
         }
   
      //
      //
      //
      //
      //
        
         if (BetterFormula) {
               if (maHigh!=maLow)
                     haClose = (maOpen+maClose)/2+(((maClose-maOpen)/(maHigh-maLow))*MathAbs((maClose-maOpen)/2));
               else  haClose = (maOpen+maClose)/2; }
         else        haClose = (maOpen+maHigh+maLow+maClose)/4;
                     haOpen   = (ExtMapBuffer3[pos+1]+ExtMapBuffer4[pos+1])/2;
                     haHigh   = MathMax(maHigh, MathMax(haOpen,haClose));
                     haLow    = MathMin(maLow,  MathMin(haOpen,haClose));

         if (haOpen<haClose) { ExtMapBuffer1[pos]=haLow;  ExtMapBuffer2[pos]=haHigh; } 
         else                { ExtMapBuffer1[pos]=haHigh; ExtMapBuffer2[pos]=haLow;  } 
                               ExtMapBuffer3[pos]=haOpen;
                               ExtMapBuffer4[pos]=haClose;
      
      //
      //
      //
      //
      //

      if (Step>0)
      {
         if( MathAbs(ExtMapBuffer1[pos]-ExtMapBuffer1[pos+1]) < Step*pointModifier*Point ) ExtMapBuffer1[pos]=ExtMapBuffer1[pos+1];
         if( MathAbs(ExtMapBuffer2[pos]-ExtMapBuffer2[pos+1]) < Step*pointModifier*Point ) ExtMapBuffer2[pos]=ExtMapBuffer2[pos+1];
         if( MathAbs(ExtMapBuffer3[pos]-ExtMapBuffer3[pos+1]) < Step*pointModifier*Point ) ExtMapBuffer3[pos]=ExtMapBuffer3[pos+1];
         if( MathAbs(ExtMapBuffer4[pos]-ExtMapBuffer4[pos+1]) < Step*pointModifier*Point ) ExtMapBuffer4[pos]=ExtMapBuffer4[pos+1];
      } 
              
      UpArrow[pos] = EMPTY_VALUE;
      DnArrow[pos] = EMPTY_VALUE;
        
      if (ExtMapBuffer3[pos]<ExtMapBuffer4[pos] && ExtMapBuffer4[pos+1]<ExtMapBuffer3[pos+1]) UpArrow[pos]=ExtMapBuffer4[pos+1]-(Ask-Bid);
      if (ExtMapBuffer3[pos]>ExtMapBuffer4[pos] && ExtMapBuffer4[pos+1]>ExtMapBuffer3[pos+1]) DnArrow[pos]=ExtMapBuffer4[pos+1]+(Ask-Bid);
   }
    
   //
   //
   //
   //
   //
         
    manageAlerts();
    return(0);
    }
    
   //
   //
   //
   //
   //
   
   int shift = -1; if (ArrowsOnFirstBar) shift=1;
   limit = MathMax(limit,MathMin(Bars,iCustom(NULL,timeFrame,indicatorFileName,"returnBars",0,0)*timeFrame/Period()));
   for(pos = limit; pos >= 0; pos--)
   {
     int y = iBarShift(NULL,timeFrame,Time[pos]);
     int z = iBarShift(NULL,timeFrame,Time[pos+shift]);
       ExtMapBuffer1[pos] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",MaPeriod,MaMetod,Step,BetterFormula,T3Average,T3Period,T3Hot,T3Original,T3Adaptive,0,y);
       ExtMapBuffer2[pos] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",MaPeriod,MaMetod,Step,BetterFormula,T3Average,T3Period,T3Hot,T3Original,T3Adaptive,1,y);
       ExtMapBuffer3[pos] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",MaPeriod,MaMetod,Step,BetterFormula,T3Average,T3Period,T3Hot,T3Original,T3Adaptive,2,y);
       ExtMapBuffer4[pos] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",MaPeriod,MaMetod,Step,BetterFormula,T3Average,T3Period,T3Hot,T3Original,T3Adaptive,3,y);
       
      if(z!=y)
      {
        UpArrow[pos]      = iCustom(NULL,timeFrame,indicatorFileName,"CalculateValue",MaPeriod,MaMetod,Step,BetterFormula,T3Average,T3Period,T3Hot,T3Original,T3Adaptive,4,y);
        DnArrow[pos]      = iCustom(NULL,timeFrame,indicatorFileName,"CalculateValue",MaPeriod,MaMetod,Step,BetterFormula,T3Average,T3Period,T3Hot,T3Original,T3Adaptive,5,y);
      }
      else
      {
        UpArrow[pos]      = EMPTY_VALUE;
        DnArrow[pos]      = EMPTY_VALUE;
      }
       
       //
       //
       //
       //
       //
       
       if (timeFrame <= Period() || y==iBarShift(NULL,timeFrame,Time[pos-1])) continue;
       if (!Interpolate) continue;

       //
       //
       //
       //
       //

       datetime time = iTime(NULL,timeFrame,y);
         for(x = 1; pos+x < Bars && Time[pos+x] >= time; x++) continue;	
         for(k = 1; k < x; k++)
         {
            ExtMapBuffer1[pos+k] = ExtMapBuffer1[pos] + (ExtMapBuffer1[pos+x] - ExtMapBuffer1[pos])* k/x;
            ExtMapBuffer2[pos+k] = ExtMapBuffer2[pos] + (ExtMapBuffer2[pos+x] - ExtMapBuffer2[pos])* k/x;
            ExtMapBuffer3[pos+k] = ExtMapBuffer3[pos] + (ExtMapBuffer3[pos+x] - ExtMapBuffer3[pos])* k/x;
            ExtMapBuffer4[pos+k] = ExtMapBuffer4[pos] + (ExtMapBuffer4[pos+x] - ExtMapBuffer4[pos])* k/x;
   
         }               
   }

   //
   //
   //
   //
   //
      
   manageAlerts();
   return(0);
}
   

//
//
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

void manageAlerts()
{
   if (!calculateValue && alertsOn)
   {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1; whichBar = iBarShift(NULL,0,iTime(NULL,timeFrame,whichBar));
      
      if (UpArrow[whichBar]!= EMPTY_VALUE) doAlert(whichBar,"HAma buy");   
      if (DnArrow[whichBar]!= EMPTY_VALUE) doAlert(whichBar,"HAma sell"); 
      
      }
   }
//
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       //
       //
       //
       //
       //

       message =  StringConcatenate(Symbol()," ",timeFrameToString(timeFrame)," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," Heiken Ashi ",doWhat);
          if (alertsMessage) Alert(message);
          if (alertsEmail)   SendMail(StringConcatenate(Symbol()," Heiken Ashi "),message);
          if (alertsPush)    SendNotification(StringConcatenate(message));
          if (alertsSound)   PlaySound("alert2.wav");
   }
}

//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

//
//
//
//
//

int stringToTimeFrame(string tfs)
{
   StringToUpper(tfs);
   for (int i=ArraySize(iTfTable)-1; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[i],Period()));
                                                      return(Period());
}
string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}


//+------------------------------------------------------------------
//|
//+------------------------------------------------------------------
//
//
//
//
//

double workT3[][28];
double workT3Coeffs[][6];
#define _period 0
#define _c1     1
#define _c2     2
#define _c3     3
#define _c4     4
#define _alpha  5
#define _atr    6

//
//
//
//
//

double iT3a(double price, double period, double hot, bool original, bool adaptive, int i, int forInstance=0)
{
   int r      = Bars-i-1;
   int buffer = forInstance*7;

   //
   //
   //
   //
   //
   
      if (ArrayRange(workT3,0) !=Bars)                  ArrayResize(workT3,Bars);
      if (ArrayRange(workT3Coeffs,0) < (forInstance+1)) ArrayResize(workT3Coeffs,forInstance+1);
      if (adaptive)
      {
         workT3[r][_atr+buffer] = iATR(NULL,0,period,i);
            double max = workT3[r][_atr+buffer];
            double min = workT3[r][_atr+buffer];
            for (int k=1; k<period && (r-k>=0); k++)
               {
                  max = MathMax(max,workT3[r-k][_atr+buffer]);
                  min = MathMin(min,workT3[r-k][_atr+buffer]);
               }
            if (min!=max)
                  double atn = 1.0-(workT3[r][_atr+buffer]-min)/(max-min);
            else         atn = 0.5;
            period = period*(atn+1.0)/2.0;
      }
   
   //
   //
   //
   //
   //
   
      if (workT3Coeffs[forInstance][_period] != period)
      {
        workT3Coeffs[forInstance][_period] = period;
           double a = hot;
               workT3Coeffs[forInstance][_c1] = -a*a*a;
               workT3Coeffs[forInstance][_c2] = 3*a*a+3*a*a*a;
               workT3Coeffs[forInstance][_c3] = -6*a*a-3*a-3*a*a*a;
               workT3Coeffs[forInstance][_c4] = 1+3*a+a*a*a+3*a*a;
               if (original)
                    workT3Coeffs[forInstance][_alpha] = 2.0/(1.0 + period);
               else workT3Coeffs[forInstance][_alpha] = 2.0/(2.0 + (period-1.0)/2.0);
      }
   
   //
   //
   //
   //
   //
   
   if (r == 0)
      {
         workT3[r][0+buffer] = price;
         workT3[r][1+buffer] = price;
         workT3[r][2+buffer] = price;
         workT3[r][3+buffer] = price;
         workT3[r][4+buffer] = price;
         workT3[r][5+buffer] = price;
      }
   else
      {
         workT3[r][0+buffer] = workT3[r-1][0+buffer]+workT3Coeffs[forInstance][_alpha]*(price              -workT3[r-1][0+buffer]);
         workT3[r][1+buffer] = workT3[r-1][1+buffer]+workT3Coeffs[forInstance][_alpha]*(workT3[r][0+buffer]-workT3[r-1][1+buffer]);
         workT3[r][2+buffer] = workT3[r-1][2+buffer]+workT3Coeffs[forInstance][_alpha]*(workT3[r][1+buffer]-workT3[r-1][2+buffer]);
         workT3[r][3+buffer] = workT3[r-1][3+buffer]+workT3Coeffs[forInstance][_alpha]*(workT3[r][2+buffer]-workT3[r-1][3+buffer]);
         workT3[r][4+buffer] = workT3[r-1][4+buffer]+workT3Coeffs[forInstance][_alpha]*(workT3[r][3+buffer]-workT3[r-1][4+buffer]);
         workT3[r][5+buffer] = workT3[r-1][5+buffer]+workT3Coeffs[forInstance][_alpha]*(workT3[r][4+buffer]-workT3[r-1][5+buffer]);
      }

   //
   //
   //
   //
   //
   
   return(workT3Coeffs[forInstance][_c1]*workT3[r][5+buffer] + 
          workT3Coeffs[forInstance][_c2]*workT3[r][4+buffer] + 
          workT3Coeffs[forInstance][_c3]*workT3[r][3+buffer] + 
          workT3Coeffs[forInstance][_c4]*workT3[r][2+buffer]);
}