//------------------------------------------------------------------
#property copyright "www.forex-station.com"
#property link      "www.forex-station.com"
//------------------------------------------------------------------
#property indicator_separate_window
#property indicator_buffers  2
#property indicator_color1   clrLimeGreen
#property indicator_color2   clrRed
#property indicator_width1   2
#property indicator_width2   2
#property indicator_minimum  0
#property indicator_maximum  1
#property strict

//
//
//
//
//

extern ENUM_TIMEFRAMES TimeFrame             = PERIOD_CURRENT;   // Time frame
extern bool            UseAutomaticMaPeriods = false;            // Use automatic settings?
extern ENUM_MA_METHOD  MaMethod              = MODE_SMMA;        // Smoothing method
extern int             MaPeriod              = 27;               // Smoothing period
extern bool            alertsOn              = false;            // Alerts on?
extern bool            alertsOnCurrent       = false;            // Alerts on current?
extern bool            alertsMessage         = true;             // Alerts message?
extern bool            alertsNotify          = false;            // Alerts push notification?
extern bool            alertsSound           = true;             // Alerts sound?
extern bool            alertsEmail           = false;            // Alerts email?
extern string          soundFile             = "alert2.wav";     // Sound file
extern bool            verticalLinesVisible  = false;            // Show vertical lines
extern bool            linesOnNewest         = true;             // Lines on newest bar?
extern string          verticalLinesID       = "has Lines";      // Lines ID
extern color           verticalLinesUpColor  = clrDeepSkyBlue;   // Lines up color 
extern color           verticalLinesDnColor  = clrPaleVioletRed; // Lines down color
extern ENUM_LINE_STYLE verticalLinesStyle    = STYLE_DOT;        // Lines style
extern int             verticalLinesWidth    = 0;                // lines width
extern bool            Interpolate           = true;             // Interpolate in multi time frame mode?

//
//
//
//
//

double Up[],Dn[],hahbu[],hahbd[],trendw[],trendb[],count[];
string indicatorFileName;
#define _mtfCall(_buf,_ind) iCustom(NULL,TimeFrame,indicatorFileName,0,UseAutomaticMaPeriods,MaMethod,MaPeriod,alertsOn,alertsOnCurrent,alertsMessage,alertsNotify,alertsSound,alertsEmail,soundFile,verticalLinesVisible,linesOnNewest,verticalLinesID,verticalLinesUpColor,verticalLinesDnColor,verticalLinesStyle,verticalLinesWidth,_buf,_ind)

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//

int init()
{
   IndicatorBuffers(6);
   SetIndexBuffer(0,Up);  SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(1,Dn);  SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(2,hahbd); 
   SetIndexBuffer(3,hahbu); 
   SetIndexBuffer(4,trendb);
   SetIndexBuffer(5,count);
      if (UseAutomaticMaPeriods)
         switch(_Period) 
         {
            case PERIOD_M1:  MaPeriod = 150; break;
            case PERIOD_M5:  MaPeriod =  60; break;
            case PERIOD_M15: MaPeriod =  80; break;
            case PERIOD_M30: MaPeriod = 192; break;
            case PERIOD_H1:  MaPeriod =  96; break;
            case PERIOD_H4:  MaPeriod = 120; break;
            default :        MaPeriod = 80;
         }
   
      //
      //
      //
      //
      //
      
         indicatorFileName = WindowExpertName();
         TimeFrame         = MathMax(TimeFrame,_Period);
      
      IndicatorShortName(timeFrameToString(TimeFrame)+" Heiken ashi smoothed histo("+(string)MaPeriod+")");
   return(0);
}   
int deinit() 
{ 
   string tlookFor       = verticalLinesID+":";
   int    tlookForLength = StringLen(tlookFor);
   for (int i=ObjectsTotal()-1; i>=0; i--)
   {
      string objectName = ObjectName(i);
         if (StringSubstr(objectName,0,tlookForLength) == tlookFor) ObjectDelete(objectName);
   }  
return(0); 
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//

int start()
{
   int counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
            int limit = MathMin(Bars-counted_bars,Bars-1); count[0] = limit;
            if (TimeFrame != _Period)
            {
               limit = (int)MathMax(limit,MathMin(Bars-1,_mtfCall(5,0)*TimeFrame/Period()));
               for (int i=limit; i>=0; i--)
               {
                  int y = iBarShift(NULL,TimeFrame,Time[i]);
                     Up[i]  = _mtfCall(0,y);
                     Dn[i]  = _mtfCall(1,y);
               }
      return(0);
      }

      //
      //
      //
      //
      //
   
      for (int i=limit; i>=0; i--)
      {
         double haHigh,haLow,haOpen,haClose;
            calculateHA(MaPeriod,MaMethod,haOpen,haClose,haHigh,haLow,i);
     
            hahbu[i] = haOpen;
            hahbd[i] = haClose;
                     trendb[i] = (i<Bars-1) ? (hahbu[i]<hahbd[i]) ? 1 : (hahbu[i]>hahbd[i]) ? -1 : trendb[i+1] : 0;
                     Up[i] = (trendb[i] ==  1) ? 1 : EMPTY_VALUE;
                     Dn[i] = (trendb[i] == -1) ? 1 : EMPTY_VALUE;
                     
                     //
                     //
                     //
                     //
                     //
        
                     if (verticalLinesVisible)
                     {
                       string tlookFor = verticalLinesID+":"+(string)Time[i]; ObjectDelete(tlookFor);  
                       if (i<Bars-1 && trendb[i]!=trendb[i+1])
                       {
                          if (trendb[i] == 1) drawLine(i,verticalLinesUpColor);
                          if (trendb[i] ==-1) drawLine(i,verticalLinesDnColor);
                       }
                     }   
                     
      }            
      if (alertsOn)
      {
         int whichBar = 1; if (alertsOnCurrent) whichBar = 0;
         if (trendb[whichBar] != trendb[whichBar+1])
         if (trendb[whichBar] == 1)
               doAlert(" Main HA trend changed to up ");
         else  doAlert(" Main HA trend changed to down ");       
     }       
return(0);      
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//

#define _haInstances     1
#define _haInstancesSize 4
double workHa[][_haInstances*_haInstancesSize];
#define _haH 0
#define _haL 1
#define _haO 2
#define _haC 3

void calculateHA(int maPeriod, int maMethod, double& tOpen, double& tClose, double& tHigh, double& tLow, int i, int instanceNo=0)
{
   if (ArrayRange(workHa,0)!= Bars) ArrayResize(workHa,Bars); int r=Bars-i-1; instanceNo*=_haInstancesSize;
   
   //
   //
   //
   //
   //
   
      double maOpen  = iMA(NULL,0,maPeriod,0,maMethod,PRICE_OPEN ,i);
      double maClose = iMA(NULL,0,maPeriod,0,maMethod,PRICE_CLOSE,i);
      double maLow   = iMA(NULL,0,maPeriod,0,maMethod,PRICE_LOW  ,i);
      double maHigh  = iMA(NULL,0,maPeriod,0,maMethod,PRICE_HIGH ,i);
      double haOpen  = (r>0) ? (workHa[r-1][instanceNo+_haO] + workHa[r-1][instanceNo+_haC])/2.0 : maOpen;
      double haClose = (maOpen+maHigh+maLow+maClose)/4;
      double haHigh  = MathMax(maHigh, MathMax(haOpen, haClose));
      double haLow   = MathMin(maLow,  MathMin(haOpen, haClose));

      if(haOpen<haClose) { workHa[r][instanceNo+_haH] = haLow;  workHa[r][instanceNo+_haL] = haHigh; } 
      else               { workHa[r][instanceNo+_haH] = haHigh; workHa[r][instanceNo+_haL] = haLow;  } 
                           workHa[r][instanceNo+_haO] = haOpen;
                           workHa[r][instanceNo+_haC] = haClose;
      //
      //
      //
      //
      //
      
   tHigh  = workHa[r][instanceNo+_haH];
   tLow   = workHa[r][instanceNo+_haL];
   tOpen  = workHa[r][instanceNo+_haO];
   tClose = workHa[r][instanceNo+_haC];
}

//-------------------------------------------------------------------
//                                                                  
//-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//
//
//
//
//

void doAlert(string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
      if (previousAlert != doWhat || previousTime != Time[0]) {
          previousAlert  = doWhat;
          previousTime   = Time[0];

       //
       //
       //
       //
       //
       
       message = timeFrameToString(_Period)+" "+Symbol()+" at "+TimeToStr(TimeLocal(),TIME_SECONDS)+" Heiken ashi smoothed "+doWhat;
          if (alertsMessage) Alert(message);
          if (alertsNotify)  SendNotification(message);
          if (alertsEmail)   SendMail(_Symbol+" Heiken ashi smoothed ",message);
          if (alertsSound)   PlaySound(soundFile);
       
   }
}

//
//
//
//
//

void drawLine(int i,color theColor)
{
      string name = verticalLinesID+":"+(string)Time[i];
   
      //
      //
      //
      //
      //
         
      datetime time = Time[i]; if (linesOnNewest) time += _Period*60-1;    
      ObjectCreate(name,OBJ_VLINE,0,time,0);
         ObjectSet(name,OBJPROP_COLOR,theColor);
         ObjectSet(name,OBJPROP_STYLE,verticalLinesStyle);
         ObjectSet(name,OBJPROP_WIDTH,verticalLinesWidth);
         ObjectSet(name,OBJPROP_BACK,true);
}



