//+----------------------------------------------------------------------+
//|                                          iPolo - Market Profile.mq4  |
//|                  original authors: Viatcheslav Suvorov, TwoBuckChuck |                                      
//|                    last updated by: polomine (2010.04.02.23:55 GMT+8 |
//+----------------------------------------------------------------------+
#define  defIndicatorName  "iPolo - Market Profile"
#define  defObjectPrefix   "iPolo_MP_"

#property indicator_chart_window

extern int      Daily_Start_Hour = 3;
extern int      EU_Start_Hour = 3;
extern int      US_Start_Hour = 8;
extern int      Asia_Start_Hour = 17;

bool             SkipSundayData = true;  // always skip sunday data

extern string sp2="===========================";
extern bool    DisplayMarketProfile = true;
extern bool    SessionBySession  = true;
extern int     ZoomInFactor =  3;
extern int     SerialNumberofEndSession = 0;
extern int     CountProfile = 5;
extern color    EU_Color = Gray;
extern color    US_Color = DarkGray;
extern color    Asia_Color        = LightGray;
extern color    POC_Color         = Peru;
extern double   POC_Height        = 1.0;
extern bool     DrawProfiles      = true;
extern bool     ShowPOCText       = true;
extern int      POCTextSize       = 8;
extern bool     UseShortDays      = true;

extern string sp3="===========================";
extern bool DisplaySeperator = true;
extern color SeperatorColor = Aqua;

string objprefix;
int fontsize=10;
int i,j;
double LastHigh,LastLow,CurPos;
bool signal;
datetime flag;
string Days[7] = {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
string DaysShort[7] = {"Sun", "Mon", "Tues", "Wed", "Thurs", "Fri", "Sat"};
string UseDays[7];
int factor = 1;
datetime sessiondt[2000];
int idx = 0;

//+------------------------------------------------------------------+
//| Custom indicator initialization function |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorShortName(defIndicatorName);
   objprefix = defObjectPrefix; //Prefix for this indicators objects

   if (UseShortDays) ArrayCopy(UseDays, DaysShort);
   else ArrayCopy(UseDays, Days);
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   for(i=ObjectsTotal();i >= 0;i--)
       {if(StringSubstr(ObjectName(i),0,StringLen(objprefix))==objprefix) ObjectDelete(ObjectName(i));}
 
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
  
   int x=Period();
   if (x<PERIOD_M5||x>PERIOD_D1) return(-1);

   // only executes upon new bar   
   static datetime prevTime;
   if (prevTime == iTime(NULL, Period(), 0))
      return (0);
   prevTime =  iTime(NULL, Period(), 0);      
   
   // delete all objects of this indi.
   for(i=ObjectsTotal(); i>=0; i--)
   {
      if(StringSubstr(ObjectName(i),0,StringLen(objprefix))==objprefix) ObjectDelete(ObjectName(i));
   }

   // Locate the session open time.
  
   switch (Period())
    {
      case PERIOD_D1:
         for (i=0; i<iBars(NULL, PERIOD_MN1); i++)
         {
            sessiondt[idx] = iTime(NULL, PERIOD_MN1, i);
            idx++;
         }  
         idx = 0;          
         break;
      case PERIOD_H4:
         for (i=0; i<iBars(NULL, PERIOD_W1); i++)
         {
            sessiondt[idx] = iTime(NULL, PERIOD_W1, i) + (Asia_Start_Hour - MathMod(Asia_Start_Hour, 4))*PERIOD_H1*60;
            idx++;
         }
         idx = 0;            
         break;
      case PERIOD_M5:
      case PERIOD_M15:
      case PERIOD_M30:
      case PERIOD_H1:
      default:
         for (i=0; i<iBars(NULL, PERIOD_D1); i++)
         {
            if (SkipSundayData&&TimeDayOfWeek(iTime(Symbol(), PERIOD_D1, i))==0) continue;
            
            sessiondt[idx] = StrToTime(TimeToStr(iTime(Symbol(), PERIOD_D1, i), TIME_DATE)+" "+Daily_Start_Hour);
            idx++;
         }
         if (TimeCurrent()>sessiondt[0]) idx=0; else idx=1;
      break;         
     } 

   // index of end session
   idx=idx+SerialNumberofEndSession;     
     
   // Market profile
   DrawMarketProfile();

   // Session Seperator
   DrawSessionSeperator();
   
//----
   return(0);
  }
  
  
//================================ 
void DrawMarketProfile()
{      
      double onetick, poc_h;  
      double Mediana=0;
      int MaxSize=0;
      int MySize=0;
      int MySizeEU=0;
      int MySizeUS=0;
      int MySizeAsia=0;
      int BACK=0;
      
      if(!DisplayMarketProfile) return(0);
      
      BACK=0;
      while (idx>1&&Time[BACK]>sessiondt[idx-1]&&BACK<Bars)
      {  
         BACK++;   
         if (BACK>=Bars) return(0);
      }//while
      
      onetick = 1/(MathPow(10,Digits));
      poc_h = onetick;
      if (Digits == 3 || Digits == 5) poc_h *= (POC_Height*10);
      else poc_h *= POC_Height;
      i=BACK;
      int cycles;

      for (cycles=0;cycles<CountProfile;cycles++)
      {
         signal=false;
         LastHigh=High[i];
         LastLow=Low[i]; 
            
         if (SessionBySession) ZoomInFactor=1; else cycles = CountProfile;
         
         while (!signal)
         {
            if (High[i+1]>LastHigh) LastHigh=High[i+1];
            if (Low[i+1]<LastLow) LastLow=Low[i+1];
            MaxSize=0;
            MySize=0;

            if (Time[i+1]<sessiondt[idx+cycles])
            {
               signal=true;
               CurPos=LastLow;
               
               while (CurPos<=LastHigh)
               {
                  MySizeEU=0;
                  MySizeUS=0;
                  MySizeAsia=0;
               
                  for (j=i;j>=BACK;j--)
                  {
                     if ((High[j]>=CurPos) && (Low[j]<=CurPos))
                     {
                        MySize++;       
  
                        if((TimeHour(Time[j])>=EU_Start_Hour) && (TimeHour(Time[j])<US_Start_Hour)) MySizeEU++; 
                           else if ((TimeHour(Time[j])>=US_Start_Hour) && (TimeHour(Time[j])<Asia_Start_Hour)) MySizeUS++; 
                              else MySizeAsia++; 
                     }//if  
                  }//for

                  if (MySizeEU+MySizeUS+MySizeAsia>MaxSize)
                  {
                     MaxSize=MySizeEU+MySizeUS+MySizeAsia;
                     Mediana=CurPos;
                  }

                  if (i-MySizeAsia>=0 && DrawProfiles)
                  {
                     if(ObjectFind(objprefix+"rec"+"EU"+TimeToStr(Time[i],TIME_DATE)+CurPos) == -1 && MySizeEU!=0)
                     {
                        ObjectCreate(objprefix+"rec"+"EU"+TimeToStr(Time[i],TIME_DATE)+CurPos, OBJ_RECTANGLE, 0, Time[i], CurPos,Time[i-ZoomInFactor*MySizeEU],CurPos+onetick);           
                        ObjectSet(objprefix+"rec"+"EU"+TimeToStr(Time[i],TIME_DATE)+CurPos, OBJPROP_COLOR, EU_Color);
                     }//if      
                     
                     if(ObjectFind(objprefix+"rec"+"US"+TimeToStr(Time[i],TIME_DATE)+CurPos) == -1 && MySizeUS!=0)
                     {
                        ObjectCreate(objprefix+"rec"+"US"+TimeToStr(Time[i],TIME_DATE)+CurPos, OBJ_RECTANGLE, 0, Time[i-ZoomInFactor*MySizeEU], CurPos,Time[i-ZoomInFactor*(MySizeEU+MySizeUS)],CurPos+onetick);           
                        ObjectSet(objprefix+"rec"+"US"+TimeToStr(Time[i],TIME_DATE)+CurPos, OBJPROP_COLOR, US_Color);
                     }//if      

                     if(ObjectFind(objprefix+"rec"+"Asia"+TimeToStr(Time[i],TIME_DATE)+CurPos) == -1 && MySizeAsia!=0)
                     {
                        if(i<(MySizeEU+MySizeUS+MySizeAsia)) Print("eRROR");
                        ObjectCreate(objprefix+"rec"+"Asia"+TimeToStr(Time[i],TIME_DATE)+CurPos, OBJ_RECTANGLE, 0, Time[i-ZoomInFactor*(MySizeEU+MySizeUS)], CurPos,Time[i-ZoomInFactor*(MySizeEU+MySizeAsia+MySizeUS)],CurPos+onetick);
                        ObjectSet(objprefix+"rec"+"Asia"+TimeToStr(Time[i],TIME_DATE)+CurPos, OBJPROP_COLOR, Asia_Color);                      
                     }//if      
                  }
                  CurPos=CurPos+onetick;
               
               }//while
               
               int ti = 0,
                   ti2 = i;
               
               ObjectCreate(objprefix+"mediana"+TimeToStr(Time[i],TIME_DATE), OBJ_RECTANGLE, 0, Time[ti], Mediana,Time[ti2],Mediana+poc_h);
               ObjectSet(objprefix+"mediana"+TimeToStr(Time[i],TIME_DATE), OBJPROP_STYLE, STYLE_SOLID);
               ObjectSet(objprefix+"mediana"+TimeToStr(Time[i],TIME_DATE), OBJPROP_COLOR, POC_Color);
               
               if (ShowPOCText)
               {
                  int ti3;
                  ti3 = ti;

                  ObjectCreate(objprefix+TimeToStr(Time[i],TIME_DATE), OBJ_TEXT, 0, Time[ti3], Mediana-poc_h);
                  ObjectSetText(objprefix+TimeToStr(Time[i],TIME_DATE), TimeToStr(Time[i], TIME_DATE)+" - "+UseDays[TimeDayOfWeek(Time[i])]+" - "+DoubleToStr(Mediana, Digits), POCTextSize, "Arial", POC_Color);
               }
                
               BACK=i+1; 
                 
            }//if
            
            i++;   
            if (i>=Bars) return(0);
            
         } //while
         
      } //for   
}      

//================================
void DrawSessionSeperator()
{
   if (!DisplaySeperator) return;

   for (i=0;i<ArraySize(sessiondt);i++)
      {
         ObjectCreate(objprefix+"VLINE"+i, OBJ_VLINE, 0, sessiondt[i], 0);   
         ObjectSet(objprefix+"VLINE"+i, OBJPROP_STYLE, STYLE_DOT);
         ObjectSet(objprefix+"VLINE"+i, OBJPROP_COLOR, SeperatorColor);
      }
}