//+------------------------------------------------------------------+
//|                                    kase permision stochastic.mq4 |
//+------------------------------------------------------------------+
#property copyright "mladen"
#property link      "mladenfx@gmail.com"
#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1  Green
#property indicator_color2  Red
#property indicator_width1  3
#property indicator_width2  3
#property indicator_minimum 0
#property indicator_maximum 1

//
//
//
//
//

enum enPrices
{
   pr_close,      // Close
   pr_open,       // Open
   pr_high,       // High
   pr_low,        // Low
   pr_median,     // Median
   pr_typical,    // Typical
   pr_weighted,   // Weighted
   pr_average,    // Average (high+low+open+close)/4
   pr_medianb,    // Average median body (open+close)/2
   pr_tbiased,    // Trend biased price
   pr_haclose,    // Heiken ashi close
   pr_haopen ,    // Heiken ashi open
   pr_hahigh,     // Heiken ashi high
   pr_halow,      // Heiken ashi low
   pr_hamedian,   // Heiken ashi median
   pr_hatypical,  // Heiken ashi typical
   pr_haweighted, // Heiken ashi weighted
   pr_haaverage,  // Heiken ashi average
   pr_hamedianb,  // Heiken ashi median body
   pr_hatbiased   // Heiken ashi trend biased price
};

extern ENUM_TIMEFRAMES TimeFrame = PERIOD_CURRENT;
extern int    pstLength          = 14;
extern int    pstX               = 10;
extern enPrices pstPriceHigh     = pr_high;
extern enPrices pstPriceLow      = pr_low;
extern enPrices pstPrice         = pr_close;
extern int    pstSmooth          =  3;
extern int    smoothPeriod       =  10;
extern bool   alertsOn           = true;
extern bool   alertsOnCurrent    = false;
extern bool   alertsMessage      = true;
extern bool   alertsSound        = false;
extern bool   alertsNotify       = false;
extern bool   alertsEmail        = false;
extern string soundFile          = "alert2.wav"; 
extern bool   arrowsVisible      = true;
extern string arrowsIdentifier   = "kpss Arrows1";
extern double arrowsUpperGap     = 1.0;
extern double arrowsLowerGap     = 1.0;
extern color  arrowsUpColor      = DeepSkyBlue;
extern color  arrowsDnColor      = Red;
extern int    arrowsUpCode       = 233;
extern int    arrowsDnCode       = 234;
extern int    arrowsUpSize       = 1;
extern int    arrowsDnSize       = 1;
extern bool   arrowsOnFirst      = false;
extern bool   linesVisible       = false;
extern string linesIdentifier    = "kpss lines1";
extern color  linesUpColor       = DeepSkyBlue;
extern color  linesDnColor       = PaleVioletRed;
extern int    LinesStyle         = STYLE_DOT;
extern int    LinesWidth         = 0;
extern bool   linesOnFirst       = false;

double pstBuffer[];
double pssBuffer[];
double wrkBuffer[][5];
double UpH[];
double DnH[];   
double trend[];
double priceHi[];
double priceLo[];

string indicatorFileName;
bool   returnBars;


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int init()
{
   IndicatorBuffers(6);
   SetIndexBuffer(0,UpH);       SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(1,DnH);       SetIndexStyle(1,DRAW_HISTOGRAM);   
   SetIndexBuffer(2,pstBuffer); 
   SetIndexBuffer(3,pssBuffer); 
   SetIndexBuffer(4,trend);
   SetIndexBuffer(5,priceHi);
   SetIndexBuffer(6,priceLo);
      
      //
      //
      //
      //
      //
      
      pstSmooth         = MathMax(pstSmooth,1);
      smoothPeriod      = MathMax(smoothPeriod,1);
      indicatorFileName = WindowExpertName();
      returnBars        = (TimeFrame==-99);
      TimeFrame         = MathMax(TimeFrame,_Period); 
        
      //
      //
      //
      //
      //

   IndicatorShortName(timeFrameToString(TimeFrame)+" Kase permission stochastic smoothed ("+pstLength+","+pstX+")");   
   return(0);
}
int deinit() 
{ 
   string lookFor       = arrowsIdentifier+":";
   int    lookForLength = StringLen(lookFor);
   for (int i=ObjectsTotal()-1; i>=0; i--)
   {
      string objectName = ObjectName(i);
         if (StringSubstr(objectName,0,lookForLength) == lookFor) ObjectDelete(objectName);
   }
   deleteLines();
   return(0);
}




//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

#define TripleK   0
#define TripleDF  1
#define TripleDFs 2
#define TripleDS  3
#define TripleDSs 4

//
//
//
//
//

int start()
{
   double alpha = 2.0/(1.0+pstSmooth);
   int lookBackPeriod = pstLength*pstX;
   int counted_bars   = IndicatorCounted();
   int i,r,limit;

   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
         limit = MathMin(Bars-counted_bars,Bars-1);
         if (returnBars) { UpH[0] = limit+1; return(0); }

   //
   //
   //
   //
   //

   if (TimeFrame==Period())
   {
     if (ArrayRange(wrkBuffer,0) != Bars) ArrayResize(wrkBuffer,Bars);
     for(i=limit,r=Bars-i-1; i>=0; i--,r++)
     {
      priceHi[i] = getPrice(pstPriceHigh,Open,Close,High,Low,i);
      priceLo[i] = getPrice(pstPriceHigh,Open,Close,High,Low,i);
        double min = priceLo[ArrayMinimum(priceLo,lookBackPeriod,i)];
        double max = priceHi[ArrayMaximum(priceHi,lookBackPeriod,i)]-min;
        if (max>0)
              wrkBuffer[r][TripleK] = 100.0*(getPrice(pstPrice,Open,Close,High,Low,i)-min)/max;
        else  wrkBuffer[r][TripleK] =   0.0;
        if (i==(Bars-1))
        {
            wrkBuffer[r][TripleDF] = wrkBuffer[r][TripleK];
            wrkBuffer[r][TripleDS] = wrkBuffer[r][TripleK];
            continue;
        }
        wrkBuffer[r][TripleDF] =  wrkBuffer[r-pstX][TripleDF]+alpha*(wrkBuffer[r][TripleK]-wrkBuffer[r-pstX][TripleDF]);
        wrkBuffer[r][TripleDS] = (wrkBuffer[r-pstX][TripleDS]*2.0+wrkBuffer[r][TripleDF])/3.0;
      
        //
        //
        //
        //
        //
      
        wrkBuffer[r][TripleDSs] = iSma(TripleDS ,3,r);
        pssBuffer[i]            = iSmooth(wrkBuffer[r][TripleDSs],smoothPeriod,i,0);
        wrkBuffer[r][TripleDFs] = iSma(TripleDF ,3,r);
        pstBuffer[i]            = iSmooth(wrkBuffer[r][TripleDFs],smoothPeriod,i,1);
      
        //
        //
        //
        //
        //
        
        UpH[i]   = EMPTY_VALUE;
        DnH[i]   = EMPTY_VALUE;
        trend[i] = trend[i+1];
        if (pstBuffer[i] > pssBuffer[i]) trend[i] =  1;
        if (pstBuffer[i] < pssBuffer[i]) trend[i] = -1;
        if (trend[i] == 1) UpH[i] = 1;
        if (trend[i] ==-1) DnH[i] = 1;
        
        //
        //
        //
        //
        //
        
        if (linesVisible )
        {
           deleteLine(Time[i]);
           if (trend[i]!= trend[i+1])
           {
              if (trend[i+1] ==-1 && trend[i] !=-1) drawLine(i,linesUpColor);
              if (trend[i+1] == 1 && trend[i] != 1) drawLine(i,linesDnColor);
           }
        }
        manageArrow(i); 
   }
   manageAlerts();
   return(0);
   }
   
   //
   //
   //
   //
   //
   
   limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,TimeFrame,indicatorFileName,-99,0,0)*TimeFrame/Period()));
   for (i=limit;i>=0; i--)
   {
      int y = iBarShift(NULL,TimeFrame,Time[i]);
         trend[i] = iCustom(NULL,TimeFrame,indicatorFileName,PERIOD_CURRENT,pstLength,pstX,pstPriceHigh,pstPriceLow,pstPrice,pstSmooth,smoothPeriod,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsNotify,alertsEmail,soundFile,arrowsVisible,arrowsIdentifier,arrowsUpperGap,arrowsLowerGap,arrowsUpColor,arrowsDnColor,arrowsUpCode,arrowsDnCode,arrowsUpSize,arrowsDnSize,arrowsOnFirst,linesVisible,linesIdentifier,linesUpColor,linesDnColor,LinesStyle,LinesWidth,linesOnFirst,4,y);
         UpH[i]   = EMPTY_VALUE;
         DnH[i]   = EMPTY_VALUE;
         if (trend[i] == 1) UpH[i] = 1;
         if (trend[i] ==-1) DnH[i] = 1;
   }
   return(0);         
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

double iSma(int forDim, int period, int pos)
{
   double sum = wrkBuffer[pos][forDim];
      for(int i=1; i<period; i++) sum += wrkBuffer[pos-i][forDim];
   return(sum/period);
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

double workSmooth[][10];
double iSmooth(double price,double length,int r, int instanceNo=0)
{
   if (ArrayRange(workSmooth,0)!=Bars) ArrayResize(workSmooth,Bars); instanceNo *= 5; r = Bars-r-1;
 	if(r<=2) { workSmooth[r][instanceNo] = price; workSmooth[r][instanceNo+2] = price; workSmooth[r][instanceNo+4] = price; return(price); }
   
   //
   //
   //
   //
   //
   
	double alpha = 0.45*(length-1.0)/(0.45*(length-1.0)+2.0);
   	  workSmooth[r][instanceNo+0] =  price+alpha*(workSmooth[r-1][instanceNo]-price);
	     workSmooth[r][instanceNo+1] = (price - workSmooth[r][instanceNo])*(1-alpha)+alpha*workSmooth[r-1][instanceNo+1];
	     workSmooth[r][instanceNo+2] =  workSmooth[r][instanceNo+0] + workSmooth[r][instanceNo+1];
	     workSmooth[r][instanceNo+3] = (workSmooth[r][instanceNo+2] - workSmooth[r-1][instanceNo+4])*MathPow(1.0-alpha,2) + MathPow(alpha,2)*workSmooth[r-1][instanceNo+3];
	     workSmooth[r][instanceNo+4] =  workSmooth[r][instanceNo+3] + workSmooth[r-1][instanceNo+4]; 
   return(workSmooth[r][instanceNo+4]);
}

//-------------------------------------------------------------------
//
//-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//
//

double workHa[][4];
double getPrice(int price, const double& open[], const double& close[], const double& high[], const double& low[], int i, int instanceNo=0)
{
  if (price>=pr_haclose)
   {
      if (ArrayRange(workHa,0)!= Bars) ArrayResize(workHa,Bars);
         int r = Bars-i-1;
         
         //
         //
         //
         //
         //
         
         double haOpen;
         if (r>0)
                haOpen  = (workHa[r-1][instanceNo+2] + workHa[r-1][instanceNo+3])/2.0;
         else   haOpen  = (open[i]+close[i])/2;
         double haClose = (open[i] + high[i] + low[i] + close[i]) / 4.0;
         double haHigh  = MathMax(high[i], MathMax(haOpen,haClose));
         double haLow   = MathMin(low[i] , MathMin(haOpen,haClose));

         if(haOpen  <haClose) { workHa[r][instanceNo+0] = haLow;  workHa[r][instanceNo+1] = haHigh; } 
         else                 { workHa[r][instanceNo+0] = haHigh; workHa[r][instanceNo+1] = haLow;  } 
                                workHa[r][instanceNo+2] = haOpen;
                                workHa[r][instanceNo+3] = haClose;
         //
         //
         //
         //
         //
         
         switch (price)
         {
            case pr_haclose:     return(haClose);
            case pr_haopen:      return(haOpen);
            case pr_hahigh:      return(haHigh);
            case pr_halow:       return(haLow);
            case pr_hamedian:    return((haHigh+haLow)/2.0);
            case pr_hamedianb:   return((haOpen+haClose)/2.0);
            case pr_hatypical:   return((haHigh+haLow+haClose)/3.0);
            case pr_haweighted:  return((haHigh+haLow+haClose+haClose)/4.0);
            case pr_haaverage:   return((haHigh+haLow+haClose+haOpen)/4.0);
            case pr_hatbiased:
               if (haClose>haOpen)
                     return((haHigh+haClose)/2.0);
               else  return((haLow+haClose)/2.0);        
         }
   }
   
   //
   //
   //
   //
   //
 
   switch (price)
   {
      case pr_close:     return(close[i]);
      case pr_open:      return(open[i]);
      case pr_high:      return(high[i]);
      case pr_low:       return(low[i]);
      case pr_median:    return((high[i]+low[i])/2.0);
      case pr_medianb:   return((open[i]+close[i])/2.0);
      case pr_typical:   return((high[i]+low[i]+close[i])/3.0);
      case pr_weighted:  return((high[i]+low[i]+close[i]+close[i])/4.0);
      case pr_average:   return((high[i]+low[i]+close[i]+open[i])/4.0);
      case pr_tbiased:   
               if (close[i]>open[i])
                     return((high[i]+close[i])/2.0);
               else  return((low[i]+close[i])/2.0);        
   }
   return(0);
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

void manageAlerts()
{
   if (alertsOn)
   {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1;
      if (trend[whichBar] != trend[whichBar+1])
      {
         if (trend[whichBar] == 1) doAlert(whichBar,"up");
         if (trend[whichBar] ==-1) doAlert(whichBar,"down");
      }         
   }
}   

//
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
      if (previousAlert != doWhat || previousTime != Time[forBar]) {
          previousAlert  = doWhat;
          previousTime   = Time[forBar];

          //
          //
          //
          //
          //

          message =  StringConcatenate(Symbol()," ",timeFrameToString(_Period)," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," Kase PS trend changed to  ",doWhat);
             if (alertsMessage) Alert(message);
             if (alertsNotify)  SendNotification(StringConcatenate(Symbol(), Period() ," Kase PS " +" "+message));
             if (alertsEmail)   SendMail(StringConcatenate(Symbol()," Kase PS "),message);
             if (alertsSound)   PlaySound(soundFile);
      }
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

void manageArrow(int i)
{
   if (arrowsVisible)
   {
      ObjectDelete(arrowsIdentifier+":"+Time[i]);
      if (trend[i] != trend[i+1])
      {
         if (trend[i] == 1) drawArrow(i,arrowsUpColor,arrowsUpCode,arrowsUpSize,false);
         if (trend[i] ==-1) drawArrow(i,arrowsDnColor,arrowsDnCode,arrowsDnSize,true);
      }
      
   }
}               

//
//
//
//
//

void drawArrow(int i,color theColor,int theCode,int theWidth,bool up)
{
   string name = arrowsIdentifier+":"+Time[i];
   double gap  = 3.0*iATR(NULL,0,20,i)/4.0;   
   int    add  = 0; if (!arrowsOnFirst) add = _Period*60-1;
   
      //
      //
      //
      //
      //
      
      ObjectCreate(name,OBJ_ARROW,0,Time[i]+add,0);
         ObjectSet(name,OBJPROP_ARROWCODE,theCode);
         ObjectSet(name,OBJPROP_COLOR,theColor);
         ObjectSet(name,OBJPROP_WIDTH,theWidth);
         if (up)
               ObjectSet(name,OBJPROP_PRICE1,High[i]+ arrowsUpperGap * gap);
         else  ObjectSet(name,OBJPROP_PRICE1,Low[i] - arrowsLowerGap * gap);
}

//
//
//
//
//

void drawLine(int i,color theColor)
{
     string name = linesIdentifier+":"+Time[i];
     int    add  = 0; if (!linesOnFirst) add = _Period*60-1;
   
     //
     //
     //
     //
     //
      
     ObjectCreate(name,OBJ_VLINE,0,Time[i]+add,0);
        ObjectSet(name,OBJPROP_COLOR,theColor);
        ObjectSet(name,OBJPROP_STYLE,LinesStyle);
        ObjectSet(name,OBJPROP_WIDTH,LinesWidth);
        ObjectSet(name,OBJPROP_BACK,true);
}

//
//
//
//
//

void deleteLines()
{
   string lookFor       = linesIdentifier+":";
   int    lookForLength = StringLen(lookFor);
   
   //
   //
   //
   //
   //
   
   for (int i=ObjectsTotal()-1; i>=0; i--)
   {
      string objectName = ObjectName(i);
      if (StringSubstr(objectName,0,lookForLength) == lookFor) ObjectDelete(objectName);
   }
}

//
//
//
//
//

void deleteLine(datetime time)
{
    string lookFor = linesIdentifier+":"+time; ObjectDelete(lookFor);
}


