//+------------------------------------------------------------------+
//|                                KawaseOsyo_StochasticHistgram.mq4 |
//|                 Copyright  2011, KawaseOsyo, Syotaro Yoshida    |
//|                                       http://www.kawaseosyo.com/ |
//+------------------------------------------------------------------+
#property copyright "Copyright By KawaseOsyo,TransEdge co.,Ltd."
#property link      "http://www.kawaseosyo.com/"

#property indicator_separate_window
#property indicator_buffers   4
#property indicator_color1 Orange
#property indicator_color2 White
#property indicator_color3 RoyalBlue
#property indicator_color4 Red
#property indicator_style1 STYLE_SOLID
#property indicator_style2 STYLE_SOLID
#property indicator_style3 STYLE_SOLID
#property indicator_style4 STYLE_SOLID
#property indicator_width1 1
#property indicator_width2 1
#property indicator_width3 3
#property indicator_width4 3


//  xC
#property indicator_levelcolor DarkGray
#property indicator_maximum  100
#property indicator_minimum -100

#define   OVER_BOUGHT 50
#define   OVER_SOLD   50

//  p[^
extern string URL = "www.kawaseosyo.com";
extern int  KPeriod    = 14;        // %K
extern int  DPeriod    =  3;        // %D
extern int  Slowing    =  3;        // Slow Stochastic

//  obt@
double m_factorK[];
double m_factorD[];
double m_up[];
double m_down[];

//  ݒ 

int init()
{
    //  obt@ݒ
    SetIndexBuffer( 0, m_factorK ); // %K
    SetIndexBuffer( 1, m_factorD ); // %D    
    SetIndexBuffer( 2, m_up );      // Up
    SetIndexBuffer( 3, m_down );    // Down    
    
    //  `
    SetIndexStyle ( 0, DRAW_NONE      );// %K
    SetIndexStyle ( 1, DRAW_NONE      );// %D
    SetIndexStyle ( 2, DRAW_HISTOGRAM );// Stochastic Up  (%K)
    SetIndexStyle ( 3, DRAW_HISTOGRAM );// Stochastic Down(%K)

    SetIndexLabel ( 0, "%K" );
    SetIndexLabel ( 1, "%D" );
    SetIndexLabel ( 2, "Stochastic Up");
    SetIndexLabel ( 3, "Stochastic Down");
    
    //  CWP[^ݒ
    string shortName = "KawaseOsyo Stochastic Histogram(" + KPeriod +","+ DPeriod +","+ Slowing +")";      
    return(0);
}


//  C 

int start()
{
int limit = Bars - IndicatorCounted();

    if(IndicatorCounted()<0) return(-1);

    //  XgLXvZ
    for( int j=limit ; j>=0 ; j--){
        m_factorK[j] = iStochastic( NULL, 0, KPeriod, DPeriod, Slowing, MODE_SMA, 1, MODE_MAIN,  j);
        m_factorD[j] = iStochastic( NULL, 0, KPeriod, DPeriod, Slowing, MODE_SMA, 1, MODE_SIGNAL,j);
    }

    //  XgLX̐FÂ
    for( int i=limit ; i>=0; i--){
        m_up[i]=EMPTY_VALUE;
        m_down[i]=EMPTY_VALUE;
    
        //  Abvgh
        if( m_factorK[i] > OVER_BOUGHT ){
            m_up[i] = GetValue(m_factorK[i]);
        }
    
        //  _Egh
        if( m_factorK[i] < OVER_SOLD ){
            m_down[i] = GetValue(m_factorK[i]);

        }
    }    
    return(0);
}

//  XgLX̐lϊ 

double GetValue( double value )
{
    return( (value-OVER_BOUGHT)*2.0);
}


