#property copyright "www,forex-station.com"
#property link      "www,forex-station.com"

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1  LimeGreen
#property indicator_color2  PaleVioletRed
#property indicator_color3  LimeGreen
#property indicator_color4  PaleVioletRed
#property indicator_width3  3
#property indicator_width4  3
#property strict

//
//
//
//
//

extern int                Kijun = 26;          // Kijun sen period
extern ENUM_APPLIED_PRICE Price = PRICE_CLOSE; // Price to use for the cross

double tkhu[],tkhd[],tkhbu[],tkhbd[],ks[],trend[];

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int init()
{
     IndicatorBuffers(6);
     SetIndexBuffer(0,tkhu);  SetIndexStyle(0,DRAW_HISTOGRAM);
     SetIndexBuffer(1,tkhd);  SetIndexStyle(1,DRAW_HISTOGRAM);
     SetIndexBuffer(2,tkhbu); SetIndexStyle(2,DRAW_HISTOGRAM);
     SetIndexBuffer(3,tkhbd); SetIndexStyle(3,DRAW_HISTOGRAM);
     SetIndexBuffer(4,ks);  
     SetIndexBuffer(5,trend); 
     
    IndicatorShortName("Price crossing Kijun Sen Candles");
   return(0);
}
int deinit() {  return(0);}

//
//
//
//                           
//
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//

int start()
{
   int counted_bars=IndicatorCounted();
   int i,k,limit;
   
   
   if(counted_bars < 0) return(-1);
   if(counted_bars > 0) counted_bars--;
           limit = MathMin(Bars-counted_bars,Bars-1); 
   
   //
   //
   //
   //
   //
   
   for (i=limit; i>=0; i--)
   {
       double prc = iMA(NULL,0,1,0,MODE_SMA,Price,i);
       double khi = High[i];
       double klo = Low[i];
       for (k=1; k<Kijun && (i+k)<Bars; k++)
       {
           if(khi<High[i+k]) khi = High[i+k];
           if(klo> Low[i+k]) klo =  Low[i+k];
        } 
        ks[i] = ((khi+klo) > 0.0) ? (khi+klo)*0.5 : 0;
        trend[i] = (i<Bars-1) ? (prc>ks[i]) ? 1 : (prc<ks[i]) ? -1 : trend[i+1] : 0; 
    
        if (trend[i]== 1)
        {
          tkhu[i]  = High[i]; 
          tkhd[i]  = Low[i];
          tkhbu[i] = fmax(Open[i],Close[i]);
          tkhbd[i] = fmin(Open[i],Close[i]);
        }               
        if (trend[i]== -1)
        {
          tkhu[i]  = Low[i];
          tkhd[i]  = High[i];
          tkhbu[i] = fmin(Open[i],Close[i]);
          tkhbd[i] = fmax(Open[i],Close[i]);
        }               
     }
return(0);
}
      
   


