
#property copyright "www,forex-station.com"
#property link      "www,forex-station.com"

#property indicator_separate_window
#property indicator_buffers    7
#property indicator_color1     clrDimGray
#property strict

//
//
//
//
//

enum enMaTypes
{
   ma_sma,     // Simple moving average
   ma_ema,     // Exponential moving average
   ma_smma,    // Smoothed MA
   ma_lwma,    // Linear weighted MA
};
enum stdMethods
{
   std_custSam, // Custom - with sample correction
   std_custNos  // Custom - without sample correction
};

        
input int             Tenkan                       = 9;                  // Tenkan Period
input int             Kijun                        = 26;                 // Kijun Period
input int             Senkou                       = 52;                 // Senkou Period  
input double          Deviations                   = 2;                  // Bands deviations
input stdMethods      DeviationType                = std_custSam;        // Band deviations calculation type
input int             MaPeriod                     = 200;                // Ma smoothing period
input enMaTypes       MaMethod                     = ma_lwma;            // Moving average smoothing method 
input int             levelOs                      = 20;                 // Oversold level
input int             levelOb                      = 100;                // Overbought level
input color           OverSoldColor                = clrDeepSkyBlue;     // Oversold color
input color           OverBoughtColor              = clrPaleVioletRed;   // Overbought color
input color           ShadowColor                  = clrGray;            // Shadow color
input int             LineWidth                    = 3;                  // Main line width
input int             ShadowWidth                  = 6;                  // Shadow width (<=0 main line width+3) 
input color           LevelClr                     = clrMediumOrchid;    // Color for levels 
input ENUM_LINE_STYLE LevelStyle                   = STYLE_DOT;          // Style for levels


double kiv[],buffer1da[],buffer1db[],buffer1ua[],buffer1ub[],valc[],shadowa[],shadowb[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
{
    int shadowWidth = (ShadowWidth<=0) ? LineWidth+3 : ShadowWidth;
    IndicatorBuffers(8);
    SetIndexBuffer(0, kiv,      INDICATOR_DATA); SetIndexStyle(0,DRAW_LINE,EMPTY,LineWidth);
    SetIndexBuffer(1, shadowa,  INDICATOR_DATA); SetIndexStyle(1,DRAW_LINE,EMPTY,shadowWidth,ShadowColor);
    SetIndexBuffer(2, shadowb,  INDICATOR_DATA); SetIndexStyle(2,DRAW_LINE,EMPTY,shadowWidth,ShadowColor);
    SetIndexBuffer(3, buffer1ua,INDICATOR_DATA); SetIndexStyle(3,DRAW_LINE,EMPTY,LineWidth,OverBoughtColor);
    SetIndexBuffer(4, buffer1ub,INDICATOR_DATA); SetIndexStyle(4,DRAW_LINE,EMPTY,LineWidth,OverBoughtColor);
    SetIndexBuffer(5, buffer1da,INDICATOR_DATA); SetIndexStyle(5,DRAW_LINE,EMPTY,LineWidth,OverSoldColor);
    SetIndexBuffer(6, buffer1db,INDICATOR_DATA); SetIndexStyle(6,DRAW_LINE,EMPTY,LineWidth,OverSoldColor);
    SetIndexBuffer(7, valc);
    
    IndicatorSetInteger(INDICATOR_LEVELS,3);
    IndicatorSetDouble( INDICATOR_LEVELVALUE,0,levelOs);
    IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,LevelStyle);
    IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,LevelClr);  
    IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,LevelStyle);
    IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,LevelClr);  
    IndicatorSetDouble( INDICATOR_LEVELVALUE,2,levelOb);
    IndicatorSetInteger(INDICATOR_LEVELSTYLE,2,LevelStyle);
    IndicatorSetInteger(INDICATOR_LEVELCOLOR,2,LevelClr); 
    
    IndicatorSetString(INDICATOR_SHORTNAME,"Kumo implied volatility"); 
return(INIT_SUCCEEDED);
}
void OnDeinit(const int reason){   } 

//
//
//
//
//

int OnCalculate (const int       rates_total,
                 const int       prev_calculated,
                 const datetime& time[],
                 const double&   open[],
                 const double&   high[],
                 const double&   low[],
                 const double&   close[],
                 const long&     tick_volume[],
                 const long&     volume[],
                 const int&      spread[])
{
   int i=rates_total-prev_calculated+1; if (i>=rates_total) i=rates_total-1; 
   if (valc[i]==-1) { CleanPoint(i,buffer1da,buffer1db); CleanPoint(i,shadowa,shadowb); }
   if (valc[i]== 1) { CleanPoint(i,buffer1ua,buffer1ub); CleanPoint(i,shadowa,shadowb); }
   for (; i>=0 && !_StopFlag; i--)
   {
      if (i>=rates_total-Tenkan) continue;
      double tlo =  low[ArrayMinimum(low, Tenkan,i)];
      double thi = high[ArrayMaximum(high,Tenkan,i)];
      double ts  = ((thi+tlo)!=0) ? (thi+tlo)*0.5 : 0;
         
      if (i>=rates_total-Kijun) continue;
      double klo =  low[ArrayMinimum(low, Kijun,i)];
      double khi = high[ArrayMaximum(high,Kijun,i)];
      double ks  = ((khi+klo)!=0) ? (khi+klo)*0.5 : 0;
         
      if (i>=rates_total-Senkou) continue;
      double slo =  low[ArrayMinimum(low, Senkou,i)];
      double shi = high[ArrayMaximum(high,Senkou,i)];
      
      double spA = (ks+ts)*0.5;
      double spB = (shi+slo)*0.5; 
      double kdep = fabs(spA-spB);
      
      double std = iDeviation(kdep,MaPeriod,DeviationType==std_custSam,i,rates_total);
      double avg = iCustomMa(MaMethod,kdep,MaPeriod,i,rates_total);
      double ub  = avg+(Deviations*std);
      double lb  = avg-(Deviations*std);
         kiv[i]  = (ub!=lb) ? ((kdep-lb)/(ub-lb)*100) : 0;   
         buffer1da[i] = buffer1db[i] = EMPTY_VALUE;
         buffer1ua[i] = buffer1ub[i] = EMPTY_VALUE;
         shadowa[i]   = shadowb[i]   = EMPTY_VALUE;
         valc[i] = (i<rates_total-1) ? (kiv[i]>levelOb) ? 1 : (kiv[i]<levelOs) ? -1 : (kiv[i]<levelOb && kiv[i]>levelOs) ? 0 : valc[i+1] : 0;  
         if (valc[i] == -1) { PlotPoint(i,buffer1da,buffer1db,kiv); PlotPoint(i,shadowa,shadowb,kiv); }
         if (valc[i] ==  1) { PlotPoint(i,buffer1ua,buffer1ub,kiv); PlotPoint(i,shadowa,shadowb,kiv); }   
   }
return(rates_total);
}

//------------------------------------------------------------------
//                                                                  
//------------------------------------------------------------------
// 
//
//
//
//

double workDev[];
double iDeviation(double dvalue, int length, bool isSample, int i, int bars)
{
   if (ArraySize(workDev)!= bars) ArrayResize(workDev,bars); i=bars-i-1; workDev[i] = dvalue;
                 
   //
   //
   //
   //
   //
   
      double oldMean   = dvalue;
      double newMean   = dvalue;
      double squares   = 0; int k;
      for (k=1; k<length && (i-k)>=0; k++)
      {
         newMean  = (workDev[i-k]-oldMean)/(k+1)+oldMean;
         squares += (workDev[i-k]-oldMean)*(workDev[i-k]-newMean);
         oldMean  = newMean;
      }
return(sqrt(squares/fmax(k-isSample,1)));
}

//------------------------------------------------------------------
//                                                                  
//------------------------------------------------------------------
//
//
//
//
//

#define _maInstances 1
#define _maWorkBufferx1 1*_maInstances
#define _maWorkBufferx2 2*_maInstances
#define _maWorkBufferx3 3*_maInstances

double iCustomMa(int mode, double price, double length, int r, int bars, int instanceNo=0)
{
   r = bars-r-1;
   switch (mode)
   {
      case ma_sma   : return(iSma(price,(int)ceil(length),r,bars,instanceNo));
      case ma_ema   : return(iEma(price,length,r,bars,instanceNo));
      case ma_smma  : return(iSmma(price,(int)ceil(length),r,bars,instanceNo));
      case ma_lwma  : return(iLwma(price,(int)ceil(length),r,bars,instanceNo));
      default       : return(price);
   }
}

//
//
//
//
//

double workSma[][_maWorkBufferx1];
double iSma(double price, int period, int r, int _bars, int instanceNo=0)
{
   if (ArrayRange(workSma,0)!= _bars) ArrayResize(workSma,_bars);

   workSma[r][instanceNo+0] = price;
   double avg = price; int k=1;  for(; k<period && (r-k)>=0; k++) avg += workSma[r-k][instanceNo+0];  
   return(avg/(double)k);
}

//
//
//
//
//

double workEma[][_maWorkBufferx1];
double iEma(double price, double period, int r, int _bars, int instanceNo=0)
{
   if (ArrayRange(workEma,0)!= _bars) ArrayResize(workEma,_bars);

   workEma[r][instanceNo] = price;
   if (r>0 && period>1)
          workEma[r][instanceNo] = workEma[r-1][instanceNo]+(2.0/(1.0+period))*(price-workEma[r-1][instanceNo]);
   return(workEma[r][instanceNo]);
}

//
//
//
//
//

double workSmma[][_maWorkBufferx1];
double iSmma(double price, double period, int r, int _bars, int instanceNo=0)
{
   if (ArrayRange(workSmma,0)!= _bars) ArrayResize(workSmma,_bars);

   workSmma[r][instanceNo] = price;
   if (r>1 && period>1)
          workSmma[r][instanceNo] = workSmma[r-1][instanceNo]+(price-workSmma[r-1][instanceNo])/period;
   return(workSmma[r][instanceNo]);
}

//
//
//
//
//

double workLwma[][_maWorkBufferx1];
double iLwma(double price, double period, int r, int _bars, int instanceNo=0)
{
   if (ArrayRange(workLwma,0)!= _bars) ArrayResize(workLwma,_bars);
   
   workLwma[r][instanceNo] = price; if (period<=1) return(price);
      double sumw = period;
      double sum  = period*price;

      for(int k=1; k<period && (r-k)>=0; k++)
      {
         double weight = period-k;
                sumw  += weight;
                sum   += weight*workLwma[r-k][instanceNo];  
      }             
      return(sum/sumw);
}

//-------------------------------------------------------------------
//                                                                  
//-------------------------------------------------------------------
//
//
//
//
//

void CleanPoint(int i,double& first[],double& second[])
{
   if (i>=Bars-3) return;
   if ((second[i]  != EMPTY_VALUE) && (second[i+1] != EMPTY_VALUE))
        second[i+1] = EMPTY_VALUE;
   else
      if ((first[i] != EMPTY_VALUE) && (first[i+1] != EMPTY_VALUE) && (first[i+2] == EMPTY_VALUE))
          first[i+1] = EMPTY_VALUE;
}

void PlotPoint(int i,double& first[],double& second[],double& from[])
{
   if (i>=Bars-2) return;
   if (first[i+1] == EMPTY_VALUE)
      if (first[i+2] == EMPTY_VALUE) 
            { first[i]  = from[i]; first[i+1]  = from[i+1]; second[i] = EMPTY_VALUE; }
      else  { second[i] = from[i]; second[i+1] = from[i+1]; first[i]  = EMPTY_VALUE; }
   else     { first[i]  = from[i];                          second[i] = EMPTY_VALUE; }
}


