#property copyright   "http://www.bestexpertadvisors.com"
#property link        "http://www.bestexpertadvisors.com"
#property description "Our amazing premium EAs and new systems are coming soon."
#property description "You can follow us to get the latest news."

//----   --------------------------------------------------------------------+
#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 Gold
#property indicator_color2 Aqua
#property indicator_color3 OrangeRed

//----   ----------------------------------------------------------------------+
extern int    LRC_MaxWidth_Pips               = 100;
extern int    LRC_Price                       = 0;
extern bool   UseLRCPrice                     = true;
extern int    BarsToCount                     = 0;

//----  --------------------------------------------------------------------------------+
static double LRCBuffer[];
static double LRCSupport[];
static double LRCResistance[];
static double LRCPeriod[];

//-----   -----------------------------------------------------------------+
static int       pips_digits;
static double    point;

//---------------------------------------------------------------------------------------------+
//----   ---------------------------------------------------------------+
//---------------------------------------------------------------------------------------------+
int init()
  {
   //----  ""   ----------------------------------------------+
   IndicatorShortName(StringConcatenate("LRC_MaxWidth(",DoubleToStr(LRC_MaxWidth_Pips,0)));
   //---- 1 q  -------------------------------------------------------------+
   IndicatorBuffers(4);
   //----     ----------------------------------------------+
   IndicatorDigits(4);
   //----     ----------------------------------------------------+
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,2);
   SetIndexStyle(1,DRAW_LINE,STYLE_SOLID,2);
   SetIndexStyle(2,DRAW_LINE,STYLE_SOLID,1);
   //----      ---------------------------------------------+
   SetIndexBuffer(0,LRCBuffer);
   SetIndexBuffer(1,LRCSupport);
   SetIndexBuffer(2,LRCResistance);
   SetIndexBuffer(3,LRCPeriod);
   //----     --------------------------------------------------------+
   SetIndexLabel(0,"LRC");
   SetIndexLabel(1,"LRC_Sup");
   SetIndexLabel(2,"LRC_Res");
   //----   --------------------------------------------------------------+
   if(Digits < 4)
     {
      point = 0.01;
      int digits = 2;
     }
   else
     {
      point = 0.0001;
      digits = 4;
     }
   pips_digits = Digits - digits;
   //----   -----------------------------------------------------------------+
   return(0);
   Print("---- Programming by Serega Lykov, http://mtexperts.narod.ru/ ----");
  }

//---------------------------------------------------------------------------------------------+
//----   -------------------------------------------------------------+
//---------------------------------------------------------------------------------------------+
int deinit()
  {
   return(0);
  }

//---------------------------------------------------------------------------------------------+
//----   ---------------------------------------------------------------------------+
//---------------------------------------------------------------------------------------------+
int start()
  {
   //----        --------------------+
   int counted_bars = IndicatorCounted();
   if(counted_bars < 0) return(-1);
   //----      ------------------------------------------+
   if(counted_bars > 0) counted_bars--;
   int limit = Bars - counted_bars;
   if(BarsToCount > 0)
     {
      if(limit > BarsToCount)
        {
         limit = BarsToCount;
         int draw_begin = Bars - BarsToCount;
         SetIndexDrawBegin(0,draw_begin);
         SetIndexDrawBegin(1,draw_begin);
         SetIndexDrawBegin(2,draw_begin);
        }
     }
   //----  LRC ----------------------------------------------------------------------+
   for(int i=limit; i>0; i--)
     {
      double lrc_width = NormalizeDouble((LRCResistance[i + 1] - LRCSupport[i + 1]) / point,pips_digits);
      if(lrc_width <= LRC_MaxWidth_Pips) LRCPeriod[i] = LRCPeriod[i + 1] + 1;
      else LRCPeriod[i] = 1;
      if(LRCPeriod[i] > 1) CalculateLRC(LRCPeriod[i],i);
     }
   //----   -----------------------------------------------------------------+
   return(0);
  }

//---------------------------------------------------------------------------------------------+
//---- CalculateLRC ---------------------------------------------------------------------------+
//---------------------------------------------------------------------------------------------+
void CalculateLRC(int bars_to_count, int shift)
  {
   //---- calculate linear regression ---------------------------------------------------------+
   int start_barshift = shift + bars_to_count - 1;
   double sumy  = 0.0;
   double sumx  = 0.0;
   double sumxy = 0.0;
   double sumx2 = 0.0;
   int j = 0;
   for(int i=shift; i<=start_barshift; i++)
     {
      double price;
      switch(LRC_Price)
        {
         case 1:  price = Open[i];                                      break;
         case 2:  price = High[i];                                      break;
         case 3:  price = Low[i];                                       break;
         case 4:  price = (High[i] + Low[i]) / 2;                       break;
         case 5:  price = (High[i] + Low[i] + Close[i]) / 3;            break;
         case 6:  price = (High[i] + Low[i] + Close[i] + Close[i]) / 4; break;
         default: price = Close[i];                                     break;
        }
      sumy  += price;
      sumxy += price * j;
      sumx  += j;
      sumx2 += j * j;
      j++;
     }
   double c = sumx2 * bars_to_count - sumx * sumx;
   if(c == 0.0)
     {
      Alert("CalculateLRC:\nError in linear regression !");
      return(0);
     }
   //---- line equation -----------------------------------------------------------------------+
   double b = (sumxy * bars_to_count - sumx * sumy) / c;
   double a = (sumy - sumx * b) / bars_to_count;
   //---- linear regression line in buffer ----------------------------------------------------+
   j = 0;
   for(i=shift; i<=start_barshift; i++)
     {
      LRCBuffer[i] = a + b * j;
      j++;
     }
   //---- use Close for support-resistance ----------------------------------------------------+
   double h = 0.0;
   double l = 0.0;
   if(UseLRCPrice)
     {
      for(i=shift; i<=start_barshift; i++)
        {
         switch(LRC_Price)
           {
            case 1:  price = Open[i];                                      break;
            case 2:  price = High[i];                                      break;
            case 3:  price = Low[i];                                       break;
            case 4:  price = (High[i] + Low[i]) / 2;                       break;
            case 5:  price = (High[i] + Low[i] + Close[i]) / 3;            break;
            case 6:  price = (High[i] + Low[i] + Close[i] + Close[i]) / 4; break;
            default: price = Close[i];                                     break;
           }
         if((price - LRCBuffer[i]) > h) h = price - LRCBuffer[i];
         if((LRCBuffer[i] - price) > l) l = LRCBuffer[i] - price;
        }
     }
   //---- use High/Low for support-resistance -------------------------------------------------+
   else
     {
      for(i=shift; i<=start_barshift; i++)
        {
         if((High[i] - LRCBuffer[i]) > h) h = High[i] - LRCBuffer[i];
         if((LRCBuffer[i] - Low[i])  > l) l = LRCBuffer[i] - Low[i];
        }
     }
   //---- calculate support - resistance lines ------------------------------------------------+
   if(h > l)
     {
      LRCSupport   [shift] = a - h;
      LRCResistance[shift] = a + h;
     }
   else
     {
      LRCSupport   [shift] = a - l;
      LRCResistance[shift] = a + l;
     }
   double lrc_halfwidth = LRCResistance[shift] - LRCBuffer[shift];
   for(i=shift+1; i<=start_barshift; i++)
     {
      LRCSupport   [i] = LRCBuffer[i] - lrc_halfwidth;
      LRCResistance[i] = LRCBuffer[i] + lrc_halfwidth;
     }
   //----     ----------------------------------------------------------+
   LRCBuffer    [start_barshift] = EMPTY_VALUE;
   LRCSupport   [start_barshift] = EMPTY_VALUE;
   LRCResistance[start_barshift] = EMPTY_VALUE;
  }
    
//-------------------------------- programming by Serega Lykov, http://mtexperts.narod.ru/ ----+