//+------------------------------------------------------------------+
//|                                              LNX_Pivots_v3.2.mq4 |
//|                                  Copyright  2007, Forex-TSD.com |                                                                  
//|                                    Many Thanks Linuxser for idea |
//|                         Written by IgorAD,igorad2003@yahoo.co.uk |   
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |                                      
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, Forex-TSD.com "
#property link      "http://www.forex-tsd.com/"

#property indicator_chart_window
//---- input parameters
extern int  CountDays      =5;
extern int  NY_CloseHour   =1;
extern int  DaysNumber1    =5;
extern int  DaysNumber2    =10;
extern int  DaysNumber3    =20;
//---- indicator buffers
double range[];
double ny_close[];

datetime time1;
datetime time2;
datetime ny_time[];

int shift, num;
int ny_shift[];
datetime prevDay=0;
bool fTime;
// ----
void ObjDel()
{
   if (ObjectsTotal() > 0)
   for (num=0;num<=CountDays;num++)
   {
   ObjectDelete("PP["+num+"]");
   ObjectDelete("R1["+num+"]");
   ObjectDelete("R2["+num+"]");
   ObjectDelete("R3["+num+"]");
   ObjectDelete("R4["+num+"]");
   ObjectDelete("S1["+num+"]");
   ObjectDelete("S2["+num+"]");
   ObjectDelete("S3["+num+"]");
   ObjectDelete("S4["+num+"]");
   }
}
// ----
void PlotLine(string name,double value,double line_color,double style)
{
   bool res = ObjectCreate(name,OBJ_TREND,0,time1,value,time2,value);
   ObjectSet(name, OBJPROP_WIDTH, 1);
   ObjectSet(name, OBJPROP_STYLE, style);
   ObjectSet(name, OBJPROP_RAY, false);
   ObjectSet(name, OBJPROP_BACK, true);
   ObjectSet(name, OBJPROP_COLOR, line_color);
}        
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   fTime = true;
   IndicatorBuffers(2);
   SetIndexBuffer(0,range);
   SetIndexBuffer(1,ny_close);
   return(0);
}

//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+   
int deinit()
{
   ObjDel();
   Comment("");
   return(0);
}
//+------------------------------------------------------------------+
//| LNX_Pivots_v3.1                                                    |
//+------------------------------------------------------------------+
int start()
{
   int i;
   double P,R1,R2,R3,R4,S1,S2,S3,S4;
  
   datetime cDay = iTime(NULL,PERIOD_D1,0) + (NY_CloseHour-Period()/60.0)*3600;
   if (cDay != prevDay || fTime)  
   {
   ObjDel();
   ArrayResize(ny_time,CountDays+DaysNumber3+1);
   ArrayResize(ny_shift,CountDays+DaysNumber3+1);
     
      for (shift=0;shift<=CountDays+DaysNumber3;shift++)
      {
      ny_time[shift]  = iTime(NULL,PERIOD_D1,shift) + (NY_CloseHour-Period()/60.0)*3600;
      ny_shift[shift] = iBarShift(NULL,0,ny_time[shift]);
      ny_close[shift] = iClose(NULL,0,ny_shift[shift]);        
      }
     
      for (shift=0;shift<=CountDays+DaysNumber3-1;shift++)
      {
      int length = ny_shift[shift+1]-ny_shift[shift];
   
      double high = High[iHighest(NULL,0,MODE_HIGH,length,ny_shift[shift])];
      double low  = Low[iLowest(NULL,0,MODE_LOW,length,ny_shift[shift])];
      range[shift] = high - low; 
      }
  
      for (shift=0;shift<=CountDays-1;shift++)
      {
      double aR1   = 0; 
      double R5    = 0;
      double R10   = 0;
      double R20   = 0;
      double Ravg  = 0;  
      double sumR5 = 0; 
      double sumR10 = 0;
      double sumR20 = 0;
   
      for(i=0;i<DaysNumber1;i++)   sumR5    += range[i+shift];
      for(i=0;i<DaysNumber2;i++)   sumR10   += range[i+shift];
      for(i=0;i<DaysNumber3;i++)   sumR20   += range[i+shift];
            
      aR1   = NormalizeDouble(range[shift],Digits); 
      R5    = NormalizeDouble(sumR5/DaysNumber1,Digits);
      R10   = NormalizeDouble(sumR10/DaysNumber2,Digits);
      R20   = NormalizeDouble(sumR20/DaysNumber3,Digits);
      Ravg  = NormalizeDouble((aR1+R5+R10+R20)/4,Digits);  
           
      P  = ny_close[shift];
      R1 = NormalizeDouble(P + 0.25*Ravg,Digits);
      R2 = NormalizeDouble(P + 0.50*Ravg,Digits);
      R3 = NormalizeDouble(P + 0.75*Ravg,Digits);
      R4 = P + Ravg;
          
      S1 = NormalizeDouble(P - 0.25*Ravg,Digits);
      S2 = NormalizeDouble(P - 0.50*Ravg,Digits);
      S3 = NormalizeDouble(P - 0.75*Ravg,Digits);
      S4 = P - Ravg;

      time1 = ny_time[shift];    
         
         if (shift==0) 
         time2 = ny_time[shift] + 24*3600 ;
         else
         time2 = ny_time[shift-1];
   
      int pstyle=0;
      PlotLine("PP["+shift+"]",P,Aqua,pstyle);
     
      PlotLine("R1["+shift+"]",R1,Red,pstyle);
      PlotLine("R2["+shift+"]",R2,Orange,pstyle);
      PlotLine("R3["+shift+"]",R3,Gold,pstyle);
      PlotLine("R4["+shift+"]",R4,Yellow,pstyle);         
      
      PlotLine("S1["+shift+"]",S1,MediumSeaGreen,pstyle);
      PlotLine("S2["+shift+"]",S2,Lime,pstyle);
      PlotLine("S3["+shift+"]",S3,GreenYellow,pstyle);
      PlotLine("S4["+shift+"]",S4,LimeGreen,pstyle);
               
         if(shift == 0)
         Comment("Average Day Range  = ",Ravg/Point,"\n",
                 "Prev 1  Days Range = ",aR1/Point,"\n",
                 "Prev ",DaysNumber1," Days Range = ",R5/Point,"\n",
                 "Prev ",DaysNumber2," Days Range = ",R10/Point,"\n",
                 "Prev ",DaysNumber3," Days Range = ",R20/Point,"\n"); 
      
        
      }
   fTime = false;
   prevDay = cDay;
   }      
        
   return(0);
}
//+------------------------------------------------------------------+