//+------------------------------------------------------------------+
//|                                                    MACD_DEMA.mq4 |
//|                                    Copyright  2007, Robert Hill |
//| Standard MACD modified to use DEMA instead of EMA                |
//|                                                                  |
//| Based on the formula developed by Patrick Mulloy                 |
//|                                                                  |
//| It can be used in place of EMA or to smooth other indicators.    |
//|                                                                  |
//| DEMA = 2 * EMA - EMA of EMA                                      |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, Robert Hill"
//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 4
#property  indicator_color1  Aqua
#property  indicator_color2  Red
#property  indicator_color3  Green
#property  indicator_color4  Red
//---- indicator parameters
extern int FastEMA=12;
extern int SlowEMA=26;
extern int SignalSMA=9;
//---- indicator buffers
double     MACD_buffer[];
double     Signal_buffer[];
double HistogramBufferUp[];
double HistogramBufferDown[];
double DemaFast[];
double DemaSlow[];
double Ema[];
double EmaOfEma[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- drawing settings
   IndicatorBuffers(8);
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS)+1);
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID);
   SetIndexBuffer(0,MACD_buffer);
   SetIndexDrawBegin(0,SlowEMA);
   SetIndexStyle(1,DRAW_LINE,STYLE_DOT);
   SetIndexBuffer(1,Signal_buffer);
   SetIndexDrawBegin(1,SignalSMA);
   SetIndexStyle(2,DRAW_HISTOGRAM,STYLE_SOLID);
   SetIndexBuffer(2,HistogramBufferUp);
   SetIndexStyle(3,DRAW_HISTOGRAM,STYLE_SOLID);
   SetIndexBuffer(3,HistogramBufferDown);
   SetIndexBuffer(4,Ema);
   SetIndexBuffer(5,EmaOfEma);
   SetIndexBuffer(6,DemaFast);
   SetIndexBuffer(7,DemaSlow);
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS)+1);
//---- name for DataWindow and indicator subwindow label
   IndicatorShortName("MACD_DEMA("+FastEMA+","+SlowEMA+","+SignalSMA+")");
   SetIndexLabel(0,"MACD");
   SetIndexLabel(1,"Signal");
   SetIndexLabel(2,"Histogram");
//---- initialization done
   return(0);
  }

//+------------------------------------------------------------------+
//| Moving Averages Convergence/Divergence                           |
//+------------------------------------------------------------------+
int start()
  {
   double temp;
   int i, limit;
   int counted_bars=IndicatorCounted();
//---- check for possible errors
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
   
//---- macd counted in the 1-st buffer
   for( i=0; i<limit; i++)
       Ema[i] = iMA(NULL,0,FastEMA,0,MODE_EMA,PRICE_CLOSE,i);
   for( i=0; i<limit; i++)
       EmaOfEma[i] = iMAOnArray(Ema,Bars,FastEMA,0,MODE_EMA,i);

   for( i=0; i<limit; i++)
       DemaFast[i] = 2 * Ema[i] - EmaOfEma[i];

   for( i=0; i<limit; i++)
       Ema[i] = iMA(NULL,0,SlowEMA,0,MODE_EMA,PRICE_CLOSE,i);
   for( i=0; i<limit; i++)
       EmaOfEma[i] = iMAOnArray(Ema,Bars,SlowEMA,0,MODE_EMA,i);

   for( i=0; i<limit; i++)
       DemaSlow[i] = 2 * Ema[i] - EmaOfEma[i];
       
   for( i=0; i<limit; i++)
      MACD_buffer[i]=DemaFast[i]- DemaSlow[i];
//---- signal line counted in the 2-nd buffer
   for(i=0; i<limit; i++)
      Signal_buffer[i]=iMAOnArray(MACD_buffer,Bars,SignalSMA,0,MODE_EMA,i);
//---- done
   for(i=0; i<limit; i++)
   {
      HistogramBufferUp[i] = 0;
      HistogramBufferDown[i] = 0;
      temp = MACD_buffer[i] - Signal_buffer[i];
      if (temp >= 0)
        HistogramBufferUp[i] = temp;
      else
        HistogramBufferDown[i] = temp;
      
   }
      
   return(0);
  }