//+------------------------------------------------------------------+
//|                                           marney range indicator |
//|                                                           mladen |
//+------------------------------------------------------------------+
#property copyright "www.forex-station.com"
#property link      "www.forex-station.com"

#property indicator_separate_window
#property indicator_buffers 5
#property indicator_color1 DimGray
#property indicator_color2 SteelBlue
#property indicator_color3 PaleVioletRed
#property indicator_color4 PaleVioletRed
#property indicator_color5 Red
#property indicator_width4 3
#property indicator_width5 2

//
//
//
//
//

extern int AveragePeriod = 50;

//
//
//
//
//

double rangeN[];
double rangeU[];
double rangeD[];
double rangeA[];
double rangeF[];


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

int init()
{
   for (int i=0; i<indicator_buffers; i++) SetIndexStyle(i,DRAW_LINE);
   SetIndexBuffer(0,rangeN);  SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(1,rangeU);  SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(2,rangeD);  SetIndexStyle(2,DRAW_HISTOGRAM);
   SetIndexBuffer(3,rangeA);
   SetIndexBuffer(4,rangeF);  SetIndexShift(4,PERIOD_D1/Period());

   IndicatorShortName("MRI ("+AveragePeriod+")");
   return(0);
}

int deinit()
{
   return(0);
}


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int start()
{
   int i,k,limit,counted_bars=IndicatorCounted();

   if (counted_bars<0) return(-1);
   if (counted_bars>0) counted_bars--;
      limit = Bars-counted_bars;

   //
   //
   //
   //
   //

   for (i=limit; i>=0; i--)
   {
      rangeN[i] = iRange(i);
      rangeU[i] = EMPTY_VALUE; if (Close[i]>Open[i]) rangeU[i] = rangeN[i];
      rangeD[i] = EMPTY_VALUE; if (Close[i]<Open[i]) rangeD[i] = rangeN[i];
      rangeA[i] = 0;
      
      //
      //
      //
      //
      //
      
         if (Period()>=PERIOD_D1)
         {
            for (k=1; k<=AveragePeriod && (i+k)<Bars; k++) rangeA[i] += iRange(i+k);
                                                           rangeA[i] /= k;
         }
         else
         {
            datetime searchTime = Time[i]-1440*60; k = 0;
            while (k<AveragePeriod && Time[Bars-1]<=searchTime)
            {
               int bar = iBarShift(NULL,0,searchTime,true);
               if (bar>-1)
               {
                  rangeA[i] += iRange(bar); k++;
               }                  
               searchTime -= 1440*60;
            }
            rangeA[i] /= MathMax(k,1);
         }            
   }

   //
   //
   //
   //
   //
   
   if (Period()<PERIOD_D1)
   {
      int shift = PERIOD_D1/Period();
      for (i=0; i<=shift; i++)
      {
         datetime futureTime = Time[0]+i*Period()*60;
         if (TimeDayOfWeek(futureTime) == 6 || TimeDayOfWeek(futureTime) == 0) continue;
         
         //
         //
         //
         //
         //
         
         rangeF[shift-i] = 0;
         searchTime = futureTime-1440*60; k = 0;
         while (k<AveragePeriod && Time[Bars-1]<=searchTime)
         {
            bar = iBarShift(NULL,0,searchTime,true);
            if (bar>-1)
            {
                  rangeF[shift-i] += iRange(bar); k++;
            }                  
            searchTime -= 1440*60;
         }
         rangeF[shift-i] /= MathMax(k,1);
      }
      SetIndexDrawBegin(4,Bars-shift-1);
   }
   return(0);
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

double iRange(int i)
{
   if (i<(Bars-1))
         return(MathMax(High[i],Close[i+1])-MathMin(Low[i],Close[i+1]));
   else  return(High[i]-Low[i]);
}