//+------------------------------------------------------------------+
//|                                           Indicator_Strength.mq4 |
//|                                                       DesO'Regan |
//|                                   mailto: oregan_des@hotmail.com |
//+------------------------------------------------------------------+
// ===================================================================================
// This indicator displays, in histogram form, the difference between a fast and slow moving average (MA_Power=true)
// This indicator also displays average levels of difference values above and below the zero line. This feature can be disabled (Set_Levels=false).
// This indicator is meant to gauge the power/strength behind a price move.
// ===================================================================================

#property copyright ""
#property link      ""

#property indicator_separate_window
#property indicator_buffers 2    //two buffers, one for above zero line, one for below
#property indicator_color1 Green // above zero line color
#property indicator_color2 Red   // below zero line color


//---- input parameters
extern bool      MA_Power=true;  // MA Indicator Strength ON/OFF
extern int       MA_Fast=8;  // default indicator values
extern ENUM_APPLIED_PRICE  PRICE_Fast=PRICE_HIGH;
extern ENUM_MA_METHOD   MODE_Fast =MODE_SMA;
extern int       MA_Slow=10;
extern ENUM_MA_METHOD   MODE_Slow =MODE_SMA;
extern ENUM_APPLIED_PRICE  PRICE_Slow=PRICE_LOW;
extern int       Back_Bars=500;  // history limit
extern bool      Set_Levels=true;   // average pos/neg indicator levels ON/OFF




//---- buffers
double Power_Buffer_Pos[]; // Pos indicator values
double Power_Buffer_Neg[]; // Neg indicator values



//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
   {
   
   //====================================
   // Checking Inputs & Set Window Labels
   //====================================
   
   if (MA_Power == true ) 
      {
      IndicatorShortName("Moving Average Strength ("+DoubleToStr(MA_Fast,0)+","+DoubleToStr(MA_Slow,0)+")");
      }     
   else 
      {
      IndicatorShortName("Invalid Parameters");
      Alert("One Power Indicator must be set to True");
    
      }
 
   //=================
   // Indicator Setup
   //=================
   SetIndexStyle(0,DRAW_HISTOGRAM,EMPTY,2); // Pos indicator type and width
   SetIndexBuffer(0,Power_Buffer_Pos); //binds buffer to Power_Buffer_Pos
   SetIndexLabel(0, "Positive Strength"); // sets mouse-over label
   
   SetIndexStyle(1,DRAW_HISTOGRAM,EMPTY,2);  // Neg indicator type and width
   SetIndexBuffer(1,Power_Buffer_Neg); //binds buffer to Power_Buffer_Neg
   SetIndexLabel(1, "Negative Strength"); // sets mouse-over label
   
 

   return(0);
  }
  

  
  
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
   {
   
   //======================
   // variable declarations
   //======================

   int Bar_Index=0; // bar tracker
   int Pos_Bar_Count=0; // pos bar count  (needed for averaging)
   int Neg_Bar_Count=0; // neg bar count  (needed for averaging)
   double Total_Pos_Power=0;  // stores total pos power/strength value   (needed for averaging)
   double Average_Pos_Power=0;   // current average pos power/strength value   
   double Total_Neg_Power=0;  // stores total neg power/strength value   (needed for averaging)
   double Average_Neg_Power=0;  // current average neg power/strength value
   int counted_bars=IndicatorCounted();   // not used!! (yet)


   for (Bar_Index = Back_Bars; Bar_Index >=0; Bar_Index--) //  MAIN INDICATOR FOR LOOP
      {
      
      //=======================
      // Indicator Calculations
      //=======================
      double MA_Fast1 = iMA(Symbol(),0,MA_Fast,0,MODE_Fast,PRICE_Fast,Bar_Index);
      double MA_Slow1 = iMA(Symbol(),0,MA_Slow,0,MODE_Slow,PRICE_Slow,Bar_Index);
      
       double MA_Diff = High[Bar_Index]/Point- MA_Fast1/Point;
      double MA_Diff2 = Low[Bar_Index]/Point- MA_Slow1/Point;
      
       
      
      
      //=================
      // MA Strength
      //=================
      if (MA_Power == true && MA_Diff > 0)
         {
         Power_Buffer_Pos[Bar_Index] = MA_Diff; // pos indicator value
         Power_Buffer_Neg[Bar_Index] = 0; // neg indicator value
         Pos_Bar_Count = Pos_Bar_Count + 1;
         Total_Pos_Power = Total_Pos_Power + MA_Diff;
         }
      else if (MA_Power == true && MA_Diff2 < 0)
         {
         Power_Buffer_Pos[Bar_Index] = 0; // pos indicator value
         Power_Buffer_Neg[Bar_Index] = MA_Diff; // neg indicator value
         Neg_Bar_Count = Neg_Bar_Count + 1;
         Total_Neg_Power = Total_Neg_Power + MA_Diff;        
         }   
      else if (MA_Power == true && MA_Diff == 0)
         {
         Power_Buffer_Pos[Bar_Index] = 0;
         Power_Buffer_Neg[Bar_Index] = 0;
         }            
         
      } // CLOSE OF FOR LOOP
      
      
   //==============================
   // Average Strength Calculations
   //==============================   
   Average_Pos_Power = Total_Pos_Power/Pos_Bar_Count;
   Average_Neg_Power = Total_Neg_Power/Neg_Bar_Count;
   
   
   //=======================
   // Setting Average Levels
   //=======================
   if (Set_Levels == true) // displaying levels 
      {
      SetLevelStyle( EMPTY, 1, Blue) ;      
      SetLevelValue(1, Average_Pos_Power);
      SetLevelValue(2, Average_Neg_Power);
      }
   else if (Set_Levels == false) // needed to erase old levels if setting Set_Levels to False  
      {
      SetLevelStyle( EMPTY, 1, Gray) ;
      SetLevelValue(1, 0);
      SetLevelValue(2, 0);
      }      
   
   
   return(0);
   }
//+------------------------------------------------------------------+