#property copyright   "www.forex-indicators.org"
#property link        "http://www.forex-indicators.org"
#property description "If this indicator does not work, please contact us at: emails@forex-indicators.org"

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 Red
#property indicator_color2 Blue
#property indicator_color3 Gray
#property indicator_color4 Gold

#property indicator_style1 2
#property indicator_style2 2
#property indicator_style3 2
#property indicator_width4 2

extern int MA_Period  = 100;
extern int MA_Method  = 1;
extern int MA_Price   = 0;


double Upper_Buffer[];
double Lower_Buffer[];
double Price_Buffer[];
double MA_Buffer[];
//----

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {

   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(0,Upper_Buffer);
   SetIndexLabel(0,"MA Price display");
   SetIndexStyle(2,DRAW_NONE);
   SetIndexBuffer(2,Price_Buffer);
   SetIndexLabel(2,"Price");
 
   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(1,Lower_Buffer);
   SetIndexLabel(1,"MA Price display");
   SetIndexStyle(3,DRAW_LINE);
   SetIndexBuffer(3,MA_Buffer);
   SetIndexLabel(3,"MA");

   return(0);
  }
//+------------------------------------------------------------------+
//| MA Price display                                                 |
//+------------------------------------------------------------------+
int start()
  {
   int    i;
   int    counted_bars=IndicatorCounted();
   

  i=Bars-counted_bars-1;
   while(i>=0)
     {
      Upper_Buffer[i]=iMA(NULL,0,MA_Period,0,MA_Method,MA_Price,i);
      Price_Buffer[i]=iMA(NULL,0,1,0,0,0,i);
      i--;
     }
     
  i=Bars-counted_bars-1;
   while(i>=0)
     {
      Lower_Buffer[i]=iMA(NULL,0,1,0,0,0,i);
      MA_Buffer[i]=iMA(NULL,0,MA_Period,0,MA_Method,MA_Price,i);
      i--;
     }

   return(0);
  }
//+------------------------------------------------------------------+