//------------------------------------------------------------------
#property copyright "www.forex-tsd.com"
#property link      "www.forex-tsd.com"
//------------------------------------------------------------------
#property indicator_separate_window
#property indicator_buffers 8

//
//
//
//
//

extern string Symbols         = "EURUSD;USDJPY;GBPUSD;USDCAD;USDCHF";
extern string SymbolsPrefix   = "";
extern string SymbolsSuffix   = "";
extern int    CCIPeriod       = 14;
extern int    CCIPrice        = PRICE_CLOSE;
extern color  Color1          = PaleVioletRed;
extern color  Color2          = Violet;
extern color  Color3          = Red;
extern color  Color4          = DeepSkyBlue;
extern color  Color5          = Blue;
extern color  Color6          = Turquoise;
extern color  Color7          = Pink;
extern color  Color8          = Gold;
extern int    LinesWidth      = 2;
extern string UniqueID        = "multi symbols CCI";

//
//
//
//
//

double buffer0[];
double buffer1[];
double buffer2[];
double buffer3[];
double buffer4[];
double buffer5[];
double buffer6[];
double buffer7[];

//
//
//
//
//

string indicatorFileName;
bool   returnBars;
string symbols[];
int    size;

//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//

int init()
{
   SetIndexBuffer(0,buffer0);
   SetIndexBuffer(1,buffer1);
   SetIndexBuffer(2,buffer2);
   SetIndexBuffer(3,buffer3);
   SetIndexBuffer(4,buffer4);
   SetIndexBuffer(5,buffer5);
   SetIndexBuffer(6,buffer6);
   SetIndexBuffer(7,buffer7);

      //
      //
      //
      //
      //
      
      returnBars  = (Symbols ==  "returnBars"); if (returnBars) return(0);
      Symbols = StringTrimLeft(StringTrimRight(Symbols));
      if (StringSubstr(Symbols,StringLen(Symbols),1) != ";")
                       Symbols = StringConcatenate(Symbols,";");

         //
         //
         //
         //
         //                                   
            
         int s =  0;
         int i =  StringFind(Symbols,";",s);
         while (i > 0)
         {
            string current = StringSubstr(Symbols,s,i-s);
            ArrayResize(symbols,ArraySize(symbols)+1);
                        symbols[ArraySize(symbols)-1] = current;
            s = i + 1;
            i = StringFind(Symbols,";",s);
         }
         size = MathMin(ArraySize(symbols),8);
         
         //
         //
         //
         //
         //
         
         for (i=0; i<size; i++) symbols[i] = SymbolsPrefix+symbols[i]+SymbolsSuffix;
         indicatorFileName = WindowExpertName();
      
      //
      //
      //
      //
      //
            
   IndicatorShortName(UniqueID);
   return(0);
}

//
//
//
//
//

int deinit()
{
   for(int i = 0; i < 8; i++) ObjectDelete(UniqueID+ i);
   return (0);
}

//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//
//

int start()
{
   int i,j,k,r,y,counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
         int limit  = MathMin(Bars-counted_bars,Bars-1);
         if (returnBars) { buffer0[0] = limit+1; return(0); }
         
            //
            //
            //
            //
            //
            
            static bool initialized = false;
            if (!initialized)
            {
               initialized = true;
               int cur = 10; 
               int cuy = 10; 
               int st  = 16;
                  if (size>0) { sl(0,"~",cur,cuy,Color1,symbols[0]); cuy += st; }
                  if (size>1) { sl(1,"~",cur,cuy,Color2,symbols[1]); cuy += st; }
                  if (size>2) { sl(2,"~",cur,cuy,Color3,symbols[2]); cuy += st; }
                  if (size>3) { sl(3,"~",cur,cuy,Color4,symbols[3]); cuy += st; }
                  if (size>4) { sl(4,"~",cur,cuy,Color5,symbols[4]); cuy += st; }
                  if (size>5) { sl(5,"~",cur,cuy,Color6,symbols[5]); cuy += st; }
                  if (size>6) { sl(6,"~",cur,cuy,Color7,symbols[6]); cuy += st; }
                  if (size>7) { sl(7,"~",cur,cuy,Color8,symbols[7]); cuy += st; }
            }

   //
   //
   //
   //
   //

   for (i=0; i<size; i++) if (symbols[i]!=Symbol()) limit = MathMax(limit,MathMin(Bars-1,iCustom(symbols[i],0,indicatorFileName,"returnBars",0,0)));
   for(i=limit, r=Bars-i-1; i>=0; i--,r++)
   {
      for (k=0; k<size; k++)
      {
         y = iBarShift(symbols[k],0,Time[i]); 
         switch(k)
         {
            case 0 : buffer0[i] = iCCI(symbols[k],0,CCIPeriod,CCIPrice,y); break;
            case 1 : buffer1[i] = iCCI(symbols[k],0,CCIPeriod,CCIPrice,y); break;
            case 2 : buffer2[i] = iCCI(symbols[k],0,CCIPeriod,CCIPrice,y); break;
            case 3 : buffer3[i] = iCCI(symbols[k],0,CCIPeriod,CCIPrice,y); break;
            case 4 : buffer4[i] = iCCI(symbols[k],0,CCIPeriod,CCIPrice,y); break;
            case 5 : buffer5[i] = iCCI(symbols[k],0,CCIPeriod,CCIPrice,y); break;
            case 6 : buffer6[i] = iCCI(symbols[k],0,CCIPeriod,CCIPrice,y); break;
            case 7 : buffer7[i] = iCCI(symbols[k],0,CCIPeriod,CCIPrice,y); break;
         }            
      }
   }     
   return(0);
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

void sl(int buffNo, string sym, int x, int y, color col, string buffLabel)
{
   int    window = WindowFind(UniqueID);
   string ID = UniqueID + buffNo;
   
      if(ObjectCreate(ID, OBJ_LABEL, window, 0, 0))
            ObjectSet(ID, OBJPROP_CORNER, 1);
            ObjectSet(ID, OBJPROP_XDISTANCE, x);
            ObjectSet(ID, OBJPROP_YDISTANCE, y);
            ObjectSetText(ID, buffLabel, 10, "Arial Bold", col);

   SetIndexStyle(buffNo,DRAW_LINE,STYLE_SOLID,LinesWidth,col);
   SetIndexLabel(buffNo,buffLabel);
}