//+------------------------------------------------------------------+
//|                                             Oma macd 4 color mtf |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "www.forex-station.com"
#property link      "www.forex-station.com"

#property indicator_separate_window
#property indicator_buffers    6
#property indicator_color1     Red
#property indicator_color2     Maroon
#property indicator_color3     LimeGreen
#property indicator_color4     DarkGreen
#property indicator_color5     Silver
#property indicator_color6     Gold
#property indicator_width1     2
#property indicator_width2     2
#property indicator_width3     2
#property indicator_width4     2
#property indicator_width5     2
#property indicator_width6     2
#property indicator_levelcolor DarkSlateGray

//
//
//
//
//

extern string TimeFrame          = "Current time frame";
extern int    FastLength         = 25;
extern double FastSpeed          = 8.0;
extern int    FastPrice          = 8;
extern bool   FastAdaptive       = true;
extern int    SlowLength         = 100;
extern double SlowSpeed          = 8.0;
extern int    SlowPrice          = 8;
extern bool   SlowAdaptive       = true;
extern int    SignalLength       = 12;
extern double SignalSpeed        = 8.0;
extern bool   SignalAdaptive     = true;
extern bool   Interpolate        = true;

extern bool   alertsOn           = false;
extern bool   alertsOnSlope      = false;
extern bool   alertsOnCurrent    = true;
extern bool   alertsMessage      = true;
extern bool   alertsSound        = false;
extern bool   alertsEmail        = false;

extern bool   arrowsVisible      = false;
extern bool   arrowsOnSlope      = false;
extern string arrowsIdentifier   = "omacd Arrows1";
extern double arrowsDisplacement = 1.0;
extern color  arrowsUpColor      = LimeGreen;
extern color  arrowsDnColor      = Red;
extern int    arrowsUpCode       = 241;
extern int    arrowsDnCode       = 242;

//
//
//
//
//

double macd[];
double signal[];
double Upa[];
double Upb[];
double Dna[];
double Dnb[];
double trend[];
double slope[];
double stored[][21];

//
//
//
//
//

string indicatorFileName;
bool   calculateValue;
bool   returnBars;
int    timeFrame;

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int init()
{
   IndicatorBuffers(8);
   SetIndexBuffer(0,Dna);   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(1,Dnb);   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(2,Upa);   SetIndexStyle(2,DRAW_HISTOGRAM);
   SetIndexBuffer(3,Upb);   SetIndexStyle(3,DRAW_HISTOGRAM);
   SetIndexBuffer(4,macd);
   SetIndexBuffer(5,signal);
   SetIndexBuffer(6,trend);
   SetIndexBuffer(7,slope);
   SetLevelValue(0,0);
   
      //
      //
      //
      //
      //
   
      FastLength        = MathMax(FastLength,   1);
      FastSpeed         = MathMax(FastSpeed ,-1.5);
      SlowLength        = MathMax(SlowLength,   1);
      SlowSpeed         = MathMax(SlowSpeed ,-1.5);
      SignalLength      = MathMax(SignalLength,   1);
      SignalSpeed       = MathMax(SignalSpeed ,-1.5);
      indicatorFileName = WindowExpertName();
      calculateValue    = (TimeFrame=="CalculateValue"); if (calculateValue) return(0);
      returnBars        = (TimeFrame=="returnBars");     if (returnBars)     return(0);
      timeFrame         = stringToTimeFrame(TimeFrame);
   
   IndicatorShortName(timeFrameToString(timeFrame)+" omacd ("+FastLength+","+SlowLength+","+SignalLength+")");
   return(0);
}

//
//
//
//
//

int deinit() { if (!calculateValue && arrowsVisible) deleteArrows();  return(0); }


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int start()
  {
   
   int counted_bars=IndicatorCounted();
   int i,limit;

   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
         limit=MathMin(Bars-counted_bars,Bars-1);
         if (returnBars) { Dna[0] = limit+1; return(0); }
   
   //
   //
   //
   //
   //
   
   if (calculateValue || timeFrame == Period())
   {
      if (ArrayRange(stored,0) != Bars) ArrayResize(stored,Bars);
      for(i=limit; i>=0; i--)
      {
      
         macd[i] = iAverage(getPrice(FastPrice,i),FastLength,FastSpeed,FastAdaptive,i,0)-
                   iAverage(getPrice(SlowPrice,i),SlowLength,SlowSpeed,SlowAdaptive,i,7);
                   
         if (SignalLength>1)
         signal[i] = iAverage(macd[i],SignalLength,SignalSpeed,SignalAdaptive,i,14);
         
         Dna[i]    = EMPTY_VALUE;
         Dnb[i]    = EMPTY_VALUE;
         Upa[i]    = EMPTY_VALUE;
         Upb[i]    = EMPTY_VALUE;
         trend[i]  = trend[i+1];
         slope[i]  = slope[i+1];
          
         if (macd[i] > 0)         trend[i] =  1;
         if (macd[i] < 0)         trend[i] = -1;
         if (macd[i] > macd[i+1]) slope[i] =  1;
         if (macd[i] < macd[i+1]) slope[i] = -1;
         if (!calculateValue) manageArrow(i); 
          
         //
         //
         //
         //
         //
          
         if (trend[i]== 1 && slope[i] == 1) Upa[i] = macd[i];
         if (trend[i]== 1 && slope[i] ==-1) Upb[i] = macd[i];
         if (trend[i]==-1 && slope[i] ==-1) Dna[i] = macd[i];
         if (trend[i]==-1 && slope[i] == 1) Dnb[i] = macd[i];
                  
      }
      manageAlerts();
      return(0);
      }
      
      //
      //
      //
      //
      //
      
      limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrame,indicatorFileName,"returnBars",0,0)*timeFrame/Period()));
      for(i=limit; i>=0; i--)
      {
         int y = iBarShift(NULL,timeFrame,Time[i]);
            macd[i]   = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",FastLength,FastSpeed,FastPrice,FastAdaptive,SlowLength,SlowSpeed,SlowPrice,SlowAdaptive,SignalLength,SignalSpeed,SignalAdaptive,4,y);
            signal[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",FastLength,FastSpeed,FastPrice,FastAdaptive,SlowLength,SlowSpeed,SlowPrice,SlowAdaptive,SignalLength,SignalSpeed,SignalAdaptive,5,y); 
            trend[i]  = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",FastLength,FastSpeed,FastPrice,FastAdaptive,SlowLength,SlowSpeed,SlowPrice,SlowAdaptive,SignalLength,SignalSpeed,SignalAdaptive,6,y);
            slope[i]  = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",FastLength,FastSpeed,FastPrice,FastAdaptive,SlowLength,SlowSpeed,SlowPrice,SlowAdaptive,SignalLength,SignalSpeed,SignalAdaptive,7,y);     
            Dna[i]    = EMPTY_VALUE;
            Dnb[i]    = EMPTY_VALUE;
            Upa[i]    = EMPTY_VALUE;
            Upb[i]    = EMPTY_VALUE;
         
            manageArrow(i);

            //
            //
            //
            //
            //
      
            if (!Interpolate || y==iBarShift(NULL,timeFrame,Time[i-1])) continue;

            //
            //
            //
            //
            //

            datetime time = iTime(NULL,timeFrame,y);
               for(int n = 1; i+n < Bars && Time[i+n] >= time; n++) continue;
               for(int k = 1; k < n; k++)
               {
                  macd[i+k]   = macd[i]   + (macd[i+n]   - macd[i])   * k/n;
                  signal[i+k] = signal[i] + (signal[i+n] - signal[i]) * k/n;
               }
      }
      for (i=limit;i>=0;i--)
      {
         
               if (trend[i] == 1 && slope[i] == 1) Upa[i] = macd[i];
               if (trend[i] == 1 && slope[i] ==-1) Upb[i] = macd[i];
               if (trend[i] ==-1 && slope[i] ==-1) Dna[i] = macd[i];
               if (trend[i] ==-1 && slope[i] == 1) Dnb[i] = macd[i];
                                          
   }
    
   manageAlerts();
return(0);
}

//+------------------------------------------------------------------
//|                                                                  
//+------------------------------------------------------------------
//
//
//
//
//
//

double getPrice(int type, int i)
{
   switch (type)
   {
      case 7:     return((Open[i]+Close[i])/2.0);
      case 8:     return((Open[i]+High[i]+Low[i]+Close[i])/4.0);
      default :   return(iMA(NULL,0,1,0,MODE_SMA,type,i));
   }      
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//
              
#define E1  0
#define E2  1
#define E3  2
#define E4  3
#define E5  4
#define E6  5
#define res 6

//
//
//
//
//

double iAverage(double price, double averagePeriod, double tconst, bool adaptive, int i, int ashift=0)
{
   
   if (averagePeriod <=1) return(price);
   int r = Bars-i-1; 
   
   double e1=stored[r-1][E1+ashift];  double e2=stored[r-1][E2+ashift];
   double e3=stored[r-1][E3+ashift];  double e4=stored[r-1][E4+ashift];
   double e5=stored[r-1][E5+ashift];  double e6=stored[r-1][E6+ashift];

   //
   //
   //
   //
   //

      if (adaptive && (averagePeriod > 1))
      {
         double minPeriod = averagePeriod/2.0;
         double maxPeriod = minPeriod*5.0;
         int    endPeriod = MathCeil(maxPeriod);
         double signal    = MathAbs((price-stored[r-endPeriod][res+ashift]));
         double noise     = 0.00000000001;

            for(int k=1; k<endPeriod; k++) noise=noise+MathAbs(price-stored[r-k][res+ashift]);

         averagePeriod = ((signal/noise)*(maxPeriod-minPeriod))+minPeriod;
      }
      
      //
      //
      //
      //
      //
      
      double alpha = (2.0+tconst)/(1.0+tconst+averagePeriod);

      e1 = e1 + alpha*(price-e1); e2 = e2 + alpha*(e1-e2); double v1 = 1.5 * e1 - 0.5 * e2;
      e3 = e3 + alpha*(v1   -e3); e4 = e4 + alpha*(e3-e4); double v2 = 1.5 * e3 - 0.5 * e4;
      e5 = e5 + alpha*(v2   -e5); e6 = e6 + alpha*(e5-e6); double v3 = 1.5 * e5 - 0.5 * e6;

   //
   //
   //
   //
   //

   stored[r][E1+ashift]  = e1;  stored[r][E2+ashift] = e2;
   stored[r][E3+ashift]  = e3;  stored[r][E4+ashift] = e4;
   stored[r][E5+ashift]  = e5;  stored[r][E6+ashift] = e6;
   stored[r][res+ashift] = price;
   return(v3);
}

//-------------------------------------------------------------------
//
//-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

//
//
//
//
//

int stringToTimeFrame(string tfs)
{
   tfs = StringUpperCase(tfs);
   for (int i=ArraySize(iTfTable)-1; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[i],Period()));
                                                      return(Period());
}

//
//
//
//
//

string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//
//
//
//
//

string StringUpperCase(string str)
{
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--)
   {
      int tchar = StringGetChar(s, length);
         if((tchar > 96 && tchar < 123) || (tchar > 223 && tchar < 256))
                     s = StringSetChar(s, length, tchar - 32);
         else if(tchar > -33 && tchar < 0)
                     s = StringSetChar(s, length, tchar + 224);
   }
   return(s);
}

//
//
//
//
//

void manageAlerts()
{
   if (!calculateValue && alertsOn)
   {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1; whichBar = iBarShift(NULL,0,iTime(NULL,timeFrame,whichBar));
      
      //
      //
      //
      //
      //
      
      if (alertsOnSlope)
      {
         if (slope[whichBar] != slope[whichBar+1])
         {
            if (slope[whichBar] == 1) doAlert(whichBar,"slope changed to up");
            if (slope[whichBar] ==-1) doAlert(whichBar,"slope changed to down");
         }         
      }
      else
      {
         if (trend[whichBar] != trend[whichBar+1])
         {
            if (trend[whichBar] == 1) doAlert(whichBar,"crossed zero line up");
            if (trend[whichBar] ==-1) doAlert(whichBar,"crossed zero line down");
         }         
      }         
   }
}   

//
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
      if (previousAlert != doWhat || previousTime != Time[forBar]) {
          previousAlert  = doWhat;
          previousTime   = Time[forBar];

          //
          //
          //
          //
          //

          message =  StringConcatenate(Symbol()," ",timeFrameToString(timeFrame)," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," Oma Macd oscillator ",doWhat);
             if (alertsMessage) Alert(message);
             if (alertsEmail)   SendMail(StringConcatenate(Symbol(),"Oma Macd"),message);
             if (alertsSound)   PlaySound("alert2.wav");
      }
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

void manageArrow(int i)
{
   if (arrowsVisible)
   {
      deleteArrow(Time[i]);
      if(arrowsOnSlope)
      {
      
         if (slope[i] != slope[i+1])
         {
            if (slope[i] == 1) drawArrow(i,arrowsUpColor,arrowsUpCode,false);
            if (slope[i] ==-1) drawArrow(i,arrowsDnColor,arrowsDnCode, true);
         }         
      }
      else
      {
         if (trend[i] != trend[i+1])
         {
            if (trend[i] == 1) drawArrow(i,arrowsUpColor,arrowsUpCode,false);
            if (trend[i] ==-1) drawArrow(i,arrowsDnColor,arrowsDnCode, true);
         }  
      }         
   }         
}       

//
//
//
//
//

//
//
//
//
//

void drawArrow(int i,color theColor,int theCode,bool up)
{
   string name = arrowsIdentifier+":"+Time[i];
   double gap  = iATR(NULL,0,20,i);   
   
      //
      //
      //
      //
      //
      
      ObjectCreate(name,OBJ_ARROW,0,Time[i],0);
         ObjectSet(name,OBJPROP_ARROWCODE,theCode);
         ObjectSet(name,OBJPROP_COLOR,theColor);
         if (up)
               ObjectSet(name,OBJPROP_PRICE1,High[i] + arrowsDisplacement * gap);
         else  ObjectSet(name,OBJPROP_PRICE1,Low[i]  - arrowsDisplacement * gap);
}

//
//
//
//
//

//
//
//
//
//

void deleteArrows()
{
   string lookFor       = arrowsIdentifier+":";
   int    lookForLength = StringLen(lookFor);
   for (int i=ObjectsTotal()-1; i>=0; i--)
   {
      string objectName = ObjectName(i);
         if (StringSubstr(objectName,0,lookForLength) == lookFor) ObjectDelete(objectName);
   }
}

//
//
//
//
//

void deleteArrow(datetime time)
{
   string lookFor = arrowsIdentifier+":"+time; ObjectDelete(lookFor);
}