
#property copyright "Christian Jungen"
#property link      "christian.jungen@gmx.de"

#property indicator_separate_window
extern int xPosition = 30;
extern int yPosition = 30;
int CornerNr = 0;

extern string _pairs       = "PAIRS (separated by semicolon, no space inbetween please)";
extern string pairs        = "AUDCAD;AUDCHF;AUDJPY;AUDNZD;AUDUSD;CADCHF;CADJPY;CHFJPY;EURAUD;EURCAD;EURCHF;EURGBP;EURJPY;EURNZD;EURUSD;GBPAUD;GBPCAD;GBPCHF;GBPJPY;GBPNZD;GBPUSD;NZDCAD;NZDCHF;NZDJPY;NZDUSD;USDCAD;USDCHF;USDJPY";

extern color ColorText     = SkyBlue;
extern color ColorPositive = Lime;
extern color ColorNegative = DarkOrange;


int numSymbols = 0;
string symbols[];

string shortName    = "Pip Distances Ichimoku Cloud";
int FontSize        = 12;
int window;
int _xPos, _yPos, _corner;



//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
    int i;

   window = -1; // force an initiatization of screen elements

    IndicatorShortName( shortName );

    // --- Split the pairs input string into array of symbols ----

    // extract suffix from current chart symbol
    string suffix = "";
    if ( StringLen(Symbol()) > 6 )
        suffix = StringSubstr(Symbol(),6,StringLen(Symbol())-6);

    pairs = StringUpperCase(StringTrimLeft(StringTrimRight(pairs)));
    if ( StringSubstr(pairs,StringLen(pairs),1) != ";" )
        pairs = pairs + ";";

    int  s = 0;
    string current;

    i = StringFind( pairs, ";", s );
    while ( i > 0 )
    {
        current = StringSubstr(pairs,s,i-s);
        ArrayResize( symbols, ArraySize(symbols) + 1 );
        current = current + suffix;
        if ( iClose(current,0,0) > 0 )
            symbols[ ArraySize(symbols) - 1 ] = current;
        else
            symbols[ ArraySize(symbols) - 1 ] = current + "?";
        s = i + 1;
        i = StringFind( pairs,";",s );
    }
    numSymbols = ArraySize( symbols );


    return(0);
}


//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{
    int i;
  //  ObjectDelete( "MNTITLE" );
    ObjectDelete( "W1TITLE" );
    ObjectDelete( "D1TITLE" );
    ObjectDelete( "H4TITLE" );
    ObjectDelete( "H1TITLE" );
    ObjectDelete( "M30TITLE" );
    ObjectDelete( "M15TITLE" );
    
    for ( i=0; i<numSymbols; i++ )
    {
        ObjectDelete( "LBL"+i );
        ObjectDelete( "M15"+i );
        ObjectDelete( "M30"+i );
        ObjectDelete( "H1"+i );
        ObjectDelete( "H4"+i );
        ObjectDelete( "D1"+i );
        ObjectDelete( "W1"+i );
   ///     ObjectDelete( "MN"+i );
    }

    return(0);
}


//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
    int i;

    window = WindowFind( shortName );
    if ( window != -1 )
    {
        PlaceScreenObjects();
        
   //      for ( i=0; i<numSymbols; i++ )
   //         SetIchimokuText( "MN"+i, symbols[i], PERIOD_MN1 );
             for ( i=0; i<numSymbols; i++ )
            SetIchimokuText( "W1"+i, symbols[i], PERIOD_W1 );
             for ( i=0; i<numSymbols; i++ )
            SetIchimokuText( "D1"+i, symbols[i], PERIOD_D1 );
             for ( i=0; i<numSymbols; i++ )
            SetIchimokuText( "H4"+i, symbols[i], PERIOD_H4);          
             for ( i=0; i<numSymbols; i++ )
            SetIchimokuText( "H1"+i, symbols[i], PERIOD_H1 );
             for ( i=0; i<numSymbols; i++ )
            SetIchimokuText( "M30"+i, symbols[i], PERIOD_M30 );
            for ( i=0; i<numSymbols; i++ )
            SetIchimokuText( "M15"+i, symbols[i], PERIOD_M15 );

    }

    return(0);
}


void PlaceScreenObjects()
{
    int i;

    // --- D1 Title ----
     SetStartPosTextEelements( xPosition+88, yPosition, CornerNr );
    SetTextElement( "M15TITLE", 0, 0 );
    ObjectSetText( "M15TITLE", "M15", FontSize, "FixedSys", ColorText );

    // --- H4 Title ----
     SetStartPosTextEelements( xPosition+130, yPosition, CornerNr );
    SetTextElement( "M30TITLE", 0, 0 );
    ObjectSetText( "M30TITLE", "M30", FontSize, "FixedSys", ColorText );

     SetStartPosTextEelements( xPosition+172, yPosition, CornerNr );
    SetTextElement( "H1TITLE", 0, 0 );
    ObjectSetText( "H1TITLE", "H1", FontSize, "FixedSys", ColorText );
    
     SetStartPosTextEelements( xPosition+214, yPosition, CornerNr );
    SetTextElement( "H4TITLE", 0, 0 );
    ObjectSetText( "H4TITLE", "H4", FontSize, "FixedSys", ColorText );
    
     SetStartPosTextEelements( xPosition+256, yPosition, CornerNr );
    SetTextElement( "D1TITLE", 0, 0 );
    ObjectSetText( "D1TITLE", "D1", FontSize, "FixedSys", ColorText );
    
     SetStartPosTextEelements( xPosition+298, yPosition, CornerNr );
    SetTextElement( "W1TITLE", 0, 0 );
    ObjectSetText( "W1TITLE", "W1", FontSize, "FixedSys", ColorText );
    
  //   SetStartPosTextEelements( xPosition+340, yPosition, CornerNr );
  //  SetTextElement( "MN1TITLE", 0, 0 );
  //  ObjectSetText( "MN1TITLE", "MN1", FontSize, "FixedSys", ColorText );
    // ----
    SetStartPosTextEelements( xPosition, yPosition+12, CornerNr );

    for ( i=0; i<numSymbols; i++ )
        SetTextElement( "LBL"+i, 0, 12 );

    for ( i=0; i<numSymbols; i++ )
        ObjectSetText( "LBL"+i, symbols[i]+" = ", FontSize, "FixedSys", ColorText );

    // ----
    SetStartPosTextEelements( xPosition+64, yPosition+12, CornerNr );

    for ( i=0; i<numSymbols; i++ )
        SetTextElement( "M15"+i, 0, 12 );

    // ----
    SetStartPosTextEelements( xPosition+108, yPosition+12, CornerNr );

    for ( i=0; i<numSymbols; i++ )
        SetTextElement( "M30"+i, 0, 12 );
        
        SetStartPosTextEelements( xPosition+152, yPosition+12, CornerNr );

    for ( i=0; i<numSymbols; i++ )
        SetTextElement( "H1"+i, 0, 12 );
        
        SetStartPosTextEelements( xPosition+196, yPosition+12, CornerNr );

    for ( i=0; i<numSymbols; i++ )
        SetTextElement( "H4"+i, 0, 12 );
        
        
        SetStartPosTextEelements( xPosition+240, yPosition+12, CornerNr );

    for ( i=0; i<numSymbols; i++ )
        SetTextElement( "D1"+i, 0, 12 );
        
        SetStartPosTextEelements( xPosition+284, yPosition+12, CornerNr );

    for ( i=0; i<numSymbols; i++ )
        SetTextElement( "W1"+i, 0, 12 );
        
   //     SetStartPosTextEelements( xPosition+328, yPosition+12, CornerNr );

   // for ( i=0; i<numSymbols; i++ )
   //     SetTextElement( "MN1"+i, 0, 12 );
}


void SetStartPosTextEelements( int xPos, int yPos, int corner )
{
    _xPos = xPos;
    _yPos = yPos;
    _corner = corner;
}

void SetTextElement( string objName, int xDelta, int yDelta )
{
    ObjectCreate( objName, OBJ_LABEL, window, 0, 0 );
    ObjectSet( objName, OBJPROP_CORNER, _corner );
    ObjectSet( objName, OBJPROP_XDISTANCE, _xPos );
    ObjectSet( objName, OBJPROP_YDISTANCE, _yPos );
    _xPos += xDelta;
    _yPos += yDelta;
}


void SetIchimokuText( string objName0, string symbol, int timeFrame )
{
    color Color = ColorPositive;
    string text;

    double close = MarketInfo( symbol, MODE_BID );
    if ( close > 0 )
    {
        double dPoint = MarketInfo( symbol, MODE_POINT );
        if ( dPoint == 0.00001 || dPoint == 0.001 )
            dPoint *= 10;

        double UpKumo = iIchimoku( symbol, timeFrame, 9, 26, 52,  3, 0 );
        double DnKumo = iIchimoku( symbol, timeFrame, 9, 26, 52,  4, 0 );

        double min = MathMin( UpKumo, DnKumo );
        double max = MathMax( UpKumo, DnKumo );


        double dist = 0;
        if ( close < min )
            dist = close - min;
        else if ( close > max )
            dist = close - max;
        dist /= dPoint;

        if ( dist < 0 )
            Color = ColorNegative;

        text = DoubleToStr(dist,0);

        if ( dist > 0 ) // append "+" if dist is positive
            text = "+" + text;

        for ( int i = StringLen(text); i < 5; i++ ) // fillup with spaces to align
            text = " " + text;
    }
    else
        text = "  ???";
    ObjectSetText( objName0, text, FontSize, "FixedSys", Color );
}


string StringUpperCase( string str )
{
    string s = str;
    int lenght = StringLen(str) - 1;
    int c;

    while ( lenght >= 0 )
    {
        c = StringGetChar( s, lenght );

        if ( (c > 96 && c < 123) || (c > 223 && c < 256) )
            s = StringSetChar( s, lenght, c - 32 );
        else
            if ( c > -33 && c < 0 )
            s = StringSetChar( s, lenght, c + 224 );
        lenght--;
    }

    return(s);
}





