#property copyright   "http://www.bestexpertadvisors.com"
#property link        "http://www.bestexpertadvisors.com"
#property description "Our amazing premium EAs and new systems are coming soon."
#property description "You can follow us to get the latest news."

#property strict
#property indicator_chart_window

extern double LotSize=1;   // Lot Size
double point;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+

int OnInit()
  {
// Broker digits
   point=Point;
   if((Digits==3) || (Digits==5))
     {
      point*=10;
     }

//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator de-init function                         |
//+------------------------------------------------------------------+  

void OnDeinit(const int reason)
  {
   Comment("");   // Cleanup

   Print(__FUNCTION__,"_UninitReason = ",getUninitReasonText(_UninitReason));
   return;
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+

int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   string CommentString="";
   string DepositCurrency=AccountInfoString(ACCOUNT_CURRENCY);
   
   double PipValue=(((MarketInfo(Symbol(),MODE_TICKVALUE)*point)/MarketInfo(Symbol(),MODE_TICKSIZE))*LotSize);
   double PointValue=PipValue/10;

   CommentString+="\n" + "Your deposit currency: " + DepositCurrency + "\n";
   CommentString+="Lot size requested: " + DoubleToStr(LotSize,2) + "\n";
   CommentString+="-----------------------------------------------------------------\n";
   CommentString+="Value of one point (" + Symbol() + "):  $" + DepositCurrency + " " + DoubleToStr(PointValue,3) + "\n";
   CommentString+="Value of one pip    (" + Symbol() + ") : $" + DepositCurrency + " " + DoubleToStr(PipValue,3) + "\n";
   CommentString+="-----------------------------------------------------------------\n";

   Comment(CommentString);

//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| Custom functions                                                 |
//+------------------------------------------------------------------+

string getUninitReasonText(int reasonCode) // Return reason for De-init function 
  {
   string text="";

   switch(reasonCode)
     {
      case REASON_ACCOUNT:
         text="Account was changed";break;
      case REASON_CHARTCHANGE:
         text="Symbol or timeframe was changed";break;
      case REASON_CHARTCLOSE:
         text="Chart was closed";break;
      case REASON_PARAMETERS:
         text="Input-parameter was changed";break;
      case REASON_RECOMPILE:
         text="Program "+__FILE__+" was recompiled";break;
      case REASON_REMOVE:
         text="Program "+__FILE__+" was removed from chart";break;
      case REASON_TEMPLATE:
         text="New template was applied to chart";break;
      default:text="Another reason";
     }

   return text;
  }
//+------------------------------------------------------------------+
