#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Magenta
#property indicator_width1 3      
#property indicator_color2 Blue
#property indicator_width2 3
extern string    Setting0                     = "HOURS PIVOT";
extern string    Setting1                     = "if use tf:M1(set to 15)and if use tf:M5(set to 30/60)";
extern string    Setting2                     = "if use tf:M15(set to 60)and if use tf:M30/60(set to 240)";
extern int       Hours_setting_timeframe      = 240;
extern bool      Hours                        = true;
extern bool      HoursPivot                   = true;
extern bool      HoursCPR                     = true;
extern bool      Hours_S_R                    = true;
extern bool      Hours_M2_M3                  = true;
extern bool      Hours_M5_M6                  = true;
extern color     fPPColour                    = clrMagenta;
extern color     fSupportColour               = C'85,0,85';//Lime;
extern color     fResistanceColour            = C'85,0,85';//Red;

extern string    Setting3                     = "DAILY PIVOT"; 
extern bool      Daily                        = true;
extern bool      DPP                          = true;
extern bool      CPR                          = true; 
extern bool      incD_S_R                     = true;
extern bool      incD_M2_M3                   = true;
extern bool      incD_M5_M6                   = true;
extern color     PPColour                     = clrTeal;
extern color     SupportColour                = Maroon;
extern color     ResistanceColour             = Blue;

extern string    Setting4                     = "WEEKLY PIVOT";
extern bool      Weekly                       = true;
extern bool      wPivot                       = true; 
extern bool      wCPR                         = true;
extern bool      incW_S_R                     = true;   
extern bool      incW_M2_M3                   = true; 
extern bool      incW_M5_M6                   = true;
extern color     wPPColour                    = clrRed;
extern color     wSupportColour               = C'125,0,0';//Lime;
extern color     wResistanceColour            = C'125,0,0';//Red;

extern string    Setting5                     = "MONTHLY PIVOT";  
extern bool      Monthly                      = true;
extern bool      mPivot                       = true; 
extern bool      mCPR                         = true; 
extern bool      incM_S_R                     = true;    
extern bool      incM_M2_M3                   = true;
extern bool      incM_M5_M6                   = true; 
extern color     mPPColour                    = clrGreen;
extern color     mSupportColour               = C'0,72,0';//Lime;
extern color     mResistanceColour            = C'0,72,0';//Red;

extern string    Setting6                     = "YEARLY PIVOT"; 
extern bool      Yearly                       = true;
extern bool      yPivot                       = true; 
extern bool      yCPR                         = true; 
extern bool      incY_S_R                     = true;   
extern bool      incY_M2_M3                   = true;
extern bool      incY_M5_M6                   = true;
extern color     yPPColour                    = clrAqua;
extern color     ySupportColour               = C'0,139,185';//Lime;
extern color     yResistanceColour            = C'0,139,185';//Red;

extern string    Setting7                     = "BACKGROUND TRUE OR NOT"; 
extern bool      bcg                          = TRUE;  
int    TimeFrame; 
int    tf; 
//---- input parameters
double HPreviousHigh;
double HPreviousLow;
double HPreviousClose;
double DPreviousHigh;
double DPreviousLow;
double DPreviousClose;
double WPreviousHigh;
double WPreviousLow;
double WPreviousClose;
double MPreviousHigh;
double MPreviousLow;
double MPreviousClose;
double YPreviousHigh;
double YPreviousLow;
double YPreviousClose;
double HPeriod_Price[][6];
double DPeriod_Price[][6];
double WPeriod_Price[][6];
double MPeriod_Price[][6];
double YPeriod_Price[][6];
double HPivot,fTC,fBC,HS1,HS2,HR1,HR2,HM6,HM5,HM4,HM1,HM2,HM3,HS3,HR3;
double DPivot,TC,BC,TC1,BC1,DS1,DS2,DR1,DR2,DM6,DM5,DM4,DM1,DM2,DM3,DS3,DR3,DS2a,DR2a,DS3a,DR3a;
double WPivot,wTC,wBC,WS1,WS2,WR1,WR2,WM5,WM6,WM4,WM1,WM2,WM3,WS3,WR3;
double MPivot,mTC,mBC,MS1,MS2,MR1,MR2,MM6,MM5,MM4,MM1,MM2,MM3,MS3,MR3;
double YPivot,yTC,yBC,YS1,YS2,YR1,YR2,YM6,YM5,YM4,YM1,YM2,YM3,YS3,YR3;
double AllLevels[200]; 

double Poin;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
  TimeFrame = MathMax(TimeFrame,_Period);
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
  
   for(int i=0;i<44;i++)
   {
      ObjectDelete("L" + i);
   }
   
   ObjectDelete("HR2");
   ObjectDelete("HR1");
   ObjectDelete("HPP");
   ObjectDelete("HS1");
   ObjectDelete("HS2");
   ObjectDelete("HM4");
   ObjectDelete("HM1");
   ObjectDelete("HM2");
   ObjectDelete("HM3");
   ObjectDelete("HM5");
   ObjectDelete("HM6");
   ObjectDelete("HS3");
   ObjectDelete("HR3");
   ObjectDelete("HTC");
   ObjectDelete("HBC");
      
   ObjectDelete("DR2");
   ObjectDelete("DR1");
   ObjectDelete("DPP");
   ObjectDelete("DS1");
   ObjectDelete("DS2");
   ObjectDelete("DM4");
   ObjectDelete("DM1");
   ObjectDelete("DM2");
   ObjectDelete("DM3");
   ObjectDelete("DM5");
   ObjectDelete("DM6");
   ObjectDelete("DS3");
   ObjectDelete("DR3");
   ObjectDelete("DTP");
   ObjectDelete("DBP");
   ObjectDelete("DCPR1");
   ObjectDelete("DCPR2");
   ObjectDelete("DCPR3");
   ObjectDelete("DCPR4");
   
   ObjectDelete("WR2");
   ObjectDelete("WR1");
   ObjectDelete("WPP");
   ObjectDelete("WS1");
   ObjectDelete("WS2");
   ObjectDelete("WM4");
   ObjectDelete("WM1");
   ObjectDelete("WM2");
   ObjectDelete("WM3");
   ObjectDelete("WM5");
   ObjectDelete("WM6");
   ObjectDelete("WS3");
   ObjectDelete("WR3");
   ObjectDelete("WTC");
   ObjectDelete("WBC");
   
   ObjectDelete("MR2");
   ObjectDelete("MR1");
   ObjectDelete("MPP");
   ObjectDelete("MS1");
   ObjectDelete("MS2");
   ObjectDelete("MM4");
   ObjectDelete("MM1");
   ObjectDelete("MM2");
   ObjectDelete("MM3");
   ObjectDelete("MM5");
   ObjectDelete("MM6");
   ObjectDelete("MS3");
   ObjectDelete("MR3");
   ObjectDelete("MTC");
   ObjectDelete("MBC");
   
   ObjectDelete("YR2");
   ObjectDelete("YR1");
   ObjectDelete("YPP");
   ObjectDelete("YS1");
   ObjectDelete("YS2");
   ObjectDelete("YM4");
   ObjectDelete("YM1");
   ObjectDelete("YM2");
   ObjectDelete("YM3");
   ObjectDelete("YM5");
   ObjectDelete("YM6");
   ObjectDelete("YS3");
   ObjectDelete("YR3");
   ObjectDelete("YTC");
   ObjectDelete("YBC");
   
   ObjectDelete("HPivotLabel");
   ObjectDelete("HR1_Label");
   ObjectDelete("HR2_Label");
   ObjectDelete("HS1_Label");
   ObjectDelete("HS2_Label");
   ObjectDelete("HM4_Label");
   ObjectDelete("HM1_Label");
   ObjectDelete("HM2_Label");
   ObjectDelete("HM3_Label");
   ObjectDelete("HM5_Label");
   ObjectDelete("HM6_Label");
   ObjectDelete("HS3_Label");
   ObjectDelete("HR3_Label");
   ObjectDelete("HTC_Label");
   ObjectDelete("HBC_Label");
   
   ObjectDelete("DPivotLabel");
   ObjectDelete("DR1_Label");
   ObjectDelete("DR2_Label");
   ObjectDelete("DS1_Label");
   ObjectDelete("DS2_Label");
   ObjectDelete("DM4_Label");
   ObjectDelete("DM1_Label");
   ObjectDelete("DM2_Label");
   ObjectDelete("DM3_Label");
   ObjectDelete("DM5_Label");
   ObjectDelete("DM6_Label");
   ObjectDelete("DS3_Label");
   ObjectDelete("DR3_Label");
   ObjectDelete("DTP_Label");
   ObjectDelete("DBP_Label");
   ObjectDelete("DCPR1_Label");
   ObjectDelete("DCPR2_Label");
   ObjectDelete("DCPR3_Label");
   ObjectDelete("DCPR4_Label");
   
   ObjectDelete("WPivotLabel");
   ObjectDelete("WR1_Label");
   ObjectDelete("WR2_Label");
   ObjectDelete("WS1_Label");
   ObjectDelete("WS2_Label");
   ObjectDelete("WM4_Label");
   ObjectDelete("WM1_Label");
   ObjectDelete("WM2_Label");
   ObjectDelete("WM3_Label");
   ObjectDelete("WM5_Label");
   ObjectDelete("WM6_Label");
   ObjectDelete("WS3_Label");
   ObjectDelete("WR3_Label");
   ObjectDelete("WTC_Label");
   ObjectDelete("WBC_Label");
   
   ObjectDelete("MPivotLabel");
   ObjectDelete("MR1_Label");
   ObjectDelete("MR2_Label");
   ObjectDelete("MS1_Label");
   ObjectDelete("MS2_Label");
   ObjectDelete("MM4_Label");
   ObjectDelete("MM1_Label");
   ObjectDelete("MM2_Label");
   ObjectDelete("MM3_Label");
   ObjectDelete("MM5_Label");
   ObjectDelete("MM6_Label");
   ObjectDelete("MS3_Label");
   ObjectDelete("MR3_Label");
   ObjectDelete("MTC_Label");
   ObjectDelete("MBC_Label");
   
   ObjectDelete("YPivotLabel");
   ObjectDelete("YR1_Label");
   ObjectDelete("YR2_Label");
   ObjectDelete("YS1_Label");
   ObjectDelete("YS2_Label");
   ObjectDelete("YM4_Label");
   ObjectDelete("YM1_Label");
   ObjectDelete("YM2_Label");
   ObjectDelete("YM3_Label");
   ObjectDelete("YM5_Label");
   ObjectDelete("YM6_Label");
   ObjectDelete("YS3_Label");
   ObjectDelete("YR3_Label"); 
   ObjectDelete("YTC_Label");
   ObjectDelete("YBC_Label");
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   deinit();
   int counter=0;
   // 4 Hourly
   if(Hours)
   {
      //ArrayInitialize(FHPeriod_Price,0);
      ArrayCopyRates(HPeriod_Price,(Symbol()), Hours_setting_timeframe);

      
      HPreviousHigh  = HPeriod_Price[1][3];
      HPreviousLow   = HPeriod_Price[1][2];
      HPreviousClose = HPeriod_Price[1][4];
      
      HPivot = ((HPreviousHigh + HPreviousLow + HPreviousClose)/3);
      fTC  =  (HPreviousHigh + HPreviousLow)/2;
      fBC  =  fTC-2*(fTC-HPivot);
      
      
      HR1 = (2*HPivot)-HPreviousLow;
      HS1 = (2*HPivot)-HPreviousHigh;     
      HR2 = HPivot+(HPreviousHigh-HPreviousLow);
      HS2 = HPivot-(HPreviousHigh-HPreviousLow);
      
      HM1 = (HS2+HS1)/2;
      
      HM4 = (HR1+HR2)/2;
      HM2 = (HS1+HPivot)/2;
      
      HM3 = (HPivot+HR1)/2;
      
      HR3 = HPreviousHigh+(2*(HPivot-HPreviousLow));
      HS3 = HPreviousLow-2*(HPreviousHigh-HPivot);
          
      HM5  = (HS3+HS2)/2;
      HM6  = (HR2+HR3)/2;
      
      
      AllLevels[75]  = HR1;
      AllLevels[76]  = HS1;
      AllLevels[77]  = HR2;
      AllLevels[78]  = HS2;
      AllLevels[79]  = HM1;
      AllLevels[80]  = HM4;
      AllLevels[81]  = HM2;
      AllLevels[82]  = HM3;
      AllLevels[83]  = HS3;
      AllLevels[84]  = HR3;
      AllLevels[85]  = HM5;
      AllLevels[86]  = HM6;
      AllLevels[87]  = fTC;
      AllLevels[88]  = fBC;
      AllLevels[89]  = HPivot;
      
     if (HoursPivot){
      
      ObjectCreate("HPP", OBJ_TREND,0, HPeriod_Price[0][0],HPivot);
      ObjectSet("HPP",10,false);
      ObjectSet("HPP", OBJPROP_COLOR, fPPColour);
      ObjectSet("HPP", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("HPP",OBJPROP_WIDTH,2);
      ObjectSet("HPP",2,HPeriod_Price[0][0] + 2629743);
      ObjectSet("HPP",3,HPivot);
      ObjectSetText("HPP",Hours_setting_timeframe+"M - PP:" + DoubleToStr(HPivot,4));
      ObjectSet("HPP",OBJPROP_BACK,bcg);}
      
      if (HoursCPR){  
      
      ObjectCreate("HTC", OBJ_TREND,0, HPeriod_Price[0][0],fTC);
      ObjectSet("HTC",10,false);
      ObjectSet("HTC", OBJPROP_COLOR, fPPColour  );
      ObjectSet("HTC", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("HTC",OBJPROP_WIDTH,2);
      ObjectSet("HTC",2,HPeriod_Price[0][0] + 2629743);
      ObjectSet("HTC",3,fTC);
      ObjectSetText("HTC",Hours_setting_timeframe+"M - TC:" + DoubleToStr(fTC,4));
      ObjectSet("HTC",OBJPROP_BACK,bcg);
      
      ObjectCreate("HBC", OBJ_TREND,0, HPeriod_Price[0][0],fBC);
      ObjectSet("HBC",10,false);
      ObjectSet("HBC", OBJPROP_COLOR, fPPColour  );
      ObjectSet("HBC", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("HBC",OBJPROP_WIDTH,2);
      ObjectSet("HBC",2,HPeriod_Price[0][0] + 2629743);
      ObjectSet("HBC",3,fBC);
      ObjectSetText("HBC",Hours_setting_timeframe+"M - BC:" + DoubleToStr(fBC,4));
      ObjectSet("HBC",OBJPROP_BACK,bcg);}
      
      if (Hours_S_R){  
      
      ObjectCreate("HR1", OBJ_TREND,0, HPeriod_Price[0][0],HR1);
      ObjectSet("HR1",10,false);
      ObjectSet("HR1", OBJPROP_COLOR, fResistanceColour);
      ObjectSet("HR1", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("HR1",OBJPROP_WIDTH,1);
      ObjectSet("HR1",2,HPeriod_Price[0][0] + 2629743);
      ObjectSet("HR1",3,HR1);
      ObjectSetText("HR1",Hours_setting_timeframe+"M - R1:" + DoubleToStr(HR1,4));
      ObjectSet("HR1",OBJPROP_BACK,bcg);

      ObjectCreate("HS1", OBJ_TREND,0, HPeriod_Price[0][0],HS1);
      ObjectSet("HS1",10,false);
      ObjectSet("HS1", OBJPROP_COLOR, fSupportColour);
      ObjectSet("HS1", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("HS1",OBJPROP_WIDTH,1);
      ObjectSet("HS1",2,HPeriod_Price[0][0] + 2629743);
      ObjectSet("HS1",3,HS1);
      ObjectSetText("HS1",Hours_setting_timeframe+"M - S1:" + DoubleToStr(HS1,4));
      ObjectSet("HS1",OBJPROP_BACK,bcg);
   
      ObjectCreate("HR2", OBJ_TREND,0, HPeriod_Price[0][0],HR2);
      ObjectSet("HR2",10,false);
      ObjectSet("HR2", OBJPROP_COLOR, fResistanceColour);
      ObjectSet("HR2", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("HR2",OBJPROP_WIDTH,1);
      ObjectSet("HR2",2,HPeriod_Price[0][0] + 2629743);
      ObjectSet("HR2",3,HR2);
      ObjectSetText("HR2",Hours_setting_timeframe+"M - R2:" + DoubleToStr(HR2,4));
      ObjectSet("HR2",OBJPROP_BACK,bcg);
      
      ObjectCreate("HR3", OBJ_TREND,0, HPeriod_Price[0][0],HR3);
      ObjectSet("HR3",10,false);
      ObjectSet("HR3", OBJPROP_COLOR, fResistanceColour);
      ObjectSet("HR3", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("HR3",OBJPROP_WIDTH,1);
      ObjectSet("HR3",2,HPeriod_Price[0][0] + 2629743);
      ObjectSet("HR3",3,HR3);
      ObjectSetText("HR3",Hours_setting_timeframe+"M - R3:" +DoubleToStr(HR3,4));
      ObjectSet("HR3",OBJPROP_BACK,bcg);

      ObjectCreate("HS2", OBJ_TREND,0, HPeriod_Price[0][0],HS2);
      ObjectSet("HS2",10,false);
      ObjectSet("HS2", OBJPROP_COLOR, fSupportColour);
      ObjectSet("HS2", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("HS2",OBJPROP_WIDTH,1);
      ObjectSet("HS2",2,HPeriod_Price[0][0] + 2629743);
      ObjectSet("HS2",3,HS2);
      ObjectSetText("HS2",Hours_setting_timeframe+"M - S2:" + DoubleToStr(HS2,4));
      ObjectSet("HS2",OBJPROP_BACK,bcg);
      
      ObjectCreate("HS3", OBJ_TREND,0, HPeriod_Price[0][0],HS3);
      ObjectSet("HS3",10,false);
      ObjectSet("HS3", OBJPROP_COLOR, fSupportColour);
      ObjectSet("HS3", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("HS3",OBJPROP_WIDTH,1);
      ObjectSet("HS3",2,HPeriod_Price[0][0] + 2629743);
      ObjectSet("HS3",3,HS3);
      ObjectSetText("HS3",Hours_setting_timeframe+"M - S3:" + DoubleToStr(HS3,4));
      ObjectSet("HS3",OBJPROP_BACK,bcg);
      
      ObjectCreate("HM4", OBJ_TREND,0, HPeriod_Price[0][0],HM4);
      ObjectSet("HM4",10,false);
      ObjectSet("HM4", OBJPROP_COLOR, fResistanceColour);
      ObjectSet("HM4", OBJPROP_STYLE, STYLE_DOT);
      ObjectSet("HM4",OBJPROP_WIDTH,0);
      ObjectSet("HM4",2,HPeriod_Price[0][0] + 2629743);
      ObjectSet("HM4",3,HM4);
      ObjectSetText("HM4",Hours_setting_timeframe+"M - mHR2:" + DoubleToStr(HM4,4));
      ObjectSet("HM4",OBJPROP_BACK,bcg);

      ObjectCreate("HM1", OBJ_TREND,0, HPeriod_Price[0][0],HM1);
      ObjectSet("HM1",10,false);
      ObjectSet("HM1", OBJPROP_COLOR, fSupportColour);
      ObjectSet("HM1", OBJPROP_STYLE, STYLE_DOT);
      ObjectSet("HM1",OBJPROP_WIDTH,0);
      ObjectSet("HM1",2,HPeriod_Price[0][0] + 2629743);
      ObjectSet("HM1",3,HM1);
      ObjectSetText("HM1",Hours_setting_timeframe+"M - mHS2:" + DoubleToStr(HM1,4));
      ObjectSet("HM1",OBJPROP_BACK,bcg);}
      
      if(Hours_M2_M3)
      {
         ObjectCreate("HM2", OBJ_TREND,0, HPeriod_Price[0][0],HM2);
         ObjectSet("HM2",10,false);
         ObjectSet("HM2", OBJPROP_COLOR, fSupportColour);
         ObjectSet("HM2", OBJPROP_STYLE, STYLE_DOT);
         ObjectSet("HM2",OBJPROP_WIDTH,0);
         ObjectSet("HM2",2,HPeriod_Price[0][0] + 2629743);
         ObjectSet("HM2",3,HM2);
         ObjectSetText("HM2",Hours_setting_timeframe+"M - mHS1:" + DoubleToStr(HM2,4));
         ObjectSet("HM2",OBJPROP_BACK,bcg);

         ObjectCreate("HM3", OBJ_TREND,0, HPeriod_Price[0][0],HM3);
         ObjectSet("HM3",10,false);
         ObjectSet("HM3", OBJPROP_COLOR, fResistanceColour);
         ObjectSet("HM3", OBJPROP_STYLE, STYLE_DOT);
         ObjectSet("HM3",OBJPROP_WIDTH,0);
         ObjectSet("HM3",2,HPeriod_Price[0][0] + 2629743);
         ObjectSet("HM3",3,HM1);
         ObjectSetText("HM3",Hours_setting_timeframe+"M - mHR1:" + DoubleToStr(HM3,4));
         ObjectSet("HM3",OBJPROP_BACK,bcg);}
         
         if(Hours_M5_M6)
      {   

         ObjectCreate("HM5", OBJ_TREND,0, HPeriod_Price[0][0],HM5);
         ObjectSet("HM5",10,false);
         ObjectSet("HM5", OBJPROP_COLOR, fSupportColour);
         ObjectSet("HM5", OBJPROP_STYLE, STYLE_DOT);
         ObjectSet("HM5",OBJPROP_WIDTH,0);
         ObjectSet("HM5",2,HPeriod_Price[0][0] + 2629743);
         ObjectSet("HM5",3,HM5);
         ObjectSetText("HM5",Hours_setting_timeframe+"M - mHS3:" + DoubleToStr(HM5,4));
         ObjectSet("HM5",OBJPROP_BACK,bcg);

         ObjectCreate("HM6", OBJ_TREND,0, HPeriod_Price[0][0],HM6);
         ObjectSet("HM6",10,false);
         ObjectSet("HM6", OBJPROP_COLOR, fResistanceColour);
         ObjectSet("HM6", OBJPROP_STYLE, STYLE_DOT);
         ObjectSet("HM6",OBJPROP_WIDTH,0);
         ObjectSet("HM6",2,HPeriod_Price[0][0] + 2629743);
         ObjectSet("HM6",3,HM6);
         ObjectSetText("HM6",Hours_setting_timeframe+"M - mHR3:" + DoubleToStr(HM6,4));
         ObjectSet("HM6",OBJPROP_BACK,bcg);
      }     
     
   }   
   
   // Daily
   if(Daily)
   {
      //ArrayInitialize(DPeriod_Price,0);
      ArrayCopyRates(DPeriod_Price,(Symbol()), 1440);
      
      DPreviousHigh  = DPeriod_Price[1][3];
      DPreviousLow   = DPeriod_Price[1][2];
      DPreviousClose = DPeriod_Price[1][4];
      
      DPivot = ((DPreviousHigh + DPreviousLow + DPreviousClose)/3);
      TC  =  (DPreviousHigh + DPreviousLow)/2;
      BC  =  TC-2*(TC-DPivot);
      
      TC1 =  (DPreviousHigh + DPreviousLow)/2;
      BC1 =  (TC1+(2*(TC1-DPivot)));
      
      DR1 = (2*DPivot)-DPreviousLow;
      DS1 = (2*DPivot)-DPreviousHigh;     
      DR2 = DPivot+(DPreviousHigh-DPreviousLow);
      DS2 = DPivot-(DPreviousHigh-DPreviousLow);
      
      DM1 = (DS2+DS1)/2;
      
      DM4 = (DR1+DR2)/2;
      DM2 = (DS1+DPivot)/2;
      
      DM3 = (DPivot+DR1)/2;
      
      DR3 = DPreviousHigh+(2*(DPivot-DPreviousLow));
      DS3 = DPreviousLow-2*(DPreviousHigh-DPivot);
          
      DM5  = (DS3+DS2)/2;
      DM6  = (DR2+DR3)/2;

      
      AllLevels[17]  = DR1;
      AllLevels[18]  = DS1;
      AllLevels[19]  = DR2;
      AllLevels[20]  = DS2;
      AllLevels[21]  = DM1;
      AllLevels[22]  = DM4;
      AllLevels[23]  = DM2;
      AllLevels[24]  = DM3;
      AllLevels[25]  = DS3;
      AllLevels[26]  = DR3;
      AllLevels[27]  = DM5;
      AllLevels[28]  = DM6;
      AllLevels[29]  = TC;
      AllLevels[30]  = BC;
      AllLevels[31]  = TC1;
      AllLevels[32]  = BC1;
      AllLevels[33]  = DPivot;
      
      if (DPP) 
      {
      
      ObjectCreate("DPP", OBJ_TREND,0, DPeriod_Price[0][0],DPivot);
      ObjectSet("DPP",10,false);
      ObjectSet("DPP", OBJPROP_COLOR, PPColour );
      ObjectSet("DPP", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("DPP",OBJPROP_WIDTH,2);
      ObjectSet("DPP",2,DPeriod_Price[0][0] + 2629743);
      ObjectSet("DPP",3,DPivot);
      ObjectSetText("DPP","PP-D1: " + DoubleToStr(DPivot,4));      
      ObjectSet("DPP",OBJPROP_BACK,bcg);
      
   }
   
   
      if (CPR) 
      {
      
      ObjectCreate("DCPR1", OBJ_TREND,0, DPeriod_Price[0][0],TC);
      ObjectSet("DCPR1",10,false);
      ObjectSet("DCPR1", OBJPROP_COLOR, PPColour );
      ObjectSet("DCPR1", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("DCPR1",OBJPROP_WIDTH,2);
      ObjectSet("DCPR1",2,DPeriod_Price[0][0] + 2629743);
      ObjectSet("DCPR1",3,TC);
      ObjectSetText("DCPR1","TC: " + DoubleToStr(TC,4));      
      ObjectSet("DCPR1",OBJPROP_BACK,bcg);
      
      ObjectCreate("DCPR2", OBJ_TREND,0, DPeriod_Price[0][0],BC);
      ObjectSet("DCPR2",10,false);
      ObjectSet("DCPR2", OBJPROP_COLOR, PPColour );
      ObjectSet("DCPR2", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("DCPR2",OBJPROP_WIDTH,2);
      ObjectSet("DCPR2",2,DPeriod_Price[0][0] + 2629743);
      ObjectSet("DCPR2",3,BC);
      ObjectSetText("DCPR2","BC: " + DoubleToStr(BC,4));      
      ObjectSet("DCPR2",OBJPROP_BACK,bcg);
      
   }
      
      
      if (incD_S_R) 
      {

      ObjectCreate("DR1", OBJ_TREND,0, DPeriod_Price[0][0],DR1);
      ObjectSet("DR1",10,false);
      ObjectSet("DR1", OBJPROP_COLOR, ResistanceColour);
      ObjectSet("DR1", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("DR1",OBJPROP_WIDTH,2);
      ObjectSet("DR1",2,DPeriod_Price[0][0] + 2629743);
      ObjectSet("DR1",3,DR1);
      ObjectSetText("DR1","R1-D1: " + DoubleToStr(DR1,4));
      ObjectSet("DR1",OBJPROP_BACK,bcg);

      ObjectCreate("DS1", OBJ_TREND,0, DPeriod_Price[0][0],DS1);
      ObjectSet("DS1",10,false);
      ObjectSet("DS1", OBJPROP_COLOR, SupportColour);
      ObjectSet("DS1", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("DS1",OBJPROP_WIDTH,2);
      ObjectSet("DS1",2,DPeriod_Price[0][0] + 2629743);
      ObjectSet("DS1",3,DS1);
      ObjectSetText("DS1","S1-D1: " + DoubleToStr(DS1,4));
      ObjectSet("DS1",OBJPROP_BACK,bcg);
   
      ObjectCreate("DR2", OBJ_TREND,0, DPeriod_Price[0][0],DR2);
      ObjectSet("DR2",10,false);
      ObjectSet("DR2", OBJPROP_COLOR, ResistanceColour);
      ObjectSet("DR2", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("DR2",OBJPROP_WIDTH,2);
      ObjectSet("DR2",2,DPeriod_Price[0][0] + 2629743);
      ObjectSet("DR2",3,DR2);
      ObjectSetText("DR2","R2-D1: " + DoubleToStr(DR2,4));
      ObjectSet("DR2",OBJPROP_BACK,bcg);
      
      ObjectCreate("DR3", OBJ_TREND,0, DPeriod_Price[0][0],DR3);
      ObjectSet("DR3",10,false);
      ObjectSet("DR3", OBJPROP_COLOR, ResistanceColour);
      ObjectSet("DR3", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("DR3",OBJPROP_WIDTH,2);
      ObjectSet("DR3",2,DPeriod_Price[0][0] + 2629743);
      ObjectSet("DR3",3,DR3);
      ObjectSetText("DR3","R3-D1: " + DoubleToStr(DR3,4));
      ObjectSet("DR3",OBJPROP_BACK,bcg);

      ObjectCreate("DS2", OBJ_TREND,0, DPeriod_Price[0][0],DS2);
      ObjectSet("DS2",10,false);
      ObjectSet("DS2", OBJPROP_COLOR, SupportColour);
      ObjectSet("DS2", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("DS2",OBJPROP_WIDTH,2);
      ObjectSet("DS2",2,DPeriod_Price[0][0] + 2629743);
      ObjectSet("DS2",3,DS2);
      ObjectSetText("DS2","S2-D1: " + DoubleToStr(DS2,4));
      ObjectSet("DS2",OBJPROP_BACK,bcg);
      
      ObjectCreate("DS3", OBJ_TREND,0, DPeriod_Price[0][0],DS3);
      ObjectSet("DS3",10,false);
      ObjectSet("DS3", OBJPROP_COLOR, SupportColour);
      ObjectSet("DS3", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("DS3",OBJPROP_WIDTH,2);
      ObjectSet("DS3",2,DPeriod_Price[0][0] + 2629743);
      ObjectSet("DS3",3,DS3);
      ObjectSetText("DS3","S3-D1: " + DoubleToStr(DS3,4));
      ObjectSet("DS3",OBJPROP_BACK,bcg);
      
      ObjectCreate("DM4", OBJ_TREND,0, DPeriod_Price[0][0],DM4);
      ObjectSet("DM4",10,false);
      ObjectSet("DM4", OBJPROP_COLOR, ResistanceColour);
      ObjectSet("DM4", OBJPROP_STYLE, STYLE_DOT);
      ObjectSet("DM4",OBJPROP_WIDTH,0);
      ObjectSet("DM4",2,DPeriod_Price[0][0] + 2629743);
      ObjectSet("DM4",3,DM4);
      ObjectSetText("DM4","mR2-D1: " + DoubleToStr(DM4,4));
      ObjectSet("DM4",OBJPROP_BACK,bcg);

      ObjectCreate("DM1", OBJ_TREND,0, DPeriod_Price[0][0],DM1);
      ObjectSet("DM1",10,false);
      ObjectSet("DM1", OBJPROP_COLOR, SupportColour);
      ObjectSet("DM1", OBJPROP_STYLE, STYLE_DOT);
      ObjectSet("DM1",OBJPROP_WIDTH,0);
      ObjectSet("DM1",2,DPeriod_Price[0][0] + 2629743);
      ObjectSet("DM1",3,DM1);
      ObjectSetText("DM1","mS2-D1: " + DoubleToStr(DM1,4));
      ObjectSet("DM1",OBJPROP_BACK,bcg);
      
       }
      
      if(incD_M2_M3)
      {
         ObjectCreate("DM2", OBJ_TREND,0, DPeriod_Price[0][0],DM2);
         ObjectSet("DM2",10,false);
         ObjectSet("DM2", OBJPROP_COLOR, SupportColour);
         ObjectSet("DM2", OBJPROP_STYLE, STYLE_DOT);
         ObjectSet("DM2",OBJPROP_WIDTH,0);
         ObjectSet("DM2",2,DPeriod_Price[0][0] + 2629743);
         ObjectSet("DM2",3,DM2);
         ObjectSetText("DM2","mS1-D1: " + DoubleToStr(DM2,4));
         ObjectSet("DM2",OBJPROP_BACK,bcg);

         ObjectCreate("DM3", OBJ_TREND,0, DPeriod_Price[0][0],DM3);
         ObjectSet("DM3",10,false);
         ObjectSet("DM3", OBJPROP_COLOR, ResistanceColour);
         ObjectSet("DM3", OBJPROP_STYLE, STYLE_DOT);
         ObjectSet("DM3",OBJPROP_WIDTH,0);
         ObjectSet("DM3",2,DPeriod_Price[0][0] + 2629743);
         ObjectSet("DM3",3,DM3);
         ObjectSetText("DM3","mR1-D1: " + DoubleToStr(DM3,4));
         ObjectSet("DM3",OBJPROP_BACK,bcg);
      }   
      
     
      if(incD_M5_M6)
      {
      
         ObjectCreate("DM5", OBJ_TREND,0, DPeriod_Price[0][0],DM5);
         ObjectSet("DM5",10,false);
         ObjectSet("DM5", OBJPROP_COLOR, SupportColour);
         ObjectSet("DM5", OBJPROP_STYLE, STYLE_DOT);
         ObjectSet("DM5",OBJPROP_WIDTH,0);
         ObjectSet("DM5",2,DPeriod_Price[0][0] + 2629743);
         ObjectSet("DM5",3,DM5);
         ObjectSetText("DM5","mS3-D1: " + DoubleToStr(DM5,4));
         ObjectSet("DM5",OBJPROP_BACK,bcg);

         ObjectCreate("DM6", OBJ_TREND,0, DPeriod_Price[0][0],DM6);
         ObjectSet("DM6",10,false);
         ObjectSet("DM6", OBJPROP_COLOR, ResistanceColour);
         ObjectSet("DM6", OBJPROP_STYLE, STYLE_DOT);
         ObjectSet("DM6",OBJPROP_WIDTH,0);
         ObjectSet("DM6",2,DPeriod_Price[0][0] + 2629743);
         ObjectSet("DM6",3,DM6);
         ObjectSetText("DM6","mR3-D1: " + DoubleToStr(DM6,4));
         ObjectSet("DM6",OBJPROP_BACK,bcg);
      }
               
   }
     
   // Weekly
   if(Weekly)
   {
      //ArrayInitialize(WPeriod_Price,0);
      ArrayCopyRates(WPeriod_Price,(Symbol()), 10080);
   
      WPreviousHigh  = WPeriod_Price[1][3];
      WPreviousLow   = WPeriod_Price[1][2];
      WPreviousClose = WPeriod_Price[1][4];

      WPivot = ((WPreviousHigh + WPreviousLow + WPreviousClose)/3);
      wTC  =  (WPreviousHigh + WPreviousLow)/2;
      wBC  =  wTC-(2*(wTC-WPivot));

      WR1 = (2*WPivot)-WPreviousLow;
      WS1 = (2*WPivot)-WPreviousHigh;
      WR2 = WPivot+(WPreviousHigh-WPreviousLow);
      WS2 = WPivot-(WPreviousHigh-WPreviousLow);
      WM1 = (WS2+WS1)/2;
      WM4 = (WR1+WR2)/2;
      WM2 = (WS1+WPivot)/2;
      WM3 = (WPivot+WR1)/2;
      
      WR3 = WPreviousHigh+(2*(WPivot-WPreviousLow));
      WS3 = WPreviousLow-2*(WPreviousHigh-WPivot);
      
      WM5 = (WS3+WS2)/2;
      WM6 = (WR3+WR2)/2;
      
      AllLevels[34] = WR1;
      AllLevels[35] = WS1;
      AllLevels[36] = WR2;
      AllLevels[37] = WS2;
      AllLevels[38] = WM1;
      AllLevels[39] = WM4;
      AllLevels[40] = WM2;
      AllLevels[41] = WM3;
      AllLevels[42] = WS3;
      AllLevels[43] = WR3;
      AllLevels[44] = WM5;
      AllLevels[45] = WM6;
      AllLevels[46] = wTC;
      AllLevels[47] = wBC;
      AllLevels[48] = WPivot;
      
      if (wPivot){
         
      ObjectCreate("WPP", OBJ_TREND,0, WPeriod_Price[0][0],WPivot);
      ObjectSet("WPP",10,false);
      ObjectSet("WPP", OBJPROP_COLOR, wPPColour );
      ObjectSet("WPP", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WPP",OBJPROP_WIDTH,3);
      ObjectSet("WPP",2,WPeriod_Price[0][0] + 2629743);
      ObjectSet("WPP",3,WPivot);
      ObjectSetText("WPP","PP-W1: " + DoubleToStr(WPivot,4));
      ObjectSet("WPP",OBJPROP_BACK,bcg);}
      
       if (wCPR){
         
      ObjectCreate("WTC", OBJ_TREND,0, WPeriod_Price[0][0],wTC);
      ObjectSet("WTC",10,false);
      ObjectSet("WTC", OBJPROP_COLOR, wPPColour );
      ObjectSet("WTC", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WTC",OBJPROP_WIDTH,3);
      ObjectSet("WTC",2,WPeriod_Price[0][0] + 2629743);
      ObjectSet("WTC",3,wTC);
      ObjectSetText("WTC","TC-W1: " + DoubleToStr(wTC,4));
      ObjectSet("WTC",OBJPROP_BACK,bcg);
      
      ObjectCreate("WBC", OBJ_TREND,0, WPeriod_Price[0][0],wBC);
      ObjectSet("WBC",10,false);
      ObjectSet("WBC", OBJPROP_COLOR, wPPColour );
      ObjectSet("WBC", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WBC",OBJPROP_WIDTH,3);
      ObjectSet("WBC",2,WPeriod_Price[0][0] + 2629743);
      ObjectSet("WBC",3,wBC);
      ObjectSetText("WBC","BC-W1: " + DoubleToStr(wBC,4));
      ObjectSet("WBC",OBJPROP_BACK,bcg);
      
      
      }
      
      if (incW_S_R){

      ObjectCreate("WR1", OBJ_TREND,0, WPeriod_Price[0][0],WR1);
      ObjectSet("WR1",10,false);
      ObjectSet("WR1", OBJPROP_COLOR, wResistanceColour);
      ObjectSet("WR1", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WR1",OBJPROP_WIDTH,1);
      ObjectSet("WR1",2,WPeriod_Price[0][0] + 2629743);
      ObjectSet("WR1",3,WR1);
      ObjectSetText("WR1","R1-W1: " + DoubleToStr(WR1,4));
      ObjectSet("WR1",OBJPROP_BACK,bcg);

      ObjectCreate("WS1", OBJ_TREND,0, WPeriod_Price[0][0],WS1);
      ObjectSet("WS1",10,false);
      ObjectSet("WS1", OBJPROP_COLOR, wSupportColour);
      ObjectSet("WS1", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WS1",OBJPROP_WIDTH,1);
      ObjectSet("WS1",2,WPeriod_Price[0][0] + 2629743);
      ObjectSet("WS1",3,WS1);
      ObjectSetText("WS1","S1-W1: " + DoubleToStr(WS1,4));
      ObjectSet("WS1",OBJPROP_BACK,bcg);

      ObjectCreate("WR2", OBJ_TREND,0, WPeriod_Price[0][0],WR2);
      ObjectSet("WR2",10,false);
      ObjectSet("WR2", OBJPROP_COLOR, wResistanceColour);
      ObjectSet("WR2", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WR2",OBJPROP_WIDTH,1);
      ObjectSet("WR2",2,WPeriod_Price[0][0] + 2629743);
      ObjectSet("WR2",3,WR2);
      ObjectSetText("WR2","R2-W1: " + DoubleToStr(WR2,4));
      ObjectSet("WR2",OBJPROP_BACK,bcg);
      
      ObjectCreate("WR3", OBJ_TREND,0, WPeriod_Price[0][0],WR3);
      ObjectSet("WR3",10,false);
      ObjectSet("WR3", OBJPROP_COLOR, wResistanceColour);
      ObjectSet("WR3", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WR3",OBJPROP_WIDTH,1);
      ObjectSet("WR3",2,WPeriod_Price[0][0] + 2629743);
      ObjectSet("WR3",3,WR3);
      ObjectSetText("WR3","R3-W1: " + DoubleToStr(WR3,4));
      ObjectSet("WR3",OBJPROP_BACK,bcg);

      ObjectCreate("WS2", OBJ_TREND,0, WPeriod_Price[0][0],WS2);
      ObjectSet("WS2",10,false);
      ObjectSet("WS2", OBJPROP_COLOR, wSupportColour);
      ObjectSet("WS2", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WS2",OBJPROP_WIDTH,1);
      ObjectSet("WS2",2,WPeriod_Price[0][0] + 2629743);
      ObjectSet("WS2",3,WS2);
      ObjectSetText("WS2","S2-W1: " + DoubleToStr(WS2,4));
      ObjectSet("WS2",OBJPROP_BACK,bcg);
      
      ObjectCreate("WS3", OBJ_TREND,0, WPeriod_Price[0][0],WS3);
      ObjectSet("WS3",10,false);
      ObjectSet("WS3", OBJPROP_COLOR, wSupportColour);
      ObjectSet("WS3", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("WS3",OBJPROP_WIDTH,1);
      ObjectSet("WS3",2,WPeriod_Price[0][0] + 2629743);
      ObjectSet("WS3",3,WS3);
      ObjectSetText("WS3","S3-W1: " + DoubleToStr(WS3,4));
      ObjectSet("WS3",OBJPROP_BACK,bcg);
      
      ObjectCreate("WM4", OBJ_TREND,0, WPeriod_Price[0][0],WM4);
      ObjectSet("WM4",10,false);
      ObjectSet("WM4", OBJPROP_COLOR, wResistanceColour);
      ObjectSet("WM4", OBJPROP_STYLE, STYLE_DASH);
      ObjectSet("WM4",OBJPROP_WIDTH,0);
      ObjectSet("WM4",2,WPeriod_Price[0][0] + 2629743);
      ObjectSet("WM4",3,WM4);
      ObjectSetText("WM4","mR2-W1: " + DoubleToStr(WM4,4));
      ObjectSet("WM4",OBJPROP_BACK,bcg);

      ObjectCreate("WM1", OBJ_TREND,0, WPeriod_Price[0][0],WM1);
      ObjectSet("WM1",10,false);
      ObjectSet("WM1", OBJPROP_COLOR, wSupportColour);
      ObjectSet("WM1", OBJPROP_STYLE, STYLE_DASH);
      ObjectSet("WM1",OBJPROP_WIDTH,0);
      ObjectSet("WM1",2,WPeriod_Price[0][0] + 2629743);
      ObjectSet("WM1",3,WM1);
      ObjectSetText("WM1","mS2-W1: " + DoubleToStr(WM1,4));
      ObjectSet("WM1",OBJPROP_BACK,bcg);}

      
      if(incW_M2_M3)
      {
         ObjectCreate("WM2", OBJ_TREND,0, WPeriod_Price[0][0],WM2);
         ObjectSet("WM2",10,false);
         ObjectSet("WM2", OBJPROP_COLOR, wSupportColour);
         ObjectSet("WM2", OBJPROP_STYLE, STYLE_DASH);
         ObjectSet("WM2",OBJPROP_WIDTH,0);
         ObjectSet("WM2",2,WPeriod_Price[0][0] + 2629743);
         ObjectSet("WM2",3,WM2);
         ObjectSetText("WM2","mS1-W1: " + DoubleToStr(WM2,4));
         ObjectSet("WM2",OBJPROP_BACK,bcg);


         ObjectCreate("WM3", OBJ_TREND,0, WPeriod_Price[0][0],WM3);
         ObjectSet("WM3",10,false);
         ObjectSet("WM3", OBJPROP_COLOR, wResistanceColour);
         ObjectSet("WM3", OBJPROP_STYLE, STYLE_DASH);
         ObjectSet("WM3",OBJPROP_WIDTH,0);
         ObjectSet("WM3",2,WPeriod_Price[0][0] + 2629743);
         ObjectSet("WM3",3,WM3);
         ObjectSetText("WM3","mR1-W1: " + DoubleToStr(WM3,4));
         ObjectSet("WM3",OBJPROP_BACK,bcg);

      }                  
      
       if(incW_M5_M6)
      {
         ObjectCreate("WM5", OBJ_TREND,0, WPeriod_Price[0][0],WM5);
         ObjectSet("WM5",10,false);
         ObjectSet("WM5", OBJPROP_COLOR, wSupportColour);
         ObjectSet("WM5", OBJPROP_STYLE, STYLE_DASH);
         ObjectSet("WM5",OBJPROP_WIDTH,0);
         ObjectSet("WM5",2,WPeriod_Price[0][0] + 2629743);
         ObjectSet("WM5",3,WM5);
         ObjectSetText("WM5","mS3-W1: " + DoubleToStr(WM5,4));
         ObjectSet("WM5",OBJPROP_BACK,bcg);


         ObjectCreate("WM6", OBJ_TREND,0, WPeriod_Price[0][0],WM6);
         ObjectSet("WM6",10,false);
         ObjectSet("WM6", OBJPROP_COLOR, wResistanceColour);
         ObjectSet("WM6", OBJPROP_STYLE, STYLE_DASH);
         ObjectSet("WM6",OBJPROP_WIDTH,0);
         ObjectSet("WM6",2,WPeriod_Price[0][0] + 2629743);
         ObjectSet("WM6",3,WM6);
         ObjectSetText("WM6","mR3-W1: " + DoubleToStr(WM6,4));
         ObjectSet("WM6",OBJPROP_BACK,bcg);

      }                  
      
   }
     
   // Monthly
   if(Monthly)
   {
      //ArrayInitialize(MPeriod_Price,0);
      ArrayCopyRates(MPeriod_Price,(Symbol()), 43200);
   
      MPreviousHigh  = MPeriod_Price[1][3];
      MPreviousLow   = MPeriod_Price[1][2];
      MPreviousClose = MPeriod_Price[1][4];

      MPivot         = ((MPreviousHigh + MPreviousLow + MPreviousClose)/3);
      mTC            = (MPreviousHigh + MPreviousLow)/2;
      mBC            =  mTC-2*(mTC-MPivot);
      

      MR1 = (2*MPivot)-MPreviousLow;
      MS1 = (2*MPivot)-MPreviousHigh;
      MR2 = MPivot+(MPreviousHigh-MPreviousLow);
      MS2 = MPivot-(MPreviousHigh-MPreviousLow);
      MM1 = (MS2+MS1)/2;
      MM4 = (MR1+MR2)/2;
      MM2 = (MS1+MPivot)/2;
      MM3 = (MPivot+MR1)/2;
      MS3 = MS2-(MPreviousHigh-MPreviousLow);
      MR3 = MR2+(MPreviousHigh-MPreviousLow);
     // DR3 = DPreviousHigh+(2*(DPivot-DPreviousLow));
     // DS3 = DPreviousLow-2*(DPreviousHigh-DPivot);
      
     // MR3 = WPreviousHigh+(2*(MPivot-MPreviousLow));
     // MS3 = WPreviousLow-(2*(MPreviousHigh-MPivot));
      MM5 = (MS3+MS2)/2;
      MM6 = (MR2+MR3)/2;
      
      AllLevels[49] = MR1;
      AllLevels[50] = MS1;
      AllLevels[51] = MR2;
      AllLevels[52] = MS2;
      AllLevels[53] = MM1;
      AllLevels[54] = MM4;
      AllLevels[55] = MM2;
      AllLevels[56] = MM3;
      AllLevels[57] = MS3;
      AllLevels[58] = MR3;
      AllLevels[59] = mTC;
      AllLevels[60] = mBC;
      AllLevels[61] = MPivot;
      
      if (mPivot){
      
   
      ObjectCreate("MPP", OBJ_TREND,0, MPeriod_Price[0][0],MPivot);
      ObjectSet("MPP",10,false);
      ObjectSet("MPP", OBJPROP_COLOR, mPPColour );
      ObjectSet("MPP", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("MPP",OBJPROP_WIDTH,2);
      ObjectSet("MPP",2,MPeriod_Price[0][0] + 2629743);
      ObjectSet("MPP",3,MPivot);
      ObjectSetText("MPP","PP-MN: " + DoubleToStr(MPivot,4));
      ObjectSet("MPP",OBJPROP_BACK,bcg);}
      
      if (mCPR){
      ObjectCreate("MTC", OBJ_TREND,0, MPeriod_Price[0][0],mTC);
      ObjectSet("MTC",10,false);
      ObjectSet("MTC", OBJPROP_COLOR, mPPColour );
      ObjectSet("MTC", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("MTC",OBJPROP_WIDTH,2);
      ObjectSet("MTC",2,MPeriod_Price[0][0] + 2629743);
      ObjectSet("MTC",3,mTC);
      ObjectSetText("MTC","TC-MN: " + DoubleToStr(mTC,4));
      ObjectSet("MTC",OBJPROP_BACK,bcg);
      
      ObjectCreate("MBC", OBJ_TREND,0, MPeriod_Price[0][0],mBC);
      ObjectSet("MBC",10,false);
      ObjectSet("MBC", OBJPROP_COLOR, mPPColour );
      ObjectSet("MBC", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("MBC",OBJPROP_WIDTH,2);
      ObjectSet("MBC",2,MPeriod_Price[0][0] + 2629743);
      ObjectSet("MBC",3,mBC);
      ObjectSetText("MBC","BC-MN: " + DoubleToStr(mBC,4));
      ObjectSet("MBC",OBJPROP_BACK,bcg);
      }
      
      if (incM_S_R){ 

      ObjectCreate("MR1", OBJ_TREND,0, MPeriod_Price[0][0],MR1);
      ObjectSet("MR1",10,false);
      ObjectSet("MR1", OBJPROP_COLOR, mResistanceColour);
      ObjectSet("MR1", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("MR1",OBJPROP_WIDTH,1);
      ObjectSet("MR1",2,MPeriod_Price[0][0] + 2629743);
      ObjectSet("MR1",3,MR1);
      ObjectSetText("MR1","R1-MN: " + DoubleToStr(MR1,4));
      ObjectSet("MR1",OBJPROP_BACK,bcg);

      ObjectCreate("MS1", OBJ_TREND,0, MPeriod_Price[0][0],MS1);
      ObjectSet("MS1",10,false);
      ObjectSet("MS1", OBJPROP_COLOR, mSupportColour);
      ObjectSet("MS1", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("MS1",OBJPROP_WIDTH,1);
      ObjectSet("MS1",2,MPeriod_Price[0][0] + 2629743);
      ObjectSet("MS1",3,MS1);
      ObjectSetText("MS1","S1-MN: " + DoubleToStr(MS1,4));
      ObjectSet("MS1",OBJPROP_BACK,bcg);

      ObjectCreate("MR2", OBJ_TREND,0, MPeriod_Price[0][0],MR2);
      ObjectSet("MR2",10,false);
      ObjectSet("MR2", OBJPROP_COLOR, mResistanceColour);
      ObjectSet("MR2", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("MR2",OBJPROP_WIDTH,1);
      ObjectSet("MR2",2,MPeriod_Price[0][0] + 2629743);
      ObjectSet("MR2",3,MR2);
      ObjectSetText("MR2","R2-MN: " + DoubleToStr(MR2,4));
      ObjectSet("MR2",OBJPROP_BACK,bcg);
      
      ObjectCreate("MR3", OBJ_TREND,0, MPeriod_Price[0][0],MR3);
      ObjectSet("MR3",10,false);
      ObjectSet("MR3", OBJPROP_COLOR, mResistanceColour);
      ObjectSet("MR3", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("MR3",OBJPROP_WIDTH,1);
      ObjectSet("MR3",2,MPeriod_Price[0][0] + 2629743);
      ObjectSet("MR3",3,MR3);
      ObjectSetText("MR3","R3-MN: " + DoubleToStr(MR3,4));
      ObjectSet("MR3",OBJPROP_BACK,bcg);

      ObjectCreate("MS2", OBJ_TREND,0, MPeriod_Price[0][0],MS2);
      ObjectSet("MS2",10,false);
      ObjectSet("MS2", OBJPROP_COLOR, mSupportColour);
      ObjectSet("MS2", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("MS2",OBJPROP_WIDTH,1);
      ObjectSet("MS2",2,MPeriod_Price[0][0] + 2629743);
      ObjectSet("MS2",3,MS2);
      ObjectSetText("MS2","S2-MN: " + DoubleToStr(MS2,4));
      ObjectSet("MS1",OBJPROP_BACK,bcg);
      
      ObjectCreate("MS3", OBJ_TREND,0, MPeriod_Price[0][0],MS3);
      ObjectSet("MS3",10,false);
      ObjectSet("MS3", OBJPROP_COLOR, mSupportColour);
      ObjectSet("MS3", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("MS3",OBJPROP_WIDTH,1);
      ObjectSet("MS3",2,MPeriod_Price[0][0] + 2629743);
      ObjectSet("MS3",3,MS3);
      ObjectSetText("MS3","S3-MN: " + DoubleToStr(MS3,4));
      ObjectSet("MS3",OBJPROP_BACK,bcg);
      
      ObjectCreate("MM4", OBJ_TREND,0, MPeriod_Price[0][0],MM4);
      ObjectSet("MM4",10,false);
      ObjectSet("MM4", OBJPROP_COLOR, mResistanceColour);
      ObjectSet("MM4", OBJPROP_STYLE, STYLE_DASH);
      ObjectSet("MM4",OBJPROP_WIDTH,0);
      ObjectSet("MM4",2,MPeriod_Price[0][0] + 2629743);
      ObjectSet("MM4",3,MM4);
      ObjectSetText("MM4","mR2-MN: " + DoubleToStr(MM4,4));
      ObjectSet("MM4",OBJPROP_BACK,bcg);

      ObjectCreate("MM1", OBJ_TREND,0, MPeriod_Price[0][0],MM1);
      ObjectSet("MM1",10,false);
      ObjectSet("MM1", OBJPROP_COLOR, mSupportColour);
      ObjectSet("MM1", OBJPROP_STYLE, STYLE_DASH);
      ObjectSet("MM1",OBJPROP_WIDTH,0);
      ObjectSet("MM1",2,MPeriod_Price[0][0] + 2629743);
      ObjectSet("MM1",3,MM1);
      ObjectSetText("MM1","mS2-MN: " + DoubleToStr(MM1,4));
      ObjectSet("MM1",OBJPROP_BACK,bcg);}
      
      if(incM_M2_M3)
      {
         ObjectCreate("MM2", OBJ_TREND,0, MPeriod_Price[0][0],MM2);
         ObjectSet("MM2",10,false);
         ObjectSet("MM2", OBJPROP_COLOR, mSupportColour);
         ObjectSet("MM2", OBJPROP_STYLE, STYLE_DASH);
         ObjectSet("MM2",OBJPROP_WIDTH,1);
         ObjectSet("MM2",2,MPeriod_Price[0][0] + 2629743);
         ObjectSet("MM2",3,MM2);
         ObjectSetText("MM2","mS1-MN: " + DoubleToStr(MM2,4));
         ObjectSet("MM2",OBJPROP_BACK,bcg);

         ObjectCreate("MM3", OBJ_TREND,0, MPeriod_Price[0][0],MM3);
         ObjectSet("MM3",10,false);
         ObjectSet("MM3", OBJPROP_COLOR, mResistanceColour);
         ObjectSet("MM3", OBJPROP_STYLE, STYLE_DASH);
         ObjectSet("MM3",OBJPROP_WIDTH,1);
         ObjectSet("MM3",2,MPeriod_Price[0][0] + 2629743);
         ObjectSet("MM3",3,MM3);
         ObjectSetText("MM3","mR1-MN: " + DoubleToStr(MM3,4));
         ObjectSet("MM3",OBJPROP_BACK,bcg);
      } 
      
       if(incM_M5_M6)
      {
         ObjectCreate("MM5", OBJ_TREND,0, MPeriod_Price[0][0],MM5);
         ObjectSet("MM5",10,false);
         ObjectSet("MM5", OBJPROP_COLOR, mSupportColour);
         ObjectSet("MM5", OBJPROP_STYLE, STYLE_DASH);
         ObjectSet("MM5",OBJPROP_WIDTH,1);
         ObjectSet("MM5",2,MPeriod_Price[0][0] + 2629743);
         ObjectSet("MM5",3,MM5);
         ObjectSetText("MM5","mS3-MN: " + DoubleToStr(MM5,4));
         ObjectSet("MM5",OBJPROP_BACK,bcg);

         ObjectCreate("MM6", OBJ_TREND,0, MPeriod_Price[0][0],MM6);
         ObjectSet("MM6",10,false);
         ObjectSet("MM6", OBJPROP_COLOR, mResistanceColour);
         ObjectSet("MM6", OBJPROP_STYLE, STYLE_DASH);
         ObjectSet("MM6",OBJPROP_WIDTH,1);
         ObjectSet("MM6",2,MPeriod_Price[0][0] + 2629743);
         ObjectSet("MM6",3,MM6);
         ObjectSetText("MM6","mR3-MN: " + DoubleToStr(MM6,4));
         ObjectSet("MM6",OBJPROP_BACK,bcg);
      }                        
                             
   }
   
   // Yearly
   if(Yearly)
   {
      ArrayCopyRates(YPeriod_Price,(Symbol()), 43200);
   
      int year = Year() - (1);
      double close,high,low=10000;
      for (int x=0;x<30;x++)
      {
         if(TimeYear(YPeriod_Price[x][0]) == year)
         {
            if(YPeriod_Price[x][3] > high)
               high = YPeriod_Price[x][3];
            if(YPeriod_Price[x][2] < low)
               low = YPeriod_Price[x][2];
            if (TimeMonth(YPeriod_Price[x][0]) == 12)
               close = YPeriod_Price[x][4];       
      
         }
      }
      YPreviousHigh  = high;
      YPreviousLow   = low;
      YPreviousClose = close;
    
      YPivot = ((YPreviousHigh + YPreviousLow + YPreviousClose)/3);
      yTC            = (YPreviousHigh + YPreviousLow)/2;
      yBC            =  yTC-2*(yTC-YPivot);
     // yBC            =  YPivot-2*(YPivot-yTC );
      //wTC  =  (WPreviousHigh + WPreviousLow)/2;
     // wBC  =  wTC-(2*(wTC-WPivot));

      YR1 = (2*YPivot)-YPreviousLow;
      YS1 = (2*YPivot)-YPreviousHigh;
      YR2 = YPivot+(YPreviousHigh-YPreviousLow);
      YS2 = YPivot-(YPreviousHigh-YPreviousLow);
      YM1 = (YS2+YS1)/2;
      YM4 = (YR1+YR2)/2;
      YM2 = (YS1+YPivot)/2;
      YM3 = (YPivot+YR1)/2;
      
      YR3 = YPreviousHigh+(2*(YPivot-YPreviousLow));
      YS3 = YPreviousLow-(2*(YPreviousHigh-YPivot));
      
      YM5 = (YS3+YS2)/2;
      YM6 = (YR2+YR3)/2;
      AllLevels[62] = YR1;
      AllLevels[63] = YS1;
      AllLevels[64] = YR2;
      AllLevels[65] = YS2;
      AllLevels[66] = YM1;
      AllLevels[67] = YM4;
      AllLevels[68] = YM2;
      AllLevels[69] = YM3;
      AllLevels[70] = YS3;
      AllLevels[71] = YR3;
      AllLevels[74] = yTC;
      AllLevels[75] = yBC;
      AllLevels[76] = YPivot;
      
      if (yPivot){
   
      ObjectCreate("YPP", OBJ_TREND,0, YPeriod_Price[0][0],YPivot);
      ObjectSet("YPP",10,false);
      ObjectSet("YPP", OBJPROP_COLOR, yPPColour );
      ObjectSet("YPP", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("YPP",OBJPROP_WIDTH,2);
      ObjectSet("YPP",2,YPeriod_Price[0][0] + 2629743);
      ObjectSet("YPP",3,YPivot);
      ObjectSetText("YPP","PP-Y1: " + DoubleToStr(YPivot,4));
      ObjectSet("YPP",OBJPROP_BACK,bcg);}
      
      if (yCPR){
         
      ObjectCreate("YTC", OBJ_TREND,0, WPeriod_Price[0][0],yTC);
      ObjectSet("YTC",10,false);
      ObjectSet("YTC", OBJPROP_COLOR, yPPColour );
      ObjectSet("YTC", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("YTC",OBJPROP_WIDTH,3);
      ObjectSet("YTC",2,WPeriod_Price[0][0] + 2629743);
      ObjectSet("YTC",3,yTC);
      ObjectSetText("YTC","TC-Y1: " + DoubleToStr(yTC,4));
      ObjectSet("YTC",OBJPROP_BACK,bcg);
      
      ObjectCreate("YBC", OBJ_TREND,0, WPeriod_Price[0][0],yBC);
      ObjectSet("YBC",10,false);
      ObjectSet("YBC", OBJPROP_COLOR, yPPColour );
      ObjectSet("YBC", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("YBC",OBJPROP_WIDTH,3);
      ObjectSet("YBC",2,WPeriod_Price[0][0] + 2629743);
      ObjectSet("YBC",3,yBC);
      ObjectSetText("YBC","BC-Y1: " + DoubleToStr(yBC,4));
      ObjectSet("YBC",OBJPROP_BACK,bcg);
      
      
      }
      
       if (incY_S_R){ 

      ObjectCreate("YR1", OBJ_TREND,0, YPeriod_Price[0][0],YR1);
      ObjectSet("YR1",10,false);
      ObjectSet("YR1", OBJPROP_COLOR, yResistanceColour);
      ObjectSet("YR1", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("YR1",OBJPROP_WIDTH,1);
      ObjectSet("YR1",2,YPeriod_Price[0][0] + 2629743);
      ObjectSet("YR1",3,YR1);
      ObjectSetText("YR1","R1-Y1: " + DoubleToStr(YR1,4));
      ObjectSet("YR1",OBJPROP_BACK,bcg);

      ObjectCreate("YS1", OBJ_TREND,0, YPeriod_Price[0][0],YS1);
      ObjectSet("YS1",10,false);
      ObjectSet("YS1", OBJPROP_COLOR, ySupportColour);
      ObjectSet("YS1", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("YS1",OBJPROP_WIDTH,1);
      ObjectSet("YS1",2,YPeriod_Price[0][0] + 2629743);
      ObjectSet("YS1",3,YS1);
      ObjectSetText("YS1","S1-Y1: " + DoubleToStr(YS1,4));
      ObjectSet("YS1",OBJPROP_BACK,bcg);

      ObjectCreate("YR2", OBJ_TREND,0, YPeriod_Price[0][0],YR2);
      ObjectSet("YR2",10,false);
      ObjectSet("YR2", OBJPROP_COLOR, yResistanceColour);
      ObjectSet("YR2", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("YR2",OBJPROP_WIDTH,1);
      ObjectSet("YR2",2,YPeriod_Price[0][0] + 2629743);
      ObjectSet("YR2",3,YR2);
      ObjectSetText("YR2","R2-Y1: " + DoubleToStr(YR2,4));
      ObjectSet("YR2",OBJPROP_BACK,bcg);
      
      ObjectCreate("YR3", OBJ_TREND,0, YPeriod_Price[0][0],YR3);
      ObjectSet("YR3",10,false);
      ObjectSet("YR3", OBJPROP_COLOR, yResistanceColour);
      ObjectSet("YR3", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("YR3",OBJPROP_WIDTH,1);
      ObjectSet("YR3",2,YPeriod_Price[0][0] + 2629743);
      ObjectSet("YR3",3,YR3);
      ObjectSetText("YR3","R3-Y1: " + DoubleToStr(YR3,4));
      ObjectSet("YR3",OBJPROP_BACK,bcg);

      ObjectCreate("YS2", OBJ_TREND,0, YPeriod_Price[0][0],YS2);
      ObjectSet("YS2",10,false);
      ObjectSet("YS2", OBJPROP_COLOR, ySupportColour);
      ObjectSet("YS2", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("YS2",OBJPROP_WIDTH,1);
      ObjectSet("YS2",2,YPeriod_Price[0][0] + 2629743);
      ObjectSet("YS2",3,YS2);
      ObjectSetText("YS2","S2-Y1: " + DoubleToStr(YS2,4));
      ObjectSet("YR2",OBJPROP_BACK,bcg);
      
      ObjectCreate("YS3", OBJ_TREND,0, YPeriod_Price[0][0],YS3);
      ObjectSet("YS3",10,false);
      ObjectSet("YS3", OBJPROP_COLOR, ySupportColour);
      ObjectSet("YS3", OBJPROP_STYLE, STYLE_SOLID);
      ObjectSet("YS3",OBJPROP_WIDTH,1);
      ObjectSet("YS3",2,YPeriod_Price[0][0] + 2629743);
      ObjectSet("YS3",3,YS3);
      ObjectSetText("YS3","S3-Y1: " + DoubleToStr(YS3,4));
      ObjectSet("YS3",OBJPROP_BACK,bcg);
      
      ObjectCreate("YM4", OBJ_TREND,0, YPeriod_Price[0][0],YM4);
      ObjectSet("YM4",10,false);
      ObjectSet("YM4", OBJPROP_COLOR, yResistanceColour);
      ObjectSet("YM4", OBJPROP_STYLE, STYLE_DASH);
      ObjectSet("YM4",OBJPROP_WIDTH,0);
      ObjectSet("YM4",2,YPeriod_Price[0][0] + 2629743);
      ObjectSet("YM4",3,YM4);
      ObjectSetText("YM4","mR2-Y1: " + DoubleToStr(YM4,4));
      ObjectSet("YM4",OBJPROP_BACK,bcg);

      ObjectCreate("YM1", OBJ_TREND,0, YPeriod_Price[0][0],YM1);
      ObjectSet("YM1",10,false);
      ObjectSet("YM1", OBJPROP_COLOR, ySupportColour);
      ObjectSet("YM1", OBJPROP_STYLE, STYLE_DASH);
      ObjectSet("YM1",OBJPROP_WIDTH,0);
      ObjectSet("YM1",2,YPeriod_Price[0][0] + 2629743);
      ObjectSet("YM1",3,YM1);
      ObjectSetText("YM1","mS2-Y1: " + DoubleToStr(YM1,4));
      ObjectSet("YM1",OBJPROP_BACK,bcg);}
      
      if(incY_M2_M3)
      {
         ObjectCreate("YM2", OBJ_TREND,0, YPeriod_Price[0][0],YM2);
         ObjectSet("YM2",10,false);
         ObjectSet("YM2", OBJPROP_COLOR, ySupportColour);
         ObjectSet("YM2", OBJPROP_STYLE, STYLE_DASH);
         ObjectSet("YM2",OBJPROP_WIDTH,0);
         ObjectSet("YM2",2,YPeriod_Price[0][0] + 2629743);
         ObjectSet("YM2",3,YM2);
         ObjectSetText("YM2","mS1-Y1: " + DoubleToStr(YM2,4));
         ObjectSet("YM2",OBJPROP_BACK,bcg);

         ObjectCreate("YM3", OBJ_TREND,0, YPeriod_Price[0][0],YM3);
         ObjectSet("YM3",10,false);
         ObjectSet("YM3", OBJPROP_COLOR, yResistanceColour);
         ObjectSet("YM3", OBJPROP_STYLE, STYLE_DASH);
         ObjectSet("YM3",OBJPROP_WIDTH,0);
         ObjectSet("YM3",2,YPeriod_Price[0][0] + 2629743);
         ObjectSet("YM3",3,YM3);
         ObjectSetText("YM3","mR1-Y1: " + DoubleToStr(YM3,4));
         ObjectSet("YM3",OBJPROP_BACK,bcg);
      }       
      
      if(incY_M5_M6)
      {
         ObjectCreate("YM5", OBJ_TREND,0, YPeriod_Price[0][0],YM5);
         ObjectSet("YM5",10,false);
         ObjectSet("YM5", OBJPROP_COLOR, ySupportColour);
         ObjectSet("YM5", OBJPROP_STYLE, STYLE_DASH);
         ObjectSet("YM5",OBJPROP_WIDTH,0);
         ObjectSet("YM5",2,YPeriod_Price[0][0] + 2629743);
         ObjectSet("YM5",3,YM5);
         ObjectSetText("YM5","mS3-Y1: " + DoubleToStr(YM5,4));
         ObjectSet("YM5",OBJPROP_BACK,bcg);

         ObjectCreate("YM6", OBJ_TREND,0, YPeriod_Price[0][0],YM6);
         ObjectSet("YM6",10,false);
         ObjectSet("YM6", OBJPROP_COLOR, yResistanceColour);
         ObjectSet("YM6", OBJPROP_STYLE, STYLE_DASH);
         ObjectSet("YM6",OBJPROP_WIDTH,0);
         ObjectSet("YM6",2,YPeriod_Price[0][0] + 2629743);
         ObjectSet("YM6",3,YM6);
         ObjectSetText("YM6","mR3-Y1: " + DoubleToStr(YM6,4));
         ObjectSet("YM6",OBJPROP_BACK,bcg);
      } }   
      
       string sTfTable[] = {"M1","M2","M3","M4","M5","M6","M7","M8","M9","M10",
                     "M11","M12","M13","M14","M15","M16","M17","M18","M19","M20",
                     "M21","M22","M23","M24","M25","M26","M27","M28","M29","M30",
                     "M31","M32","M33","M34","M35","M36","M37","M38","M39","M40",
                     "M41","M42","M43","M44","M45","M46","M47","M48","M49","M50",
                     "M51","M52","M53","M54","M55","M56","M57","M58","M59","H1",
                     "M61","M62","M63","M64","M65","M66","M67","M68","M69","M69","M70",
                     "H2","H3","H4","H5","H6","H7","H8","D1","W1","MN"};
int    iTfTable[] = {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
                     26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,
                     49,50,51,52,53,54,55,56,57,58,60,61,62,63,64,65,66,67,68,69,70,
                     120,180,240,300,360,420,480,1440,10080,43200};

//string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return(0);
} 
      
      return(0); 
  }

 

