#property copyright   "http://www.bestexpertadvisors.com"
#property link        "http://www.bestexpertadvisors.com"
#property description "Our amazing premium EAs and new systems are coming soon."
#property description "You can follow us to get the latest news."

//----   --------------------------------------------------------------------+
#property indicator_separate_window
#property indicator_buffers 8
#property indicator_color1 Red
#property indicator_color2 Gold
#property indicator_color3 Aqua
#property indicator_color4 Lime
#property indicator_color5 Brown
#property indicator_color6 Blue
#property indicator_color7 Magenta
#property indicator_color8 DarkGray
#property indicator_minimum 0
#property indicator_maximum 100

//----  ------------------------------------------------------------------------------+
#define Indicator_Name                  "RSI Currency Strength Oscillator"
#define Indicator_Digits                4
#define NumBaskets                      8
#define NumLinesInBasket                6
#define Labels_Corner                   1
#define Labels_OffsetX                  1
#define Labels_FontSize                 1
#define Labels_FontName                 "Arial"

//----   ----------------------------------------------------------------------+
extern int    RSI_Period                      = 14;    //  RSI
extern int    RSI_Price                       = 0;     // (0-6)   RSI.  : 0 = Close, 1 = Open, 2 = High, 3 = Low, 4 = Median, 5 = Typical, 6 = Weighted
extern bool   AutoDetectBaskets               = true;
extern string ____Line_1____________          = "---------------------------------------------";
extern bool   L1_Show                         = true;
extern string L1_Name                         = "USD";
extern bool   L1_S1_Enable                    = true;
extern string L1_S1_Symbol                    = "EURUSD";
extern bool   L1_S1_ReverseDirection          = true;
extern double L1_S1_Weight                    = 1;
extern bool   L1_S2_Enable                    = true;
extern string L1_S2_Symbol                    = "GBPUSD";
extern bool   L1_S2_ReverseDirection          = true;
extern double L1_S2_Weight                    = 1;
extern bool   L1_S3_Enable                    = true;
extern string L1_S3_Symbol                    = "USDJPY";
extern bool   L1_S3_ReverseDirection          = false;
extern double L1_S3_Weight                    = 1;
extern bool   L1_S4_Enable                    = true;
extern string L1_S4_Symbol                    = "USDCHF";
extern bool   L1_S4_ReverseDirection          = false;
extern double L1_S4_Weight                    = 1;
extern bool   L1_S5_Enable                    = false;
extern string L1_S5_Symbol                    = "";
extern bool   L1_S5_ReverseDirection          = false;
extern double L1_S5_Weight                    = 1;
extern bool   L1_S6_Enable                    = false;
extern string L1_S6_Symbol                    = "";
extern bool   L1_S6_ReverseDirection          = false;
extern double L1_S6_Weight                    = 1;
extern string ____Line_2____________          = "---------------------------------------------";
extern bool   L2_Show                         = true;
extern string L2_Name                         = "EUR";
extern bool   L2_S1_Enable                    = true;
extern string L2_S1_Symbol                    = "EURUSD";
extern bool   L2_S1_ReverseDirection          = false;
extern double L2_S1_Weight                    = 1;
extern bool   L2_S2_Enable                    = true;
extern string L2_S2_Symbol                    = "EURGBP";
extern bool   L2_S2_ReverseDirection          = false;
extern double L2_S2_Weight                    = 1;
extern bool   L2_S3_Enable                    = true;
extern string L2_S3_Symbol                    = "EURJPY";
extern bool   L2_S3_ReverseDirection          = false;
extern double L2_S3_Weight                    = 1;
extern bool   L2_S4_Enable                    = true;
extern string L2_S4_Symbol                    = "EURCHF";
extern bool   L2_S4_ReverseDirection          = false;
extern double L2_S4_Weight                    = 1;
extern bool   L2_S5_Enable                    = false;
extern string L2_S5_Symbol                    = "";
extern bool   L2_S5_ReverseDirection          = false;
extern double L2_S5_Weight                    = 1;
extern bool   L2_S6_Enable                    = false;
extern string L2_S6_Symbol                    = "";
extern bool   L2_S6_ReverseDirection          = false;
extern double L2_S6_Weight                    = 1;
extern string ____Line_3____________          = "---------------------------------------------";
extern bool   L3_Show                         = true;
extern string L3_Name                         = "GBP";
extern bool   L3_S1_Enable                    = true;
extern string L3_S1_Symbol                    = "EURGBP";
extern bool   L3_S1_ReverseDirection          = true;
extern double L3_S1_Weight                    = 1;
extern bool   L3_S2_Enable                    = true;
extern string L3_S2_Symbol                    = "GBPUSD";
extern bool   L3_S2_ReverseDirection          = false;
extern double L3_S2_Weight                    = 1;
extern bool   L3_S3_Enable                    = true; 
extern string L3_S3_Symbol                    = "GBPJPY";
extern bool   L3_S3_ReverseDirection          = false;
extern double L3_S3_Weight                    = 1;
extern bool   L3_S4_Enable                    = true; 
extern string L3_S4_Symbol                    = "GBPCHF";
extern bool   L3_S4_ReverseDirection          = false;
extern double L3_S4_Weight                    = 1;
extern bool   L3_S5_Enable                    = false;
extern string L3_S5_Symbol                    = "";
extern bool   L3_S5_ReverseDirection          = false;
extern double L3_S5_Weight                    = 1;
extern bool   L3_S6_Enable                    = false;
extern string L3_S6_Symbol                    = "";
extern bool   L3_S6_ReverseDirection          = false;
extern double L3_S6_Weight                    = 1;
extern string ____Line_4____________          = "---------------------------------------------";
extern bool   L4_Show                         = true;
extern string L4_Name                         = "JPY";
extern bool   L4_S1_Enable                    = true; 
extern string L4_S1_Symbol                    = "EURJPY";
extern bool   L4_S1_ReverseDirection          = true; 
extern double L4_S1_Weight                    = 1;
extern bool   L4_S2_Enable                    = true; 
extern string L4_S2_Symbol                    = "GBPJPY";
extern bool   L4_S2_ReverseDirection          = true; 
extern double L4_S2_Weight                    = 1;
extern bool   L4_S3_Enable                    = true; 
extern string L4_S3_Symbol                    = "USDJPY";
extern bool   L4_S3_ReverseDirection          = true; 
extern double L4_S3_Weight                    = 1;
extern bool   L4_S4_Enable                    = true; 
extern string L4_S4_Symbol                    = "CHFJPY";
extern bool   L4_S4_ReverseDirection          = true; 
extern double L4_S4_Weight                    = 1;
extern bool   L4_S5_Enable                    = false;
extern string L4_S5_Symbol                    = "";
extern bool   L4_S5_ReverseDirection          = false;
extern double L4_S5_Weight                    = 1;
extern bool   L4_S6_Enable                    = false;
extern string L4_S6_Symbol                    = "";
extern bool   L4_S6_ReverseDirection          = false;
extern double L4_S6_Weight                    = 1;
extern string ____Line_5____________          = "---------------------------------------------";
extern bool   L5_Show                         = true;
extern string L5_Name                         = "CHF";
extern bool   L5_S1_Enable                    = true; 
extern string L5_S1_Symbol                    = "EURCHF";
extern bool   L5_S1_ReverseDirection          = true; 
extern double L5_S1_Weight                    = 1;
extern bool   L5_S2_Enable                    = true; 
extern string L5_S2_Symbol                    = "GBPCHF";
extern bool   L5_S2_ReverseDirection          = true; 
extern double L5_S2_Weight                    = 1;
extern bool   L5_S3_Enable                    = true; 
extern string L5_S3_Symbol                    = "CHFJPY";
extern bool   L5_S3_ReverseDirection          = false;
extern double L5_S3_Weight                    = 1;
extern bool   L5_S4_Enable                    = true; 
extern string L5_S4_Symbol                    = "USDCHF";
extern bool   L5_S4_ReverseDirection          = true; 
extern double L5_S4_Weight                    = 1;
extern bool   L5_S5_Enable                    = false;
extern string L5_S5_Symbol                    = "";
extern bool   L5_S5_ReverseDirection          = false;
extern double L5_S5_Weight                    = 1;
extern bool   L5_S6_Enable                    = false;
extern string L5_S6_Symbol                    = "";
extern bool   L5_S6_ReverseDirection          = false;
extern double L5_S6_Weight                    = 1;
extern string ____Line_6____________          = "---------------------------------------------";
extern bool   L6_Show                         = false;
extern string L6_Name                         = "";
extern bool   L6_S1_Enable                    = false;
extern string L6_S1_Symbol                    = "";
extern bool   L6_S1_ReverseDirection          = false;
extern double L6_S1_Weight                    = 1;
extern bool   L6_S2_Enable                    = false;
extern string L6_S2_Symbol                    = "";
extern bool   L6_S2_ReverseDirection          = false;
extern double L6_S2_Weight                    = 1;
extern bool   L6_S3_Enable                    = false;
extern string L6_S3_Symbol                    = "";
extern bool   L6_S3_ReverseDirection          = false;
extern double L6_S3_Weight                    = 1;
extern bool   L6_S4_Enable                    = false;
extern string L6_S4_Symbol                    = "";
extern bool   L6_S4_ReverseDirection          = false;
extern double L6_S4_Weight                    = 1;
extern bool   L6_S5_Enable                    = false;
extern string L6_S5_Symbol                    = "";
extern bool   L6_S5_ReverseDirection          = false;
extern double L6_S5_Weight                    = 1;
extern bool   L6_S6_Enable                    = false;
extern string L6_S6_Symbol                    = "";
extern bool   L6_S6_ReverseDirection          = false;
extern double L6_S6_Weight                    = 1;
extern string ____Line_7____________          = "---------------------------------------------";
extern bool   L7_Show                         = false;
extern string L7_Name                         = "";
extern bool   L7_S1_Enable                    = false;
extern string L7_S1_Symbol                    = "";
extern bool   L7_S1_ReverseDirection          = false;
extern double L7_S1_Weight                    = 1;
extern bool   L7_S2_Enable                    = false;
extern string L7_S2_Symbol                    = "";
extern bool   L7_S2_ReverseDirection          = false;
extern double L7_S2_Weight                    = 1;
extern bool   L7_S3_Enable                    = false;
extern string L7_S3_Symbol                    = "";
extern bool   L7_S3_ReverseDirection          = false;
extern double L7_S3_Weight                    = 1;
extern bool   L7_S4_Enable                    = false;
extern string L7_S4_Symbol                    = "";
extern bool   L7_S4_ReverseDirection          = false;
extern double L7_S4_Weight                    = 1;
extern bool   L7_S5_Enable                    = false;
extern string L7_S5_Symbol                    = "";
extern bool   L7_S5_ReverseDirection          = false;
extern double L7_S5_Weight                    = 1;
extern bool   L7_S6_Enable                    = false;
extern string L7_S6_Symbol                    = "";
extern bool   L7_S6_ReverseDirection          = false;
extern double L7_S6_Weight                    = 1;
extern string ____Line_8____________          = "---------------------------------------------";
extern bool   L8_Show                         = false;
extern string L8_Name                         = "";
extern bool   L8_S1_Enable                    = false;
extern string L8_S1_Symbol                    = "";
extern bool   L8_S1_ReverseDirection          = false;
extern double L8_S1_Weight                    = 1;
extern bool   L8_S2_Enable                    = false;
extern string L8_S2_Symbol                    = "";
extern bool   L8_S2_ReverseDirection          = false;
extern double L8_S2_Weight                    = 1;
extern bool   L8_S3_Enable                    = false;
extern string L8_S3_Symbol                    = "";
extern bool   L8_S3_ReverseDirection          = false;
extern double L8_S3_Weight                    = 1;
extern bool   L8_S4_Enable                    = false;
extern string L8_S4_Symbol                    = "";
extern bool   L8_S4_ReverseDirection          = false;
extern double L8_S4_Weight                    = 1;
extern bool   L8_S5_Enable                    = false;
extern string L8_S5_Symbol                    = "";
extern bool   L8_S5_ReverseDirection          = false;
extern double L8_S5_Weight                    = 1;
extern bool   L8_S6_Enable                    = false;
extern string L8_S6_Symbol                    = "";
extern bool   L8_S6_ReverseDirection          = false;
extern double L8_S6_Weight                    = 1;

//----  --------------------------------------------------------------------------------+
static double Line_1[];
static double Line_2[];
static double Line_3[];
static double Line_4[];
static double Line_5[];
static double Line_6[];
static double Line_7[];
static double Line_8[];

//-----   -----------------------------------------------------------------+
static bool   have_init;
static int    win_index;
static string short_name;
static bool   Basket_Show              [NumBaskets];
static string Basket_Name              [NumBaskets];
static bool   Basket_S_Enable          [NumBaskets][NumLinesInBasket];
static string Basket_S_Symbol          [NumBaskets][NumLinesInBasket];
static bool   Basket_S_ReverseDirection[NumBaskets][NumLinesInBasket];
static double Basket_S_Weight          [NumBaskets][NumLinesInBasket];
static double Basket_S_Weight_percents [NumBaskets][NumLinesInBasket];
static string Basket_labels_objname    [NumBaskets];
static bool   Basket_labels_offset_y   [NumBaskets];
static color  Basket_labels_color      [NumBaskets];

//---------------------------------------------------------------------------------------------+
//---- init -----------------------------------------------------------------------------------+
//---------------------------------------------------------------------------------------------+
int init()
  {
   have_init = true;
   //----   ----------------------------------------------------------------+
   LoadArrays();
   //----  ""   ----------------------------------------------+
   short_name = StringConcatenate(Indicator_Name,"(",DoubleToStr(RSI_Period,0),")");
   if(WindowFind(short_name) >= 0)
     {
      for(int i=1; i<256; i++)
        {
         short_name = StringConcatenate(Indicator_Name,"(",DoubleToStr(RSI_Period,0),") #",DoubleToStr(i,0));
         if(WindowFind(short_name) < 0) break;
        }
     }
   IndicatorShortName(short_name);
   //---- 0   ------------------------------------------------------------+
   IndicatorBuffers(8);
   //----     ----------------------------------------------+
   IndicatorDigits(Indicator_Digits);
   //----      ---------------------------------------------+
   SetIndexBuffer(0,Line_1);
   SetIndexBuffer(1,Line_2);
   SetIndexBuffer(2,Line_3);
   SetIndexBuffer(3,Line_4);
   SetIndexBuffer(4,Line_5);
   SetIndexBuffer(5,Line_6);
   SetIndexBuffer(6,Line_7);
   SetIndexBuffer(7,Line_8);
   for(i=0; i<NumBaskets; i++)
     {
      if(!Basket_Show[i]) SetIndexLabel(i,NULL);
      else
        {
         //----     ----------------------------------------------+
         SetIndexStyle(i,DRAW_LINE,STYLE_SOLID,1);
         //----     --------------------------------------------------+
         SetIndexLabel(i,Basket_Name[i]);
         //----       --------------------------+
         SetIndexDrawBegin(i,RSI_Period);
        }
     }
   //----    --------------------------------------------------------+
   SetLevelStyle(STYLE_DOT,1,White);
   SetLevelValue(0,70.0);
   SetLevelValue(1,50.0);
   SetLevelValue(2,30.0);
   //----   ----------------------------------------------------------------+
   int offset_y = 10;
   for(i=0; i<NumBaskets; i++)
     {
      if(!Basket_Show[i]) continue;
      Basket_labels_objname [i] = StringConcatenate(short_name,"_line",DoubleToStr(i,0));
      Basket_labels_offset_y[i] = offset_y;
      offset_y += 10;
     }
   Basket_labels_color[0] = indicator_color1;
   Basket_labels_color[1] = indicator_color2;
   Basket_labels_color[2] = indicator_color3;
   Basket_labels_color[3] = indicator_color4;
   Basket_labels_color[4] = indicator_color5;
   Basket_labels_color[5] = indicator_color6;
   Basket_labels_color[6] = indicator_color7;
   Basket_labels_color[7] = indicator_color8;
   //----   -----------------------------------------------------------------+
   return(0);
   Print("---- Programming by Serega Lykov, http://mtexperts.narod.ru/ ----");
  }

//---------------------------------------------------------------------------------------------+
//---- deinit ---------------------------------------------------------------------------------+
//---------------------------------------------------------------------------------------------+
int deinit()
  {
   DeleteObjects(short_name);
   return(0);
  }

//---------------------------------------------------------------------------------------------+
//---- start ----------------------------------------------------------------------------------+
//---------------------------------------------------------------------------------------------+
int start()
  {
   //----      -------------------------------------------------+
   if(have_init)
     {
      win_index = WindowFind(short_name);
      have_init = false;
     }
   for(int i=0; i<NumBaskets; i++)
     {
      if(!Basket_Show[i]) continue;
      CreateObjectLabel(Basket_labels_objname[i],Labels_Corner,Labels_OffsetX,Basket_labels_offset_y[i],Labels_FontSize,Basket_labels_color[i],Labels_FontName,win_index,Basket_Name[i]);
     }
   //----        --------------------+
   int counted_bars = IndicatorCounted();
   if(counted_bars < 0) return(-1);
   //----      ------------------------------------------+
   if(counted_bars > 0) counted_bars--;
   int limit = Bars - counted_bars;
   //----    ------------------------------------------------------------+
   CalculateBasket(0,Line_1,limit,0);
   CalculateBasket(1,Line_2,limit,0);
   CalculateBasket(2,Line_3,limit,0);
   CalculateBasket(3,Line_4,limit,0);
   CalculateBasket(4,Line_5,limit,0);
   CalculateBasket(5,Line_6,limit,0);
   CalculateBasket(6,Line_7,limit,0);
   CalculateBasket(7,Line_8,limit,0);
   //----   -----------------------------------------------------------------+
   return(0);
  }
    
//---------------------------------------------------------------------------------------------+
//---- CalculateBasket ------------------------------------------------------------------------+
//---------------------------------------------------------------------------------------------+
void CalculateBasket(int index_of_basket, double& array[], int start_barshift, int finish_barshift)
  {
   for(int i=start_barshift; i>=finish_barshift; i--)
     {
      if(!Basket_Show[index_of_basket]) double basket_value = EMPTY_VALUE;
      else
        {
         basket_value = 0.0;
         for(int k=0; k<NumLinesInBasket; k++)
           {
            if(!Basket_S_Enable[index_of_basket][k]) continue;
            double line = iRSI(Basket_S_Symbol[index_of_basket][k],0,RSI_Period,RSI_Price,i);
            if(Basket_S_ReverseDirection[index_of_basket][k]) line = NormalizeDouble(100.0 - line,Indicator_Digits);
            basket_value += Basket_S_Weight_percents[index_of_basket][k] * line;
           }
        }
      array[i] = basket_value;
     }
  }

//---------------------------------------------------------------------------------------------+
//---- LoadArrays -----------------------------------------------------------------------------+
//---------------------------------------------------------------------------------------------+
void LoadArrays()
  {
   Basket_Show              [0]    = L1_Show;
   Basket_Name              [0]    = L1_Name;
   Basket_S_Enable          [0][0] = L1_S1_Enable;
   Basket_S_Symbol          [0][0] = L1_S1_Symbol;
   Basket_S_ReverseDirection[0][0] = L1_S1_ReverseDirection;
   Basket_S_Weight          [0][0] = L1_S1_Weight;
   Basket_S_Enable          [0][1] = L1_S2_Enable;
   Basket_S_Symbol          [0][1] = L1_S2_Symbol;
   Basket_S_ReverseDirection[0][1] = L1_S2_ReverseDirection;
   Basket_S_Weight          [0][1] = L1_S2_Weight;
   Basket_S_Enable          [0][2] = L1_S3_Enable;
   Basket_S_Symbol          [0][2] = L1_S3_Symbol;
   Basket_S_ReverseDirection[0][2] = L1_S3_ReverseDirection;
   Basket_S_Weight          [0][2] = L1_S3_Weight;
   Basket_S_Enable          [0][3] = L1_S4_Enable;
   Basket_S_Symbol          [0][3] = L1_S4_Symbol;
   Basket_S_ReverseDirection[0][3] = L1_S4_ReverseDirection;
   Basket_S_Weight          [0][3] = L1_S4_Weight;
   Basket_S_Enable          [0][4] = L1_S5_Enable;
   Basket_S_Symbol          [0][4] = L1_S5_Symbol;
   Basket_S_ReverseDirection[0][4] = L1_S5_ReverseDirection;
   Basket_S_Weight          [0][4] = L1_S5_Weight;
   Basket_S_Enable          [0][5] = L1_S6_Enable;
   Basket_S_Symbol          [0][5] = L1_S6_Symbol;
   Basket_S_ReverseDirection[0][5] = L1_S6_ReverseDirection;
   Basket_S_Weight          [0][5] = L1_S6_Weight;
   Basket_Show              [1]    = L2_Show;
   Basket_Name              [1]    = L2_Name;
   Basket_S_Enable          [1][0] = L2_S1_Enable;
   Basket_S_Symbol          [1][0] = L2_S1_Symbol;
   Basket_S_ReverseDirection[1][0] = L2_S1_ReverseDirection;
   Basket_S_Weight          [1][0] = L2_S1_Weight;
   Basket_S_Enable          [1][1] = L2_S2_Enable;
   Basket_S_Symbol          [1][1] = L2_S2_Symbol;
   Basket_S_ReverseDirection[1][1] = L2_S2_ReverseDirection;
   Basket_S_Weight          [1][1] = L2_S2_Weight;
   Basket_S_Enable          [1][2] = L2_S3_Enable;
   Basket_S_Symbol          [1][2] = L2_S3_Symbol;
   Basket_S_ReverseDirection[1][2] = L2_S3_ReverseDirection;
   Basket_S_Weight          [1][2] = L2_S3_Weight;
   Basket_S_Enable          [1][3] = L2_S4_Enable;
   Basket_S_Symbol          [1][3] = L2_S4_Symbol;
   Basket_S_ReverseDirection[1][3] = L2_S4_ReverseDirection;
   Basket_S_Weight          [1][3] = L2_S4_Weight;
   Basket_S_Enable          [1][4] = L2_S5_Enable;
   Basket_S_Symbol          [1][4] = L2_S5_Symbol;
   Basket_S_ReverseDirection[1][4] = L2_S5_ReverseDirection;
   Basket_S_Weight          [1][4] = L2_S5_Weight;
   Basket_S_Enable          [1][5] = L2_S6_Enable;
   Basket_S_Symbol          [1][5] = L2_S6_Symbol;
   Basket_S_ReverseDirection[1][5] = L2_S6_ReverseDirection;
   Basket_S_Weight          [1][5] = L2_S6_Weight;
   Basket_Show              [2]    = L3_Show;
   Basket_Name              [2]    = L3_Name;
   Basket_S_Enable          [2][0] = L3_S1_Enable;
   Basket_S_Symbol          [2][0] = L3_S1_Symbol;
   Basket_S_ReverseDirection[2][0] = L3_S1_ReverseDirection;
   Basket_S_Weight          [2][0] = L3_S1_Weight;
   Basket_S_Enable          [2][1] = L3_S2_Enable;
   Basket_S_Symbol          [2][1] = L3_S2_Symbol;
   Basket_S_ReverseDirection[2][1] = L3_S2_ReverseDirection;
   Basket_S_Weight          [2][1] = L3_S2_Weight;
   Basket_S_Enable          [2][2] = L3_S3_Enable;
   Basket_S_Symbol          [2][2] = L3_S3_Symbol;
   Basket_S_ReverseDirection[2][2] = L3_S3_ReverseDirection;
   Basket_S_Weight          [2][2] = L3_S3_Weight;
   Basket_S_Enable          [2][3] = L3_S4_Enable;
   Basket_S_Symbol          [2][3] = L3_S4_Symbol;
   Basket_S_ReverseDirection[2][3] = L3_S4_ReverseDirection;
   Basket_S_Weight          [2][3] = L3_S4_Weight;
   Basket_S_Enable          [2][4] = L3_S5_Enable;
   Basket_S_Symbol          [2][4] = L3_S5_Symbol;
   Basket_S_ReverseDirection[2][4] = L3_S5_ReverseDirection;
   Basket_S_Weight          [2][4] = L3_S5_Weight;
   Basket_S_Enable          [2][5] = L3_S6_Enable;
   Basket_S_Symbol          [2][5] = L3_S6_Symbol;
   Basket_S_ReverseDirection[2][5] = L3_S6_ReverseDirection;
   Basket_S_Weight          [2][5] = L3_S6_Weight;
   Basket_Show              [3]    = L4_Show;
   Basket_Name              [3]    = L4_Name;
   Basket_S_Enable          [3][0] = L4_S1_Enable;
   Basket_S_Symbol          [3][0] = L4_S1_Symbol;
   Basket_S_ReverseDirection[3][0] = L4_S1_ReverseDirection;
   Basket_S_Weight          [3][0] = L4_S1_Weight;
   Basket_S_Enable          [3][1] = L4_S2_Enable;
   Basket_S_Symbol          [3][1] = L4_S2_Symbol;
   Basket_S_ReverseDirection[3][1] = L4_S2_ReverseDirection;
   Basket_S_Weight          [3][1] = L4_S2_Weight;
   Basket_S_Enable          [3][2] = L4_S3_Enable;
   Basket_S_Symbol          [3][2] = L4_S3_Symbol;
   Basket_S_ReverseDirection[3][2] = L4_S3_ReverseDirection;
   Basket_S_Weight          [3][2] = L4_S3_Weight;
   Basket_S_Enable          [3][3] = L4_S4_Enable;
   Basket_S_Symbol          [3][3] = L4_S4_Symbol;
   Basket_S_ReverseDirection[3][3] = L4_S4_ReverseDirection;
   Basket_S_Weight          [3][3] = L4_S4_Weight;
   Basket_S_Enable          [3][4] = L4_S5_Enable;
   Basket_S_Symbol          [3][4] = L4_S5_Symbol;
   Basket_S_ReverseDirection[3][4] = L4_S5_ReverseDirection;
   Basket_S_Weight          [3][4] = L4_S5_Weight;
   Basket_S_Enable          [3][5] = L4_S6_Enable;
   Basket_S_Symbol          [3][5] = L4_S6_Symbol;
   Basket_S_ReverseDirection[3][5] = L4_S6_ReverseDirection;
   Basket_S_Weight          [3][5] = L4_S6_Weight;
   Basket_Show              [4]    = L5_Show;
   Basket_Name              [4]    = L5_Name;
   Basket_S_Enable          [4][0] = L5_S1_Enable;
   Basket_S_Symbol          [4][0] = L5_S1_Symbol;
   Basket_S_ReverseDirection[4][0] = L5_S1_ReverseDirection;
   Basket_S_Weight          [4][0] = L5_S1_Weight;
   Basket_S_Enable          [4][1] = L5_S2_Enable;
   Basket_S_Symbol          [4][1] = L5_S2_Symbol;
   Basket_S_ReverseDirection[4][1] = L5_S2_ReverseDirection;
   Basket_S_Weight          [4][1] = L5_S2_Weight;
   Basket_S_Enable          [4][2] = L5_S3_Enable;
   Basket_S_Symbol          [4][2] = L5_S3_Symbol;
   Basket_S_ReverseDirection[4][2] = L5_S3_ReverseDirection;
   Basket_S_Weight          [4][2] = L5_S3_Weight;
   Basket_S_Enable          [4][3] = L5_S4_Enable;
   Basket_S_Symbol          [4][3] = L5_S4_Symbol;
   Basket_S_ReverseDirection[4][3] = L5_S4_ReverseDirection;
   Basket_S_Weight          [4][3] = L5_S4_Weight;
   Basket_S_Enable          [4][4] = L5_S5_Enable;
   Basket_S_Symbol          [4][4] = L5_S5_Symbol;
   Basket_S_ReverseDirection[4][4] = L5_S5_ReverseDirection;
   Basket_S_Weight          [4][4] = L5_S5_Weight;
   Basket_S_Enable          [4][5] = L5_S6_Enable;
   Basket_S_Symbol          [4][5] = L5_S6_Symbol;
   Basket_S_ReverseDirection[4][5] = L5_S6_ReverseDirection;
   Basket_S_Weight          [4][5] = L5_S6_Weight;
   Basket_Show              [5]    = L6_Show;
   Basket_Name              [5]    = L6_Name;
   Basket_S_Enable          [5][0] = L6_S1_Enable;
   Basket_S_Symbol          [5][0] = L6_S1_Symbol;
   Basket_S_ReverseDirection[5][0] = L6_S1_ReverseDirection;
   Basket_S_Weight          [5][0] = L6_S1_Weight;
   Basket_S_Enable          [5][1] = L6_S2_Enable;
   Basket_S_Symbol          [5][1] = L6_S2_Symbol;
   Basket_S_ReverseDirection[5][1] = L6_S2_ReverseDirection;
   Basket_S_Weight          [5][1] = L6_S2_Weight;
   Basket_S_Enable          [5][2] = L6_S3_Enable;
   Basket_S_Symbol          [5][2] = L6_S3_Symbol;
   Basket_S_ReverseDirection[5][2] = L6_S3_ReverseDirection;
   Basket_S_Weight          [5][2] = L6_S3_Weight;
   Basket_S_Enable          [5][3] = L6_S4_Enable;
   Basket_S_Symbol          [5][3] = L6_S4_Symbol;
   Basket_S_ReverseDirection[5][3] = L6_S4_ReverseDirection;
   Basket_S_Weight          [5][3] = L6_S4_Weight;
   Basket_S_Enable          [5][4] = L6_S5_Enable;
   Basket_S_Symbol          [5][4] = L6_S5_Symbol;
   Basket_S_ReverseDirection[5][4] = L6_S5_ReverseDirection;
   Basket_S_Weight          [5][4] = L6_S5_Weight;
   Basket_S_Enable          [5][5] = L6_S6_Enable;
   Basket_S_Symbol          [5][5] = L6_S6_Symbol;
   Basket_S_ReverseDirection[5][5] = L6_S6_ReverseDirection;
   Basket_S_Weight          [5][5] = L6_S6_Weight;
   Basket_Show              [6]    = L7_Show;
   Basket_Name              [6]    = L7_Name;
   Basket_S_Enable          [6][0] = L7_S1_Enable;
   Basket_S_Symbol          [6][0] = L7_S1_Symbol;
   Basket_S_ReverseDirection[6][0] = L7_S1_ReverseDirection;
   Basket_S_Weight          [6][0] = L7_S1_Weight;
   Basket_S_Enable          [6][1] = L7_S2_Enable;
   Basket_S_Symbol          [6][1] = L7_S2_Symbol;
   Basket_S_ReverseDirection[6][1] = L7_S2_ReverseDirection;
   Basket_S_Weight          [6][1] = L7_S2_Weight;
   Basket_S_Enable          [6][2] = L7_S3_Enable;
   Basket_S_Symbol          [6][2] = L7_S3_Symbol;
   Basket_S_ReverseDirection[6][2] = L7_S3_ReverseDirection;
   Basket_S_Weight          [6][2] = L7_S3_Weight;
   Basket_S_Enable          [6][3] = L7_S4_Enable;
   Basket_S_Symbol          [6][3] = L7_S4_Symbol;
   Basket_S_ReverseDirection[6][3] = L7_S4_ReverseDirection;
   Basket_S_Weight          [6][3] = L7_S4_Weight;
   Basket_S_Enable          [6][4] = L7_S5_Enable;
   Basket_S_Symbol          [6][4] = L7_S5_Symbol;
   Basket_S_ReverseDirection[6][4] = L7_S5_ReverseDirection;
   Basket_S_Weight          [6][4] = L7_S5_Weight;
   Basket_S_Enable          [6][5] = L7_S6_Enable;
   Basket_S_Symbol          [6][5] = L7_S6_Symbol;
   Basket_S_ReverseDirection[6][5] = L7_S6_ReverseDirection;
   Basket_S_Weight          [6][5] = L7_S6_Weight;
   Basket_Show              [7]    = L8_Show;
   Basket_Name              [7]    = L8_Name;
   Basket_S_Enable          [7][0] = L8_S1_Enable;
   Basket_S_Symbol          [7][0] = L8_S1_Symbol;
   Basket_S_ReverseDirection[7][0] = L8_S1_ReverseDirection;
   Basket_S_Weight          [7][0] = L8_S1_Weight;
   Basket_S_Enable          [7][1] = L8_S2_Enable;
   Basket_S_Symbol          [7][1] = L8_S2_Symbol;
   Basket_S_ReverseDirection[7][1] = L8_S2_ReverseDirection;
   Basket_S_Weight          [7][1] = L8_S2_Weight;
   Basket_S_Enable          [7][2] = L8_S3_Enable;
   Basket_S_Symbol          [7][2] = L8_S3_Symbol;
   Basket_S_ReverseDirection[7][2] = L8_S3_ReverseDirection;
   Basket_S_Weight          [7][2] = L8_S3_Weight;
   Basket_S_Enable          [7][3] = L8_S4_Enable;
   Basket_S_Symbol          [7][3] = L8_S4_Symbol;
   Basket_S_ReverseDirection[7][3] = L8_S4_ReverseDirection;
   Basket_S_Weight          [7][3] = L8_S4_Weight;
   Basket_S_Enable          [7][4] = L8_S5_Enable;
   Basket_S_Symbol          [7][4] = L8_S5_Symbol;
   Basket_S_ReverseDirection[7][4] = L8_S5_ReverseDirection;
   Basket_S_Weight          [7][4] = L8_S5_Weight;
   Basket_S_Enable          [7][5] = L8_S6_Enable;
   Basket_S_Symbol          [7][5] = L8_S6_Symbol;
   Basket_S_ReverseDirection[7][5] = L8_S6_ReverseDirection;
   Basket_S_Weight          [7][5] = L8_S6_Weight;
   if(AutoDetectBaskets)
     {
      int num_active_baskets = 0;
      string symbol = Symbol();
      for(int i=0; i<NumBaskets; i++)
        {
         if(StringLen(Basket_Name[i]) <= 0) Basket_Show[i] = false;
         else
           {
            if(StringFind(symbol,Basket_Name[i]) < 0) Basket_Show[i] = false;
            else Basket_Show[i] = true;
           }
        }
     }
   for(i=0; i<NumBaskets; i++)
     {
      if(!Basket_Show[i]) continue;
      for(int k=0; k<NumLinesInBasket; k++)
        {
         if(!Basket_S_Enable[i][k]) continue;
         Basket_S_Enable[i][k] = StringLen(Basket_S_Symbol[i][k]) > 0;
         if(!Basket_S_Enable[i][k]) continue;
         Basket_S_Enable[i][k] = Basket_S_Weight[i][k] > 0.0;
        }
     }
   for(i=0; i<NumBaskets; i++)
     {
      if(!Basket_Show[i]) continue;
      int num_active_lines = 0;
      for(k=0; k<NumLinesInBasket; k++)
        {
         if(!Basket_S_Enable[i][k]) continue;
         num_active_lines++;
        }
      if(num_active_lines == 0) Basket_Show[i] = false;
     }
   for(i=0; i<NumBaskets; i++)
     {
      if(!Basket_Show[i]) continue;
      double sum_of_weights = 0.0;
      for(k=0; k<NumLinesInBasket; k++)
        {
         if(!Basket_S_Enable[i][k]) continue;
         sum_of_weights += Basket_S_Weight[i][k];
        }
      for(k=0; k<NumLinesInBasket; k++)
        {
         if(!Basket_S_Enable[i][k]) continue;
         Basket_S_Weight_percents[i][k] = Basket_S_Weight[i][k] / sum_of_weights;
        }
     }
  }
 
//---------------------------------------------------------------------------------------------+
//---- DeleteObjects --------------------------------------------------------------------------+
//-------------------------------- programming by Serega Lykov, http://mtexperts.narod.ru/ ----+
//---------------------------------------------------------------------------------------------+
void DeleteObjects(string obj_name_signature, int obj_type=-1)
  {
   int obj_total = ObjectsTotal() - 1;
   for(int i=obj_total; i>=0; i--)
     {
      string obj_name = ObjectName(i);
      if(obj_type >= 0) if(ObjectType(obj_name) != obj_type) continue;
      if(StringFind(obj_name,obj_name_signature,0) != 0) continue;
      ObjectDelete(obj_name);
     }
  }

//---------------------------------------------------------------------------------------------+
//---- CreateObjectLabel ----------------------------------------------------------------------+
//-------------------------------- programming by Serega Lykov, http://mtexperts.narod.ru/ ----+
//---------------------------------------------------------------------------------------------+
void CreateObjectLabel(string obj_name, int corner, int offset_x, int offset_y, int fontsize, color obj_color, string fontname, int obj_window = 0, string obj_text = "")
  {
   if(ObjectFind(obj_name) < 0) ObjectCreate(obj_name,OBJ_LABEL,obj_window,0,0);
   ObjectSet(obj_name,OBJPROP_CORNER,corner);
   ObjectSet(obj_name,OBJPROP_XDISTANCE,offset_x);
   ObjectSet(obj_name,OBJPROP_YDISTANCE,offset_y);
   ObjectSetText(obj_name,obj_text,fontsize,fontname,obj_color);
  }

//-------------------------------- programming by Serega Lykov, http://mtexperts.narod.ru/ ----+