//+------------------------------------------------------------------+
//|                                       RSI_TripleHull_COL.mq4     +
//+------------------------------------------------------------------+

#property copyright "AHGDP"
#property link      "RSI_TripleHull_COL"

#property indicator_separate_window
#property indicator_buffers 5
#property indicator_color1 clrNONE
#property indicator_color2 clrNONE
#property indicator_color3 clrLime
#property indicator_color4 clrRed
#property indicator_color5 clrYellow

    //       SetLevelValue (0,98);//70
    //       SetLevelValue (1,2);//30
    //       SetLevelValue (3,50);
   //        SetLevelStyle (STYLE_DOT,0,C'204,122,72');  //White

#property indicator_maximum 105
#property indicator_minimum -5


extern int      Len            = 4 ;//10

extern bool    Add_Ma          = false;

extern int     MaPer           = 4 ;// 10
extern int     MA_SiEmSmWe3    = 0 ;
extern int     MA_Style        = 2 ;
extern int     MaShift         = 0 ;// 3 = Alan Hull's original shift 24 Nov 2017

extern int     LineSize        = 2 ;
extern int     MaLineSize      = 1 ;
extern int     CountBars       = 600 ; 

string shortName_THC;

double rsi_triple_hullvalue, VelocityRaw, vel_HMA1, vel_HMA2, vel_HMA3, vol_HMA1, vol_HMA3;
double Mixing, MixingC, vel_1A, vel_1B, vel_2A, vel_3A, vol_HMA2;
double vel_3B, vol_1A, vol_1B, vol_2A, vol_2B, vol_3A, vol_3B, vel_2B;

double rsi_triple_hull[];
double SDownBuffer[];
double rsi_triple_hullfast[]; 
double FDownBuffer[];
double MaF[];
//==========================================================================================
int init()
 {
  IndicatorDigits(Digits+6);
  IndicatorBuffers(5);
  SetIndexStyle (0,DRAW_LINE,STYLE_SOLID, LineSize);
  SetIndexBuffer(0,rsi_triple_hull);
  SetIndexStyle (1,DRAW_LINE,STYLE_SOLID, LineSize);
  SetIndexBuffer(1,SDownBuffer);
  
  SetIndexStyle (2,DRAW_LINE,STYLE_SOLID, LineSize);
  SetIndexBuffer(2,rsi_triple_hullfast);
  SetIndexStyle (3,DRAW_LINE,STYLE_SOLID, LineSize);
  SetIndexBuffer(3,FDownBuffer); 
  
  SetIndexStyle (4,DRAW_LINE,MA_Style, MaLineSize);
  SetIndexBuffer(4,MaF);
  
  if((Len + 2.0)!=0)
  Mixing = 3.0 / (Len + 2.0);
  MixingC = 1.0 - Mixing;
  
//===========================================================  

        shortName_THC = ("RSI_TripleHull_COL"); 
        shortName_THC = shortName_THC+"(";
        shortName_THC = shortName_THC+""+DoubleToStr(Len,0);
        shortName_THC = shortName_THC+")";
        IndicatorShortName(shortName_THC);  
        int windowIndex_THC = WindowFind(shortName_THC);
        if(windowIndex_THC < 0)
         
        SetIndexLabel(0,"THS");
        SetIndexLabel(1,"DN");
        SetIndexLabel(2,"THF");
        SetIndexLabel(3,"DN");
        SetIndexLabel(4,"MA");
//===========================================================  
  return(0);
}
//==========================================================================================
int deinit()
{ // Refresh();
return(0);
}
//==========================================================================================
int start()
{  // Refresh();
  int counted_bars=IndicatorCounted(),limit,shift;

  if (counted_bars<0) return(-1);
  if (counted_bars>0) counted_bars--;
  limit=Bars-Len-2;
 //  if(counted_bars>Len) limit=Bars-counted_bars-1;
 
     SetIndexDrawBegin(0,Bars-CountBars);
     SetIndexDrawBegin(1,Bars-CountBars);
     SetIndexDrawBegin(2,Bars-CountBars);
     SetIndexDrawBegin(3,Bars-CountBars); 

//=============HORIZONTAL COLOR LINES method 1 =================================  
 
 //   double indlev1 ,  indlev2; 
 //   switch(Period()) 
 // { case 1:  case 5:  case 15:  case 30:  case 60:  case 240:  case 1440: case 10080:case 43200:
  
 //     indlev1 =70  ;  indlev2= 30  ; break;
 // }   
 //     drawLine_THC(indlev1,  "Up1_THC"   ,  C'204,122,72');
 //    drawLine_THC(indlev2,  "Dn1_THC"   ,  C'204,122,72');
  //    drawLine_THC(50,       "Zer_THC"   ,  BurlyWood    ); 
      
//============================================================================  
    
  for (shift=limit;shift>=0;shift--) {
    VelocityRaw = 100.0*(Close[shift]-Close[shift+1]); // velocity f8 - f10;
    
    //  a Hull MA.
    vel_1A = MixingC * vel_1A + Mixing * VelocityRaw;
    vel_1B = Mixing * vel_1A + MixingC * vel_1B;
    vel_HMA1 = vel_1A * 1.5 - vel_1B * 0.5;

    // another Hull MA
    vel_2A = MixingC * vel_2A + Mixing * vel_HMA1;
    vel_2B = Mixing * vel_2A + MixingC * vel_2B; 
    vel_HMA2 = vel_2A * 1.5 - vel_2B * 0.5;
    
    // Yet another Hull MA; 
    vel_3A = MixingC * vel_3A + Mixing * vel_HMA2;
    vel_3B = Mixing * vel_3A + MixingC * vel_3B;
    vel_HMA3 = vel_3A * 1.5 - vel_3B * 0.5;
    
    // Onto volatility. 
    vol_1A = MixingC * vol_1A + Mixing * MathAbs(VelocityRaw);
    vol_1B = Mixing * vol_1A + MixingC * vol_1B;
    vol_HMA1 = vol_1A * 1.5 - vol_1B * 0.5;

    // Hull MA
    vol_2A = MixingC * vol_2A + Mixing * vol_HMA1;
    vol_2B = Mixing * vol_2A + MixingC * vol_2B;
    vol_HMA2 = vol_2A * 1.5 - vol_2B * 0.5;
    
    // Hull MA
    vol_3A = MixingC * vol_3A + Mixing * vol_HMA2;
    vol_3B = Mixing * vol_3A + MixingC * vol_3B;
    vol_HMA3 = vol_3A * 1.5 - vol_3B * 0.5;
    
    if(vol_HMA3!=0)
    rsi_triple_hull[shift] = (vel_HMA3 / vol_HMA3 + 1.0) * 50.0;
    
    if(vol_HMA2!=0)
    rsi_triple_hullfast[shift] = (vel_HMA2 / vol_HMA2+1.0)*50.0; 
    }
    
    
    for (shift=limit;shift>=0;shift--){
    if (Add_Ma== true)
     MaF[shift] = iMAOnArray(rsi_triple_hullfast,0,MaPer,MaShift,MA_SiEmSmWe3,shift);// ?????? Correct???
   
//=======================  COLOR CODE A =========================================================================================   
   {   
      SDownBuffer[shift] = EMPTY_VALUE;
      
      if   ( rsi_triple_hull[shift + 1] < rsi_triple_hull[shift] )  {SDownBuffer[shift + 1] = SDownBuffer[shift + 1];
                                               SDownBuffer[shift] = SDownBuffer[shift];
           }
     else 
          {  if  (rsi_triple_hull[shift + 1] > rsi_triple_hull[shift])
                 {
                   if (SDownBuffer[shift + 1] == EMPTY_VALUE) SDownBuffer[shift + 1] = rsi_triple_hull[shift + 1];
                                                          SDownBuffer[shift] = rsi_triple_hull[shift];
   }      }      }     
   
//=============  COLOR CODE B ===================================================================================================  
   {   
      FDownBuffer[shift] = EMPTY_VALUE;
      
      if   ( rsi_triple_hullfast[shift + 1] < rsi_triple_hullfast[shift] )  {FDownBuffer[shift + 1] = FDownBuffer[shift + 1];
                                               FDownBuffer[shift] = FDownBuffer[shift];
           }
     else 
          {  if  (rsi_triple_hullfast[shift + 1] > rsi_triple_hullfast[shift])
                 {
                   if (FDownBuffer[shift + 1] == EMPTY_VALUE) FDownBuffer[shift + 1] = rsi_triple_hullfast[shift + 1];
                                                          FDownBuffer[shift] = rsi_triple_hullfast[shift];
   }      }      }           
   
//===============================================================================================================================        
//===============================================================================================================================  
  }
return(0);
}
/*
//================HORIZONTAL COLOR LINES=====================================
void drawLine_THC(double lvl_THC,string name_THC, color Col_THC )
{int indicatorWindow_THC = WindowFind(shortName_THC);
   if(indicatorWindow_THC < 0)
       return;
       
   ObjectDelete(name_THC);
   ObjectCreate(name_THC,    OBJ_HLINE,indicatorWindow_THC, Time[0], lvl_THC,Time[0],lvl_THC);
   ObjectSet   (name_THC   , OBJPROP_STYLE, STYLE_DOT);
   ObjectSet   (name_THC   , OBJPROP_COLOR, Col_THC);        
   ObjectSet   (name_THC   , OBJPROP_WIDTH, 1);
  }  
//====================================================================
void Refresh() 
   {  ObjectDelete("LabA_THC");   
      ObjectDelete("LabB_THC");             
      ObjectDelete("Up1_THC");   
      ObjectDelete("Dn1_THC");   
      ObjectDelete("Zer_THC");     
   }
//===============================================================================================================================  
*/