#property copyright "mladen"
#property link      "mladenfx@gmail.com"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1  Gray
#property indicator_color2  Orange
#property indicator_width2  2
#property indicator_style1  STYLE_DOT

//
//
//
//
//
//

extern int RSIPeriod     = 14;
extern int RSIPrice      = PRICE_CLOSE;
extern int HighLowPeriod = 30;

//
//
//
//
//

double RSIBuffer[];
double HighBuffer[];
double LowBuffer[];
double ZigZagBuffer[];
double ZigZagLow[];
double ZigZagHigh[];

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int init()
{
   IndicatorBuffers(6);
   SetIndexBuffer(0,ZigZagBuffer);
   SetIndexBuffer(1,RSIBuffer);
   SetIndexBuffer(2,HighBuffer);
   SetIndexBuffer(3,LowBuffer);
   SetIndexBuffer(4,ZigZagLow);
   SetIndexBuffer(5,ZigZagHigh);
         SetIndexStyle(0,DRAW_SECTION);
         SetIndexEmptyValue(0,0);
         SetIndexEmptyValue(4,0);
         SetIndexEmptyValue(5,0);
   IndicatorShortName("RSI ("+RSIPeriod+","+HighLowPeriod+")");
   return(0);
}
int deinit()
{
   return(0);
}  

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int start()
{
   int i,lastZag,counted_bars = IndicatorCounted();
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
           int limit=MathMin(Bars-counted_bars,Bars-1);

   //
   //
   //
   //
   //

      for (lastZag=limit+1; lastZag<Bars; lastZag++) if (ZigZagLow[lastZag] != 0 || ZigZagHigh[lastZag] != 0) break;

   //
   //
   //
   //
   //
   
   for(i=limit; i>=0; i--) 
   {
      RSIBuffer[i]  = iRSI(NULL,0,RSIPeriod,RSIPrice,i);
      LowBuffer[i]  = RSIBuffer[ArrayMinimum(RSIBuffer,HighLowPeriod,i)];
      HighBuffer[i] = RSIBuffer[ArrayMaximum(RSIBuffer,HighLowPeriod,i)];

      //
      //
      //
      //
      //
         
         ZigZagLow[i]  = 0;
         ZigZagHigh[i] = 0;
         if (LowBuffer[i] < LowBuffer[i+1])
            {
               if (ZigZagBuffer[lastZag] == LowBuffer[lastZag])
                   ZigZagBuffer[lastZag] = 0;
                   ZigZagBuffer[i]       =  LowBuffer[i];
                   ZigZagLow[i]          =  LowBuffer[i];
                                 lastZag = i;
                                 continue;
            }
         if (HighBuffer[i] > HighBuffer[i+1])
            {
               if (ZigZagBuffer[lastZag] == HighBuffer[lastZag])
                   ZigZagBuffer[lastZag] = 0;
                   ZigZagBuffer[i]       =  HighBuffer[i];
                   ZigZagHigh[i]         =  HighBuffer[i];
                                 lastZag = i;
                                 continue;
            }
         if (ZigZagBuffer[i] != 0)
            {
               ZigZagBuffer[i] = 0;
               for (lastZag=i+1; lastZag<Bars; lastZag++)
               {
                  if (ZigZagLow[lastZag]  != 0) { ZigZagBuffer[lastZag] = ZigZagLow[lastZag];  break; }
                  if (ZigZagHigh[lastZag] != 0) { ZigZagBuffer[lastZag] = ZigZagHigh[lastZag]; break; }
               }
            }
   }

   //
   //
   //
   //
   //
      
   return(0);
}

