//+------------------------------------------------------------------+
//|                                                 StochCandles.mq4 |
//| Colored Candles, based on Stochastic Signal.							|
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, Christof Risch (iya)"
#property link      "http://www.forexfactory.com/showthread.php?t=13321"
#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 Black
#property indicator_color2 Black
#property indicator_color3 Green
#property indicator_color4 Red
#property indicator_width1 2
#property indicator_width2 2
#property indicator_width3 3
#property indicator_width4 3

//---- stoch settings
extern double	Stoch_K			= 8.0,
					Stoch_D			= 3.0,
					Stoch_Slowing	= 3.0,
					Overbought		= 80,
					Oversold			= 20;

//---- input parameters
extern color	BarUp				= Black,
					BarDown			= Black,
					BullCandle		= Green,
					BearCandle		= Red;
extern int		BarWidth			= 2,
					CandleWidth		= 3;

//---- buffers
double Buffer1[];
double Buffer2[];
double Buffer3[];
double Buffer4[];


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
//---- indicators
	SetIndexStyle(0,DRAW_HISTOGRAM,0,BarWidth,BarUp);
	SetIndexStyle(1,DRAW_HISTOGRAM,0,BarWidth,BarDown);
	SetIndexStyle(2,DRAW_HISTOGRAM,0,CandleWidth,BullCandle);
	SetIndexStyle(3,DRAW_HISTOGRAM,0,CandleWidth,BearCandle);
	SetIndexBuffer(0, Buffer1);
	SetIndexBuffer(1, Buffer2);
	SetIndexBuffer(2, Buffer3);
	SetIndexBuffer(3, Buffer4);
	return(0);
}

//+------------------------------------------------------------------+
double Stoch_Main  	(int i = 0)	{return(iStochastic(NULL,0,Stoch_K,Stoch_D,Stoch_Slowing,MODE_SMA,0,MODE_MAIN,  i));}
double Stoch_Signal	(int i = 0)	{return(iStochastic(NULL,0,Stoch_K,Stoch_D,Stoch_Slowing,MODE_SMA,0,MODE_SIGNAL,i));}
//+------------------------------------------------------------------+
bool IsBullCandle(int i = 0)
{
	if(i>=Bars)
		return(false);

	if(High[i]==Low[i])
		return(IsBullCandle(i+1));

	return(Buffer1[i]==High[i] && Buffer2[i]==Low[i]);
}

//+------------------------------------------------------------------+
void SetBullCandle(int i = 0)
{
	Buffer1[i] = High[i];
	Buffer2[i] = Low[i];
	Buffer3[i] = MathMax(Open[i],Close[i]);
	Buffer4[i] = MathMin(Open[i],Close[i]);
}

//+------------------------------------------------------------------+
void SetBearCandle(int i = 0)
{
	Buffer1[i] = Low[i];
	Buffer2[i] = High[i];
	Buffer3[i] = MathMin(Open[i],Close[i]);
	Buffer4[i] = MathMax(Open[i],Close[i]);
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
	for(int i = MathMax(Bars-1-IndicatorCounted(),1); i >= 0; i--)
	{
//		bool		bull = Close[i] > Open[i],
//					bear = Close[i] < Open[i];
		double	stochMain	= Stoch_Main(i),
					stochSignal	= Stoch_Signal(i);
		bool		bull = stochMain > Overbought,
					bear = stochMain < Oversold;

		if(!bull && !bear)
		{
			bull = stochMain > stochSignal;
			bear = stochMain < stochSignal;
		}

		if			(bull)					SetBullCandle(i);
		else if	(bear)					SetBearCandle(i);
		else if	(IsBullCandle(i+1))	SetBullCandle(i);
		else									SetBearCandle(i);
	}

	return(0);
}
//+------------------------------------------------------------------+

