//------------------------------------------------------------------
//
//------------------------------------------------------------------
#property copyright "mladen"
#property link "www.forex-station.com"
#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1  clrLimeGreen
#property indicator_color2  clrGold
#property indicator_width1  2
#property indicator_style2  STYLE_DOT
#property indicator_minimum 0
#property indicator_maximum 100
#property indicator_level1  20
#property indicator_level2  80
#property strict

//
//
//
//
//

extern ENUM_TIMEFRAMES   TimeFrame                  = PERIOD_CURRENT;   // Time frame
input int                RsiPeriod                  = 13;               // Rsi period
input ENUM_APPLIED_PRICE RsiPrice                   = PRICE_CLOSE;      // Rsi price to use
input int                StoPeriod                  = 13;               // Stochastic period
input int                StoSlowing                 = 8;                // Stochastic slowing period
input int                StoSignal                  = 8;                // Stochastic signal
input ENUM_MA_METHOD     StoSignalMethod            = MODE_EMA;         // Stochastic ma method
input bool               alertsOn                   = false;            // Turn alerts on?
input bool               alertsOnCurrent            = false;            // Alerts on still opened bar?
input bool               alertsMessage              = true;             // Alerts should display message?
input bool               alertsOnLevelCross         = true;             // Alerts on level cross?
input bool               alertsOnSignalCross        = true;             // Alerts on signal cross?
input bool               alertsSound                = false;            // Alerts should play a sound?
input bool               alertsNotify               = false;            // Alerts should send a notification?
input bool               alertsEmail                = false;            // Alerts should send an email?
input string             soundFile                  = "alert2.wav";     // Sound file
input double             levUp                      = 80;               // Upper level or overbought
input double             levDn                      = 20;               // Lower level or oversold
input bool               arrowsVisible              = false;            // Show arrows?
input bool               arrowsOnNewest             = false;            // Arrows drawn on newest bar of higher time frame bar true/false?
input string             arrowsIdentifier           = "sto arrows1";    // Arrows ID
input double             arrowsUpperGap             = 0.5;              // Arrows Upper Gap
input double             arrowsLowerGap             = 0.5;              // Arrows lower gap
input bool               arrowsOnLevelCross         = true;             // Show arrows on level cross?
input color              arrowsOnLevelCrossUpColor  = clrLimeGreen;     // Level cross Up arrow color
input color              arrowsOnLevelCrossDnColor  = clrRed;           // Level cross Down arrows color
input int                arrowsOnLevelCrossUpCode   = 241;              // Level cross Up arrow code
input int                arrowsOnLevelCrossDnCode   = 242;              // Level cross Down arrow code
input int                arrowsOnLevelCrossUpSize   = 2;                // Level cross Up arrow size
input int                arrowsOnLevelCrossDnSize   = 2;                // Level cross Down arrow size
input bool               arrowsOnSignalCross        = false;            // Show arrows on signal cross?      
input color              arrowsOnSignalCrossUpColor = clrLimeGreen;     // Signal cross Up arrow color
input color              arrowsOnSignalCrossDnColor = clrRed;           // Signal cross Down arrows color
input int                arrowsOnSignalCrossUpCode  = 159;              // Signal cross Up arrow code
input int                arrowsOnSignalCrossDnCode  = 159;              // Signal cross Down arrow code
input int                arrowsOnSignalCrossUpSize  = 2;                // Signal cross Up arrow size
input int                arrowsOnSignalCrossDnSize  = 2;                // Signal cross Down arrow size  
input bool               Interpolate                = true;             // Interpolate in multi time frame mode

double sto[],sig[],value[],trend[],count[];
string indicatorFileName;
#define _mtfCall(_buff,_ind) iCustom(NULL,TimeFrame,indicatorFileName,PERIOD_CURRENT,RsiPeriod,RsiPrice,StoPeriod,StoSlowing,StoSignal,StoSignalMethod,alertsOn,alertsOnCurrent,alertsMessage,alertsOnLevelCross,alertsOnSignalCross,alertsSound,alertsNotify,alertsEmail,soundFile,levUp,levDn,arrowsVisible,arrowsOnNewest,arrowsIdentifier,arrowsUpperGap,arrowsLowerGap,arrowsOnLevelCross,arrowsOnLevelCrossUpColor,arrowsOnLevelCrossDnColor,arrowsOnLevelCrossUpCode,arrowsOnLevelCrossDnCode,arrowsOnLevelCrossUpSize,arrowsOnLevelCrossDnSize,arrowsOnSignalCross,arrowsOnSignalCrossUpColor,arrowsOnSignalCrossDnColor,arrowsOnSignalCrossUpCode,arrowsOnSignalCrossDnCode,arrowsOnSignalCrossUpSize,arrowsOnSignalCrossDnSize,_buff,_ind)

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int OnInit()
{
   IndicatorBuffers(5);
   SetIndexBuffer(0,sto);  SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(1,sig);  SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(2,value);  
   SetIndexBuffer(3,trend);  
   SetIndexBuffer(4,count);  
   SetLevelValue(0,levUp);
   SetLevelValue(1,levDn);
   
   indicatorFileName = WindowExpertName();
   TimeFrame         = fmax(TimeFrame,_Period);
   
   IndicatorSetString(INDICATOR_SHORTNAME,timeFrameToString(TimeFrame)+" Stochastic RSI ("+(string)RsiPeriod+","+(string)StoPeriod+","+(string)StoSlowing+","+(string)StoSignal+")");
return(INIT_SUCCEEDED);
}  
void OnDeinit(const int reason)
{
   string lookFor       = arrowsIdentifier+":";
   int    lookForLength = StringLen(lookFor);
   for (int i=ObjectsTotal()-1; i>=0; i--)
   {
      string objectName = ObjectName(i);
         if (StringSubstr(objectName,0,lookForLength) == lookFor) ObjectDelete(objectName);
   }
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//`
//
//

int OnCalculate (const int       rates_total,
                 const int       prev_calculated,
                 const datetime& time[],
                 const double&   open[],
                 const double&   high[],
                 const double&   low[],
                 const double&   close[],
                 const long&     tick_volume[],
                 const long&     volume[],
                 const int&      spread[])
{
   int i,limit=fmin(rates_total-prev_calculated+1,rates_total-1); count[0] = limit;
   if (TimeFrame != _Period)
      {
         limit = (int)fmax(limit,fmin(rates_total-1,_mtfCall(4,0)*TimeFrame/_Period));
         for (i=limit;i>=0 && !_StopFlag; i--)
         {
            int y = iBarShift(NULL,TimeFrame,time[i]);
            sto[i] = _mtfCall(0,y);
            sig[i] = _mtfCall(1,y);
         
            //
            //
            //
            //
            //
                  
            if (!Interpolate || (i>0 && y==iBarShift(NULL,TimeFrame,time[i-1]))) continue;
               #define _interpolate(buff) buff[i+k] = buff[i]+(buff[i+n]-buff[i])*k/n
               int n,k; datetime itime = iTime(NULL,TimeFrame,y);
                  for(n = 1; (i+n)<rates_total && time[i+n] >= itime; n++) continue;	
                  for(k = 1; k<n && (i+n)<rates_total && (i+k)<rates_total; k++)
                  {
                     _interpolate(sto);                                         
                     _interpolate(sig); 
                  }                          
         }
   return(rates_total);
   }  

   //
   //
   //
   //
   //

   for (i=limit;i>=0 && !_StopFlag; i--) { double rsi = iRSI(NULL,0,RsiPeriod,RsiPrice,i); sto[i] = iStoch(rsi,rsi,rsi,StoPeriod,StoSlowing,i,rates_total); }         
   for (i=limit;i>=0 && !_StopFlag; i--)
   {
      sig[i] = iMAOnArray(sto,rates_total,StoSignal,0,StoSignalMethod,i);
      trend[i] = (i<rates_total-1) ? (sto[i]>levUp)  ? 1 : (sto[i]<levDn)  ? -1 : (sto[i]<levUp && sto[i]>levDn) ? 0 : trend[i+1] : 0;  
      value[i] = (i<rates_total-1) ? (sto[i]>sig[i]) ? 1 : (sto[i]<sig[i]) ? -1 :                                      value[i+1] : 0;
      
      //
       //
       //
       //
       //
            
       if (arrowsVisible)
       {
           ObjectDelete(arrowsIdentifier+":1:"+(string)time[i]);
           ObjectDelete(arrowsIdentifier+":2:"+(string)time[i]);
           string lookFor = arrowsIdentifier+":"+(string)time[i]; ObjectDelete(lookFor);
           if (i<(rates_total-1) && arrowsOnLevelCross && trend[i] != trend[i+1])
           {
              if (trend[i+1] == 1 && trend[i]!= 1) drawArrow("1",0.5,i,arrowsOnLevelCrossDnColor,arrowsOnLevelCrossDnCode,arrowsOnLevelCrossDnSize,true);
              if (trend[i+1] ==-1 && trend[i]!=-1) drawArrow("1",0.5,i,arrowsOnLevelCrossUpColor,arrowsOnLevelCrossUpCode,arrowsOnLevelCrossUpSize,false);
           }
           if (i<(rates_total-1) && arrowsOnSignalCross && value[i] != value[i+1])
           {
              if (value[i] == 1) drawArrow("2",1,i,arrowsOnSignalCrossUpColor,arrowsOnSignalCrossUpCode,arrowsOnSignalCrossUpSize,false);
              if (value[i] ==-1) drawArrow("2",1,i,arrowsOnSignalCrossDnColor,arrowsOnSignalCrossDnCode,arrowsOnSignalCrossDnSize,true);
           }
             
              
        }
   }
   if (alertsOn)
   {
      int whichBar = 1; if (alertsOnCurrent) whichBar = 0; 
      static datetime time1 = 0;
      static string   mess1 = "";
      if (alertsOnLevelCross && trend[whichBar] != trend[whichBar+1])
      {
         if (trend[whichBar+1] ==-1 && trend[whichBar]!=-1) doAlert(time1,mess1,whichBar,"crossing lower level up");
         if (trend[whichBar+1] == 1 && trend[whichBar]!= 1) doAlert(time1,mess1,whichBar,"crossing upper level down");
      }
      static datetime time2 = 0;
      static string   mess2 = "";
      if (alertsOnSignalCross && value[whichBar] != value[whichBar+1])
      {
         if (value[whichBar] ==  1) doAlert(time2,mess2,whichBar,"crossing signal up");
         if (value[whichBar] == -1) doAlert(time2,mess2,whichBar,"crossing signal down");
      }                  
    }         
return(rates_total);
} 

//
//
//
//
//

#define _stochInstances     1
#define _stochInstancesSize 5
double  workSto[][_stochInstances+_stochInstancesSize];
#define _hi 0
#define _lo 1
#define _re 2
#define _ma 3
#define _mi 4
double iStoch(double priceR, double priceH, double priceL, int period, int slowing, int i, int bars, int instanceNo=0)
{
   if (ArrayRange(workSto,0)!=bars) ArrayResize(workSto,bars); i = bars-i-1; instanceNo *= _stochInstancesSize;
   
   //
   //
   //
   //
   //
   
   workSto[i][_hi+instanceNo] = priceH;
   workSto[i][_lo+instanceNo] = priceL;
   workSto[i][_re+instanceNo] = priceR;
   workSto[i][_ma+instanceNo] = priceH;
   workSto[i][_mi+instanceNo] = priceL;
      for (int k=1; k<period && (i-k)>=0; k++)
      {
         workSto[i][_mi+instanceNo] = fmin(workSto[i][_mi+instanceNo],workSto[i-k][instanceNo+_lo]);
         workSto[i][_ma+instanceNo] = fmax(workSto[i][_ma+instanceNo],workSto[i-k][instanceNo+_hi]);
      }                   
      double sumlow  = 0.0;
      double sumhigh = 0.0;
      for(int k=0; k<fmax(slowing,1) && (i-k)>=0; k++)
      {
         sumlow  += workSto[i-k][_re+instanceNo]-workSto[i-k][_mi+instanceNo];
         sumhigh += workSto[i-k][_ma+instanceNo]-workSto[i-k][_mi+instanceNo];
      }

   //
   //
   //
   //
   //
   
   if(sumhigh!=0.0) 
         return(100.0*sumlow/sumhigh);
   else  return(0);    
}

//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}


//
//
//
//
//

void doAlert(datetime& previousTime, string& previousAlert, int forBar, string doWhat)
{
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];
       
       //
       //
       //
       //
       //

       message = timeFrameToString(_Period)+" "+_Symbol+" at "+TimeToStr(TimeLocal(),TIME_SECONDS)+" Stochastic Rsi "+doWhat;
          if (alertsMessage) Alert(message);
          if (alertsNotify)  SendNotification(message);
          if (alertsEmail)   SendMail(_Symbol+" Stochastic Rsi ",message);
          if (alertsSound)   PlaySound(soundFile);
      }
}

//-------------------------------------------------------------------
//                                                                  
//-------------------------------------------------------------------
//
//
//
//
//

void drawArrow(string nameAdd, double gapMul, int i,color theColor, int theCode, int theWidth, bool up)
{
   string name = arrowsIdentifier+":"+nameAdd+":"+(string)Time[i];
   double gap  = iATR(NULL,0,20,i)*gapMul;   
   
      //
      //
      //
      //
      //
      
      datetime atime = Time[i]; if (arrowsOnNewest) atime += _Period*60-1;      
      ObjectCreate(name,OBJ_ARROW,0,atime,0);
         ObjectSet(name,OBJPROP_ARROWCODE,theCode);
         ObjectSet(name,OBJPROP_WIDTH,theWidth);
         ObjectSet(name,OBJPROP_COLOR,theColor);
         if (up)
               ObjectSet(name,OBJPROP_PRICE1,High[i] + arrowsUpperGap * gap);
         else  ObjectSet(name,OBJPROP_PRICE1,Low[i]  - arrowsLowerGap * gap);
}




