#property copyright   "http://www.bestexpertadvisors.com"
#property link        "http://www.bestexpertadvisors.com"
#property description "Our amazing premium EAs and new systems are coming soon."
#property description "You can follow us to get the latest news."

//----   --------------------------------------------------------------------+
#property indicator_chart_window
#property indicator_buffers 6
#property indicator_color1 LightSeaGreen
#property indicator_color2 Red
#property indicator_color3 DodgerBlue
#property indicator_color4 DodgerBlue
#property indicator_color5 DodgerBlue
#property indicator_color6 DodgerBlue

//----   ----------------------------------------------------------------------+
extern bool   AttachToPrice                   = false;
extern int    Stochastic_Kperiod              = 5;
extern int    Stochastic_Dperiod              = 3;
extern int    Stochastic_Slowing              = 3;
extern int    Stochastic_Method               = 0;
extern int    Stochastic_PriceField           = 0;
extern double Level_1_Value                   = 20;
extern double Level_2_Value                   = 80;
extern double Level_3_Value                   = -1;
extern double Level_4_Value                   = -1;

//----  --------------------------------------------------------------------------------+
static double MainOnChart[];
static double SignalOnChart[];
static double Level_1[];
static double Level_2[];
static double Level_3[];
static double Level_4[];
static double Stoch_Main[];
static double Stoch_Signal[];

//-----   -----------------------------------------------------------------+

//---------------------------------------------------------------------------------------------+
//----   ---------------------------------------------------------------+
//---------------------------------------------------------------------------------------------+
int init()
  {
   //----  ""   ----------------------------------------------+
   if(Stochastic_Method < 0 || Stochastic_Method > 3) Stochastic_Method = 0;
   IndicatorShortName(StringConcatenate("StochasticOnChart(",DoubleToStr(Stochastic_Kperiod,0),",",DoubleToStr(Stochastic_Dperiod,0),",",GetStringMAMethod(Stochastic_Method),"(",DoubleToStr(Stochastic_Slowing,0),"))"));
   //---- 2   ------------------------------------------------------------+
   IndicatorBuffers(8);
   //----     ----------------------------------------------+
   IndicatorDigits(4);
   //----     ----------------------------------------------------+
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,1);
   SetIndexStyle(1,DRAW_LINE,STYLE_DOT,1);
   SetIndexStyle(2,DRAW_LINE,STYLE_DOT,1);
   SetIndexStyle(3,DRAW_LINE,STYLE_DOT,1);
   SetIndexStyle(4,DRAW_LINE,STYLE_DOT,1);
   SetIndexStyle(5,DRAW_LINE,STYLE_DOT,1);
   //----      ---------------------------------------------+
   SetIndexBuffer(0,MainOnChart);
   SetIndexBuffer(1,SignalOnChart);
   SetIndexBuffer(2,Level_1);
   SetIndexBuffer(3,Level_2);
   SetIndexBuffer(4,Level_3);
   SetIndexBuffer(5,Level_4);
   SetIndexBuffer(6,Stoch_Main);
   SetIndexBuffer(7,Stoch_Signal);
   //----     --------------------------------------------------------+
   SetIndexLabel(0,"Main");
   SetIndexLabel(1,"Signal");
   if(Level_1_Value < 0) SetIndexLabel(2,NULL);
   else SetIndexLabel(2,DoubleToStr(Level_1_Value,2));
   if(Level_2_Value < 0) SetIndexLabel(3,NULL);
   else SetIndexLabel(3,DoubleToStr(Level_2_Value,2));
   if(Level_3_Value < 0) SetIndexLabel(4,NULL);
   else SetIndexLabel(4,DoubleToStr(Level_3_Value,2));
   if(Level_4_Value < 0) SetIndexLabel(5,NULL);
   else SetIndexLabel(5,DoubleToStr(Level_4_Value,2));
   //----       --------------------------------+
   SetIndexDrawBegin(0,Stochastic_Kperiod + Stochastic_Dperiod);
   SetIndexDrawBegin(1,Stochastic_Kperiod + Stochastic_Dperiod + Stochastic_Slowing);
   SetIndexDrawBegin(2,0);
   SetIndexDrawBegin(3,0);
   SetIndexDrawBegin(4,0);
   SetIndexDrawBegin(5,0);
   //----   -----------------------------------------------------------------+
   return(0);
   Print("---- Programming by Serega Lykov, http://mtexperts.narod.ru/ ----");
  }

//---------------------------------------------------------------------------------------------+
//----   -------------------------------------------------------------+
//---------------------------------------------------------------------------------------------+
int deinit()
  {
   return(0);
  }

//---------------------------------------------------------------------------------------------+
//----   ---------------------------------------------------------------------------+
//---------------------------------------------------------------------------------------------+
int start()
  {
   //----        --------------------+
   int counted_bars = IndicatorCounted();
   if(counted_bars < 0) return(-1);
   //----      ------------------------------------------+
   if(counted_bars > 0) counted_bars--;
   int limit = Bars - counted_bars;
   //----   Stochastic --------------------------------------------------------+
   for(int i=limit; i>=0; i--)
     {
      Stoch_Main  [i] = iStochastic(NULL,0,Stochastic_Kperiod,Stochastic_Dperiod,Stochastic_Slowing,Stochastic_Method,Stochastic_PriceField,MODE_MAIN,  i);
      Stoch_Signal[i] = iStochastic(NULL,0,Stochastic_Kperiod,Stochastic_Dperiod,Stochastic_Slowing,Stochastic_Method,Stochastic_PriceField,MODE_SIGNAL,i);
     }
   //----  Stochastic   ----------------------------------------------------+
   int window_first_bar      = WindowFirstVisibleBar();
   int window_bars_per_chart = WindowBarsPerChart();
   limit = window_first_bar - window_bars_per_chart;
   if(limit < 0) limit = 0;
   if(!AttachToPrice)
     {
      double window_price_max   = NormalizeDouble(WindowPriceMax(),Digits);
      double window_price_min   = NormalizeDouble(WindowPriceMin(),Digits);
     }
   else
     {
      int window_num_bars = window_first_bar - limit;
      window_price_max   = NormalizeDouble(High[iHighest(NULL,0,MODE_HIGH,window_num_bars,limit)],Digits);
      window_price_min   = NormalizeDouble(Low [iLowest (NULL,0,MODE_LOW, window_num_bars,limit)],Digits);
     }
   double price_range = NormalizeDouble((window_price_max - window_price_min) / 100.0,Digits);
   for(i=window_first_bar; i>=limit; i--)
     {
      MainOnChart  [i] = NormalizeDouble(window_price_min + price_range*Stoch_Main[i],  Digits);
      SignalOnChart[i] = NormalizeDouble(window_price_min + price_range*Stoch_Signal[i],Digits);
     }
   //----   Stochastic   ---------------------------------------------+
   if(Level_1_Value >= 0) DrawLevel(Level_1,NormalizeDouble(window_price_min + price_range*Level_1_Value,Digits),window_first_bar,limit);
   if(Level_2_Value >= 0) DrawLevel(Level_2,NormalizeDouble(window_price_min + price_range*Level_2_Value,Digits),window_first_bar,limit);
   if(Level_3_Value >= 0) DrawLevel(Level_3,NormalizeDouble(window_price_min + price_range*Level_3_Value,Digits),window_first_bar,limit);
   if(Level_4_Value >= 0) DrawLevel(Level_4,NormalizeDouble(window_price_min + price_range*Level_4_Value,Digits),window_first_bar,limit);
   //----   -----------------------------------------------------------------+
   return(0);
  }

//---------------------------------------------------------------------------------------------+
//---- DrawLevel ------------------------------------------------------------------------------+
//---------------------------------------------------------------------------------------------+
void DrawLevel(double& ind_buffer[], double level_value, int first_bar, int last_bar)
  {
   for(int i=first_bar; i>=last_bar; i--) ind_buffer[i] = level_value;
  }

//---------------------------------------------------------------------------------------------+
//---- GetStringMAMethod ----------------------------------------------------------------------+
//-------------------------------- programming by Serega Lykov, http://mtexperts.narod.ru/ ----+
//---------------------------------------------------------------------------------------------+
string GetStringMAMethod(int ma_method)
  {
   switch(ma_method)
     {
      case 1:  string str_ma_method = "EMA";  break;
      case 2:         str_ma_method = "SMMA"; break;
      case 3:         str_ma_method = "LWMA"; break;
      default:        str_ma_method = "SMA";
     }
   return(str_ma_method);
  }
    
//-------------------------------- programming by Serega Lykov, http://mtexperts.narod.ru/ ----+