//------------------------------------------------------------------
//
//------------------------------------------------------------------
#property copyright "mladen"
#property link "www.forex-tsd.com"
#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1  Blue
#property indicator_color2  Red
#property indicator_width1  2
#property indicator_width2  2
#property indicator_style2  STYLE_SOLID
#property indicator_minimum 0
#property indicator_maximum 100
#property indicator_level1  25
#property indicator_level2  75

//
//
//
//
//

extern int RsiPeriod       = 21;
extern int RsiPrice        = PRICE_CLOSE;
extern int StoPeriod       = 21;
extern int StoSlowing      = 8;
extern int StoSignal       = 2;
extern int StoSignalMethod = MODE_EMA;

double stoch[];
double signal[];

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int init()
{
   SetIndexBuffer(0,stoch);
   SetIndexBuffer(1,signal);
   IndicatorShortName("Stochastic RSI ("+RsiPeriod+","+StoPeriod+","+StoSlowing+","+StoSignal+")");
   return(0);
}
int deinit() { return(0); }

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//

int start()
{
   int counted_bars=IndicatorCounted();
      if (counted_bars<0) return(-1);
      if (counted_bars>0) counted_bars--;
         int limit = MathMin(Bars-counted_bars,Bars-1);

   //
   //
   //
   //
   //

   for (int i=limit; i>=0; i--)
   {
      double rsi = iRSI(NULL,0,RsiPeriod,RsiPrice,i); stoch[i] = iStoch(rsi,rsi,rsi,StoPeriod,StoSlowing,i);
   }         
   for (i=limit; i>=0; i--) signal[i] = iMAOnArray(stoch,0,StoSignal,0,StoSignalMethod,i);
   return(0);
} 

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//

double workSto[][5];
#define _hi 0
#define _lo 1
#define _re 2
#define _ma 3
#define _mi 4
double iStoch(double priceR, double priceH, double priceL, int period, int slowing, int i, int instanceNo=0)
{
   if (ArrayRange(workSto,0)!=Bars) ArrayResize(workSto,Bars); i = Bars-i-1; instanceNo *= 5;
   
   //
   //
   //
   //
   //
   
   workSto[i][_hi+instanceNo] = priceH;
   workSto[i][_lo+instanceNo] = priceL;
   workSto[i][_re+instanceNo] = priceR;
   workSto[i][_ma+instanceNo] = priceH;
   workSto[i][_mi+instanceNo] = priceL;
      for (int k=1; k<period && (i-k)>=0; k++)
      {
         workSto[i][_mi+instanceNo] = MathMin(workSto[i][_mi+instanceNo],workSto[i-k][_lo]);
         workSto[i][_ma+instanceNo] = MathMax(workSto[i][_ma+instanceNo],workSto[i-k][_hi]);
      }                   
      double sumlow  = 0.0;
      double sumhigh = 0.0;
      for(k=0; k<slowing; k++)
      {
         sumlow  += workSto[i-k][_re+instanceNo]-workSto[i-k][_mi+instanceNo];
         sumhigh += workSto[i-k][_ma+instanceNo]-workSto[i-k][_mi+instanceNo];
      }

   //
   //
   //
   //
   //
   
   if(sumhigh!=0.0) 
         return(100.0*sumlow/sumhigh);
   else  return(0);    
}