//+------------------------------------------------------------------+
//|                                       synthetic smoothed RSI.mq4 |
//+------------------------------------------------------------------+
#property copyright "mladen"
#property link      "mladenfx@gmail.com"

#property indicator_separate_window
#property indicator_buffers  2
#property indicator_color1   Magenta
#property indicator_color2   DimGray
#property indicator_width1   2
#property indicator_minimum  0
#property indicator_maximum  100
#property indicator_level1   20
#property indicator_level2   80
#property indicator_levelcolor DimGray 


//
//
//
//
//

extern int  rsiPrice         = PRICE_CLOSE;
extern int  rsiSignalLength  =  8;
extern int  emaLength1       = 48;
extern int  rsiLength1       = 32;
extern int  emaLength2       = 24;
extern int  rsiLength2       = 16;
extern int  emaLength3       = 12;
extern int  rsiLength3       =  8;
extern bool smoothedRsi      = true;

//
//
//
//
//

double rsiBuffer[];
double sigBuffer[];
double wrkBuffer[][6];

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int init()
{
   SetIndexBuffer(0,rsiBuffer);
   SetIndexBuffer(1,sigBuffer);
   
   IndicatorShortName("Synthetic smoothed RSI ("+emaLength1+","+rsiLength1+","+emaLength2+","+rsiLength2+","+emaLength3+","+rsiLength3+")");   
   return(0);
}
int deinit() { return(0); }




//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

#define ema1 0
#define dif1 1
#define ema2 2
#define dif2 3
#define ema3 4
#define dif3 5

//
//
//
//
//

int start()
{
   int counted_bars = IndicatorCounted();
   int i,r,limit;

   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
         limit = MathMin(Bars-counted_bars,Bars-1);
         if (ArrayRange(wrkBuffer,0) != Bars) ArrayResize(wrkBuffer,Bars);
         
   //
   //
   //
   //
   //

   double alpha1 = 2.0/(1.0+emaLength1);
   double alpha2 = 2.0/(1.0+emaLength2);
   double alpha3 = 2.0/(1.0+emaLength3);
   double alpha4 = 2.0/(1.0+rsiSignalLength);
   
   for(i=limit,r=Bars-i-1; i>=0; i--,r++)
   {
      double price = iMA(NULL,0,1,0,MODE_SMA,rsiPrice,i);
         if (i==(Bars-1))
         {
            wrkBuffer[r][ema1]=price;
            wrkBuffer[r][ema2]=price;
            wrkBuffer[r][ema3]=price;
            sigBuffer[i]      =0;
            continue;
         }

      //
      //
      //
      //
      //
               
      wrkBuffer[r][ema1] = wrkBuffer[r-1][ema1]+alpha1*(price-wrkBuffer[r-1][ema1]);
      wrkBuffer[r][ema2] = wrkBuffer[r-1][ema2]+alpha2*(price-wrkBuffer[r-1][ema2]);
      wrkBuffer[r][ema3] = wrkBuffer[r-1][ema3]+alpha3*(price-wrkBuffer[r-1][ema3]);
      
         double rsi1 = iSRsi(ema1,dif1,rsiLength1,r);
         double rsi2 = iSRsi(ema2,dif2,rsiLength2,r);
         double rsi3 = iSRsi(ema3,dif3,rsiLength3,r);
         
      rsiBuffer[i] = (rsi3+2.0*rsi2+3.0*rsi1)/6.0;
      sigBuffer[i] = sigBuffer[i+1]+alpha4*(rsiBuffer[i]-sigBuffer[i+1]);
   }
   return(0);
}

//
//
//
//
//

double iSRsi(int fromDim, int forDim, int length, int r)
{
   double rsi = 0;
   double cu  = 0;
   double cd  = 0;

   for (int k=0; (r-k)>0 && k<length; k++)
   {
      double diff = wrkBuffer[r-k][fromDim]-wrkBuffer[r-k-1][fromDim];
         if (diff > 0) cu += diff;
         if (diff < 0) cd -= diff;
   }
   if ((cu+cd)!=0)
         wrkBuffer[r][forDim] = 50.0*((cu-cd)/(cu+cd)+1.0);
   else  wrkBuffer[r][forDim] = 0;

   if (smoothedRsi)
          rsi = (wrkBuffer[r][forDim] + 2.0*wrkBuffer[r-1][forDim] + wrkBuffer[r-2][forDim])/4.0;
   else   rsi = (wrkBuffer[r][forDim]);
   return(rsi);
}