
#property indicator_separate_window
#property indicator_level1  95
#property indicator_level2  80
#property indicator_level3  50
#property indicator_level4  20
#property indicator_level5 5

#property indicator_buffers 4
#property indicator_color1 DodgerBlue
#property indicator_width1 2
#property indicator_color2 White
#property indicator_width2 2
#property indicator_color3 Chartreuse
#property indicator_color4 Red
#property indicator_maximum 105
#property indicator_minimum -5
//---- input parameters
extern int   K_Period=5; //13/4/8 //// 15 / 5 /5 vir die 1-m !!! 21/8/5 op 1M tans.
extern int   D_Period=3;
extern int   Slowing= 3;
extern bool  alertsOn         = false;
extern bool  alertsOnCurrent  = false;
extern bool  alertsMessage    = true;
extern bool  alertsSound      = false;
extern bool  alertsEmail      = false;


//---- buffers
double MainBuffer[];
double SignalBuffer[];
double WorkBuffer1[];
double WorkBuffer2[];
double WorkBuffer3[];
double upX[],dnX[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorBuffers(7);
     SetIndexStyle(0, DRAW_LINE);
   SetIndexBuffer(0, MainBuffer);
   SetIndexStyle(1, DRAW_LINE);
   SetIndexBuffer(1, SignalBuffer);
    SetIndexStyle(2,DRAW_ARROW);
   SetIndexArrow(2,233);  // 159
   SetIndexBuffer(2,upX);
   SetIndexStyle(3,DRAW_ARROW);
   SetIndexArrow(3,234);  //159
   SetIndexBuffer(3,dnX);   
 
   SetIndexBuffer(4, WorkBuffer1);
   SetIndexBuffer(5, WorkBuffer2);
   SetIndexBuffer(6, WorkBuffer3);     
   
   return(0);
  }
//+------------------------------------------------------------------+
//| Stochastic oscillator                                            |
//+------------------------------------------------------------------+
int start()
  {
   int    i;
   int    counted_bars = IndicatorCounted();
   double EMA;
 if(counted_bars > 0) 
       counted_bars--;
   int limit = Bars - counted_bars;
   for(i = 0; i < limit; i++)

      {
 WorkBuffer1[i]=(iStochastic(NULL,0,K_Period,D_Period,Slowing,MODE_SMA,0,MODE_MAIN,i));
 }
   for(i = 0; i < limit; i++)
       WorkBuffer2[i] = iMAOnArray(WorkBuffer1, 0, Slowing, 0, MODE_SMA, i);
   for(i = 0; i < limit; i++)
     {
       EMA = iMAOnArray(WorkBuffer2, 0, Slowing, 0, MODE_SMA, i);
       MainBuffer[i] = WorkBuffer2[i] + WorkBuffer2[i] - EMA;
     }
//---- signal line (%D) is simple movimg average
   for(i = 0; i < limit; i++)
       WorkBuffer3[i] = iMAOnArray(MainBuffer, 0, D_Period, 0, MODE_SMA, i);
   for(i = 0; i < limit; i++)
     {
       EMA = iMAOnArray(WorkBuffer3,0, D_Period, 0, MODE_SMA, i);
       SignalBuffer[i] = WorkBuffer3[i] + WorkBuffer3[i] - EMA;
     }
   for(i = 0; i < limit; i++)
   {
      upX[i] = EMPTY_VALUE;
      dnX[i] = EMPTY_VALUE;
      if (MainBuffer[i]>SignalBuffer[i] && MainBuffer[i+1]<SignalBuffer[i+1] )
       upX[i]=SignalBuffer[i]-5;//-15 <<<<<<<<<<<<<<<<<<<<
      if (MainBuffer[i]<SignalBuffer[i] && MainBuffer[i+1]>SignalBuffer[i+1] ) 
      dnX[i]=SignalBuffer[i]+5;//+15
}
   manageAlerts();
   return(0);
  }


//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//
//

void manageAlerts()
{
   if (alertsOn)
   {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1;
      if (upX[whichBar] !=  EMPTY_VALUE) doAlert(whichBar,"up");
      if (dnX[whichBar] !=  EMPTY_VALUE) doAlert(whichBar,"down");
   }
}

//
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       //
       //
       //
       //
       //

       message =  StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," leledc zerolag stoch signal ",doWhat);
          if (alertsMessage) Alert(message);
          if (alertsEmail)   SendMail(StringConcatenate(Symbol(),"leledc zerolag stoch "),message);
          if (alertsSound)   PlaySound("alert2.wav");
   }
}