#property copyright "Copyright 2022 mql5.com"
#property link      "https://www.mql5.com"
#property version   "1.00"
#property strict
#property indicator_chart_window
#property indicator_plots 0

input bool               Exclude_Weekend               = true; // Exclude weekends
input bool               Lines_Extend_Right            = false;
input ENUM_LINE_STYLE    Lines_Style                   = STYLE_DASH;
input int                Lines_Width                   = 1;
input ENUM_TIMEFRAMES    Visibility_Tf                 = PERIOD_CURRENT;
input color              Lines_Color_1                 = clrDarkGray; // Color for Line 1
input color              Lines_Color_2                 = clrDarkGray; // Color for Line 2
input color              Lines_Color_3                 = clrDarkGray; // Color for Line 3
input color              Midline_Color                 = clrDarkGray; // Color for Midline

datetime startTime;
datetime endTime;

int OnInit()
{
    if (_Period <= PERIOD_D1 && (_Period == Visibility_Tf||Visibility_Tf==PERIOD_CURRENT))
    {
        // Set the start and end times based on Exclude_Weekend parameter
        startTime = GetStartTime();
        endTime = iTime(_Symbol, PERIOD_D1, 1) + PERIOD_D1 * 60 - _Period;

        // Draw lines connecting the highest high and lowest low
        ConnectHHLL();
    }

    return (INIT_SUCCEEDED);
}

datetime GetStartTime()
{
    datetime lastDaysStartTime;

    int startDayOfWeek = TimeDayOfWeek(TimeCurrent());

    if (Exclude_Weekend && (startDayOfWeek >= 1 && startDayOfWeek <= 3)) // Monday, Tuesday, or Wednesday
    {
        lastDaysStartTime = iTime(_Symbol, PERIOD_D1, 4); // Use last 4 days
    }
    else
    {
        lastDaysStartTime = iTime(_Symbol, PERIOD_D1, 3); // Use last 3 days
    }

    return lastDaysStartTime;
}

int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
{
    if (_Period <= PERIOD_D1 && (_Period == Visibility_Tf||Visibility_Tf==PERIOD_CURRENT))
    {
        // Set the start and end times based on Exclude_Weekend parameter
        startTime = GetStartTime();
        endTime = iTime(_Symbol, PERIOD_D1, 1) + PERIOD_D1 * 60 - _Period;

        // Draw lines connecting the highest high and lowest low
        ConnectHHLL();
    }
    return (rates_total);
}

void OnDeinit(const int reason)
{
    // Remove objects when the indicator is removed
    ObjectDelete(ChartID(),"HHLL_Line1");
    ObjectDelete(ChartID(),"HHLL_Line2");
    ObjectDelete(ChartID(),"HHLL_Line3");
    ObjectDelete(ChartID(),"HHLL_Midline");
}

void ConnectHHLL()
{
    // Find the highest high and lowest low within the specified period
    int startBar = iBarShift(NULL, PERIOD_CURRENT, startTime, false);
    int endBar = iBarShift(NULL, PERIOD_CURRENT, endTime, false);

    int ihighest = iHighest(_Symbol, PERIOD_CURRENT, MODE_HIGH, startBar - endBar, endBar);
    int ilowest = iLowest(_Symbol, PERIOD_CURRENT, MODE_LOW, startBar - endBar, endBar);
    double highestHigh = iHigh(_Symbol,_Period,iHighest(_Symbol, PERIOD_CURRENT, MODE_HIGH, startBar - endBar, endBar));
    double lowestLow = iLow(_Symbol,_Period,iLowest(_Symbol, PERIOD_CURRENT, MODE_LOW, startBar - endBar, endBar));

    // Calculate midline
    double midline = (highestHigh + lowestLow) / 2;

    // Draw lines connecting the highest high and lowest low
    ObjectCreate(0, "HHLL_Line1", OBJ_TREND, 0, iTime(_Symbol,_Period,startBar), highestHigh, iTime(_Symbol,_Period,endBar), highestHigh);
    ObjectSetInteger(0, "HHLL_Line1", OBJPROP_COLOR, Lines_Color_1); // Set color based on input
    ObjectSetInteger(0, "HHLL_Line1", OBJPROP_STYLE, Lines_Style);
    ObjectSetInteger(0, "HHLL_Line1", OBJPROP_WIDTH, Lines_Width);
    ObjectSetInteger(0, "HHLL_Line1", OBJPROP_RAY, Lines_Extend_Right);

    ObjectCreate(0, "HHLL_Line2", OBJ_TREND, 0, iTime(_Symbol,_Period,startBar), lowestLow, iTime(_Symbol,_Period,endBar), lowestLow);
    ObjectSetInteger(0, "HHLL_Line2", OBJPROP_COLOR, Lines_Color_2); // Set color based on input
    ObjectSetInteger(0, "HHLL_Line2", OBJPROP_STYLE, Lines_Style);
    ObjectSetInteger(0, "HHLL_Line2", OBJPROP_WIDTH, Lines_Width);
    ObjectSetInteger(0, "HHLL_Line2", OBJPROP_RAY, Lines_Extend_Right);

    ObjectCreate(0, "HHLL_Line3", OBJ_TREND, 0, iTime(_Symbol,_Period,ilowest), lowestLow, iTime(_Symbol,_Period,ihighest), highestHigh);
    ObjectSetInteger(0, "HHLL_Line3", OBJPROP_COLOR, Lines_Color_3); // Set color based on input
    ObjectSetInteger(0, "HHLL_Line3", OBJPROP_STYLE, Lines_Style);
    ObjectSetInteger(0, "HHLL_Line3", OBJPROP_WIDTH, Lines_Width);
    ObjectSetInteger(0, "HHLL_Line3", OBJPROP_RAY, Lines_Extend_Right);

    // Draw midline
    ObjectCreate(0, "HHLL_Midline", OBJ_TREND, 0, iTime(_Symbol,_Period,startBar), midline, iTime(_Symbol,_Period,endBar), midline);
    ObjectSetInteger(0, "HHLL_Midline", OBJPROP_COLOR, Midline_Color); // Set color based on input
    ObjectSetInteger(0, "HHLL_Midline", OBJPROP_STYLE, Lines_Style);
    ObjectSetInteger(0, "HHLL_Midline", OBJPROP_WIDTH, Lines_Width);
//  ObjectSetInteger(0, "HHLL_Midline", OBJPROP_RAY, Lines_Extend_Right);
}

int TimeDayOfWeek(datetime date)
  {
   MqlDateTime tm;
   TimeToStruct(date,tm);
   return(tm.day_of_week);
  }
  