// https://www.mql5.com/en/forum/181297/page11#comment_4462199
//------------------------------------------------------------------
#property copyright "www.Forex-Station.com"
#property link      "www.Forex-Station.com"
//------------------------------------------------------------------
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_plots   1
#property indicator_label1  "Dema"
#property indicator_type1   DRAW_COLOR_LINE
#property indicator_color1  clrGray,clrLimeGreen,clrPaleVioletRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  2

//
//
//
//
//

enum enPrices
{
   pr_close,      // Close
   pr_open,       // Open
   pr_high,       // High
   pr_low,        // Low
   pr_median,     // Median
   pr_typical,    // Typical
   pr_weighted,   // Weighted
   pr_average     // Average (high+low+oprn+close)/4
};

input double   DemaPeriod  = 25;       // Dema calculation period
input enPrices Price       = pr_close; // Price to use

//
//
//
//
//
//

double dema[], colorBuffer[];

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int OnInit()
{
   SetIndexBuffer(0,dema,INDICATOR_DATA); 
   SetIndexBuffer(1,colorBuffer,INDICATOR_COLOR_INDEX); 
   return(0);
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime& time[],
                const double& open[],
                const double& high[],
                const double& low[],
                const double& close[],
                const long& tick_volume[],
                const long& volume[],
                const int& spread[])
{

   //
   //
   //
   //
   //

   for (int i=(int)MathMax(prev_calculated-1,0); i<rates_total; i++)
   {
      double price = getPrice(Price,open,close,high,low,i,rates_total);
             dema[i] = iDema(price,DemaPeriod,i,rates_total);
             if (i>0)
             {
//                colorBuffer[i] = colorBuffer[i-1];
                    colorBuffer[i] = 0;
                    if (dema[i] > dema[i-1]) colorBuffer[i]= 1;
                    if (dema[i] < dema[i-1]) colorBuffer[i]= 2;
             }                    
   }
   return(rates_total);
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

double workDema[][5];
#define _ema1 0
#define _ema2 1

double iDema(double price, double period, int r, int bars, int instanceNo=0)
{
   if (ArrayRange(workDema,0)!= bars) ArrayResize(workDema,bars); instanceNo*=2;

   //
   //
   //
   //
   //

   if (r==0)      
   {
      workDema[r][_ema1+instanceNo] = price;
      workDema[r][_ema2+instanceNo] = price;
   }      
   else
   {      
      double alpha = 2.0 / (1.0+period);
             workDema[r][_ema1+instanceNo] = workDema[r-1][_ema1+instanceNo]+alpha*(price                        -workDema[r-1][_ema1+instanceNo]);
             workDema[r][_ema2+instanceNo] = workDema[r-1][_ema2+instanceNo]+alpha*(workDema[r][_ema1+instanceNo]-workDema[r-1][_ema2+instanceNo]);
   }             
   return(workDema[r][_ema1+instanceNo]*2.0-workDema[r][_ema2+instanceNo]);
}

//------------------------------------------------------------------
//                                                                  
//------------------------------------------------------------------
//
//
//
//
//

double getPrice(enPrices price, const double& open[], const double& close[], const double& high[], const double& low[], int i, int bars)
{
   switch (price)
   {
      case pr_close:     return(close[i]);
      case pr_open:      return(open[i]);
      case pr_high:      return(high[i]);
      case pr_low:       return(low[i]);
      case pr_median:    return((high[i]+low[i])/2.0);
      case pr_typical:   return((high[i]+low[i]+close[i])/3.0);
      case pr_weighted:  return((high[i]+low[i]+close[i]+close[i])/4.0);
      case pr_average:   return((high[i]+low[i]+close[i]+open[i])/4.0);
   }
   return(0);
}
