//+------------------------------------------------------------------+
//|                                         Turtle Trading Rules.mq5 |
//|                                      Copyright 2024, Shaun Bosch |
//|                                              shadavbos@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, Shaun Bosch"
#property link      "shadavbos@gmail.com"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 13
#property indicator_plots   9
//--- plot Upper Line
#property indicator_label1  "Upper Line"
#property indicator_type1   DRAW_COLOR_LINE
#property indicator_color1  clrGreenYellow,clrCoral
#property indicator_style1  STYLE_SOLID
#property indicator_width1  3
//--- plot Lower Line
#property indicator_label2  "Lower Line"
#property indicator_type2   DRAW_COLOR_LINE
#property indicator_color2  clrGreenYellow,clrCoral
#property indicator_style2  STYLE_SOLID
#property indicator_width2  3
//--- plot Exit Line
#property indicator_label3  "Exit Line"
#property indicator_type3   DRAW_ARROW
#property indicator_color3  clrDodgerBlue
#property indicator_style3  STYLE_DOT
#property indicator_width3  1
//--- plot Up Trend
#property indicator_label4  "Up Trend"
#property indicator_type4   DRAW_FILLING
#property indicator_color4  clrDarkGreen,clrNONE
#property indicator_style4  STYLE_DOT
#property indicator_width4  1
//--- plot Down Trend
#property indicator_label5  "Down Trend"
#property indicator_type5   DRAW_FILLING
#property indicator_color5  clrMaroon,clrNONE
#property indicator_style5  STYLE_DOT
#property indicator_width5  1
//--- plot Enter Buy
#property indicator_label6  "Enter Buy"
#property indicator_type6   DRAW_ARROW
#property indicator_color6  clrGreen
#property indicator_style6  STYLE_DOT
#property indicator_width6  1
//--- plot Enter Sell
#property indicator_label7  "Enter Sell"
#property indicator_type7   DRAW_ARROW
#property indicator_color7  clrRed
#property indicator_style7  STYLE_DOT
#property indicator_width7  1
//--- plot Exit Buy
#property indicator_label8  "Exit Buy"
#property indicator_type8   DRAW_ARROW
#property indicator_color8  clrGreen
#property indicator_style8  STYLE_DOT
#property indicator_width8  1
//--- plot Exit Sell
#property indicator_label9  "Exit Sell"
#property indicator_type9   DRAW_ARROW
#property indicator_color9  clrRed
#property indicator_style9  STYLE_DOT
#property indicator_width9  1
//--- input parameters
input int      inp_entry_period        = 20;       // Entry Period
input int      inp_exit_period         = 10;       // Exit Period
//--- indicator buffers
double         upper_plot[];
double         upper_color[];
double         lower_plot[];
double         lower_color[];
double         exit_plot[];
double         up_trend_1[];
double         up_trend_2[];
double         down_trend_1[];
double         down_trend_2[];
double         enter_buy[];
double         enter_sell[];
double         exit_buy[];
double         exit_sell[];
//--- indicator variables
int            entry_period;
int            exit_period;
static bool    buy;
static bool    sell;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- check input parameters
   entry_period = inp_entry_period < 1 ? 1 : inp_entry_period;
   exit_period = inp_exit_period < 1 ? 1 : inp_exit_period;
//--- indicator buffers mapping
   SetIndexBuffer(0, upper_plot, INDICATOR_DATA);
   SetIndexBuffer(1, upper_color, INDICATOR_COLOR_INDEX);
   SetIndexBuffer(2, lower_plot, INDICATOR_DATA);
   SetIndexBuffer(3, lower_color, INDICATOR_COLOR_INDEX);
   SetIndexBuffer(4, exit_plot, INDICATOR_DATA);
   SetIndexBuffer(5, up_trend_1, INDICATOR_CALCULATIONS);
   SetIndexBuffer(6, up_trend_2, INDICATOR_CALCULATIONS);
   SetIndexBuffer(7, down_trend_1, INDICATOR_CALCULATIONS);
   SetIndexBuffer(8, down_trend_2, INDICATOR_CALCULATIONS);
   SetIndexBuffer(9, enter_buy, INDICATOR_CALCULATIONS);
   SetIndexBuffer(10, enter_sell, INDICATOR_CALCULATIONS);
   SetIndexBuffer(11, exit_buy, INDICATOR_CALCULATIONS);
   SetIndexBuffer(12, exit_sell, INDICATOR_CALCULATIONS);
//--- define the symbol code for drawing in plot_arrow
   PlotIndexSetInteger(2, PLOT_ARROW, 159);
   PlotIndexSetInteger(5, PLOT_ARROW, 233);
   PlotIndexSetInteger(6, PLOT_ARROW, 234);
   PlotIndexSetInteger(7, PLOT_ARROW, 251);
   PlotIndexSetInteger(8, PLOT_ARROW, 251);
//--- set the vertical shift of arrows in pixels
   PlotIndexSetInteger(5, PLOT_ARROW_SHIFT, 15);
   PlotIndexSetInteger(6, PLOT_ARROW_SHIFT, -15);
   PlotIndexSetInteger(7, PLOT_ARROW_SHIFT, -15);
   PlotIndexSetInteger(8, PLOT_ARROW_SHIFT, 15);
//--- place price chart in the foreground
   ChartSetInteger(0, CHART_FOREGROUND, 0, true);
//--- accuracy of drawing of indicator values
   IndicatorSetInteger(INDICATOR_DIGITS, _Digits);
//--- set indicator name display
   string short_name = "TURTLE (" + IntegerToString(entry_period) + ", " + IntegerToString(exit_period) + ")";
   IndicatorSetString(INDICATOR_SHORTNAME, short_name);
//--- an empty value for plotting, for which there is no drawing
   PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, EMPTY_VALUE);
   PlotIndexSetDouble(1, PLOT_EMPTY_VALUE, EMPTY_VALUE);
   PlotIndexSetDouble(2, PLOT_EMPTY_VALUE, EMPTY_VALUE);
   PlotIndexSetDouble(3, PLOT_EMPTY_VALUE, EMPTY_VALUE);
   PlotIndexSetDouble(4, PLOT_EMPTY_VALUE, EMPTY_VALUE);
   PlotIndexSetDouble(5, PLOT_EMPTY_VALUE, EMPTY_VALUE);
   PlotIndexSetDouble(6, PLOT_EMPTY_VALUE, EMPTY_VALUE);
   PlotIndexSetDouble(7, PLOT_EMPTY_VALUE, EMPTY_VALUE);
   PlotIndexSetDouble(8, PLOT_EMPTY_VALUE, EMPTY_VALUE);
//--- set staic variables
   buy = false;
   sell = false;
//--- successful initialization
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//--- bar index start
   int bar_index;
   if(prev_calculated == 0)
      bar_index = 0;
   else
      bar_index = prev_calculated - 1;
//--- main loop
   for(int i = bar_index; i < rates_total && !_StopFlag; i++)
     {
      upper_plot[i] = EMPTY_VALUE;
      upper_color[i] = EMPTY_VALUE;
      lower_plot[i] = EMPTY_VALUE;
      lower_color[i] = EMPTY_VALUE;
      exit_plot[i] = EMPTY_VALUE;
      up_trend_1[i] = EMPTY_VALUE;
      up_trend_2[i] = EMPTY_VALUE;
      down_trend_1[i] = EMPTY_VALUE;
      down_trend_2[i] = EMPTY_VALUE;
      enter_buy[i] = EMPTY_VALUE;
      enter_sell[i] = EMPTY_VALUE;
      exit_buy[i] = EMPTY_VALUE;
      exit_sell[i] = EMPTY_VALUE;
      if(i >= entry_period)
        {
         double entry_hh = high[i], entry_ll = low[i];
         for(int j = 0; j < entry_period; j++)
           {
            entry_hh = high[i - j] > entry_hh ? high[i - j] : entry_hh;
            entry_ll = low[i - j] < entry_ll ? low[i - j] : entry_ll;
           }
         upper_plot[i] = entry_hh;
         lower_plot[i] = entry_ll;
         double exit_hh = high[i], exit_ll = low[i];
         for(int j = 0; j < exit_period; j++)
           {
            exit_hh = high[i - j] > exit_hh ? high[i - j] : exit_hh;
            exit_ll = low[i - j] < exit_ll ? low[i - j] : exit_ll;
           }
         int barsince_high = 0, barsince_low = 0;
         for(int j = 1; j < i; j++)
           {
            if(high[i - j] >= upper_plot[i - j - 1])
              {
               barsince_high = j;
               if(barsince_high > 0 && barsince_low > 0)
                  break;
              }
            if(low[i - j] <= lower_plot[i - j - 1])
              {
               barsince_low = j;
               if(barsince_high > 0 && barsince_low > 0)
                  break;
              }
           }
         upper_color[i] = barsince_high <= barsince_low ? 0.0 : 1.0;
         lower_color[i] = barsince_high >= barsince_low ? 0.0 : 1.0;
         exit_plot[i] = barsince_high <= barsince_low ? exit_ll : exit_hh;
         up_trend_1[i] = fmin(close[i], open[i]);
         up_trend_2[i] = exit_plot[i];
         down_trend_1[i] = exit_plot[i];
         down_trend_2[i] = fmax(close[i], open[i]);
         if(high[i] >= upper_plot[i - 1] && !buy && !sell)
           {
            enter_buy[i] = lower_plot[i];
            buy = true;
            sell = false;
           }
         if(low[i] <= lower_plot[i - 1] && !buy && !sell)
           {
            enter_sell[i] = upper_plot[i];
            buy = false;
            sell = true;
           }
         if(low[i] <= exit_plot[i - 1] && low[i - 1] > exit_plot[i - 2] && buy && !sell)
           {
            exit_buy[i] = upper_plot[i];
            buy = false;
            sell = false;
           }
         if(high[i] >= exit_plot[i - 1] && high[i - 1] < exit_plot[i - 2] && !buy && sell)
           {
            exit_sell[i] = lower_plot[i];
            buy = false;
            sell = false;
           }
        }
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
